/* 
 * File:   Spectral_FIFOBuffers.h
 * Author: Jeremy Leach
 */

#ifndef SPECTRAL_FIFOBUFFERS_H
#define	SPECTRAL_FIFOBUFFERS_H

#ifdef	__cplusplus
extern "C" {
#endif
#include <xc.h>
    
/******************************************************************************/
/***** Definitions ************************************************************/
/******************************************************************************/     
#define	NULL (0)
#define SPI_RX_IN_PROGRESS 0x0
#define SPI1_DUMMY_DATA 0x0
    
#define FifoBuffer_size 256
#define  max_FifoBuffer_count 255
//#define FifoBuffer_size 128
//#define  max_FifoBuffer_count 127
    
#define HAASFifoBuffer_size 1100
#define AgcRingBuffer_size 256
#define AgcWindow_size 128
#define AgcWindow_size_as_shift 7

/******************************************************************************/
/***** Types ************************************************************/
/******************************************************************************/  
        
typedef struct  {
        int32_t buf[AgcRingBuffer_size];
        uint16_t window_index;
        uint16_t buffer_index;
        uint16_t env_value;
        uint16_t env_target;
        uint16_t env_lin_delta;    
        uint32_t window_peak;
        uint16_t old_simplistic_env_target;
        int16_t outputL;
        int16_t outputR;
        } agc_t;        
    
typedef struct  {
        uint16_t buf[FifoBuffer_size];
        uint16_t head;
        uint16_t tail;
        uint16_t count;
        uint8_t flag_overflow;
        } fifo_buffer16_t; 
        
typedef struct  {
        int32_t buf[HAASFifoBuffer_size];
        uint16_t index;
        } haas_fifo_t;    
        
typedef struct  {
        uint8_t buf[FifoBuffer_size];
        uint16_t head;
        uint16_t tail;
        uint16_t count;
        uint8_t flag_overflow;
        } fifo_buffer8_t;  

#ifdef	__cplusplus
}
#endif

#endif	/* SPECTRAL_FIFOBUFFERS_H */

