/**
  @Generated Pin Manager Header File

  @Company:
    Microchip Technology Inc.

  @File Name:
    pin_manager.h

  @Summary:
    This is the Pin Manager file generated using PIC10 / PIC12 / PIC16 / PIC18 MCUs

  @Description
    This header file provides APIs for driver for .
    Generation Information :
        Product Revision  :  PIC10 / PIC12 / PIC16 / PIC18 MCUs - 1.76
        Device            :  PIC18LF25K50
        Driver Version    :  2.11
    The generated drivers are tested against the following:
        Compiler          :  XC8 2.00
        MPLAB 	          :  MPLAB X 5.10	
*/

/*
    (c) 2018 Microchip Technology Inc. and its subsidiaries. 
    
    Subject to your compliance with these terms, you may use Microchip software and any 
    derivatives exclusively with Microchip products. It is your responsibility to comply with third party 
    license terms applicable to your use of third party software (including open source software) that 
    may accompany Microchip software.
    
    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER 
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY 
    IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS 
    FOR A PARTICULAR PURPOSE.
    
    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP 
    HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO 
    THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL 
    CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT 
    OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS 
    SOFTWARE.
*/

#ifndef PIN_MANAGER_H
#define PIN_MANAGER_H

/**
  Section: Included Files
*/

#include <xc.h>

#define INPUT   1
#define OUTPUT  0

#define HIGH    1
#define LOW     0

#define ANALOG      1
#define DIGITAL     0

#define PULL_UP_ENABLED      1
#define PULL_UP_DISABLED     0

// get/set ADC_USB_SENSE aliases
#define ADC_USB_SENSE_TRIS                 TRISAbits.TRISA0
#define ADC_USB_SENSE_LAT                  LATAbits.LATA0
#define ADC_USB_SENSE_PORT                 PORTAbits.RA0
#define ADC_USB_SENSE_ANS                  ANSELAbits.ANSA0
#define ADC_USB_SENSE_SetHigh()            do { LATAbits.LATA0 = 1; } while(0)
#define ADC_USB_SENSE_SetLow()             do { LATAbits.LATA0 = 0; } while(0)
#define ADC_USB_SENSE_Toggle()             do { LATAbits.LATA0 = ~LATAbits.LATA0; } while(0)
#define ADC_USB_SENSE_GetValue()           PORTAbits.RA0
#define ADC_USB_SENSE_SetDigitalInput()    do { TRISAbits.TRISA0 = 1; } while(0)
#define ADC_USB_SENSE_SetDigitalOutput()   do { TRISAbits.TRISA0 = 0; } while(0)
#define ADC_USB_SENSE_SetAnalogMode()      do { ANSELAbits.ANSA0 = 1; } while(0)
#define ADC_USB_SENSE_SetDigitalMode()     do { ANSELAbits.ANSA0 = 0; } while(0)

// get/set IO_RA1 aliases
#define IO_RA1_TRIS                 TRISAbits.TRISA1
#define IO_RA1_LAT                  LATAbits.LATA1
#define IO_RA1_PORT                 PORTAbits.RA1
#define IO_RA1_ANS                  ANSELAbits.ANSA1
#define IO_RA1_SetHigh()            do { LATAbits.LATA1 = 1; } while(0)
#define IO_RA1_SetLow()             do { LATAbits.LATA1 = 0; } while(0)
#define IO_RA1_Toggle()             do { LATAbits.LATA1 = ~LATAbits.LATA1; } while(0)
#define IO_RA1_GetValue()           PORTAbits.RA1
#define IO_RA1_SetDigitalInput()    do { TRISAbits.TRISA1 = 1; } while(0)
#define IO_RA1_SetDigitalOutput()   do { TRISAbits.TRISA1 = 0; } while(0)
#define IO_RA1_SetAnalogMode()      do { ANSELAbits.ANSA1 = 1; } while(0)
#define IO_RA1_SetDigitalMode()     do { ANSELAbits.ANSA1 = 0; } while(0)

// get/set IO_RA2 aliases
#define IO_RA2_TRIS                 TRISAbits.TRISA2
#define IO_RA2_LAT                  LATAbits.LATA2
#define IO_RA2_PORT                 PORTAbits.RA2
#define IO_RA2_ANS                  ANSELAbits.ANSA2
#define IO_RA2_SetHigh()            do { LATAbits.LATA2 = 1; } while(0)
#define IO_RA2_SetLow()             do { LATAbits.LATA2 = 0; } while(0)
#define IO_RA2_Toggle()             do { LATAbits.LATA2 = ~LATAbits.LATA2; } while(0)
#define IO_RA2_GetValue()           PORTAbits.RA2
#define IO_RA2_SetDigitalInput()    do { TRISAbits.TRISA2 = 1; } while(0)
#define IO_RA2_SetDigitalOutput()   do { TRISAbits.TRISA2 = 0; } while(0)
#define IO_RA2_SetAnalogMode()      do { ANSELAbits.ANSA2 = 1; } while(0)
#define IO_RA2_SetDigitalMode()     do { ANSELAbits.ANSA2 = 0; } while(0)

// get/set IO_RA3 aliases
#define IO_RA3_TRIS                 TRISAbits.TRISA3
#define IO_RA3_LAT                  LATAbits.LATA3
#define IO_RA3_PORT                 PORTAbits.RA3
#define IO_RA3_ANS                  ANSELAbits.ANSA3
#define IO_RA3_SetHigh()            do { LATAbits.LATA3 = 1; } while(0)
#define IO_RA3_SetLow()             do { LATAbits.LATA3 = 0; } while(0)
#define IO_RA3_Toggle()             do { LATAbits.LATA3 = ~LATAbits.LATA3; } while(0)
#define IO_RA3_GetValue()           PORTAbits.RA3
#define IO_RA3_SetDigitalInput()    do { TRISAbits.TRISA3 = 1; } while(0)
#define IO_RA3_SetDigitalOutput()   do { TRISAbits.TRISA3 = 0; } while(0)
#define IO_RA3_SetAnalogMode()      do { ANSELAbits.ANSA3 = 1; } while(0)
#define IO_RA3_SetDigitalMode()     do { ANSELAbits.ANSA3 = 0; } while(0)

// get/set IO_RA4 aliases
#define IO_RA4_TRIS                 TRISAbits.TRISA4
#define IO_RA4_LAT                  LATAbits.LATA4
#define IO_RA4_PORT                 PORTAbits.RA4
#define IO_RA4_SetHigh()            do { LATAbits.LATA4 = 1; } while(0)
#define IO_RA4_SetLow()             do { LATAbits.LATA4 = 0; } while(0)
#define IO_RA4_Toggle()             do { LATAbits.LATA4 = ~LATAbits.LATA4; } while(0)
#define IO_RA4_GetValue()           PORTAbits.RA4
#define IO_RA4_SetDigitalInput()    do { TRISAbits.TRISA4 = 1; } while(0)
#define IO_RA4_SetDigitalOutput()   do { TRISAbits.TRISA4 = 0; } while(0)

// get/set OUT_SS aliases
#define OUT_SS_TRIS                 TRISAbits.TRISA5
#define OUT_SS_LAT                  LATAbits.LATA5
#define OUT_SS_PORT                 PORTAbits.RA5
#define OUT_SS_ANS                  ANSELAbits.ANSA5
#define OUT_SS_SetHigh()            do { LATAbits.LATA5 = 1; } while(0)
#define OUT_SS_SetLow()             do { LATAbits.LATA5 = 0; } while(0)
#define OUT_SS_Toggle()             do { LATAbits.LATA5 = ~LATAbits.LATA5; } while(0)
#define OUT_SS_GetValue()           PORTAbits.RA5
#define OUT_SS_SetDigitalInput()    do { TRISAbits.TRISA5 = 1; } while(0)
#define OUT_SS_SetDigitalOutput()   do { TRISAbits.TRISA5 = 0; } while(0)
#define OUT_SS_SetAnalogMode()      do { ANSELAbits.ANSA5 = 1; } while(0)
#define OUT_SS_SetDigitalMode()     do { ANSELAbits.ANSA5 = 0; } while(0)

// get/set IO_RA6 aliases
#define IO_RA6_TRIS                 TRISAbits.TRISA6
#define IO_RA6_LAT                  LATAbits.LATA6
#define IO_RA6_PORT                 PORTAbits.RA6
#define IO_RA6_SetHigh()            do { LATAbits.LATA6 = 1; } while(0)
#define IO_RA6_SetLow()             do { LATAbits.LATA6 = 0; } while(0)
#define IO_RA6_Toggle()             do { LATAbits.LATA6 = ~LATAbits.LATA6; } while(0)
#define IO_RA6_GetValue()           PORTAbits.RA6
#define IO_RA6_SetDigitalInput()    do { TRISAbits.TRISA6 = 1; } while(0)
#define IO_RA6_SetDigitalOutput()   do { TRISAbits.TRISA6 = 0; } while(0)

// get/set IN_SDI aliases
#define IN_SDI_TRIS                 TRISBbits.TRISB0
#define IN_SDI_LAT                  LATBbits.LATB0
#define IN_SDI_PORT                 PORTBbits.RB0
#define IN_SDI_WPU                  WPUBbits.WPUB0
#define IN_SDI_ANS                  ANSELBbits.ANSB0
#define IN_SDI_SetHigh()            do { LATBbits.LATB0 = 1; } while(0)
#define IN_SDI_SetLow()             do { LATBbits.LATB0 = 0; } while(0)
#define IN_SDI_Toggle()             do { LATBbits.LATB0 = ~LATBbits.LATB0; } while(0)
#define IN_SDI_GetValue()           PORTBbits.RB0
#define IN_SDI_SetDigitalInput()    do { TRISBbits.TRISB0 = 1; } while(0)
#define IN_SDI_SetDigitalOutput()   do { TRISBbits.TRISB0 = 0; } while(0)
#define IN_SDI_SetPullup()          do { WPUBbits.WPUB0 = 1; } while(0)
#define IN_SDI_ResetPullup()        do { WPUBbits.WPUB0 = 0; } while(0)
#define IN_SDI_SetAnalogMode()      do { ANSELBbits.ANSB0 = 1; } while(0)
#define IN_SDI_SetDigitalMode()     do { ANSELBbits.ANSB0 = 0; } while(0)

// get/set OUT_SCK aliases
#define OUT_SCK_TRIS                 TRISBbits.TRISB1
#define OUT_SCK_LAT                  LATBbits.LATB1
#define OUT_SCK_PORT                 PORTBbits.RB1
#define OUT_SCK_WPU                  WPUBbits.WPUB1
#define OUT_SCK_ANS                  ANSELBbits.ANSB1
#define OUT_SCK_SetHigh()            do { LATBbits.LATB1 = 1; } while(0)
#define OUT_SCK_SetLow()             do { LATBbits.LATB1 = 0; } while(0)
#define OUT_SCK_Toggle()             do { LATBbits.LATB1 = ~LATBbits.LATB1; } while(0)
#define OUT_SCK_GetValue()           PORTBbits.RB1
#define OUT_SCK_SetDigitalInput()    do { TRISBbits.TRISB1 = 1; } while(0)
#define OUT_SCK_SetDigitalOutput()   do { TRISBbits.TRISB1 = 0; } while(0)
#define OUT_SCK_SetPullup()          do { WPUBbits.WPUB1 = 1; } while(0)
#define OUT_SCK_ResetPullup()        do { WPUBbits.WPUB1 = 0; } while(0)
#define OUT_SCK_SetAnalogMode()      do { ANSELBbits.ANSB1 = 1; } while(0)
#define OUT_SCK_SetDigitalMode()     do { ANSELBbits.ANSB1 = 0; } while(0)

// get/set IO_RB2 aliases
#define IO_RB2_TRIS                 TRISBbits.TRISB2
#define IO_RB2_LAT                  LATBbits.LATB2
#define IO_RB2_PORT                 PORTBbits.RB2
#define IO_RB2_WPU                  WPUBbits.WPUB2
#define IO_RB2_ANS                  ANSELBbits.ANSB2
#define IO_RB2_SetHigh()            do { LATBbits.LATB2 = 1; } while(0)
#define IO_RB2_SetLow()             do { LATBbits.LATB2 = 0; } while(0)
#define IO_RB2_Toggle()             do { LATBbits.LATB2 = ~LATBbits.LATB2; } while(0)
#define IO_RB2_GetValue()           PORTBbits.RB2
#define IO_RB2_SetDigitalInput()    do { TRISBbits.TRISB2 = 1; } while(0)
#define IO_RB2_SetDigitalOutput()   do { TRISBbits.TRISB2 = 0; } while(0)
#define IO_RB2_SetPullup()          do { WPUBbits.WPUB2 = 1; } while(0)
#define IO_RB2_ResetPullup()        do { WPUBbits.WPUB2 = 0; } while(0)
#define IO_RB2_SetAnalogMode()      do { ANSELBbits.ANSB2 = 1; } while(0)
#define IO_RB2_SetDigitalMode()     do { ANSELBbits.ANSB2 = 0; } while(0)

// get/set OUT_SDO aliases
#define OUT_SDO_TRIS                 TRISBbits.TRISB3
#define OUT_SDO_LAT                  LATBbits.LATB3
#define OUT_SDO_PORT                 PORTBbits.RB3
#define OUT_SDO_WPU                  WPUBbits.WPUB3
#define OUT_SDO_ANS                  ANSELBbits.ANSB3
#define OUT_SDO_SetHigh()            do { LATBbits.LATB3 = 1; } while(0)
#define OUT_SDO_SetLow()             do { LATBbits.LATB3 = 0; } while(0)
#define OUT_SDO_Toggle()             do { LATBbits.LATB3 = ~LATBbits.LATB3; } while(0)
#define OUT_SDO_GetValue()           PORTBbits.RB3
#define OUT_SDO_SetDigitalInput()    do { TRISBbits.TRISB3 = 1; } while(0)
#define OUT_SDO_SetDigitalOutput()   do { TRISBbits.TRISB3 = 0; } while(0)
#define OUT_SDO_SetPullup()          do { WPUBbits.WPUB3 = 1; } while(0)
#define OUT_SDO_ResetPullup()        do { WPUBbits.WPUB3 = 0; } while(0)
#define OUT_SDO_SetAnalogMode()      do { ANSELBbits.ANSB3 = 1; } while(0)
#define OUT_SDO_SetDigitalMode()     do { ANSELBbits.ANSB3 = 0; } while(0)

// get/set channel_AN11 aliases
#define channel_AN11_TRIS                 TRISBbits.TRISB4
#define channel_AN11_LAT                  LATBbits.LATB4
#define channel_AN11_PORT                 PORTBbits.RB4
#define channel_AN11_WPU                  WPUBbits.WPUB4
#define channel_AN11_ANS                  ANSELBbits.ANSB4
#define channel_AN11_SetHigh()            do { LATBbits.LATB4 = 1; } while(0)
#define channel_AN11_SetLow()             do { LATBbits.LATB4 = 0; } while(0)
#define channel_AN11_Toggle()             do { LATBbits.LATB4 = ~LATBbits.LATB4; } while(0)
#define channel_AN11_GetValue()           PORTBbits.RB4
#define channel_AN11_SetDigitalInput()    do { TRISBbits.TRISB4 = 1; } while(0)
#define channel_AN11_SetDigitalOutput()   do { TRISBbits.TRISB4 = 0; } while(0)
#define channel_AN11_SetPullup()          do { WPUBbits.WPUB4 = 1; } while(0)
#define channel_AN11_ResetPullup()        do { WPUBbits.WPUB4 = 0; } while(0)
#define channel_AN11_SetAnalogMode()      do { ANSELBbits.ANSB4 = 1; } while(0)
#define channel_AN11_SetDigitalMode()     do { ANSELBbits.ANSB4 = 0; } while(0)

// get/set IO_RB5 aliases
#define IO_RB5_TRIS                 TRISBbits.TRISB5
#define IO_RB5_LAT                  LATBbits.LATB5
#define IO_RB5_PORT                 PORTBbits.RB5
#define IO_RB5_WPU                  WPUBbits.WPUB5
#define IO_RB5_ANS                  ANSELBbits.ANSB5
#define IO_RB5_SetHigh()            do { LATBbits.LATB5 = 1; } while(0)
#define IO_RB5_SetLow()             do { LATBbits.LATB5 = 0; } while(0)
#define IO_RB5_Toggle()             do { LATBbits.LATB5 = ~LATBbits.LATB5; } while(0)
#define IO_RB5_GetValue()           PORTBbits.RB5
#define IO_RB5_SetDigitalInput()    do { TRISBbits.TRISB5 = 1; } while(0)
#define IO_RB5_SetDigitalOutput()   do { TRISBbits.TRISB5 = 0; } while(0)
#define IO_RB5_SetPullup()          do { WPUBbits.WPUB5 = 1; } while(0)
#define IO_RB5_ResetPullup()        do { WPUBbits.WPUB5 = 0; } while(0)
#define IO_RB5_SetAnalogMode()      do { ANSELBbits.ANSB5 = 1; } while(0)
#define IO_RB5_SetDigitalMode()     do { ANSELBbits.ANSB5 = 0; } while(0)

// get/set OUT_MIDI_SENSE aliases
#define OUT_MIDI_SENSE_TRIS                 TRISBbits.TRISB6
#define OUT_MIDI_SENSE_LAT                  LATBbits.LATB6
#define OUT_MIDI_SENSE_PORT                 PORTBbits.RB6
#define OUT_MIDI_SENSE_WPU                  WPUBbits.WPUB6
#define OUT_MIDI_SENSE_SetHigh()            do { LATBbits.LATB6 = 1; } while(0)
#define OUT_MIDI_SENSE_SetLow()             do { LATBbits.LATB6 = 0; } while(0)
#define OUT_MIDI_SENSE_Toggle()             do { LATBbits.LATB6 = ~LATBbits.LATB6; } while(0)
#define OUT_MIDI_SENSE_GetValue()           PORTBbits.RB6
#define OUT_MIDI_SENSE_SetDigitalInput()    do { TRISBbits.TRISB6 = 1; } while(0)
#define OUT_MIDI_SENSE_SetDigitalOutput()   do { TRISBbits.TRISB6 = 0; } while(0)
#define OUT_MIDI_SENSE_SetPullup()          do { WPUBbits.WPUB6 = 1; } while(0)
#define OUT_MIDI_SENSE_ResetPullup()        do { WPUBbits.WPUB6 = 0; } while(0)

// get/set OUT_ALERT aliases
#define OUT_ALERT_TRIS                 TRISBbits.TRISB7
#define OUT_ALERT_LAT                  LATBbits.LATB7
#define OUT_ALERT_PORT                 PORTBbits.RB7
#define OUT_ALERT_WPU                  WPUBbits.WPUB7
#define OUT_ALERT_SetHigh()            do { LATBbits.LATB7 = 1; } while(0)
#define OUT_ALERT_SetLow()             do { LATBbits.LATB7 = 0; } while(0)
#define OUT_ALERT_Toggle()             do { LATBbits.LATB7 = ~LATBbits.LATB7; } while(0)
#define OUT_ALERT_GetValue()           PORTBbits.RB7
#define OUT_ALERT_SetDigitalInput()    do { TRISBbits.TRISB7 = 1; } while(0)
#define OUT_ALERT_SetDigitalOutput()   do { TRISBbits.TRISB7 = 0; } while(0)
#define OUT_ALERT_SetPullup()          do { WPUBbits.WPUB7 = 1; } while(0)
#define OUT_ALERT_ResetPullup()        do { WPUBbits.WPUB7 = 0; } while(0)

// get/set IO_RC0 aliases
#define IO_RC0_TRIS                 TRISCbits.TRISC0
#define IO_RC0_LAT                  LATCbits.LATC0
#define IO_RC0_PORT                 PORTCbits.RC0
#define IO_RC0_SetHigh()            do { LATCbits.LATC0 = 1; } while(0)
#define IO_RC0_SetLow()             do { LATCbits.LATC0 = 0; } while(0)
#define IO_RC0_Toggle()             do { LATCbits.LATC0 = ~LATCbits.LATC0; } while(0)
#define IO_RC0_GetValue()           PORTCbits.RC0
#define IO_RC0_SetDigitalInput()    do { TRISCbits.TRISC0 = 1; } while(0)
#define IO_RC0_SetDigitalOutput()   do { TRISCbits.TRISC0 = 0; } while(0)

// get/set IO_RC1 aliases
#define IO_RC1_TRIS                 TRISCbits.TRISC1
#define IO_RC1_LAT                  LATCbits.LATC1
#define IO_RC1_PORT                 PORTCbits.RC1
#define IO_RC1_SetHigh()            do { LATCbits.LATC1 = 1; } while(0)
#define IO_RC1_SetLow()             do { LATCbits.LATC1 = 0; } while(0)
#define IO_RC1_Toggle()             do { LATCbits.LATC1 = ~LATCbits.LATC1; } while(0)
#define IO_RC1_GetValue()           PORTCbits.RC1
#define IO_RC1_SetDigitalInput()    do { TRISCbits.TRISC1 = 1; } while(0)
#define IO_RC1_SetDigitalOutput()   do { TRISCbits.TRISC1 = 0; } while(0)

// get/set IO_RC2 aliases
#define IO_RC2_TRIS                 TRISCbits.TRISC2
#define IO_RC2_LAT                  LATCbits.LATC2
#define IO_RC2_PORT                 PORTCbits.RC2
#define IO_RC2_ANS                  ANSELCbits.ANSC2
#define IO_RC2_SetHigh()            do { LATCbits.LATC2 = 1; } while(0)
#define IO_RC2_SetLow()             do { LATCbits.LATC2 = 0; } while(0)
#define IO_RC2_Toggle()             do { LATCbits.LATC2 = ~LATCbits.LATC2; } while(0)
#define IO_RC2_GetValue()           PORTCbits.RC2
#define IO_RC2_SetDigitalInput()    do { TRISCbits.TRISC2 = 1; } while(0)
#define IO_RC2_SetDigitalOutput()   do { TRISCbits.TRISC2 = 0; } while(0)
#define IO_RC2_SetAnalogMode()      do { ANSELCbits.ANSC2 = 1; } while(0)
#define IO_RC2_SetDigitalMode()     do { ANSELCbits.ANSC2 = 0; } while(0)

// get/set IO_RC6 aliases
#define IO_RC6_TRIS                 TRISCbits.TRISC6
#define IO_RC6_LAT                  LATCbits.LATC6
#define IO_RC6_PORT                 PORTCbits.RC6
#define IO_RC6_ANS                  ANSELCbits.ANSC6
#define IO_RC6_SetHigh()            do { LATCbits.LATC6 = 1; } while(0)
#define IO_RC6_SetLow()             do { LATCbits.LATC6 = 0; } while(0)
#define IO_RC6_Toggle()             do { LATCbits.LATC6 = ~LATCbits.LATC6; } while(0)
#define IO_RC6_GetValue()           PORTCbits.RC6
#define IO_RC6_SetDigitalInput()    do { TRISCbits.TRISC6 = 1; } while(0)
#define IO_RC6_SetDigitalOutput()   do { TRISCbits.TRISC6 = 0; } while(0)
#define IO_RC6_SetAnalogMode()      do { ANSELCbits.ANSC6 = 1; } while(0)
#define IO_RC6_SetDigitalMode()     do { ANSELCbits.ANSC6 = 0; } while(0)

// get/set IN_MIDI aliases
#define IN_MIDI_TRIS                 TRISCbits.TRISC7
#define IN_MIDI_LAT                  LATCbits.LATC7
#define IN_MIDI_PORT                 PORTCbits.RC7
#define IN_MIDI_ANS                  ANSELCbits.ANSC7
#define IN_MIDI_SetHigh()            do { LATCbits.LATC7 = 1; } while(0)
#define IN_MIDI_SetLow()             do { LATCbits.LATC7 = 0; } while(0)
#define IN_MIDI_Toggle()             do { LATCbits.LATC7 = ~LATCbits.LATC7; } while(0)
#define IN_MIDI_GetValue()           PORTCbits.RC7
#define IN_MIDI_SetDigitalInput()    do { TRISCbits.TRISC7 = 1; } while(0)
#define IN_MIDI_SetDigitalOutput()   do { TRISCbits.TRISC7 = 0; } while(0)
#define IN_MIDI_SetAnalogMode()      do { ANSELCbits.ANSC7 = 1; } while(0)
#define IN_MIDI_SetDigitalMode()     do { ANSELCbits.ANSC7 = 0; } while(0)

/**
   @Param
    none
   @Returns
    none
   @Description
    GPIO and peripheral I/O initialization
   @Example
    PIN_MANAGER_Initialize();
 */
void PIN_MANAGER_Initialize (void);

/**
 * @Param
    none
 * @Returns
    none
 * @Description
    Interrupt on Change Handling routine
 * @Example
    PIN_MANAGER_IOC();
 */
void PIN_MANAGER_IOC(void);



#endif // PIN_MANAGER_H
/**
 End of File
*/