/* 
 * File:   Spectral_Interrupts.c
 * Author: Jeremy Leach
 */

#include "Spectral_Interrupts.h"
#include "Spectral_Timer1.h"


/******************************************************************************/
/***** Declarations ***********************************************************/
/******************************************************************************/
volatile uint16_t flag_sample_refresh_pending;
volatile int16_t processor_being_sampled = -1;
static volatile int32_t sample_delta;

extern volatile agc_t agc;
extern volatile uint16_t alert_delay_ms;
extern volatile uint16_t flag_messaging_EEPROM;
extern volatile uint16_t ms_counter;
extern volatile int32_t tone_proc_sample_sum;
/******************************************************************************/
/***** Methods ****************************************************************/
/******************************************************************************/

void  Interrupts_Initialize (void)
{
    INTCON1bits.COVTE = 0;  // Catastrophic overflow trap disabled
    INTCON1bits.NSTDIS = 0; // Interrupt nesting is enabled. We need this to ensure SPI reception is ALWAYS processed.
    
    //=============Set interrupt priorities====================================
    //Highest is DAC, then SPI1 then Timer1
    IPC19bits.DAC1LIP = 7; //Essential for timely audio streaming
    IPC19bits.DAC1RIP = 7; //Essential for timely audio streaming
    IPC2bits.SPI1IP = 6; //This is the slave and MUST process received bytes promptly.
    //IPC8bits.SPI2IP = 5; //Not quite as important as SPI1.
    IPC1bits.T2IP = 1; //Lowest priority for the 100Hz timer that controls the alert LED
    
    //============INTCON2======================================================
    INTCON2bits.ALTIVT = 0; // 0 = Use standard interrupt vector
    INTCON2bits.DISI = 0;   // 0 = Disable Interrupts instruction not active       
            
    //===== SPI ======
    IFS0bits.SPI1IF = 0;    // SPI1 Event Interrupt Flag Status bit
    IFS0bits.SPI1EIF = 0;   // SPI1 Error Interrupt Flag Status bit
    //IFS2bits.SPI2IF = 0;    // SPI1 Event Interrupt Flag Status bit
    //IFS2bits.SPI2EIF = 0;   // SPI1 Error Interrupt Flag Status bit
    
    //============ ENABLE INTERRUPTS ==================
    IEC0bits.SPI1IE = 1;    // SPI1 Event Interrupt Enable bit
    IEC0bits.SPI1EIE = 1;   // SPI1 Error Interrupt Enable bit
    IEC2bits.SPI2IE = 0;    // SPI2 Event Interrupt Enable bit
    IEC2bits.SPI2EIE = 0;   // SPI2 Error Interrupt Enable bit
    IEC0bits.T2IE = 1;      // Timer2 Event Interrupt Enable bit
    
    //============ Clear Flag ===================================================
    flag_sample_refresh_pending = 0;
}

//NOTE:See detail here: file:///C:/Program%20Files%20(x86)/Microchip/xc16/v1.36/docs/vector_docs/PIC33FJ128GP802.html

void __attribute__((__interrupt__, auto_psv)) _SPI1Interrupt(void)
{
    if(SPI1STATbits.SPIRBF == 1)
    { 
        WriteByteToSPI1RxBuffer((uint8_t)(SPI1BUF & 0x00FF));  //SPIRBF is automatically cleared in hardware when core reads SPIxBUF location, reading SPIxRXB    
    }
    IFS0bits.SPI1IF = 0;
}

void __attribute__((__interrupt__, auto_psv)) _SPI1ErrInterrupt(void)
{
    IFS0bits.SPI1EIF = 0;
    OUT_SPI2_SS2_PORT_SetLow(); OUT_MIXALERT_PORT_SetHigh(); while(1){};//FLAG ERROR THROUGH SS LINE
}

void __attribute__((__interrupt__, auto_psv)) _T2Interrupt(void)
{
    IFS0bits.T2IF = 0;
    ms_counter --;
    if ((alert_delay_ms > 0) && (flag_messaging_EEPROM == 0))
    {
        alert_delay_ms--;
        if (alert_delay_ms == 0)
        {
           OUT_MIXALERT_PORT_SetLow(); 
        }   
    }
}

void __attribute__((interrupt, no_auto_psv)) _DAC1RInterrupt(void)
{
    IFS4bits.DAC1RIF = 0; //Clear Right Channel Interrupt Flag 
    DAC1RDAT = agc.outputR;
}
void __attribute__((interrupt, no_auto_psv)) _DAC1LInterrupt(void)
{
    IFS4bits.DAC1LIF = 0; // Clear Left Channel Interrupt Flag
    DAC1LDAT = agc.outputL;
    flag_sample_refresh_pending = 1;
}
