/* 
 * File:   SPECTRAL_messaging.h
 * Author: Jeremy Leach 2019
 */

#ifndef SPECTRAL_MESSAGING_H
#define	SPECTRAL_MESSAGING_H

#ifdef	__cplusplus
extern "C" {
#endif

#include "mcc_generated_files/mcc.h"
#include "SPECTRAL_MIDI.h"
/******************************************************************************/
/***** Constants **************************************************************/
/******************************************************************************/
//wr_buffer_size was 64
#define Standard88Keyboard_bottomnote 21
#define Standard88Keyboard_topnote 108 
#define wr_buffer_size 80
#define message_start_char 0x7E
#define msg_instance_noteon_len 10
#define msg_instance_noteoff_len 5
#define msg_ucc_len 5
#define msg_volume_change_len 5
#define msg_select_patch_len 5
#define msg_header_length 4
#define eeprom_loaded_indicator 123
#define max_ucc_items 8
#define max_midi_controllers 129
#define performance_id_not_set 100
#define EEPROM_perfbank_lsb 252
#define EEPROM_perfbank_msb 253
#define EEPROM_patchbank_lsb 254
#define EEPROM_patchbank_msb 255
/******************************************************************************/
/***** Enumerations ***********************************************************/
/******************************************************************************/
    enum cc_item_statuses
    {
        not_used = 0,
        value_changed = 1,
        pending_sending = 2
    };
    
    enum used_midi_cc
    {
        ucc_none = 0,
        ucc_pitch_bend = 1,
        ucc_modulation = 2,
        ucc_breath_controller = 3,
        ucc_expression = 4,
        ucc_foot_controller = 5,
        ucc_sustain = 6,
        ucc_velocity = 7
    };
    
    enum message_recipients
    {
        processor0 = 0,
        processor1 = 1,
        processor2 = 2,
        processor3 = 3,
        processor4 = 4,
        processor5 = 5,
        all_processors = 6,
        mixer = 9,
        master = 10,
        no_recipient = 100
    };
  
    enum msg_types
    {
       msg_type_adsr_section = 0,
       msg_type_adsr_section_envelope_config = 1,
       msg_type_biquad_eq_calculated = 2,
       msg_type_lfo_envelope_config = 3,
       msg_type_patch = 4,
       msg_type_waveform = 5,
       msg_type_waveform_harmonic = 6,
       msg_type_waveform_set = 7,
       msg_type_patch_all = 8,
       msg_type_body_resonance_filter_band = 10,
       msg_type_envelope_control = 11,
       msg_type_save_patch_to_EEPROM = 15,
       msg_type_load_patch_from_EEPROM = 16,
       msg_type_performance = 17,
       msg_type_select_performance = 18,
       msg_type_relay_performances_to_mixer = 19,
       InstanceNoteOn = 20,
       InstanceNoteOff = 21,
       UsedControlChange = 22,
       ChangeEQ = 30,
       ChangeEffect = 31,
       ChangeVolume = 32,
       StartPlayMode = 41,
       StopPlayMode = 42,
       msg_default_banks = 43,
       GetToneProcSample = 10000 //XC16 uses int data type, i.e signed
    };
    
    enum midi_controls
    {
        cc_bank_msb = 0,
        cc_bank_lsb = 32,
        cc_aftertouch = 123,
    };
    
    enum usb_message_states
    {
        waiting_for_start = 0,
        waiting_for_length_LSB = 1,
        waiting_for_length_MSB = 2,
        waiting_for_payload_recipient_id = 3,
        waiting_for_payload_message_type_id = 4,
        waiting_for_other_payload_bytes = 5
    };
/******************************************************************************/
/***** Types ******************************************************************/
/******************************************************************************/

typedef union
{   
uint8_t data[msg_instance_noteon_len];
struct  {
        uint8_t message_recipient;
        uint8_t message_type;
        uint16_t payload_length;
        uint8_t instance_id;
        uint8_t midi_channel;
        uint8_t patch_id; 
        uint8_t note_id;
        uint8_t last_midi_note_number;
        uint8_t velocity_id;
        };
} msg_instance_noteon;

typedef union
{   
uint8_t data[msg_instance_noteoff_len];
struct  {
        uint8_t message_recipient;
        uint8_t message_type;
        uint16_t payload_length;
        uint8_t instance_id;
        };
} msg_instance_noteoff;

typedef union
{   
uint8_t data[msg_ucc_len];
struct  {
        uint8_t message_recipient;
        uint8_t message_type;
        uint8_t ucc_id;
        uint16_t ucc_value;
        };
} msg_ucc;

typedef union
{   
uint8_t data[msg_volume_change_len];
struct  {
        uint8_t message_recipient;
        uint8_t message_type;
        uint16_t payload_length;
        uint8_t new_volume_value;
        };
} msg_volume_change;

typedef union
{   
uint8_t data[msg_select_patch_len];
struct  {
        uint8_t message_recipient;
        uint8_t message_type;
        uint16_t payload_length;
        uint8_t module_patch_id;
        };
} msg_select_patch;

typedef struct {
    uint16_t ucc_value;
    uint8_t ucc_status;
}ucc_item;
    
/******************************************************************************/
/***** Methods ****************************************************************/
/******************************************************************************/
void SPECTRAL_messaging_initialise();
void delay_ms(uint16_t delaytime);
void SPECTRAL_ProcessUSBData();
unsigned uint8_t eeprom18_read(uint8_t offset);
void eeprom18_write(unsigned int offset, unsigned char value);
void SelectPerformance(void);
void RelayPerformancesToMixer(void);
void SPECTRAL_SavePerformancesToEEPROM(void);
void SPECTRAL_LoadPerformancesFromEEPROM(void);
void SPECTRAL_ForwardMIDIMessage(uint8_t processor_id,uint8_t instance_id,midi_event e,uint8_t last_midi_note_number);
void SPECTRAL_SendUCC(uint8_t ucc_id,uint16_t ucc_value);
void SPECTRAL_SendVolumeChange(uint8_t new_volume_value);
void SPECTRAL_SendSelectPatch(uint8_t module_patch_id);
void SPECTRAL_LoadBankNumbersFromEEPROM(void);
void SPECTRAL_SaveBankNumbersToEEPROM(void);

#ifdef	__cplusplus
}
#endif

#endif	/* SPECTRAL_MESSAGING_H */

