/* 
 * File:   Spectral_SPI_Tone.h
 * Author: Jeremy Leach
 */

#ifndef SPECTRAL_SPI_TONE_H
#define	SPECTRAL_SPI_TONE_H

#ifdef	__cplusplus
extern "C" {
#endif

#include <xc.h>
    
/******************************************************************************/
/***** Definitions ************************************************************/
/******************************************************************************/     
#define SPI1RxBuffer_size  64
#define max_SPI1RxBuffer_count 63

/******************************************************************************/
/***** Types ************************************************************/
/******************************************************************************/ 

typedef struct  {
        uint16_t buf[SPI1RxBuffer_size];
        uint8_t head;
        uint8_t tail;
        uint8_t count;
        } fifo_SPI1RxBuffer16;  

/******************************************************************************/
/***** Methods ****************************************************************/
/******************************************************************************/  
void SPI1_Initialize(void);
void ClearSPI1RxBuffer(void);
uint16_t ReadWordFromSPI1RxBuffer(void);
uint16_t WaitForWordFromRxBuffer(void);
void WriteWordToSPI1RxBuffer(uint16_t data);
int16_t ProcessSPIRxBuffer(void);

#ifdef	__cplusplus
}
#endif

#endif	/* SPECTRAL_SPI_TONE_H */

