/* 
 * File:   Spectral_SPI_Tone.h
 * Author: Jeremy Leach
 */

#ifndef SPECTRAL_SPI_2_H
#define	SPECTRAL_SPI_2_H

#ifdef	__cplusplus
extern "C" {
#endif

#include <xc.h>
#include "Spectral_FIFOBuffers.h" 
#include "Spectral_Pins.h"
#include "Spectral_Messaging.h"
#include "Spectral_SPI_1.h"
  
/******************************************************************************/
/***** Declarations ***********************************************************/
/******************************************************************************/ 
 #define max_processors 6

/******************************************************************************/
/***** Enums ******************************************************************/
/******************************************************************************/    
    enum SPI2_statuses
    {
        SPI2_status_recipient = 0,
        SPI2_status_message_type = 1, 
        SPI2_status_payload_length_LSB = 2, 
        SPI2_status_payload_length_MSB = 3, 
        SPI2_status_payload = 4,
        SPI2_status_ucc_index,
        SPI2_status_ucc_value_LSB,
        SPI2_status_ucc_value_MSB
    };
    
/******************************************************************************/
/***** Types ******************************************************************/
/******************************************************************************/     
    
typedef struct  {
    uint8_t status;
    uint8_t recipient_id;
    uint8_t message_type_id;   
    uint8_t payload_length_LSB;  
    uint8_t payload_length_MSB;  
    uint16_t payload_length;    
    uint16_t payload_words_pending;
}SPI2TxState_t;
        
        
/******************************************************************************/
/***** Methods ****************************************************************/
/******************************************************************************/ 
void SPI2Initialize(void);
void SelectPerformance(uint16_t performance_id);
inline void ProcessSPI1Message(void);
void Output16bitValueToLED(uint16_t v);
void SPI2TxSetSS(uint8_t processor_id);
void SPI2TxClearSS(uint8_t processor_id);
void ChangePlayMode(uint16_t play_mode);
void SendMessageToToneProcs(uint16_t message_type_id,uint16_t payload_length,uint16_t recipient_id);
void send_adsr_section(uint16_t adsr_section_id,uint16_t recipient_id);
void send_adsr_section_envelope_config(uint16_t adsr_section_id,uint16_t adsr_section_envelope_config_id,uint16_t recipient_id);
void send_lfo_envelope_config(uint16_t lfo_envelope_config_id,uint16_t recipient_id);
void send_envelope_control(uint16_t envelope_control_id,uint16_t recipient_id);
void send_body_resonance_filter_band(uint16_t b,uint16_t recipient_id);
void send_patch(uint16_t recipient_id);
void send_waveform_harmonic(uint16_t n,uint16_t i,uint16_t waveform_id,uint16_t recipient_id);
void send_waveform_set(uint16_t recipient_id);
void send_channel_volume(uint16_t recipient_id,uint16_t volume);
void send_all_patch_data(uint16_t recipient_id);

#ifdef	__cplusplus
}
#endif

#endif	/* SPECTRAL_SPI_2_H */

