/* 
 * File:   Spectral_SPI.h
 * Author: Jeremy Leach
 */

#ifndef SPECTRAL_SPI_H
#define	SPECTRAL_SPI_H

#ifdef	__cplusplus
extern "C" {
#endif
#include <xc.h>
#include "Spectral_FIFOBuffers.h" 
#include "Spectral_Messaging.h"
#include "Spectral_SPI_2.h" 
#include "Spectral_Pins.h"
#include "Spectral_Sound.h"
    
/******************************************************************************/
/***** Enums ******************************************************************/
/******************************************************************************/    
    enum SPI1_statuses
    {
        SPI1_status_idle = 0,
        SPI1_status_waiting_for_message_type = 1,
        SPI1_status_waiting_for_payload_LSB = 2,
        SPI1_status_waiting_for_payload_MSB = 3,
        SPI1_status_payload_in_progress = 4
    };
    
/******************************************************************************/
/***** Types ******************************************************************/
/******************************************************************************/  
    
/******************************************************************************/
/***** Methods ****************************************************************/
/******************************************************************************/  
void SPI1Initialize(void);
uint8_t ReadByteFromSPI1RxBuffer(void);
uint8_t WaitForByteFromSPI1RxBuffer(void);
uint16_t WaitForWordFromSPI1RxBuffer(void);
void WriteByteToSPI1RxBuffer(uint8_t data);

#ifdef	__cplusplus
}
#endif

#endif	/* SPECTRAL_SPI_H */

