/* 
 * File:   Spectral_I2C.h
 * Author: Jeremy Leach
 */

#ifndef SPECTRAL_I2C_H
#define	SPECTRAL_I2C_H

#ifdef	__cplusplus
extern "C" {
#endif

#include <xc.h>
    
/******************************************************************************/
/***** Definitions ************************************************************/
/******************************************************************************/ 
#define EEPROM_ControlByteRead 0b10101111
#define EEPROM_ControlByteWrite 0b10101110
#define PAGESIZE	128
#define PAGE_SIZE_AS_SHIFT 7
#define PAGES_PER_PATCH 27
    
/******************************************************************************/
/***** Methods ****************************************************************/
/******************************************************************************/ 
unsigned int I2CInitialize(void);
//Low Level Functions
unsigned int IdleI2C(void);
unsigned int StartI2C(void);
unsigned int WriteI2C(unsigned char);
unsigned int StopI2C(void);
unsigned int RestartI2C(void);
unsigned int getsI2C(volatile unsigned char*, unsigned char);
unsigned int NotAckI2C(void);
unsigned int I2CInitialize(void);
unsigned int ACKStatus(void);
unsigned int getI2C(void);
unsigned int AckI2C(void);
unsigned int EEAckPolling(unsigned char);
unsigned int putstringI2C(volatile unsigned char*);

//High Level Functions for High Density Devices
unsigned int HDPageWriteI2C(unsigned char ControlByte, unsigned char HighAdd, unsigned char LowAdd, volatile unsigned char *wrptr);
unsigned int HDSequentialReadI2C(unsigned char, unsigned char, unsigned char, volatile unsigned char*, unsigned char);

void SavePageToEEPROM(void);
void SaveByteToEPB(unsigned char b);
void SaveWordToEPB(uint16_t w);
void save_adsr_section(uint16_t adsr_section_id);
void save_adsr_section_envelope_config(uint16_t adsr_section_id,uint16_t adsr_section_envelope_config_id);
void save_lfo_envelope_config(uint16_t lfo_envelope_config_id);
void save_envelope_control(uint16_t envelope_control_id);
void save_initial_depth_value(uint16_t envelope_control_id);
void save_body_resonance_filter_band(void);
void save_waveform_harmonic(uint16_t n,uint16_t i,uint16_t waveform_id);
void save_waveform_set();
void SavePatchToEEPROM(uint16_t module_patch_id);

void LoadPageFromEEPROM(void);
unsigned char LoadByteFromEPB(void);
uint16_t LoadWordFromEPB(void);
void load_adsr_section(uint16_t adsr_section_id);
void load_adsr_section_envelope_config(uint16_t adsr_section_id,uint16_t adsr_section_envelope_config_id);
void load_lfo_envelope_config(uint16_t lfo_envelope_config_id);
void load_envelope_control(uint16_t envelope_control_id);
void load_initial_depth_value(uint16_t envelope_control_id);
void load_body_resonance_filter_band(void);
void load_waveform_harmonic(uint16_t n,uint16_t i,uint16_t waveform_id);
void load_waveform_set();
void LoadPatchFromEEPROM(uint16_t module_patch_id);

#ifdef	__cplusplus
}
#endif

#endif	/* SPECTRAL_I2C_H */

