
#include "mcc_generated_files/mcc.h"
#include "SPECTRAL_General.h"
#include "SPECTRAL_MIDI.h"
#include "SPECTRAL_messaging.h"
#include "mcc_generated_files/adc.h"

extern volatile uint8_t adc_change_interval_count;
extern volatile ucc_item ucc_items[max_ucc_items];
volatile uint8_t flag_volume_check_pending;
volatile uint8_t flag_cc_check_pending;

void main(void) 
{
    //Disable selected modules
    PMD0bits.TMR3MD = 1 ;//Timer3
    PMD1bits.ADCMD = 0; //ADC Module
    PMD1bits.CCP1MD = 1;//CCP1 
    PMD1bits.CCP2MD = 1;//CCP2
    PMD1bits.CMP1MD = 1;//Comparator 1
    PMD1bits.CMP2MD = 1;//Comparator 2
    
    // Initialize the device
    SYSTEM_Initialize(); 
    SPECTRAL_messaging_initialise();
    OUT_SS_PORT = 1; //Set slave select high
    EUSART1_SetRxInterruptHandler(Rx_MIDI_Event_InterruptHandler);
    
    SPECTRAL_MIDI_Initialise(0);
    
    // Enable high priority global interrupts
    INTERRUPT_GlobalInterruptHighEnable();

    // Enable low priority global interrupts.
    INTERRUPT_GlobalInterruptLowEnable();
    
    delay_ms(2500); //Wait for Mixer and Tone Processors to be ready and also USB to connect if necessary
    
//    if(USBGetDeviceState() != DETACHED_STATE)
//    {
//        //If USB is attached then wait until it is fully configured and ready
//        while((USBGetDeviceState() < CONFIGURED_STATE) ||(USBIsDeviceSuspended()== true) || ( USBUSARTIsTxTrfReady() == false))
//        {};
//    }
    
    //Load performance   
    if (eeprom18_read(0) == eeprom_loaded_indicator)
        {
        SPECTRAL_LoadBankNumbersFromEEPROM();
        SPECTRAL_LoadPerformancesFromEEPROM();
        RelayPerformancesToMixer();
        }    
    
    uint8_t volume_value = 255;
    uint8_t new_volume_value;
    uint8_t ucc_index = 0;
    flag_volume_check_pending = 0;
    flag_cc_check_pending = 0;

    ADC_SelectChannel(ADC_VOL);
    ADC_StartConversion();
   
    while (1) 
    {
        ProcessMIDI();
        
        if(ADC_IsConversionDone())
            {
            new_volume_value = (uint8_t)(ADC_GetConversionResult()>>2);//ADC is 10 bit 
            ADC_StartConversion();
            }
        
        if(ucc_items[ucc_index].ucc_status == pending_sending)
        {
            SPECTRAL_SendUCC(ucc_index,ucc_items[ucc_index].ucc_value);
            ucc_items[ucc_index].ucc_status = not_used;
        }
        ucc_index ++;if(ucc_index == max_ucc_items){ucc_index = 0;}
        
        if (flag_cc_check_pending   == 1)
            {    
            flag_cc_check_pending   = 0;
            
            //Tag all changed CC as pending sending
            uint8_t j;
            for (j = 0; j < max_ucc_items;j++)
                {
                    if (ucc_items[j].ucc_status == value_changed){ucc_items[j].ucc_status = pending_sending;}
                }
            }
        
        if (flag_volume_check_pending  == 1)
            {    
            flag_volume_check_pending  = 0;
  
            //Change the volume
            if (new_volume_value > volume_value)
                {
                if ((new_volume_value - volume_value) > 16)
                    {
                    SPECTRAL_SendVolumeChange(new_volume_value);
                    volume_value = new_volume_value;
                    }
                }
            else if ((volume_value - new_volume_value) > 16)
                {
                SPECTRAL_SendVolumeChange(new_volume_value);
                volume_value = new_volume_value;
                }
            }
    }
}
/**
 End of File
*/