﻿using Spectral1.DATA_ACCESS;
using Spectral1.Properties;
using System;
using System.Windows.Forms;
using static Spectral1.DATA_ACCESS.DA_Spectral;

namespace Spectral1.PRESENTATION
{
    public partial class PL_SetIntensityLayerRange : Form
    {
        c_from_to_range _r;
        PL_Main _plm;

        public PL_SetIntensityLayerRange(ref PL_Main plm, ref c_from_to_range r, intensity_layer_range_contexts context)
        {
            InitializeComponent();
            _plm = plm;
            _r = r;
            bool select_waveform = false;

            switch (context)
            {
                case intensity_layer_range_contexts.MorphWholeLayer:
                    this.Text = "Morph all harmonics across intensity layers";
                    pictureBox1.Image = Resources.Morph_WaveSet_AcrossIntensityLayers;
                    break;
                case intensity_layer_range_contexts.MorphCurrentNoteSectorBlocks:
                    this.Text = "Morph current note sector waveform blocks across intensity layers";
                    pictureBox1.Image = Resources.Morph_CurrentNSBlocksAcrossIntensityLayers;
                    break;
                case intensity_layer_range_contexts.MorphCurrentNoteSectorWaveforms:
                    this.Text = "Morph current note sector waveforms across intensity layers";
                    select_waveform = true;
                    pictureBox1.Image = Resources.Morph_CurrentNSWaveformsAcrossIntensityLayers;
                    break;
                case intensity_layer_range_contexts.CopyCurrentBlock:
                    this.Text = "Copy current waveform block across intensity layers";
                    select_waveform = false;
                    pictureBox1.Image = Resources.Copy_CurrentNSBlockAcrossIntensityLayers;
                    break;
                case intensity_layer_range_contexts.CopyCurrentWaveform:
                    this.Text = "Copy current waveform across intensity layers";
                    select_waveform = false;
                    pictureBox1.Image = Resources.Copy_CurrentNSWaveformAcrossIntensityLayers;
                    break;
            }

            BindingSource ilfbs = new BindingSource(); ilfbs.DataSource = plm.BL.DA.CGSS.Table_intensity_layer.Table_BindingSource;
            BindingSource iltbs = new BindingSource(); iltbs.DataSource = plm.BL.DA.CGSS.Table_intensity_layer.Table_BindingSource;
            BindingSource wtbs = new BindingSource(); wtbs.DataSource = plm.BL.DA.CGSS.Table_waveform.Table_BindingSource;

            comboBox_NSF.DisplayMember = "intensity_layer_name";
            comboBox_NSF.ValueMember = "intensity_layer_id";
            comboBox_NSF.DataSource = ilfbs;
            comboBox_NSF.SelectedValue = 0;

            comboBox_NST.DisplayMember = "intensity_layer_name";
            comboBox_NST.ValueMember = "intensity_layer_id";
            comboBox_NST.DataSource = iltbs;
            comboBox_NST.SelectedValue = DA_Spectral.max_intensity_layers - 1;

            comboBox_W.DisplayMember = "waveform_name";
            comboBox_W.ValueMember = "waveform_id";
            comboBox_W.DataSource = wtbs;
            comboBox_W.SelectedValue = DA_Spectral.max_waveforms - 1;

            comboBox_W.Visible = select_waveform;
            label_waveform.Visible = select_waveform;
        }


        private void button_OK_Click_1(object sender, EventArgs e)
        {
            _r.from_id = Convert.ToInt32(comboBox_NSF.SelectedValue);
            _r.to_id = Convert.ToInt32(comboBox_NST.SelectedValue);
            _r.waveform_id = Convert.ToInt32(comboBox_W.SelectedValue);

            if (_r.to_id <= _r.from_id)
            {
                _plm.PLInfo.DisplayExclamation("The 'From' value must be less than the 'To' value and separated by at least one !");
            }
            else
            {
                this.DialogResult = DialogResult.OK;
                this.Close();
            }
        }

        private void button_Cancel_Click_1(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
            this.Close();
        }
    }
}
