﻿using Spectral1.DATA_ACCESS;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Spectral1.PRESENTATION
{
    public partial class PL_SetHarmonicRange : Form
    {
        c_from_to_range _r;
        PL_Main _plm;
        bool flag_initialising = true;

        public PL_SetHarmonicRange(ref PL_Main plm, ref c_from_to_range r,string context)
        {
            InitializeComponent();

            flag_initialising = true;
            _plm = plm;
            _r = r;
            this.Text = context;

            List<int> hfrom = new List<int>();
            for (int h = 0; h < DA_Spectral.max_harmonics; h++){hfrom.Add(h);}

            List<int> hto = new List<int>();
            for (int h = 0; h < DA_Spectral.max_harmonics; h++) { hto.Add(h); }
           
            comboBox_NSF.DisplayMember = "name";
            comboBox_NSF.ValueMember = "name";
            comboBox_NSF.DataSource = hfrom;
            comboBox_NSF.SelectedIndex = 0;
            _r.from_id = 0;

            comboBox_NST.DisplayMember = "name";
            comboBox_NST.ValueMember = "name";
            comboBox_NST.DataSource = hto;
            comboBox_NST.SelectedIndex = DA_Spectral.max_harmonics - 1;
            _r.to_id = DA_Spectral.max_harmonics - 1;

            refresh_ui();
            flag_initialising = false;
        }

        private void button_OK_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        private void button_Cancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
            this.Close();
        }

        private void comboBox_NSF_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (flag_initialising) return;
            _r.from_id = Convert.ToInt32(comboBox_NSF.Text);
            refresh_ui();
        }

        private void comboBox_NST_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (flag_initialising) return;
            _r.to_id = Convert.ToInt32(comboBox_NST.Text);
            refresh_ui();
        }

        private void refresh_ui()
        {
            button_OK.Enabled = (_r.to_id > _r.from_id);
        }
    }
}
