﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Spectral1.PRESENTATION
{
    public partial class PL_Indicator : UserControl
    {
        private indicator_statuses _indicator_status = indicator_statuses.NotKnown;
        private string _status_text = "";
        public enum indicator_statuses
        {
            NotKnown = -1,
            Idle = 0,
            Disconnected = 1,
            Connected = 2,
            OK = 3,
            Active = 4,
            NotOK = 5,
            Sending = 6
        }

        public PL_Indicator()
        {
            InitializeComponent();
            panel_drawing.Paint += new PaintEventHandler(panel_drawing_paint);
        }

        public void SetStatus(indicator_statuses indicator_status, String status_text)
        {
            _indicator_status = indicator_status;
            if (_status_text != "*") { _status_text = status_text; }
            this.Parent.Refresh();
        }

        public void SetStatusInAnotherThread(indicator_statuses indicator_status, String status_text)
        {
            if (this.InvokeRequired)
            {
                this.Invoke((Action)(() => 
                { SetStatus(indicator_status, status_text);}));
            }
            else
                SetStatus(indicator_status, status_text);
        }

        public indicator_statuses GetStatus()
        {
            return _indicator_status;
        }

        private void panel_drawing_paint(object sender, PaintEventArgs e)
        {
            label_status.Text = _status_text;
            Color indicator_color = Color.Black;
            Color indicator_centre_color = Color.Black;
            Color outline_color = Color.Black;
            Color dot_color = Color.Black;
            Color status_text_forecolor = Color.Black;
            switch (_indicator_status)
            {
                case indicator_statuses.Idle:
                    indicator_color = Color.LightGray;
                    status_text_forecolor = Color.DarkGray;
                    break;
                case indicator_statuses.NotKnown:
                    indicator_color = Color.Yellow;
                    status_text_forecolor = Color.DarkGray;
                    break;
                case indicator_statuses.Disconnected:
                    indicator_color = Color.LightGray;
                    status_text_forecolor = Color.DarkGray;
                    break;
                case indicator_statuses.NotOK:
                    indicator_color = Color.Red;
                    status_text_forecolor = Color.Crimson;
                    break;
                case indicator_statuses.OK:
                    indicator_color = Color.LawnGreen;
                    status_text_forecolor = Color.Black;
                    break;
                case indicator_statuses.Connected:
                    indicator_color = Color.LawnGreen;
                    status_text_forecolor = Color.Black;
                    break;
                case indicator_statuses.Active:
                    indicator_color = Color.LawnGreen;
                    status_text_forecolor = Color.Black;
                    break;
                case indicator_statuses.Sending:
                    indicator_color = Color.Red;
                    status_text_forecolor = Color.Crimson;
                    break;
            }
            indicator_centre_color = ChangeColorBrightness(indicator_color,(float)0.3);
            dot_color = ChangeColorBrightness(indicator_color, (float)0.6);
            outline_color = ChangeColorBrightness(indicator_color, (float)-0.3);
            SolidBrush brush1 = new SolidBrush(indicator_color);
            SolidBrush brush2 = new SolidBrush(indicator_centre_color);
            SolidBrush brush3 = new SolidBrush(dot_color);
            SolidBrush brush4 = new SolidBrush(outline_color);
            label_status.ForeColor = status_text_forecolor;

            e.Graphics.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.High;
            e.Graphics.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;

            FillCircle(e.Graphics, brush1, 15, 15, 10);
            Pen outline_pen = new Pen(brush4,2);
            e.Graphics.DrawEllipse(outline_pen, 5, 5, 20, 20);
            FillCircle(e.Graphics, brush2, 15, 15, 7);
            FillCircle(e.Graphics, brush3, 19, 16, 3);
            FillCircle(e.Graphics, brush3, 18, 17, 3);
            FillCircle(e.Graphics, brush3, 18, 18, 3);
        }

        public static void FillCircle(Graphics g, Brush brush, float centerX, float centerY, float radius)
        {
            g.FillEllipse(brush, centerX - radius, centerY - radius,
                          radius + radius, radius + radius);
        }

        /// <summary>
        /// Creates color with corrected brightness.
        /// </summary>
        /// <param name="color">Color to correct.</param>
        /// <param name="correctionFactor">The brightness correction factor. Must be between -1 and 1. 
        /// Negative values produce darker colors.</param>
        /// <returns>
        /// Corrected <see cref="Color"/> structure.
        /// </returns>
        public static Color ChangeColorBrightness(Color color, float correctionFactor)
        {
            float red = (float)color.R;
            float green = (float)color.G;
            float blue = (float)color.B;

            if (correctionFactor < 0)
            {
                correctionFactor = 1 + correctionFactor;
                red *= correctionFactor;
                green *= correctionFactor;
                blue *= correctionFactor;
            }
            else
            {
                red = (255 - red) * correctionFactor + red;
                green = (255 - green) * correctionFactor + green;
                blue = (255 - blue) * correctionFactor + blue;
            }

            return Color.FromArgb(color.A, (int)red, (int)green, (int)blue);
        }

    }
}
