﻿using Spectral1_VBClassLibrary;
using System;
using System.Data;
using System.Drawing;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using System.Windows.Forms;
using WarmBreeze_DataLibrary;
using Spectral1.DATA_ACCESS;
using static Spectral1_VBClassLibrary.DataSet_Spectral;
using static Spectral1.DATA_ACCESS.DA_Spectral;

namespace Spectral1.PRESENTATION
{
    public partial class PL_Import : Form
    {
        CodeGen_DS_Spectral iCGS = new CodeGen_DS_Spectral();

        PL_Main _plm;
        Spectral1_VBClassLibrary.DataSet_Spectral ds_to_import_from;

        public PL_Import(PL_Main plm)
        {
            InitializeComponent();
            _plm = plm;
        }

        private void InitialiseForSelectedFile()
        {

            I_GenericCodeGenNonSortableTable i_tcp = (I_GenericCodeGenNonSortableTable)iCGS.Table_patch;

            DGVColumnConfigs PC = _plm.BL.BLDGV.get_patch_dgv_column_configs();

            pL_UC_AddDeleteDGV_PatchToImport.ColumnConfigs = PC;
            pL_UC_AddDeleteDGV_PatchToImport.DGVConfig.HeaderRowHeight = 32;
            pL_UC_AddDeleteDGV_PatchToImport.DGVConfig.MultiSelect = true;
            pL_UC_AddDeleteDGV_PatchToImport.EX_Initialise(ref i_tcp, "Patch", 500, false);
            pL_UC_AddDeleteDGV_PatchToImport.HideAddDelete();
        }

        private void button_select_file_Click(object sender, EventArgs e)
        {
            using (System.Windows.Forms.OpenFileDialog openFileDialog1 = new System.Windows.Forms.OpenFileDialog())
            {
                try
                {
                    if (Properties.Settings.Default.last_opened_filepath != null && Properties.Settings.Default.last_opened_filepath != "")
                    {
                        openFileDialog1.InitialDirectory = Path.GetFullPath(Properties.Settings.Default.last_opened_filepath);
                    }

                    openFileDialog1.RestoreDirectory = true;
                    openFileDialog1.Title = "Import from";
                    openFileDialog1.DefaultExt = "spectral";
                    openFileDialog1.Filter = "Spectral Sound Module files (*.spectral)|*.spectral";

                    if (openFileDialog1.ShowDialog() == DialogResult.OK)
                    {
                        OpenFile(openFileDialog1.FileName);
                        textBox_file_path.Text = openFileDialog1.FileName;
                        RefreshUI();
                    }
                }
                catch (Exception ex)
                {
                    _plm.PLInfo.DisplayMinorError("Error opening file : " + ex.Message);
                }
            }
        }

        private void OpenFile(string filename)
        {
            _plm.Cursor = Cursors.WaitCursor;
            using (FileStream stream = new FileStream(filename, FileMode.Open))
            {
                BinaryFormatter format = new BinaryFormatter();
                ds_to_import_from = (Spectral1_VBClassLibrary.DataSet_Spectral)format.Deserialize(stream);

                for (Int32 i = 0; i < iCGS.DSSPECTRAL.Tables.Count; i++)
                {
                    iCGS.DSSPECTRAL.Tables[i].Clear();
                    iCGS.DSSPECTRAL.Tables[i].Merge(ds_to_import_from.Tables[i]);
                }
                iCGS.DSSPECTRAL.AcceptChanges();

                InitialiseForSelectedFile();
                _plm.Cursor = Cursors.Default;
            }
        }

        private void RefreshUI()
        {
            button_import.Enabled = (textBox_file_path.Text != "");
            pL_UC_AddDeleteDGV_PatchToImport.Enabled = (textBox_file_path.Text != "");

        }

        private void PL_Import_Shown(object sender, EventArgs e)
        {
            RefreshUI();
        }

        private void button_close_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void button_import_Click(object sender, EventArgs e)
        {
            string import_summary = "";
          
            _plm.SetStatus("Importing");
            Cursor = Cursors.WaitCursor;
            string error_text = _plm.BL.DA.ImportFromFile(pL_UC_AddDeleteDGV_PatchToImport.DGV.SelectedRows,ref import_summary,ref iCGS);
            if (error_text == "")
            {
                _plm.PLInfo.DisplayInfo(import_summary);
            }
            else
            {
                _plm.PLInfo.DisplayMinorError(error_text);
            }

            Cursor = Cursors.Default;
            _plm.BL.DA.DASpectral.data_changed.set_all(true);
            _plm.SyncVisible();
            _plm.RefreshUI();
            _plm.remote_InitialisePatchRelatedViewsForCurrentPatch();
            _plm.remote_InitForCurrentWaveSet();
            _plm.ClearStatus();
        }



    }
}
