﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using static Spectral1.PARSER.c_lexer;

namespace Spectral1.PARSER
{
    public partial class c_parser
    {
        #region "======================== DECLARATIONS ========================="
        private c_lexer _lexer = new c_lexer();
        private c_lexer_token _lookaheadFirst;
        private c_lexer_token _lookaheadSecond;
        private Stack<c_lexer_token> _tokenSequence;
        private c_dsl_functions list_of_functions;

        private RichTextBox _rtb;
        private int rtb_char_index;
        public int rtb_found_start_index;
        public int rtb_found_end_index;

        public enum parser_modes
        {
            all = 0,
            waveset = 1,
            patch = 2,
            filter = 3
        }

        public enum recording_modes
        {
            none = 0,
            waveset = 1,
            patch = 2,
            filter = 3
        }

        public string InvalidEnabledErrorText = "Invalid Enabled value  ";
        public string InvalidPercentErrorText = "Invalid Percent value  ";
        public string InvalidIntegerErrorText = "Invalid Integer value  ";
        public string InvalidDecimalErrorText = "Invalid Decimal value  ";
        #endregion

        #region "======================== PROPERTIES ========================="
        public c_lexer lexer
        {
            get { return _lexer; }
        }

        public c_dsl_functions parsed_list_of_functions
        {
            get { return list_of_functions; }
        }

        #endregion

        #region "======================== PUBLIC METHODS ========================="
        public void Parse(ref RichTextBox rtb,List<c_lexer_token> tokens)
        {
            _rtb = rtb;
            list_of_functions = new c_dsl_functions();
            rtb_char_index = 0;
            rtb_found_start_index = 0;
            rtb_found_end_index = 0;

            LoadSequenceStack(tokens);
            PrepareLookaheads();
            sdl_code();
            DiscardToken(TokenType.SequenceTerminator);
        }

        #endregion

        #region "======================== METHODS - TOKEN LOGIC ==================="
        public static bool is_enabled_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.True
                   || token.TokenType == TokenType.False;
        }

        public static bool is_percent_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.Percent;
        }

        public static bool is_note_name_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.NoteValue;
        }
        public static bool is_integer_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.Integer;
        }

        public static bool is_decimal_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.Decimal;
        }

        private string GetEnabledValue(c_lexer_token token)
        {
            if (is_enabled_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidEnabledErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetPercentValue(c_lexer_token token)
        {
            if (is_percent_token(token))
            { return token.Value.Replace("%", ""); }
            else
            {
                throw new c_dsl_exception(InvalidPercentErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetIntegerValue(c_lexer_token token)
        {
            if (is_integer_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidIntegerErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetDecimalValue(c_lexer_token token)
        {
            if (is_decimal_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidDecimalErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }
        #endregion


        #region "======================== PRIVATE METHODS ========================="
        private void sdl_code()
        {
            //sdl_code -> define Dot WaveSetDefinition|PatchDefinition|FilterDefinition
            while (_lookaheadFirst.TokenType != TokenType.SequenceTerminator)
            {
                DiscardToken(TokenType.Define);
                DiscardToken(TokenType.Dot);
                if (lexer.is_definition_object_token(_lookaheadFirst))
                {
                    switch (_lookaheadFirst.TokenType)
                    {
                        case TokenType.WaveSet:
                            WaveSetDefinition(); break;
                        case TokenType.Patch:
                            PatchDefinition(); break;
                        case TokenType.Filter:
                            FilterDefinition(); break;
                    }
                }
                else
                {
                    throw new c_dsl_exception(ExpectedDefinitionObjectErrorText + "'" + _lookaheadFirst.Value + "'");
                }
            }
        }

        private void LoadSequenceStack(List<c_lexer_token> tokens)
        {
            _tokenSequence = new Stack<c_lexer_token>();
            int count = tokens.Count;
            for (int i = count - 1; i >= 0; i--)
            {
                if (tokens[i].TokenType != TokenType.Comment)
                {
                    _tokenSequence.Push(tokens[i]);
                }
            }
        }

        private c_lexer_token ReadToken(TokenType tokenType)
        {
            if (_lookaheadFirst.TokenType != tokenType)
                throw new c_dsl_exception(string.Format("Expected {0} but found: {1}", tokenType.ToString(), _lookaheadFirst.Value));

            return _lookaheadFirst;
        }

        private void DiscardToken()
        {
            if (rtb_char_index < _rtb.Text.Length)
            {
                try
                {
                    rtb_found_start_index = _rtb.Find(_lookaheadFirst.Value, rtb_char_index, RichTextBoxFinds.None);
                    if (rtb_found_start_index > -1)
                    {
                        rtb_found_end_index = rtb_found_start_index + _lookaheadFirst.Value.Length;
                        rtb_char_index = rtb_found_end_index - 1;
                    }
                }
                catch (Exception ex)
                {
                    string s = "";
                }

            }


            _lookaheadFirst = _lookaheadSecond.Clone();

            if (_tokenSequence.Any())
                _lookaheadSecond = _tokenSequence.Pop();
            else
                _lookaheadSecond = new c_lexer_token(TokenType.SequenceTerminator, string.Empty,0);
        }

        private void DiscardToken(TokenType tokenType)
        {
            if (_lookaheadFirst.TokenType != tokenType)
                throw new c_dsl_exception(string.Format("Expected {0} but found {1}", tokenType.ToString(), _lookaheadFirst.Value));

            DiscardToken();
        }

        private void PrepareLookaheads()
        {
            _lookaheadFirst = _tokenSequence.Pop();
            _lookaheadSecond = _tokenSequence.Pop();
        }
        #endregion
    }
}
