﻿Imports System.Windows.Forms
Imports WarmBreeze_DataLibrary
#Region "Automatically generated DataSet code"
Public Class CodeGen_DS_Spectral_System
    '=============================================================================================
    'Automatic DataSet code generation. © Jeremy Leach WarmBreeze Software 2016
    'Generated on :05/12/2020 15:12:01
    'Version : 1.0
    'RULES:
    ' - Primary key columns must be integer ID columns.
    ' - Columns can end _id and not be primary keys. It checks which ones are primary.
    ' - All primary and foreign key names should be of the format <tablename>_id. Lowever case.
    ' - All tables MUST have a sort_order column.
    ' - If there is a name column then it must be of the format <tablename>_name.
    '=============================================================================================

#Region "Declarations"
    'DataSet variable
    Private _DSSPECTRALSYSTEM As New DataSet_Spectral_System
    Private PLInfo As New WarmBreeze_DataLibrary.PL_Info
    'Table variables
    Private WithEvents _Table_adsr_preset As New TableClass_adsr_preset(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_adsr_section As New TableClass_adsr_section(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_cc_source As New TableClass_cc_source(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_detuning_mode As New TableClass_detuning_mode(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_envelope As New TableClass_envelope(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_envelope_type As New TableClass_envelope_type(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_filter_type As New TableClass_filter_type(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_harmonic As New TableClass_harmonic(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_intensity_layer As New TableClass_intensity_layer(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_lfo As New TableClass_lfo(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_lfo_wave_type As New TableClass_lfo_wave_type(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_midi_channel As New TableClass_midi_channel(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_midi_note As New TableClass_midi_note(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_note_sector As New TableClass_note_sector(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_patch_category As New TableClass_patch_category(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_patch_type As New TableClass_patch_type(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_phase_setting As New TableClass_phase_setting(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_sample As New TableClass_sample(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_sample_playback_mode As New TableClass_sample_playback_mode(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_timbre_mode As New TableClass_timbre_mode(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_wave_editing_action As New TableClass_wave_editing_action(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_wave_shape As New TableClass_wave_shape(_DSSPECTRALSYSTEM, Me)
    Private WithEvents _Table_waveform As New TableClass_waveform(_DSSPECTRALSYSTEM, Me)
    Public Event Event_AfterFileLoad(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_adsr_preset_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_adsr_preset_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_adsr_section_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_adsr_section_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_cc_source_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_cc_source_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_detuning_mode_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_detuning_mode_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_envelope_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_envelope_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_envelope_type_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_envelope_type_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_filter_type_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_filter_type_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_harmonic_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_harmonic_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_intensity_layer_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_intensity_layer_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_lfo_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_lfo_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_lfo_wave_type_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_lfo_wave_type_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_midi_channel_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_midi_channel_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_midi_note_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_midi_note_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_note_sector_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_note_sector_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_patch_category_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_patch_category_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_patch_type_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_patch_type_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_phase_setting_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_phase_setting_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_sample_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_sample_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_sample_playback_mode_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_sample_playback_mode_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_timbre_mode_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_timbre_mode_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_wave_editing_action_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_wave_editing_action_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_wave_shape_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_wave_shape_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_waveform_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
    Public Event Event_waveform_RowDeleted(ByVal sender As Object, ByVal e As System.EventArgs)
#End Region

#Region "Properties"
    Public Property DSSPECTRALSYSTEM() As DataSet_Spectral_System
        Get
            Return _DSSPECTRALSYSTEM
        End Get
        Set(value As DataSet_Spectral_System)
            _DSSPECTRALSYSTEM = value
        End Set
    End Property

    Public ReadOnly Property Tables() As DataTableCollection
        Get
            Return _DSSPECTRALSYSTEM.Tables
        End Get
    End Property

    Public Property Table_adsr_preset() As TableClass_adsr_preset
        Get
            Return _Table_adsr_preset
        End Get
        Set(value As TableClass_adsr_preset)
            _Table_adsr_preset = value
        End Set
    End Property

    Public Property Table_adsr_section() As TableClass_adsr_section
        Get
            Return _Table_adsr_section
        End Get
        Set(value As TableClass_adsr_section)
            _Table_adsr_section = value
        End Set
    End Property

    Public Property Table_cc_source() As TableClass_cc_source
        Get
            Return _Table_cc_source
        End Get
        Set(value As TableClass_cc_source)
            _Table_cc_source = value
        End Set
    End Property

    Public Property Table_detuning_mode() As TableClass_detuning_mode
        Get
            Return _Table_detuning_mode
        End Get
        Set(value As TableClass_detuning_mode)
            _Table_detuning_mode = value
        End Set
    End Property

    Public Property Table_envelope() As TableClass_envelope
        Get
            Return _Table_envelope
        End Get
        Set(value As TableClass_envelope)
            _Table_envelope = value
        End Set
    End Property

    Public Property Table_envelope_type() As TableClass_envelope_type
        Get
            Return _Table_envelope_type
        End Get
        Set(value As TableClass_envelope_type)
            _Table_envelope_type = value
        End Set
    End Property

    Public Property Table_filter_type() As TableClass_filter_type
        Get
            Return _Table_filter_type
        End Get
        Set(value As TableClass_filter_type)
            _Table_filter_type = value
        End Set
    End Property

    Public Property Table_harmonic() As TableClass_harmonic
        Get
            Return _Table_harmonic
        End Get
        Set(value As TableClass_harmonic)
            _Table_harmonic = value
        End Set
    End Property

    Public Property Table_intensity_layer() As TableClass_intensity_layer
        Get
            Return _Table_intensity_layer
        End Get
        Set(value As TableClass_intensity_layer)
            _Table_intensity_layer = value
        End Set
    End Property

    Public Property Table_lfo() As TableClass_lfo
        Get
            Return _Table_lfo
        End Get
        Set(value As TableClass_lfo)
            _Table_lfo = value
        End Set
    End Property

    Public Property Table_lfo_wave_type() As TableClass_lfo_wave_type
        Get
            Return _Table_lfo_wave_type
        End Get
        Set(value As TableClass_lfo_wave_type)
            _Table_lfo_wave_type = value
        End Set
    End Property

    Public Property Table_midi_channel() As TableClass_midi_channel
        Get
            Return _Table_midi_channel
        End Get
        Set(value As TableClass_midi_channel)
            _Table_midi_channel = value
        End Set
    End Property

    Public Property Table_midi_note() As TableClass_midi_note
        Get
            Return _Table_midi_note
        End Get
        Set(value As TableClass_midi_note)
            _Table_midi_note = value
        End Set
    End Property

    Public Property Table_note_sector() As TableClass_note_sector
        Get
            Return _Table_note_sector
        End Get
        Set(value As TableClass_note_sector)
            _Table_note_sector = value
        End Set
    End Property

    Public Property Table_patch_category() As TableClass_patch_category
        Get
            Return _Table_patch_category
        End Get
        Set(value As TableClass_patch_category)
            _Table_patch_category = value
        End Set
    End Property

    Public Property Table_patch_type() As TableClass_patch_type
        Get
            Return _Table_patch_type
        End Get
        Set(value As TableClass_patch_type)
            _Table_patch_type = value
        End Set
    End Property

    Public Property Table_phase_setting() As TableClass_phase_setting
        Get
            Return _Table_phase_setting
        End Get
        Set(value As TableClass_phase_setting)
            _Table_phase_setting = value
        End Set
    End Property

    Public Property Table_sample() As TableClass_sample
        Get
            Return _Table_sample
        End Get
        Set(value As TableClass_sample)
            _Table_sample = value
        End Set
    End Property

    Public Property Table_sample_playback_mode() As TableClass_sample_playback_mode
        Get
            Return _Table_sample_playback_mode
        End Get
        Set(value As TableClass_sample_playback_mode)
            _Table_sample_playback_mode = value
        End Set
    End Property

    Public Property Table_timbre_mode() As TableClass_timbre_mode
        Get
            Return _Table_timbre_mode
        End Get
        Set(value As TableClass_timbre_mode)
            _Table_timbre_mode = value
        End Set
    End Property

    Public Property Table_wave_editing_action() As TableClass_wave_editing_action
        Get
            Return _Table_wave_editing_action
        End Get
        Set(value As TableClass_wave_editing_action)
            _Table_wave_editing_action = value
        End Set
    End Property

    Public Property Table_wave_shape() As TableClass_wave_shape
        Get
            Return _Table_wave_shape
        End Get
        Set(value As TableClass_wave_shape)
            _Table_wave_shape = value
        End Set
    End Property

    Public Property Table_waveform() As TableClass_waveform
        Get
            Return _Table_waveform
        End Get
        Set(value As TableClass_waveform)
            _Table_waveform = value
        End Set
    End Property

#End Region

#Region "Methods - General"
    Public Sub New()
    End Sub

    Public Sub SaveDataToFile(FilePath As String)
        Try
            _DSSPECTRALSYSTEM.WriteXml(FilePath, XmlWriteMode.IgnoreSchema)
            'Must accept all the changes
            AcceptChangesOnAllFileData()
        Catch ex As Exception
            PLInfo.DisplayExclamation("Error saving to file. Error is :" & ex.Message.ToString)
        End Try
    End Sub

    Public Sub LoadDataFromFile(FilePath As String)
        Try
            ''First delete all data because :If the DataSet already contains data, the new data from the XML is added to the data already present in the DataSet.
            DeleteAllTableContents()
            ''Now read the data
            _DSSPECTRALSYSTEM.ReadXml(FilePath, XmlWriteMode.IgnoreSchema)
            ''Must accept all the changes
            AcceptChangesOnAllFileData()
            RaiseEvent Event_AfterFileLoad(Nothing, Nothing)
        Catch ex As Exception
            PLInfo.DisplayExclamation("Error loading from file. Error is :" & ex.Message.ToString)
        End Try
    End Sub

    Friend Function HasChildTableDataDependency(parent_table_name As String, parent_table_pk_id As Integer) As Boolean
        Dim parent_table_pk_name As String = parent_table_name & "_id"
        For Each T As DataTable In _DSSPECTRALSYSTEM.Tables
            If T.TableName <> parent_table_name Then
                For Each C As DataColumn In T.Columns
                    If C.ColumnName = parent_table_pk_name Then
                        If T.Select(C.ColumnName & " = " & parent_table_pk_id, Nothing, DataViewRowState.CurrentRows).Count > 0 Then
                            Return True
                        End If
                    End If
                Next
            End If
        Next
        Return False
    End Function

    Public Function DataHasChanged() As Boolean
        For Each T As DataTable In _DSSPECTRALSYSTEM.Tables
            If T.GetChanges IsNot Nothing Then
                If T.Rows.Count > 0 Then
                    If T.GetChanges.Rows.Count > 0 Then Return True
                End If
            End If
        Next
        Return False
    End Function

    Public Sub AcceptChangesOnAllFileData()
        For Each T As DataTable In _DSSPECTRALSYSTEM.Tables
            T.AcceptChanges()
        Next
    End Sub

    Public Sub DisposeOfAllComponents()
        _DSSPECTRALSYSTEM.Dispose()
        _Table_adsr_preset.Table_BindingSource.Dispose()
        _Table_adsr_section.Table_BindingSource.Dispose()
        _Table_cc_source.Table_BindingSource.Dispose()
        _Table_detuning_mode.Table_BindingSource.Dispose()
        _Table_envelope.Table_BindingSource.Dispose()
        _Table_envelope_type.Table_BindingSource.Dispose()
        _Table_filter_type.Table_BindingSource.Dispose()
        _Table_harmonic.Table_BindingSource.Dispose()
        _Table_intensity_layer.Table_BindingSource.Dispose()
        _Table_lfo.Table_BindingSource.Dispose()
        _Table_lfo_wave_type.Table_BindingSource.Dispose()
        _Table_midi_channel.Table_BindingSource.Dispose()
        _Table_midi_note.Table_BindingSource.Dispose()
        _Table_note_sector.Table_BindingSource.Dispose()
        _Table_patch_category.Table_BindingSource.Dispose()
        _Table_patch_type.Table_BindingSource.Dispose()
        _Table_phase_setting.Table_BindingSource.Dispose()
        _Table_sample.Table_BindingSource.Dispose()
        _Table_sample_playback_mode.Table_BindingSource.Dispose()
        _Table_timbre_mode.Table_BindingSource.Dispose()
        _Table_wave_editing_action.Table_BindingSource.Dispose()
        _Table_wave_shape.Table_BindingSource.Dispose()
        _Table_waveform.Table_BindingSource.Dispose()
    End Sub

    Public Sub DeleteAllTableContents()
        ''NOTE: Do NOT use DSFT.Tables.Clear() because thiserases the actual tables !!
        For Each T As DataTable In _DSSPECTRALSYSTEM.Tables
            T.Clear()
        Next
    End Sub

    Public Sub DecoupleAllTableBindings()
        _Table_adsr_preset.Table_BindingSource.DataSource = Nothing
        _Table_adsr_section.Table_BindingSource.DataSource = Nothing
        _Table_cc_source.Table_BindingSource.DataSource = Nothing
        _Table_detuning_mode.Table_BindingSource.DataSource = Nothing
        _Table_envelope.Table_BindingSource.DataSource = Nothing
        _Table_envelope_type.Table_BindingSource.DataSource = Nothing
        _Table_filter_type.Table_BindingSource.DataSource = Nothing
        _Table_harmonic.Table_BindingSource.DataSource = Nothing
        _Table_intensity_layer.Table_BindingSource.DataSource = Nothing
        _Table_lfo.Table_BindingSource.DataSource = Nothing
        _Table_lfo_wave_type.Table_BindingSource.DataSource = Nothing
        _Table_midi_channel.Table_BindingSource.DataSource = Nothing
        _Table_midi_note.Table_BindingSource.DataSource = Nothing
        _Table_note_sector.Table_BindingSource.DataSource = Nothing
        _Table_patch_category.Table_BindingSource.DataSource = Nothing
        _Table_patch_type.Table_BindingSource.DataSource = Nothing
        _Table_phase_setting.Table_BindingSource.DataSource = Nothing
        _Table_sample.Table_BindingSource.DataSource = Nothing
        _Table_sample_playback_mode.Table_BindingSource.DataSource = Nothing
        _Table_timbre_mode.Table_BindingSource.DataSource = Nothing
        _Table_wave_editing_action.Table_BindingSource.DataSource = Nothing
        _Table_wave_shape.Table_BindingSource.DataSource = Nothing
        _Table_waveform.Table_BindingSource.DataSource = Nothing
    End Sub

    Public Sub RecoupleAllTableBindings()
        ReCoupleTableBindings(_Table_adsr_preset)
        ReCoupleTableBindings(_Table_adsr_section)
        ReCoupleTableBindings(_Table_cc_source)
        ReCoupleTableBindings(_Table_detuning_mode)
        ReCoupleTableBindings(_Table_envelope)
        ReCoupleTableBindings(_Table_envelope_type)
        ReCoupleTableBindings(_Table_filter_type)
        ReCoupleTableBindings(_Table_harmonic)
        ReCoupleTableBindings(_Table_intensity_layer)
        ReCoupleTableBindings(_Table_lfo)
        ReCoupleTableBindings(_Table_lfo_wave_type)
        ReCoupleTableBindings(_Table_midi_channel)
        ReCoupleTableBindings(_Table_midi_note)
        ReCoupleTableBindings(_Table_note_sector)
        ReCoupleTableBindings(_Table_patch_category)
        ReCoupleTableBindings(_Table_patch_type)
        ReCoupleTableBindings(_Table_phase_setting)
        ReCoupleTableBindings(_Table_sample)
        ReCoupleTableBindings(_Table_sample_playback_mode)
        ReCoupleTableBindings(_Table_timbre_mode)
        ReCoupleTableBindings(_Table_wave_editing_action)
        ReCoupleTableBindings(_Table_wave_shape)
        ReCoupleTableBindings(_Table_waveform)
    End Sub

    Private Sub ReCoupleTableBindings(CodeGenTable As I_GenericCodeGenTable)
        For Each ChildCodeGenTable As I_GenericCodeGenTable In CodeGenTable.ChildCodeGenTableList
            ReCoupleTableBindings(ChildCodeGenTable)
        Next
        CodeGenTable.RecoupleTableBindings()
    End Sub

    Public Sub InitialiseForParentTable(ParentCodeGenTable As I_GenericCodeGenTable)
        If ParentCodeGenTable Is Nothing Then Exit Sub
        Dim ParentTableName As String = ParentCodeGenTable.TableName
        Dim ParentTableIDValue As Integer = ParentCodeGenTable.GetTablePKCurrentValue
        For Each ChildCodGenTable As I_GenericCodeGenTable In ParentCodeGenTable.ChildCodeGenTableList
            If ChildCodGenTable.HasForeignKeys = True Then
                ChildCodGenTable.SetDefaultViewFilter(ParentTableName & "_id = " & ParentTableIDValue)
                ChildCodGenTable.SetDefaultForeignKeyValue(ParentTableName & "_id", ParentTableIDValue)
            End If
            InitialiseForParentTable(ChildCodGenTable)
        Next
    End Sub

#End Region

#Region "Private subs"
    Private Sub EventRelay_adsr_preset_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_adsr_preset.Event_NewRowAdded
        RaiseEvent Event_adsr_preset_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_adsr_preset_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_adsr_preset.Event_BeforeRowDeleted
        RaiseEvent Event_adsr_preset_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_adsr_section_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_adsr_section.Event_NewRowAdded
        RaiseEvent Event_adsr_section_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_adsr_section_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_adsr_section.Event_BeforeRowDeleted
        RaiseEvent Event_adsr_section_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_cc_source_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_cc_source.Event_NewRowAdded
        RaiseEvent Event_cc_source_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_cc_source_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_cc_source.Event_BeforeRowDeleted
        RaiseEvent Event_cc_source_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_detuning_mode_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_detuning_mode.Event_NewRowAdded
        RaiseEvent Event_detuning_mode_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_detuning_mode_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_detuning_mode.Event_BeforeRowDeleted
        RaiseEvent Event_detuning_mode_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_envelope_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_envelope.Event_NewRowAdded
        RaiseEvent Event_envelope_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_envelope_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_envelope.Event_BeforeRowDeleted
        RaiseEvent Event_envelope_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_envelope_type_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_envelope_type.Event_NewRowAdded
        RaiseEvent Event_envelope_type_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_envelope_type_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_envelope_type.Event_BeforeRowDeleted
        RaiseEvent Event_envelope_type_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_filter_type_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_filter_type.Event_NewRowAdded
        RaiseEvent Event_filter_type_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_filter_type_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_filter_type.Event_BeforeRowDeleted
        RaiseEvent Event_filter_type_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_harmonic_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_harmonic.Event_NewRowAdded
        RaiseEvent Event_harmonic_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_harmonic_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_harmonic.Event_BeforeRowDeleted
        RaiseEvent Event_harmonic_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_intensity_layer_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_intensity_layer.Event_NewRowAdded
        RaiseEvent Event_intensity_layer_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_intensity_layer_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_intensity_layer.Event_BeforeRowDeleted
        RaiseEvent Event_intensity_layer_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_lfo_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_lfo.Event_NewRowAdded
        RaiseEvent Event_lfo_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_lfo_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_lfo.Event_BeforeRowDeleted
        RaiseEvent Event_lfo_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_lfo_wave_type_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_lfo_wave_type.Event_NewRowAdded
        RaiseEvent Event_lfo_wave_type_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_lfo_wave_type_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_lfo_wave_type.Event_BeforeRowDeleted
        RaiseEvent Event_lfo_wave_type_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_midi_channel_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_midi_channel.Event_NewRowAdded
        RaiseEvent Event_midi_channel_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_midi_channel_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_midi_channel.Event_BeforeRowDeleted
        RaiseEvent Event_midi_channel_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_midi_note_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_midi_note.Event_NewRowAdded
        RaiseEvent Event_midi_note_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_midi_note_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_midi_note.Event_BeforeRowDeleted
        RaiseEvent Event_midi_note_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_note_sector_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_note_sector.Event_NewRowAdded
        RaiseEvent Event_note_sector_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_note_sector_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_note_sector.Event_BeforeRowDeleted
        RaiseEvent Event_note_sector_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_patch_category_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_patch_category.Event_NewRowAdded
        RaiseEvent Event_patch_category_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_patch_category_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_patch_category.Event_BeforeRowDeleted
        RaiseEvent Event_patch_category_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_patch_type_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_patch_type.Event_NewRowAdded
        RaiseEvent Event_patch_type_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_patch_type_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_patch_type.Event_BeforeRowDeleted
        RaiseEvent Event_patch_type_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_phase_setting_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_phase_setting.Event_NewRowAdded
        RaiseEvent Event_phase_setting_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_phase_setting_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_phase_setting.Event_BeforeRowDeleted
        RaiseEvent Event_phase_setting_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_sample_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_sample.Event_NewRowAdded
        RaiseEvent Event_sample_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_sample_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_sample.Event_BeforeRowDeleted
        RaiseEvent Event_sample_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_sample_playback_mode_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_sample_playback_mode.Event_NewRowAdded
        RaiseEvent Event_sample_playback_mode_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_sample_playback_mode_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_sample_playback_mode.Event_BeforeRowDeleted
        RaiseEvent Event_sample_playback_mode_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_timbre_mode_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_timbre_mode.Event_NewRowAdded
        RaiseEvent Event_timbre_mode_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_timbre_mode_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_timbre_mode.Event_BeforeRowDeleted
        RaiseEvent Event_timbre_mode_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_wave_editing_action_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_wave_editing_action.Event_NewRowAdded
        RaiseEvent Event_wave_editing_action_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_wave_editing_action_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_wave_editing_action.Event_BeforeRowDeleted
        RaiseEvent Event_wave_editing_action_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_wave_shape_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_wave_shape.Event_NewRowAdded
        RaiseEvent Event_wave_shape_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_wave_shape_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_wave_shape.Event_BeforeRowDeleted
        RaiseEvent Event_wave_shape_RowDeleted(sender, Nothing)
    End Sub

    Private Sub EventRelay_waveform_NewRowAdded(sender As Object, e As System.EventArgs) Handles _Table_waveform.Event_NewRowAdded
        RaiseEvent Event_waveform_NewRowAdded(sender, Nothing)
    End Sub

    Private Sub EventRelay_waveform_RowDeleted(sender As Object, e As System.EventArgs) Handles _Table_waveform.Event_BeforeRowDeleted
        RaiseEvent Event_waveform_RowDeleted(sender, Nothing)
    End Sub

#End Region

#Region "Sub-classes"
#Region "----------Class : TableClass_adsr_preset ------------------------------"
    Public Class TableClass_adsr_preset
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.adsr_presetDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim envelope_id As System.Int32
            Dim adsr_preset_id As System.Int32
            Dim preset_name As System.String
            Dim envelope_type_id As System.Int32
            Dim attack_target As System.Single
            Dim decay_target As System.Single
            Dim sustain_target As System.Single
            Dim release_target As System.Single
            Dim attack_linear_delta As System.Int32
            Dim decay_linear_delta As System.Int32
            Dim sustain_linear_delta As System.Int32
            Dim release_linear_delta As System.Int32
            Dim attack_exp_multiplier As System.Single
            Dim decay_exp_multiplier As System.Single
            Dim sustain_exp_multiplier As System.Single
            Dim release_exp_multiplier As System.Single
            Dim sort_order As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public envelope_id As System.Int32 = 0
            Public preset_name As System.String = ""
            Public envelope_type_id As System.Int32 = 0
            Public attack_target As System.Single = 0
            Public decay_target As System.Single = 0
            Public sustain_target As System.Single = 0
            Public release_target As System.Single = 0
            Public attack_linear_delta As System.Int32 = 0
            Public decay_linear_delta As System.Int32 = 0
            Public sustain_linear_delta As System.Int32 = 0
            Public release_linear_delta As System.Int32 = 0
            Public attack_exp_multiplier As System.Single = 0
            Public decay_exp_multiplier As System.Single = 0
            Public sustain_exp_multiplier As System.Single = 0
            Public release_exp_multiplier As System.Single = 0
            Public sort_order As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const envelope_id = "envelope_id"
            Const adsr_preset_id = "adsr_preset_id"
            Const preset_name = "preset_name"
            Const envelope_type_id = "envelope_type_id"
            Const attack_target = "attack_target"
            Const decay_target = "decay_target"
            Const sustain_target = "sustain_target"
            Const release_target = "release_target"
            Const attack_linear_delta = "attack_linear_delta"
            Const decay_linear_delta = "decay_linear_delta"
            Const sustain_linear_delta = "sustain_linear_delta"
            Const release_linear_delta = "release_linear_delta"
            Const attack_exp_multiplier = "attack_exp_multiplier"
            Const decay_exp_multiplier = "decay_exp_multiplier"
            Const sustain_exp_multiplier = "sustain_exp_multiplier"
            Const release_exp_multiplier = "release_exp_multiplier"
            Const sort_order = "sort_order"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "adsr_preset"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.adsr_presetDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return True
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.adsr_preset
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.adsr_preset.DefaultView
            DefaultView.Sort = "sort_order ASC"
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenSortableTable.AddRow
            Dim R As DataSet_Spectral_System.adsr_presetRow = _DSSPECTRALSYSTEM.adsr_preset.Newadsr_presetRow
            With R
                .adsr_preset_id = GetNewadsr_presetID()
                .envelope_id = _DefaultRowValues.envelope_id
                If _DefaultRowValues.preset_name IsNot Nothing Then .preset_name = _DefaultRowValues.preset_name
                .envelope_type_id = _DefaultRowValues.envelope_type_id
                .attack_target = _DefaultRowValues.attack_target
                .decay_target = _DefaultRowValues.decay_target
                .sustain_target = _DefaultRowValues.sustain_target
                .release_target = _DefaultRowValues.release_target
                .attack_linear_delta = _DefaultRowValues.attack_linear_delta
                .decay_linear_delta = _DefaultRowValues.decay_linear_delta
                .sustain_linear_delta = _DefaultRowValues.sustain_linear_delta
                .release_linear_delta = _DefaultRowValues.release_linear_delta
                .attack_exp_multiplier = _DefaultRowValues.attack_exp_multiplier
                .decay_exp_multiplier = _DefaultRowValues.decay_exp_multiplier
                .sustain_exp_multiplier = _DefaultRowValues.sustain_exp_multiplier
                .release_exp_multiplier = _DefaultRowValues.release_exp_multiplier
                .sort_order = _DefaultRowValues.sort_order
                .sort_order = 10000
            End With
            _DSSPECTRALSYSTEM.adsr_preset.Addadsr_presetRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.adsr_preset_id
        End Function

        Public Function AddRow2(envelope_id As System.Int32, preset_name As System.String, envelope_type_id As System.Int32, attack_target As System.Single, decay_target As System.Single, sustain_target As System.Single, release_target As System.Single, attack_linear_delta As System.Int32, decay_linear_delta As System.Int32, sustain_linear_delta As System.Int32, release_linear_delta As System.Int32, attack_exp_multiplier As System.Single, decay_exp_multiplier As System.Single, sustain_exp_multiplier As System.Single, release_exp_multiplier As System.Single, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.adsr_presetRow = _DSSPECTRALSYSTEM.adsr_preset.Newadsr_presetRow
            With R
                .adsr_preset_id = GetNewadsr_presetID()
                .envelope_id = envelope_id
                .preset_name = preset_name
                .envelope_type_id = envelope_type_id
                .attack_target = attack_target
                .decay_target = decay_target
                .sustain_target = sustain_target
                .release_target = release_target
                .attack_linear_delta = attack_linear_delta
                .decay_linear_delta = decay_linear_delta
                .sustain_linear_delta = sustain_linear_delta
                .release_linear_delta = release_linear_delta
                .attack_exp_multiplier = attack_exp_multiplier
                .decay_exp_multiplier = decay_exp_multiplier
                .sustain_exp_multiplier = sustain_exp_multiplier
                .release_exp_multiplier = release_exp_multiplier
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.adsr_preset.Addadsr_presetRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.adsr_preset_id
        End Function

        Public Function AddRow3(envelope_id As System.Int32, adsr_preset_id As System.Int32, preset_name As System.String, envelope_type_id As System.Int32, attack_target As System.Single, decay_target As System.Single, sustain_target As System.Single, release_target As System.Single, attack_linear_delta As System.Int32, decay_linear_delta As System.Int32, sustain_linear_delta As System.Int32, release_linear_delta As System.Int32, attack_exp_multiplier As System.Single, decay_exp_multiplier As System.Single, sustain_exp_multiplier As System.Single, release_exp_multiplier As System.Single, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.adsr_presetRow = _DSSPECTRALSYSTEM.adsr_preset.Newadsr_presetRow
            With R
                .envelope_id = envelope_id
                .adsr_preset_id = adsr_preset_id
                .preset_name = preset_name
                .envelope_type_id = envelope_type_id
                .attack_target = attack_target
                .decay_target = decay_target
                .sustain_target = sustain_target
                .release_target = release_target
                .attack_linear_delta = attack_linear_delta
                .decay_linear_delta = decay_linear_delta
                .sustain_linear_delta = sustain_linear_delta
                .release_linear_delta = release_linear_delta
                .attack_exp_multiplier = attack_exp_multiplier
                .decay_exp_multiplier = decay_exp_multiplier
                .sustain_exp_multiplier = sustain_exp_multiplier
                .release_exp_multiplier = release_exp_multiplier
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.adsr_preset.Addadsr_presetRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.adsr_preset_id
        End Function

        Public Function envelope_id_ForeignKeyUsed(envelope_id) As Boolean
            Dim RowSet As DataSet_Spectral_System.adsr_presetRow() = _DSSPECTRALSYSTEM.adsr_preset.Select("envelope_id = " & envelope_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function envelope_type_id_ForeignKeyUsed(envelope_type_id) As Boolean
            Dim RowSet As DataSet_Spectral_System.adsr_presetRow() = _DSSPECTRALSYSTEM.adsr_preset.Select("envelope_type_id = " & envelope_type_id, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.adsr_presetRow() = _DSSPECTRALSYSTEM.adsr_preset.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.adsr_presetRow() = _DSSPECTRALSYSTEM.adsr_preset.Select("adsr_preset_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function GetRow(envelope_id As Integer, adsr_preset_id As Integer) As DataSet_Spectral_System.adsr_presetRow
            Return _DSSPECTRALSYSTEM.adsr_preset.FindByenvelope_idadsr_preset_id(envelope_id, adsr_preset_id)
        End Function

        Public Function GetRowsSortedBySortOrder(Filter As String) As DataRow() Implements I_GenericCodeGenSortableTable.GetRowsSortedBySortOrder
            Return _DSSPECTRALSYSTEM.adsr_preset.Select(Filter, "sort_order ASC", DataViewRowState.CurrentRows)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.adsr_presetRow() = _DSSPECTRALSYSTEM.adsr_preset.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.adsr_preset_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.adsr_presetRow
            Dim RowSet As DataSet_Spectral_System.adsr_presetRow() = _DSSPECTRALSYSTEM.adsr_preset.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("adsr_preset", _CurrentRow.adsr_preset_id)
        End Function

        Public Sub DeleteRow(envelope_id As Integer, adsr_preset_id As Integer)
            Dim R As DataSet_Spectral_System.adsr_presetRow = GetRow(envelope_id, adsr_preset_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.adsr_presetRow = GetRow(CurrentRow.envelope_id, CurrentRow.adsr_preset_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.adsr_presetRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.adsr_presetRow In RowsToDelete
                DeleteRow(R.envelope_id, R.adsr_preset_id)
            Next
        End Sub

        Public Sub MoveCurrentRow(MoveUp As Boolean) Implements I_GenericCodeGenSortableTable.MoveCurrentRow
            Dim R As DataSet_Spectral_System.adsr_presetRow = GetRow(CurrentRow.envelope_id, CurrentRow.adsr_preset_id)
            If MoveUp = True Then
                R.sort_order = R.sort_order - 15
            Else
                R.sort_order = R.sort_order + 15
            End If
            R.EndEdit() 'Seems to be ESSENTIAL, otherwise the next SELECT doesn't order properly. Strange !! 

            ReSortRows()
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .envelope_id = DGV.CurrentRow.Cells("envelope_id").Value
                    .adsr_preset_id = DGV.CurrentRow.Cells("adsr_preset_id").Value
                    .preset_name = DGV.CurrentRow.Cells("preset_name").Value.ToString
                    .envelope_type_id = DGV.CurrentRow.Cells("envelope_type_id").Value
                    .attack_target = DGV.CurrentRow.Cells("attack_target").Value
                    .decay_target = DGV.CurrentRow.Cells("decay_target").Value
                    .sustain_target = DGV.CurrentRow.Cells("sustain_target").Value
                    .release_target = DGV.CurrentRow.Cells("release_target").Value
                    .attack_linear_delta = DGV.CurrentRow.Cells("attack_linear_delta").Value
                    .decay_linear_delta = DGV.CurrentRow.Cells("decay_linear_delta").Value
                    .sustain_linear_delta = DGV.CurrentRow.Cells("sustain_linear_delta").Value
                    .release_linear_delta = DGV.CurrentRow.Cells("release_linear_delta").Value
                    .attack_exp_multiplier = DGV.CurrentRow.Cells("attack_exp_multiplier").Value
                    .decay_exp_multiplier = DGV.CurrentRow.Cells("decay_exp_multiplier").Value
                    .sustain_exp_multiplier = DGV.CurrentRow.Cells("sustain_exp_multiplier").Value
                    .release_exp_multiplier = DGV.CurrentRow.Cells("release_exp_multiplier").Value
                    .sort_order = DGV.CurrentRow.Cells("sort_order").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.adsr_presetRow() = _DSSPECTRALSYSTEM.adsr_preset.Select("adsr_preset_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .envelope_id = RowSet.First.envelope_id
                    .adsr_preset_id = RowSet.First.adsr_preset_id
                    .preset_name = RowSet.First.preset_name
                    .envelope_type_id = RowSet.First.envelope_type_id
                    .attack_target = RowSet.First.attack_target
                    .decay_target = RowSet.First.decay_target
                    .sustain_target = RowSet.First.sustain_target
                    .release_target = RowSet.First.release_target
                    .attack_linear_delta = RowSet.First.attack_linear_delta
                    .decay_linear_delta = RowSet.First.decay_linear_delta
                    .sustain_linear_delta = RowSet.First.sustain_linear_delta
                    .release_linear_delta = RowSet.First.release_linear_delta
                    .attack_exp_multiplier = RowSet.First.attack_exp_multiplier
                    .decay_exp_multiplier = RowSet.First.decay_exp_multiplier
                    .sustain_exp_multiplier = RowSet.First.sustain_exp_multiplier
                    .release_exp_multiplier = RowSet.First.release_exp_multiplier
                    .sort_order = RowSet.First.sort_order
                End With
            End If
        End Sub

        Public Sub SetBSFilterForForeignKey_envelope_id(envelope_id As String)
            _Table_BindingSource.Filter = "envelope_id = " & envelope_id
        End Sub

        Public Sub SetBSFilterForForeignKey_envelope_type_id(envelope_type_id As String)
            _Table_BindingSource.Filter = "envelope_type_id = " & envelope_type_id
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
                Case "envelope_id"
                    DefaultRowValues.envelope_id = KeyValue
                Case "envelope_type_id"
                    DefaultRowValues.envelope_type_id = KeyValue
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.adsr_preset_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewadsr_presetID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.adsr_preset.Compute("MAX(adsr_preset_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

        Public Sub ReSortRows()
            Dim FilterString As String = _DSSPECTRALSYSTEM.adsr_preset.DefaultView.RowFilter
            Dim RowSet As DataSet_Spectral_System.adsr_presetRow() = _DSSPECTRALSYSTEM.adsr_preset.Select(FilterString, "sort_order ASC", DataViewRowState.CurrentRows)
            For i = 0 To RowSet.Count - 1
                RowSet(i).sort_order = i * 10
            Next
        End Sub

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_adsr_section ------------------------------"
    Public Class TableClass_adsr_section
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.adsr_sectionDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim adsr_section_id As System.Int32
            Dim adsr_section_name As System.String
            Dim sort_order As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public adsr_section_name As System.String = ""
            Public sort_order As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const adsr_section_id = "adsr_section_id"
            Const adsr_section_name = "adsr_section_name"
            Const sort_order = "sort_order"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "adsr_section"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.adsr_sectionDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.adsr_section
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.adsr_section.DefaultView
            DefaultView.Sort = "sort_order ASC"
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenSortableTable.AddRow
            Dim R As DataSet_Spectral_System.adsr_sectionRow = _DSSPECTRALSYSTEM.adsr_section.Newadsr_sectionRow
            With R
                .adsr_section_id = GetNewadsr_sectionID()
                If _DefaultRowValues.adsr_section_name IsNot Nothing Then .adsr_section_name = _DefaultRowValues.adsr_section_name
                .sort_order = _DefaultRowValues.sort_order
                .sort_order = 10000
            End With
            _DSSPECTRALSYSTEM.adsr_section.Addadsr_sectionRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.adsr_section_id
        End Function

        Public Function AddRow2(adsr_section_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.adsr_sectionRow = _DSSPECTRALSYSTEM.adsr_section.Newadsr_sectionRow
            With R
                .adsr_section_id = GetNewadsr_sectionID()
                .adsr_section_name = adsr_section_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.adsr_section.Addadsr_sectionRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.adsr_section_id
        End Function

        Public Function AddRow3(adsr_section_id As System.Int32, adsr_section_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.adsr_sectionRow = _DSSPECTRALSYSTEM.adsr_section.Newadsr_sectionRow
            With R
                .adsr_section_id = adsr_section_id
                .adsr_section_name = adsr_section_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.adsr_section.Addadsr_sectionRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.adsr_section_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.adsr_sectionRow() = _DSSPECTRALSYSTEM.adsr_section.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.adsr_sectionRow() = _DSSPECTRALSYSTEM.adsr_section.Select("adsr_section_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(adsr_section_name As String) As DataSet_Spectral_System.adsr_sectionRow
            For Each r As DataSet_Spectral_System.adsr_sectionRow In DT.Rows
                If r.adsr_section_name = adsr_section_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(adsr_section_id As Integer) As DataSet_Spectral_System.adsr_sectionRow
            Return _DSSPECTRALSYSTEM.adsr_section.FindByadsr_section_id(adsr_section_id)
        End Function

        Public Function GetRowsSortedBySortOrder(Filter As String) As DataRow() Implements I_GenericCodeGenSortableTable.GetRowsSortedBySortOrder
            Return _DSSPECTRALSYSTEM.adsr_section.Select(Filter, "sort_order ASC", DataViewRowState.CurrentRows)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.adsr_sectionRow() = _DSSPECTRALSYSTEM.adsr_section.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.adsr_section_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.adsr_sectionRow
            Dim RowSet As DataSet_Spectral_System.adsr_sectionRow() = _DSSPECTRALSYSTEM.adsr_section.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("adsr_section", _CurrentRow.adsr_section_id)
        End Function

        Public Sub DeleteRow(adsr_section_id As Integer)
            Dim R As DataSet_Spectral_System.adsr_sectionRow = GetRow(adsr_section_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.adsr_sectionRow = GetRow(CurrentRow.adsr_section_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.adsr_sectionRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.adsr_sectionRow In RowsToDelete
                DeleteRow(R.adsr_section_id)
            Next
        End Sub

        Public Sub MoveCurrentRow(MoveUp As Boolean) Implements I_GenericCodeGenSortableTable.MoveCurrentRow
            Dim R As DataSet_Spectral_System.adsr_sectionRow = GetRow(CurrentRow.adsr_section_id)
            If MoveUp = True Then
                R.sort_order = R.sort_order - 15
            Else
                R.sort_order = R.sort_order + 15
            End If
            R.EndEdit() 'Seems to be ESSENTIAL, otherwise the next SELECT doesn't order properly. Strange !! 

            ReSortRows()
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .adsr_section_id = DGV.CurrentRow.Cells("adsr_section_id").Value
                    .adsr_section_name = DGV.CurrentRow.Cells("adsr_section_name").Value.ToString
                    .sort_order = DGV.CurrentRow.Cells("sort_order").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.adsr_sectionRow() = _DSSPECTRALSYSTEM.adsr_section.Select("adsr_section_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .adsr_section_id = RowSet.First.adsr_section_id
                    .adsr_section_name = RowSet.First.adsr_section_name
                    .sort_order = RowSet.First.sort_order
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.adsr_section_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewadsr_sectionID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.adsr_section.Compute("MAX(adsr_section_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

        Public Sub ReSortRows()
            Dim FilterString As String = _DSSPECTRALSYSTEM.adsr_section.DefaultView.RowFilter
            Dim RowSet As DataSet_Spectral_System.adsr_sectionRow() = _DSSPECTRALSYSTEM.adsr_section.Select(FilterString, "sort_order ASC", DataViewRowState.CurrentRows)
            For i = 0 To RowSet.Count - 1
                RowSet(i).sort_order = i * 10
            Next
        End Sub

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_cc_source ------------------------------"
    Public Class TableClass_cc_source
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.cc_sourceDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim cc_source_id As System.Int32
            Dim cc_source_name As System.String
            Dim sort_order As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public cc_source_name As System.String = ""
            Public sort_order As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const cc_source_id = "cc_source_id"
            Const cc_source_name = "cc_source_name"
            Const sort_order = "sort_order"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "cc_source"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.cc_sourceDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.cc_source
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.cc_source.DefaultView
            DefaultView.Sort = "sort_order ASC"
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenSortableTable.AddRow
            Dim R As DataSet_Spectral_System.cc_sourceRow = _DSSPECTRALSYSTEM.cc_source.Newcc_sourceRow
            With R
                .cc_source_id = GetNewcc_sourceID()
                If _DefaultRowValues.cc_source_name IsNot Nothing Then .cc_source_name = _DefaultRowValues.cc_source_name
                .sort_order = _DefaultRowValues.sort_order
                .sort_order = 10000
            End With
            _DSSPECTRALSYSTEM.cc_source.Addcc_sourceRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.cc_source_id
        End Function

        Public Function AddRow2(cc_source_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.cc_sourceRow = _DSSPECTRALSYSTEM.cc_source.Newcc_sourceRow
            With R
                .cc_source_id = GetNewcc_sourceID()
                .cc_source_name = cc_source_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.cc_source.Addcc_sourceRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.cc_source_id
        End Function

        Public Function AddRow3(cc_source_id As System.Int32, cc_source_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.cc_sourceRow = _DSSPECTRALSYSTEM.cc_source.Newcc_sourceRow
            With R
                .cc_source_id = cc_source_id
                .cc_source_name = cc_source_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.cc_source.Addcc_sourceRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.cc_source_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.cc_sourceRow() = _DSSPECTRALSYSTEM.cc_source.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.cc_sourceRow() = _DSSPECTRALSYSTEM.cc_source.Select("cc_source_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(cc_source_name As String) As DataSet_Spectral_System.cc_sourceRow
            For Each r As DataSet_Spectral_System.cc_sourceRow In DT.Rows
                If r.cc_source_name = cc_source_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(cc_source_id As Integer) As DataSet_Spectral_System.cc_sourceRow
            Return _DSSPECTRALSYSTEM.cc_source.FindBycc_source_id(cc_source_id)
        End Function

        Public Function GetRowsSortedBySortOrder(Filter As String) As DataRow() Implements I_GenericCodeGenSortableTable.GetRowsSortedBySortOrder
            Return _DSSPECTRALSYSTEM.cc_source.Select(Filter, "sort_order ASC", DataViewRowState.CurrentRows)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.cc_sourceRow() = _DSSPECTRALSYSTEM.cc_source.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.cc_source_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.cc_sourceRow
            Dim RowSet As DataSet_Spectral_System.cc_sourceRow() = _DSSPECTRALSYSTEM.cc_source.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("cc_source", _CurrentRow.cc_source_id)
        End Function

        Public Sub DeleteRow(cc_source_id As Integer)
            Dim R As DataSet_Spectral_System.cc_sourceRow = GetRow(cc_source_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.cc_sourceRow = GetRow(CurrentRow.cc_source_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.cc_sourceRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.cc_sourceRow In RowsToDelete
                DeleteRow(R.cc_source_id)
            Next
        End Sub

        Public Sub MoveCurrentRow(MoveUp As Boolean) Implements I_GenericCodeGenSortableTable.MoveCurrentRow
            Dim R As DataSet_Spectral_System.cc_sourceRow = GetRow(CurrentRow.cc_source_id)
            If MoveUp = True Then
                R.sort_order = R.sort_order - 15
            Else
                R.sort_order = R.sort_order + 15
            End If
            R.EndEdit() 'Seems to be ESSENTIAL, otherwise the next SELECT doesn't order properly. Strange !! 

            ReSortRows()
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .cc_source_id = DGV.CurrentRow.Cells("cc_source_id").Value
                    .cc_source_name = DGV.CurrentRow.Cells("cc_source_name").Value.ToString
                    .sort_order = DGV.CurrentRow.Cells("sort_order").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.cc_sourceRow() = _DSSPECTRALSYSTEM.cc_source.Select("cc_source_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .cc_source_id = RowSet.First.cc_source_id
                    .cc_source_name = RowSet.First.cc_source_name
                    .sort_order = RowSet.First.sort_order
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.cc_source_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewcc_sourceID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.cc_source.Compute("MAX(cc_source_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

        Public Sub ReSortRows()
            Dim FilterString As String = _DSSPECTRALSYSTEM.cc_source.DefaultView.RowFilter
            Dim RowSet As DataSet_Spectral_System.cc_sourceRow() = _DSSPECTRALSYSTEM.cc_source.Select(FilterString, "sort_order ASC", DataViewRowState.CurrentRows)
            For i = 0 To RowSet.Count - 1
                RowSet(i).sort_order = i * 10
            Next
        End Sub

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_detuning_mode ------------------------------"
    Public Class TableClass_detuning_mode
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.detuning_modeDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim detuning_mode_id As System.Int32
            Dim detuning_mode_name As System.String
            Dim sort_order As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public detuning_mode_name As System.String = ""
            Public sort_order As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const detuning_mode_id = "detuning_mode_id"
            Const detuning_mode_name = "detuning_mode_name"
            Const sort_order = "sort_order"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "detuning_mode"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.detuning_modeDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.detuning_mode
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.detuning_mode.DefaultView
            DefaultView.Sort = "sort_order ASC"
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenSortableTable.AddRow
            Dim R As DataSet_Spectral_System.detuning_modeRow = _DSSPECTRALSYSTEM.detuning_mode.Newdetuning_modeRow
            With R
                .detuning_mode_id = GetNewdetuning_modeID()
                If _DefaultRowValues.detuning_mode_name IsNot Nothing Then .detuning_mode_name = _DefaultRowValues.detuning_mode_name
                .sort_order = _DefaultRowValues.sort_order
                .sort_order = 10000
            End With
            _DSSPECTRALSYSTEM.detuning_mode.Adddetuning_modeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.detuning_mode_id
        End Function

        Public Function AddRow2(detuning_mode_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.detuning_modeRow = _DSSPECTRALSYSTEM.detuning_mode.Newdetuning_modeRow
            With R
                .detuning_mode_id = GetNewdetuning_modeID()
                .detuning_mode_name = detuning_mode_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.detuning_mode.Adddetuning_modeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.detuning_mode_id
        End Function

        Public Function AddRow3(detuning_mode_id As System.Int32, detuning_mode_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.detuning_modeRow = _DSSPECTRALSYSTEM.detuning_mode.Newdetuning_modeRow
            With R
                .detuning_mode_id = detuning_mode_id
                .detuning_mode_name = detuning_mode_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.detuning_mode.Adddetuning_modeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.detuning_mode_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.detuning_modeRow() = _DSSPECTRALSYSTEM.detuning_mode.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.detuning_modeRow() = _DSSPECTRALSYSTEM.detuning_mode.Select("detuning_mode_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(detuning_mode_name As String) As DataSet_Spectral_System.detuning_modeRow
            For Each r As DataSet_Spectral_System.detuning_modeRow In DT.Rows
                If r.detuning_mode_name = detuning_mode_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(detuning_mode_id As Integer) As DataSet_Spectral_System.detuning_modeRow
            Return _DSSPECTRALSYSTEM.detuning_mode.FindBydetuning_mode_id(detuning_mode_id)
        End Function

        Public Function GetRowsSortedBySortOrder(Filter As String) As DataRow() Implements I_GenericCodeGenSortableTable.GetRowsSortedBySortOrder
            Return _DSSPECTRALSYSTEM.detuning_mode.Select(Filter, "sort_order ASC", DataViewRowState.CurrentRows)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.detuning_modeRow() = _DSSPECTRALSYSTEM.detuning_mode.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.detuning_mode_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.detuning_modeRow
            Dim RowSet As DataSet_Spectral_System.detuning_modeRow() = _DSSPECTRALSYSTEM.detuning_mode.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("detuning_mode", _CurrentRow.detuning_mode_id)
        End Function

        Public Sub DeleteRow(detuning_mode_id As Integer)
            Dim R As DataSet_Spectral_System.detuning_modeRow = GetRow(detuning_mode_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.detuning_modeRow = GetRow(CurrentRow.detuning_mode_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.detuning_modeRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.detuning_modeRow In RowsToDelete
                DeleteRow(R.detuning_mode_id)
            Next
        End Sub

        Public Sub MoveCurrentRow(MoveUp As Boolean) Implements I_GenericCodeGenSortableTable.MoveCurrentRow
            Dim R As DataSet_Spectral_System.detuning_modeRow = GetRow(CurrentRow.detuning_mode_id)
            If MoveUp = True Then
                R.sort_order = R.sort_order - 15
            Else
                R.sort_order = R.sort_order + 15
            End If
            R.EndEdit() 'Seems to be ESSENTIAL, otherwise the next SELECT doesn't order properly. Strange !! 

            ReSortRows()
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .detuning_mode_id = DGV.CurrentRow.Cells("detuning_mode_id").Value
                    .detuning_mode_name = DGV.CurrentRow.Cells("detuning_mode_name").Value.ToString
                    .sort_order = DGV.CurrentRow.Cells("sort_order").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.detuning_modeRow() = _DSSPECTRALSYSTEM.detuning_mode.Select("detuning_mode_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .detuning_mode_id = RowSet.First.detuning_mode_id
                    .detuning_mode_name = RowSet.First.detuning_mode_name
                    .sort_order = RowSet.First.sort_order
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.detuning_mode_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewdetuning_modeID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.detuning_mode.Compute("MAX(detuning_mode_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

        Public Sub ReSortRows()
            Dim FilterString As String = _DSSPECTRALSYSTEM.detuning_mode.DefaultView.RowFilter
            Dim RowSet As DataSet_Spectral_System.detuning_modeRow() = _DSSPECTRALSYSTEM.detuning_mode.Select(FilterString, "sort_order ASC", DataViewRowState.CurrentRows)
            For i = 0 To RowSet.Count - 1
                RowSet(i).sort_order = i * 10
            Next
        End Sub

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_envelope ------------------------------"
    Public Class TableClass_envelope
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.envelopeDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim envelope_id As System.Int32
            Dim envelope_name As System.String
            Dim sort_order As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public envelope_name As System.String = ""
            Public sort_order As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const envelope_id = "envelope_id"
            Const envelope_name = "envelope_name"
            Const sort_order = "sort_order"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "envelope"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.envelopeDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.envelope
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.envelope.DefaultView
            DefaultView.Sort = "sort_order ASC"
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenSortableTable.AddRow
            Dim R As DataSet_Spectral_System.envelopeRow = _DSSPECTRALSYSTEM.envelope.NewenvelopeRow
            With R
                .envelope_id = GetNewenvelopeID()
                If _DefaultRowValues.envelope_name IsNot Nothing Then .envelope_name = _DefaultRowValues.envelope_name
                .sort_order = _DefaultRowValues.sort_order
                .sort_order = 10000
            End With
            _DSSPECTRALSYSTEM.envelope.AddenvelopeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.envelope_id
        End Function

        Public Function AddRow2(envelope_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.envelopeRow = _DSSPECTRALSYSTEM.envelope.NewenvelopeRow
            With R
                .envelope_id = GetNewenvelopeID()
                .envelope_name = envelope_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.envelope.AddenvelopeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.envelope_id
        End Function

        Public Function AddRow3(envelope_id As System.Int32, envelope_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.envelopeRow = _DSSPECTRALSYSTEM.envelope.NewenvelopeRow
            With R
                .envelope_id = envelope_id
                .envelope_name = envelope_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.envelope.AddenvelopeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.envelope_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.envelopeRow() = _DSSPECTRALSYSTEM.envelope.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.envelopeRow() = _DSSPECTRALSYSTEM.envelope.Select("envelope_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(envelope_name As String) As DataSet_Spectral_System.envelopeRow
            For Each r As DataSet_Spectral_System.envelopeRow In DT.Rows
                If r.envelope_name = envelope_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(envelope_id As Integer) As DataSet_Spectral_System.envelopeRow
            Return _DSSPECTRALSYSTEM.envelope.FindByenvelope_id(envelope_id)
        End Function

        Public Function GetRowsSortedBySortOrder(Filter As String) As DataRow() Implements I_GenericCodeGenSortableTable.GetRowsSortedBySortOrder
            Return _DSSPECTRALSYSTEM.envelope.Select(Filter, "sort_order ASC", DataViewRowState.CurrentRows)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.envelopeRow() = _DSSPECTRALSYSTEM.envelope.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.envelope_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.envelopeRow
            Dim RowSet As DataSet_Spectral_System.envelopeRow() = _DSSPECTRALSYSTEM.envelope.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("envelope", _CurrentRow.envelope_id)
        End Function

        Public Sub DeleteRow(envelope_id As Integer)
            Dim R As DataSet_Spectral_System.envelopeRow = GetRow(envelope_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_adsr_preset.DeleteRows("envelope_id = " & envelope_id)

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.envelopeRow = GetRow(CurrentRow.envelope_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_adsr_preset.DeleteRows("envelope_id = " & R.envelope_id)

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.envelopeRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.envelopeRow In RowsToDelete
                DeleteRow(R.envelope_id)
            Next
        End Sub

        Public Sub MoveCurrentRow(MoveUp As Boolean) Implements I_GenericCodeGenSortableTable.MoveCurrentRow
            Dim R As DataSet_Spectral_System.envelopeRow = GetRow(CurrentRow.envelope_id)
            If MoveUp = True Then
                R.sort_order = R.sort_order - 15
            Else
                R.sort_order = R.sort_order + 15
            End If
            R.EndEdit() 'Seems to be ESSENTIAL, otherwise the next SELECT doesn't order properly. Strange !! 

            ReSortRows()
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .envelope_id = DGV.CurrentRow.Cells("envelope_id").Value
                    .envelope_name = DGV.CurrentRow.Cells("envelope_name").Value.ToString
                    .sort_order = DGV.CurrentRow.Cells("sort_order").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.envelopeRow() = _DSSPECTRALSYSTEM.envelope.Select("envelope_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .envelope_id = RowSet.First.envelope_id
                    .envelope_name = RowSet.First.envelope_name
                    .sort_order = RowSet.First.sort_order
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.envelope_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewenvelopeID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.envelope.Compute("MAX(envelope_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

        Public Sub ReSortRows()
            Dim FilterString As String = _DSSPECTRALSYSTEM.envelope.DefaultView.RowFilter
            Dim RowSet As DataSet_Spectral_System.envelopeRow() = _DSSPECTRALSYSTEM.envelope.Select(FilterString, "sort_order ASC", DataViewRowState.CurrentRows)
            For i = 0 To RowSet.Count - 1
                RowSet(i).sort_order = i * 10
            Next
        End Sub

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_envelope_type ------------------------------"
    Public Class TableClass_envelope_type
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.envelope_typeDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim envelope_type_id As System.Int32
            Dim envelope_type_name As System.String
            Dim sort_order As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public envelope_type_name As System.String = ""
            Public sort_order As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const envelope_type_id = "envelope_type_id"
            Const envelope_type_name = "envelope_type_name"
            Const sort_order = "sort_order"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "envelope_type"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.envelope_typeDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.envelope_type
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.envelope_type.DefaultView
            DefaultView.Sort = "sort_order ASC"
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenSortableTable.AddRow
            Dim R As DataSet_Spectral_System.envelope_typeRow = _DSSPECTRALSYSTEM.envelope_type.Newenvelope_typeRow
            With R
                .envelope_type_id = GetNewenvelope_typeID()
                If _DefaultRowValues.envelope_type_name IsNot Nothing Then .envelope_type_name = _DefaultRowValues.envelope_type_name
                .sort_order = _DefaultRowValues.sort_order
                .sort_order = 10000
            End With
            _DSSPECTRALSYSTEM.envelope_type.Addenvelope_typeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.envelope_type_id
        End Function

        Public Function AddRow2(envelope_type_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.envelope_typeRow = _DSSPECTRALSYSTEM.envelope_type.Newenvelope_typeRow
            With R
                .envelope_type_id = GetNewenvelope_typeID()
                .envelope_type_name = envelope_type_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.envelope_type.Addenvelope_typeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.envelope_type_id
        End Function

        Public Function AddRow3(envelope_type_id As System.Int32, envelope_type_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.envelope_typeRow = _DSSPECTRALSYSTEM.envelope_type.Newenvelope_typeRow
            With R
                .envelope_type_id = envelope_type_id
                .envelope_type_name = envelope_type_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.envelope_type.Addenvelope_typeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.envelope_type_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.envelope_typeRow() = _DSSPECTRALSYSTEM.envelope_type.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.envelope_typeRow() = _DSSPECTRALSYSTEM.envelope_type.Select("envelope_type_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(envelope_type_name As String) As DataSet_Spectral_System.envelope_typeRow
            For Each r As DataSet_Spectral_System.envelope_typeRow In DT.Rows
                If r.envelope_type_name = envelope_type_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(envelope_type_id As Integer) As DataSet_Spectral_System.envelope_typeRow
            Return _DSSPECTRALSYSTEM.envelope_type.FindByenvelope_type_id(envelope_type_id)
        End Function

        Public Function GetRowsSortedBySortOrder(Filter As String) As DataRow() Implements I_GenericCodeGenSortableTable.GetRowsSortedBySortOrder
            Return _DSSPECTRALSYSTEM.envelope_type.Select(Filter, "sort_order ASC", DataViewRowState.CurrentRows)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.envelope_typeRow() = _DSSPECTRALSYSTEM.envelope_type.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.envelope_type_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.envelope_typeRow
            Dim RowSet As DataSet_Spectral_System.envelope_typeRow() = _DSSPECTRALSYSTEM.envelope_type.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("envelope_type", _CurrentRow.envelope_type_id)
        End Function

        Public Sub DeleteRow(envelope_type_id As Integer)
            Dim R As DataSet_Spectral_System.envelope_typeRow = GetRow(envelope_type_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_adsr_preset.DeleteRows("envelope_type_id = " & envelope_type_id)

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.envelope_typeRow = GetRow(CurrentRow.envelope_type_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub
            _ParentClass.Table_adsr_preset.DeleteRows("envelope_type_id = " & R.envelope_type_id)

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.envelope_typeRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.envelope_typeRow In RowsToDelete
                DeleteRow(R.envelope_type_id)
            Next
        End Sub

        Public Sub MoveCurrentRow(MoveUp As Boolean) Implements I_GenericCodeGenSortableTable.MoveCurrentRow
            Dim R As DataSet_Spectral_System.envelope_typeRow = GetRow(CurrentRow.envelope_type_id)
            If MoveUp = True Then
                R.sort_order = R.sort_order - 15
            Else
                R.sort_order = R.sort_order + 15
            End If
            R.EndEdit() 'Seems to be ESSENTIAL, otherwise the next SELECT doesn't order properly. Strange !! 

            ReSortRows()
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .envelope_type_id = DGV.CurrentRow.Cells("envelope_type_id").Value
                    .envelope_type_name = DGV.CurrentRow.Cells("envelope_type_name").Value.ToString
                    .sort_order = DGV.CurrentRow.Cells("sort_order").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.envelope_typeRow() = _DSSPECTRALSYSTEM.envelope_type.Select("envelope_type_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .envelope_type_id = RowSet.First.envelope_type_id
                    .envelope_type_name = RowSet.First.envelope_type_name
                    .sort_order = RowSet.First.sort_order
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.envelope_type_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewenvelope_typeID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.envelope_type.Compute("MAX(envelope_type_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

        Public Sub ReSortRows()
            Dim FilterString As String = _DSSPECTRALSYSTEM.envelope_type.DefaultView.RowFilter
            Dim RowSet As DataSet_Spectral_System.envelope_typeRow() = _DSSPECTRALSYSTEM.envelope_type.Select(FilterString, "sort_order ASC", DataViewRowState.CurrentRows)
            For i = 0 To RowSet.Count - 1
                RowSet(i).sort_order = i * 10
            Next
        End Sub

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_filter_type ------------------------------"
    Public Class TableClass_filter_type
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.filter_typeDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim filter_type_id As System.Int32
            Dim filter_type_name As System.String
            Dim sort_order As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public filter_type_name As System.String = ""
            Public sort_order As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const filter_type_id = "filter_type_id"
            Const filter_type_name = "filter_type_name"
            Const sort_order = "sort_order"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "filter_type"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.filter_typeDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.filter_type
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.filter_type.DefaultView
            DefaultView.Sort = "sort_order ASC"
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenSortableTable.AddRow
            Dim R As DataSet_Spectral_System.filter_typeRow = _DSSPECTRALSYSTEM.filter_type.Newfilter_typeRow
            With R
                .filter_type_id = GetNewfilter_typeID()
                If _DefaultRowValues.filter_type_name IsNot Nothing Then .filter_type_name = _DefaultRowValues.filter_type_name
                .sort_order = _DefaultRowValues.sort_order
                .sort_order = 10000
            End With
            _DSSPECTRALSYSTEM.filter_type.Addfilter_typeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.filter_type_id
        End Function

        Public Function AddRow2(filter_type_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.filter_typeRow = _DSSPECTRALSYSTEM.filter_type.Newfilter_typeRow
            With R
                .filter_type_id = GetNewfilter_typeID()
                .filter_type_name = filter_type_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.filter_type.Addfilter_typeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.filter_type_id
        End Function

        Public Function AddRow3(filter_type_id As System.Int32, filter_type_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.filter_typeRow = _DSSPECTRALSYSTEM.filter_type.Newfilter_typeRow
            With R
                .filter_type_id = filter_type_id
                .filter_type_name = filter_type_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.filter_type.Addfilter_typeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.filter_type_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.filter_typeRow() = _DSSPECTRALSYSTEM.filter_type.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.filter_typeRow() = _DSSPECTRALSYSTEM.filter_type.Select("filter_type_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(filter_type_name As String) As DataSet_Spectral_System.filter_typeRow
            For Each r As DataSet_Spectral_System.filter_typeRow In DT.Rows
                If r.filter_type_name = filter_type_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(filter_type_id As Integer) As DataSet_Spectral_System.filter_typeRow
            Return _DSSPECTRALSYSTEM.filter_type.FindByfilter_type_id(filter_type_id)
        End Function

        Public Function GetRowsSortedBySortOrder(Filter As String) As DataRow() Implements I_GenericCodeGenSortableTable.GetRowsSortedBySortOrder
            Return _DSSPECTRALSYSTEM.filter_type.Select(Filter, "sort_order ASC", DataViewRowState.CurrentRows)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.filter_typeRow() = _DSSPECTRALSYSTEM.filter_type.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.filter_type_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.filter_typeRow
            Dim RowSet As DataSet_Spectral_System.filter_typeRow() = _DSSPECTRALSYSTEM.filter_type.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("filter_type", _CurrentRow.filter_type_id)
        End Function

        Public Sub DeleteRow(filter_type_id As Integer)
            Dim R As DataSet_Spectral_System.filter_typeRow = GetRow(filter_type_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.filter_typeRow = GetRow(CurrentRow.filter_type_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.filter_typeRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.filter_typeRow In RowsToDelete
                DeleteRow(R.filter_type_id)
            Next
        End Sub

        Public Sub MoveCurrentRow(MoveUp As Boolean) Implements I_GenericCodeGenSortableTable.MoveCurrentRow
            Dim R As DataSet_Spectral_System.filter_typeRow = GetRow(CurrentRow.filter_type_id)
            If MoveUp = True Then
                R.sort_order = R.sort_order - 15
            Else
                R.sort_order = R.sort_order + 15
            End If
            R.EndEdit() 'Seems to be ESSENTIAL, otherwise the next SELECT doesn't order properly. Strange !! 

            ReSortRows()
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .filter_type_id = DGV.CurrentRow.Cells("filter_type_id").Value
                    .filter_type_name = DGV.CurrentRow.Cells("filter_type_name").Value.ToString
                    .sort_order = DGV.CurrentRow.Cells("sort_order").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.filter_typeRow() = _DSSPECTRALSYSTEM.filter_type.Select("filter_type_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .filter_type_id = RowSet.First.filter_type_id
                    .filter_type_name = RowSet.First.filter_type_name
                    .sort_order = RowSet.First.sort_order
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.filter_type_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewfilter_typeID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.filter_type.Compute("MAX(filter_type_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

        Public Sub ReSortRows()
            Dim FilterString As String = _DSSPECTRALSYSTEM.filter_type.DefaultView.RowFilter
            Dim RowSet As DataSet_Spectral_System.filter_typeRow() = _DSSPECTRALSYSTEM.filter_type.Select(FilterString, "sort_order ASC", DataViewRowState.CurrentRows)
            For i = 0 To RowSet.Count - 1
                RowSet(i).sort_order = i * 10
            Next
        End Sub

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_harmonic ------------------------------"
    Public Class TableClass_harmonic
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.harmonicDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim harmonic_id As System.Int32
            Dim harmonic_name As System.String
            Dim sort_order As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public harmonic_name As System.String = ""
            Public sort_order As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const harmonic_id = "harmonic_id"
            Const harmonic_name = "harmonic_name"
            Const sort_order = "sort_order"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "harmonic"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.harmonicDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.harmonic
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.harmonic.DefaultView
            DefaultView.Sort = "sort_order ASC"
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenSortableTable.AddRow
            Dim R As DataSet_Spectral_System.harmonicRow = _DSSPECTRALSYSTEM.harmonic.NewharmonicRow
            With R
                .harmonic_id = GetNewharmonicID()
                If _DefaultRowValues.harmonic_name IsNot Nothing Then .harmonic_name = _DefaultRowValues.harmonic_name
                .sort_order = _DefaultRowValues.sort_order
                .sort_order = 10000
            End With
            _DSSPECTRALSYSTEM.harmonic.AddharmonicRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.harmonic_id
        End Function

        Public Function AddRow2(harmonic_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.harmonicRow = _DSSPECTRALSYSTEM.harmonic.NewharmonicRow
            With R
                .harmonic_id = GetNewharmonicID()
                .harmonic_name = harmonic_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.harmonic.AddharmonicRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.harmonic_id
        End Function

        Public Function AddRow3(harmonic_id As System.Int32, harmonic_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.harmonicRow = _DSSPECTRALSYSTEM.harmonic.NewharmonicRow
            With R
                .harmonic_id = harmonic_id
                .harmonic_name = harmonic_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.harmonic.AddharmonicRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.harmonic_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.harmonicRow() = _DSSPECTRALSYSTEM.harmonic.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.harmonicRow() = _DSSPECTRALSYSTEM.harmonic.Select("harmonic_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(harmonic_name As String) As DataSet_Spectral_System.harmonicRow
            For Each r As DataSet_Spectral_System.harmonicRow In DT.Rows
                If r.harmonic_name = harmonic_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(harmonic_id As Integer) As DataSet_Spectral_System.harmonicRow
            Return _DSSPECTRALSYSTEM.harmonic.FindByharmonic_id(harmonic_id)
        End Function

        Public Function GetRowsSortedBySortOrder(Filter As String) As DataRow() Implements I_GenericCodeGenSortableTable.GetRowsSortedBySortOrder
            Return _DSSPECTRALSYSTEM.harmonic.Select(Filter, "sort_order ASC", DataViewRowState.CurrentRows)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.harmonicRow() = _DSSPECTRALSYSTEM.harmonic.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.harmonic_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.harmonicRow
            Dim RowSet As DataSet_Spectral_System.harmonicRow() = _DSSPECTRALSYSTEM.harmonic.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("harmonic", _CurrentRow.harmonic_id)
        End Function

        Public Sub DeleteRow(harmonic_id As Integer)
            Dim R As DataSet_Spectral_System.harmonicRow = GetRow(harmonic_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.harmonicRow = GetRow(CurrentRow.harmonic_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.harmonicRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.harmonicRow In RowsToDelete
                DeleteRow(R.harmonic_id)
            Next
        End Sub

        Public Sub MoveCurrentRow(MoveUp As Boolean) Implements I_GenericCodeGenSortableTable.MoveCurrentRow
            Dim R As DataSet_Spectral_System.harmonicRow = GetRow(CurrentRow.harmonic_id)
            If MoveUp = True Then
                R.sort_order = R.sort_order - 15
            Else
                R.sort_order = R.sort_order + 15
            End If
            R.EndEdit() 'Seems to be ESSENTIAL, otherwise the next SELECT doesn't order properly. Strange !! 

            ReSortRows()
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .harmonic_id = DGV.CurrentRow.Cells("harmonic_id").Value
                    .harmonic_name = DGV.CurrentRow.Cells("harmonic_name").Value.ToString
                    .sort_order = DGV.CurrentRow.Cells("sort_order").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.harmonicRow() = _DSSPECTRALSYSTEM.harmonic.Select("harmonic_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .harmonic_id = RowSet.First.harmonic_id
                    .harmonic_name = RowSet.First.harmonic_name
                    .sort_order = RowSet.First.sort_order
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.harmonic_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewharmonicID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.harmonic.Compute("MAX(harmonic_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

        Public Sub ReSortRows()
            Dim FilterString As String = _DSSPECTRALSYSTEM.harmonic.DefaultView.RowFilter
            Dim RowSet As DataSet_Spectral_System.harmonicRow() = _DSSPECTRALSYSTEM.harmonic.Select(FilterString, "sort_order ASC", DataViewRowState.CurrentRows)
            For i = 0 To RowSet.Count - 1
                RowSet(i).sort_order = i * 10
            Next
        End Sub

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_intensity_layer ------------------------------"
    Public Class TableClass_intensity_layer
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.intensity_layerDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim intensity_layer_id As System.Int32
            Dim intensity_layer_name As System.String
            Dim sort_order As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public intensity_layer_name As System.String = ""
            Public sort_order As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const intensity_layer_id = "intensity_layer_id"
            Const intensity_layer_name = "intensity_layer_name"
            Const sort_order = "sort_order"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "intensity_layer"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.intensity_layerDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.intensity_layer
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.intensity_layer.DefaultView
            DefaultView.Sort = "sort_order ASC"
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenSortableTable.AddRow
            Dim R As DataSet_Spectral_System.intensity_layerRow = _DSSPECTRALSYSTEM.intensity_layer.Newintensity_layerRow
            With R
                .intensity_layer_id = GetNewintensity_layerID()
                If _DefaultRowValues.intensity_layer_name IsNot Nothing Then .intensity_layer_name = _DefaultRowValues.intensity_layer_name
                .sort_order = _DefaultRowValues.sort_order
                .sort_order = 10000
            End With
            _DSSPECTRALSYSTEM.intensity_layer.Addintensity_layerRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.intensity_layer_id
        End Function

        Public Function AddRow2(intensity_layer_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.intensity_layerRow = _DSSPECTRALSYSTEM.intensity_layer.Newintensity_layerRow
            With R
                .intensity_layer_id = GetNewintensity_layerID()
                .intensity_layer_name = intensity_layer_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.intensity_layer.Addintensity_layerRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.intensity_layer_id
        End Function

        Public Function AddRow3(intensity_layer_id As System.Int32, intensity_layer_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.intensity_layerRow = _DSSPECTRALSYSTEM.intensity_layer.Newintensity_layerRow
            With R
                .intensity_layer_id = intensity_layer_id
                .intensity_layer_name = intensity_layer_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.intensity_layer.Addintensity_layerRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.intensity_layer_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.intensity_layerRow() = _DSSPECTRALSYSTEM.intensity_layer.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.intensity_layerRow() = _DSSPECTRALSYSTEM.intensity_layer.Select("intensity_layer_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(intensity_layer_name As String) As DataSet_Spectral_System.intensity_layerRow
            For Each r As DataSet_Spectral_System.intensity_layerRow In DT.Rows
                If r.intensity_layer_name = intensity_layer_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(intensity_layer_id As Integer) As DataSet_Spectral_System.intensity_layerRow
            Return _DSSPECTRALSYSTEM.intensity_layer.FindByintensity_layer_id(intensity_layer_id)
        End Function

        Public Function GetRowsSortedBySortOrder(Filter As String) As DataRow() Implements I_GenericCodeGenSortableTable.GetRowsSortedBySortOrder
            Return _DSSPECTRALSYSTEM.intensity_layer.Select(Filter, "sort_order ASC", DataViewRowState.CurrentRows)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.intensity_layerRow() = _DSSPECTRALSYSTEM.intensity_layer.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.intensity_layer_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.intensity_layerRow
            Dim RowSet As DataSet_Spectral_System.intensity_layerRow() = _DSSPECTRALSYSTEM.intensity_layer.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("intensity_layer", _CurrentRow.intensity_layer_id)
        End Function

        Public Sub DeleteRow(intensity_layer_id As Integer)
            Dim R As DataSet_Spectral_System.intensity_layerRow = GetRow(intensity_layer_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.intensity_layerRow = GetRow(CurrentRow.intensity_layer_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.intensity_layerRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.intensity_layerRow In RowsToDelete
                DeleteRow(R.intensity_layer_id)
            Next
        End Sub

        Public Sub MoveCurrentRow(MoveUp As Boolean) Implements I_GenericCodeGenSortableTable.MoveCurrentRow
            Dim R As DataSet_Spectral_System.intensity_layerRow = GetRow(CurrentRow.intensity_layer_id)
            If MoveUp = True Then
                R.sort_order = R.sort_order - 15
            Else
                R.sort_order = R.sort_order + 15
            End If
            R.EndEdit() 'Seems to be ESSENTIAL, otherwise the next SELECT doesn't order properly. Strange !! 

            ReSortRows()
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .intensity_layer_id = DGV.CurrentRow.Cells("intensity_layer_id").Value
                    .intensity_layer_name = DGV.CurrentRow.Cells("intensity_layer_name").Value.ToString
                    .sort_order = DGV.CurrentRow.Cells("sort_order").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.intensity_layerRow() = _DSSPECTRALSYSTEM.intensity_layer.Select("intensity_layer_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .intensity_layer_id = RowSet.First.intensity_layer_id
                    .intensity_layer_name = RowSet.First.intensity_layer_name
                    .sort_order = RowSet.First.sort_order
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.intensity_layer_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewintensity_layerID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.intensity_layer.Compute("MAX(intensity_layer_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

        Public Sub ReSortRows()
            Dim FilterString As String = _DSSPECTRALSYSTEM.intensity_layer.DefaultView.RowFilter
            Dim RowSet As DataSet_Spectral_System.intensity_layerRow() = _DSSPECTRALSYSTEM.intensity_layer.Select(FilterString, "sort_order ASC", DataViewRowState.CurrentRows)
            For i = 0 To RowSet.Count - 1
                RowSet(i).sort_order = i * 10
            Next
        End Sub

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_lfo ------------------------------"
    Public Class TableClass_lfo
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.lfoDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim lfo_id As System.Int32
            Dim lfo_name As System.String
            Dim sort_order As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public lfo_name As System.String = ""
            Public sort_order As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const lfo_id = "lfo_id"
            Const lfo_name = "lfo_name"
            Const sort_order = "sort_order"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "lfo"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.lfoDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.lfo
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.lfo.DefaultView
            DefaultView.Sort = "sort_order ASC"
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenSortableTable.AddRow
            Dim R As DataSet_Spectral_System.lfoRow = _DSSPECTRALSYSTEM.lfo.NewlfoRow
            With R
                .lfo_id = GetNewlfoID()
                If _DefaultRowValues.lfo_name IsNot Nothing Then .lfo_name = _DefaultRowValues.lfo_name
                .sort_order = _DefaultRowValues.sort_order
                .sort_order = 10000
            End With
            _DSSPECTRALSYSTEM.lfo.AddlfoRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.lfo_id
        End Function

        Public Function AddRow2(lfo_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.lfoRow = _DSSPECTRALSYSTEM.lfo.NewlfoRow
            With R
                .lfo_id = GetNewlfoID()
                .lfo_name = lfo_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.lfo.AddlfoRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.lfo_id
        End Function

        Public Function AddRow3(lfo_id As System.Int32, lfo_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.lfoRow = _DSSPECTRALSYSTEM.lfo.NewlfoRow
            With R
                .lfo_id = lfo_id
                .lfo_name = lfo_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.lfo.AddlfoRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.lfo_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.lfoRow() = _DSSPECTRALSYSTEM.lfo.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.lfoRow() = _DSSPECTRALSYSTEM.lfo.Select("lfo_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(lfo_name As String) As DataSet_Spectral_System.lfoRow
            For Each r As DataSet_Spectral_System.lfoRow In DT.Rows
                If r.lfo_name = lfo_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(lfo_id As Integer) As DataSet_Spectral_System.lfoRow
            Return _DSSPECTRALSYSTEM.lfo.FindBylfo_id(lfo_id)
        End Function

        Public Function GetRowsSortedBySortOrder(Filter As String) As DataRow() Implements I_GenericCodeGenSortableTable.GetRowsSortedBySortOrder
            Return _DSSPECTRALSYSTEM.lfo.Select(Filter, "sort_order ASC", DataViewRowState.CurrentRows)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.lfoRow() = _DSSPECTRALSYSTEM.lfo.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.lfo_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.lfoRow
            Dim RowSet As DataSet_Spectral_System.lfoRow() = _DSSPECTRALSYSTEM.lfo.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("lfo", _CurrentRow.lfo_id)
        End Function

        Public Sub DeleteRow(lfo_id As Integer)
            Dim R As DataSet_Spectral_System.lfoRow = GetRow(lfo_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.lfoRow = GetRow(CurrentRow.lfo_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.lfoRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.lfoRow In RowsToDelete
                DeleteRow(R.lfo_id)
            Next
        End Sub

        Public Sub MoveCurrentRow(MoveUp As Boolean) Implements I_GenericCodeGenSortableTable.MoveCurrentRow
            Dim R As DataSet_Spectral_System.lfoRow = GetRow(CurrentRow.lfo_id)
            If MoveUp = True Then
                R.sort_order = R.sort_order - 15
            Else
                R.sort_order = R.sort_order + 15
            End If
            R.EndEdit() 'Seems to be ESSENTIAL, otherwise the next SELECT doesn't order properly. Strange !! 

            ReSortRows()
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .lfo_id = DGV.CurrentRow.Cells("lfo_id").Value
                    .lfo_name = DGV.CurrentRow.Cells("lfo_name").Value.ToString
                    .sort_order = DGV.CurrentRow.Cells("sort_order").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.lfoRow() = _DSSPECTRALSYSTEM.lfo.Select("lfo_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .lfo_id = RowSet.First.lfo_id
                    .lfo_name = RowSet.First.lfo_name
                    .sort_order = RowSet.First.sort_order
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.lfo_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewlfoID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.lfo.Compute("MAX(lfo_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

        Public Sub ReSortRows()
            Dim FilterString As String = _DSSPECTRALSYSTEM.lfo.DefaultView.RowFilter
            Dim RowSet As DataSet_Spectral_System.lfoRow() = _DSSPECTRALSYSTEM.lfo.Select(FilterString, "sort_order ASC", DataViewRowState.CurrentRows)
            For i = 0 To RowSet.Count - 1
                RowSet(i).sort_order = i * 10
            Next
        End Sub

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_lfo_wave_type ------------------------------"
    Public Class TableClass_lfo_wave_type
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.lfo_wave_typeDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim lfo_wave_type_id As System.Int32
            Dim lfo_wave_type_name As System.String
        End Structure

        Public Class Default_Row_Values
            Public lfo_wave_type_name As System.String = ""
        End Class

        Public Structure ColNames
            Const lfo_wave_type_id = "lfo_wave_type_id"
            Const lfo_wave_type_name = "lfo_wave_type_name"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "lfo_wave_type"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.lfo_wave_typeDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.lfo_wave_type
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.lfo_wave_type.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral_System.lfo_wave_typeRow = _DSSPECTRALSYSTEM.lfo_wave_type.Newlfo_wave_typeRow
            With R
                .lfo_wave_type_id = GetNewlfo_wave_typeID()
                If _DefaultRowValues.lfo_wave_type_name IsNot Nothing Then .lfo_wave_type_name = _DefaultRowValues.lfo_wave_type_name
            End With
            _DSSPECTRALSYSTEM.lfo_wave_type.Addlfo_wave_typeRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.lfo_wave_type_id
        End Function

        Public Function AddRow2(lfo_wave_type_name As System.String) As Integer
            Dim R As DataSet_Spectral_System.lfo_wave_typeRow = _DSSPECTRALSYSTEM.lfo_wave_type.Newlfo_wave_typeRow
            With R
                .lfo_wave_type_id = GetNewlfo_wave_typeID()
                .lfo_wave_type_name = lfo_wave_type_name
            End With
            _DSSPECTRALSYSTEM.lfo_wave_type.Addlfo_wave_typeRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.lfo_wave_type_id
        End Function

        Public Function AddRow3(lfo_wave_type_id As System.Int32, lfo_wave_type_name As System.String) As Integer
            Dim R As DataSet_Spectral_System.lfo_wave_typeRow = _DSSPECTRALSYSTEM.lfo_wave_type.Newlfo_wave_typeRow
            With R
                .lfo_wave_type_id = lfo_wave_type_id
                .lfo_wave_type_name = lfo_wave_type_name
            End With
            _DSSPECTRALSYSTEM.lfo_wave_type.Addlfo_wave_typeRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.lfo_wave_type_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.lfo_wave_typeRow() = _DSSPECTRALSYSTEM.lfo_wave_type.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.lfo_wave_typeRow() = _DSSPECTRALSYSTEM.lfo_wave_type.Select("lfo_wave_type_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(lfo_wave_type_name As String) As DataSet_Spectral_System.lfo_wave_typeRow
            For Each r As DataSet_Spectral_System.lfo_wave_typeRow In DT.Rows
                If r.lfo_wave_type_name = lfo_wave_type_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(lfo_wave_type_id As Integer) As DataSet_Spectral_System.lfo_wave_typeRow
            Return _DSSPECTRALSYSTEM.lfo_wave_type.FindBylfo_wave_type_id(lfo_wave_type_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.lfo_wave_typeRow() = _DSSPECTRALSYSTEM.lfo_wave_type.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.lfo_wave_type_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.lfo_wave_typeRow
            Dim RowSet As DataSet_Spectral_System.lfo_wave_typeRow() = _DSSPECTRALSYSTEM.lfo_wave_type.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("lfo_wave_type", _CurrentRow.lfo_wave_type_id)
        End Function

        Public Sub DeleteRow(lfo_wave_type_id As Integer)
            Dim R As DataSet_Spectral_System.lfo_wave_typeRow = GetRow(lfo_wave_type_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.lfo_wave_typeRow = GetRow(CurrentRow.lfo_wave_type_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.lfo_wave_typeRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.lfo_wave_typeRow In RowsToDelete
                DeleteRow(R.lfo_wave_type_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .lfo_wave_type_id = DGV.CurrentRow.Cells("lfo_wave_type_id").Value
                    .lfo_wave_type_name = DGV.CurrentRow.Cells("lfo_wave_type_name").Value.ToString
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.lfo_wave_typeRow() = _DSSPECTRALSYSTEM.lfo_wave_type.Select("lfo_wave_type_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .lfo_wave_type_id = RowSet.First.lfo_wave_type_id
                    .lfo_wave_type_name = RowSet.First.lfo_wave_type_name
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.lfo_wave_type_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewlfo_wave_typeID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.lfo_wave_type.Compute("MAX(lfo_wave_type_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_midi_channel ------------------------------"
    Public Class TableClass_midi_channel
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.midi_channelDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim midi_channel_id As System.Int32
            Dim midi_channel_name As System.String
        End Structure

        Public Class Default_Row_Values
            Public midi_channel_name As System.String = ""
        End Class

        Public Structure ColNames
            Const midi_channel_id = "midi_channel_id"
            Const midi_channel_name = "midi_channel_name"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "midi_channel"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.midi_channelDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.midi_channel
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.midi_channel.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral_System.midi_channelRow = _DSSPECTRALSYSTEM.midi_channel.Newmidi_channelRow
            With R
                .midi_channel_id = GetNewmidi_channelID()
                If _DefaultRowValues.midi_channel_name IsNot Nothing Then .midi_channel_name = _DefaultRowValues.midi_channel_name
            End With
            _DSSPECTRALSYSTEM.midi_channel.Addmidi_channelRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.midi_channel_id
        End Function

        Public Function AddRow2(midi_channel_name As System.String) As Integer
            Dim R As DataSet_Spectral_System.midi_channelRow = _DSSPECTRALSYSTEM.midi_channel.Newmidi_channelRow
            With R
                .midi_channel_id = GetNewmidi_channelID()
                .midi_channel_name = midi_channel_name
            End With
            _DSSPECTRALSYSTEM.midi_channel.Addmidi_channelRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.midi_channel_id
        End Function

        Public Function AddRow3(midi_channel_id As System.Int32, midi_channel_name As System.String) As Integer
            Dim R As DataSet_Spectral_System.midi_channelRow = _DSSPECTRALSYSTEM.midi_channel.Newmidi_channelRow
            With R
                .midi_channel_id = midi_channel_id
                .midi_channel_name = midi_channel_name
            End With
            _DSSPECTRALSYSTEM.midi_channel.Addmidi_channelRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.midi_channel_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.midi_channelRow() = _DSSPECTRALSYSTEM.midi_channel.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.midi_channelRow() = _DSSPECTRALSYSTEM.midi_channel.Select("midi_channel_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(midi_channel_name As String) As DataSet_Spectral_System.midi_channelRow
            For Each r As DataSet_Spectral_System.midi_channelRow In DT.Rows
                If r.midi_channel_name = midi_channel_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(midi_channel_id As Integer) As DataSet_Spectral_System.midi_channelRow
            Return _DSSPECTRALSYSTEM.midi_channel.FindBymidi_channel_id(midi_channel_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.midi_channelRow() = _DSSPECTRALSYSTEM.midi_channel.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.midi_channel_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.midi_channelRow
            Dim RowSet As DataSet_Spectral_System.midi_channelRow() = _DSSPECTRALSYSTEM.midi_channel.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("midi_channel", _CurrentRow.midi_channel_id)
        End Function

        Public Sub DeleteRow(midi_channel_id As Integer)
            Dim R As DataSet_Spectral_System.midi_channelRow = GetRow(midi_channel_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.midi_channelRow = GetRow(CurrentRow.midi_channel_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.midi_channelRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.midi_channelRow In RowsToDelete
                DeleteRow(R.midi_channel_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .midi_channel_id = DGV.CurrentRow.Cells("midi_channel_id").Value
                    .midi_channel_name = DGV.CurrentRow.Cells("midi_channel_name").Value.ToString
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.midi_channelRow() = _DSSPECTRALSYSTEM.midi_channel.Select("midi_channel_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .midi_channel_id = RowSet.First.midi_channel_id
                    .midi_channel_name = RowSet.First.midi_channel_name
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.midi_channel_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewmidi_channelID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.midi_channel.Compute("MAX(midi_channel_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_midi_note ------------------------------"
    Public Class TableClass_midi_note
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.midi_noteDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim midi_note_id As System.Int32
            Dim midi_note_name As System.String
        End Structure

        Public Class Default_Row_Values
            Public midi_note_name As System.String = ""
        End Class

        Public Structure ColNames
            Const midi_note_id = "midi_note_id"
            Const midi_note_name = "midi_note_name"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "midi_note"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.midi_noteDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.midi_note
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.midi_note.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral_System.midi_noteRow = _DSSPECTRALSYSTEM.midi_note.Newmidi_noteRow
            With R
                .midi_note_id = GetNewmidi_noteID()
                If _DefaultRowValues.midi_note_name IsNot Nothing Then .midi_note_name = _DefaultRowValues.midi_note_name
            End With
            _DSSPECTRALSYSTEM.midi_note.Addmidi_noteRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.midi_note_id
        End Function

        Public Function AddRow2(midi_note_name As System.String) As Integer
            Dim R As DataSet_Spectral_System.midi_noteRow = _DSSPECTRALSYSTEM.midi_note.Newmidi_noteRow
            With R
                .midi_note_id = GetNewmidi_noteID()
                .midi_note_name = midi_note_name
            End With
            _DSSPECTRALSYSTEM.midi_note.Addmidi_noteRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.midi_note_id
        End Function

        Public Function AddRow3(midi_note_id As System.Int32, midi_note_name As System.String) As Integer
            Dim R As DataSet_Spectral_System.midi_noteRow = _DSSPECTRALSYSTEM.midi_note.Newmidi_noteRow
            With R
                .midi_note_id = midi_note_id
                .midi_note_name = midi_note_name
            End With
            _DSSPECTRALSYSTEM.midi_note.Addmidi_noteRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.midi_note_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.midi_noteRow() = _DSSPECTRALSYSTEM.midi_note.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.midi_noteRow() = _DSSPECTRALSYSTEM.midi_note.Select("midi_note_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(midi_note_name As String) As DataSet_Spectral_System.midi_noteRow
            For Each r As DataSet_Spectral_System.midi_noteRow In DT.Rows
                If r.midi_note_name = midi_note_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(midi_note_id As Integer) As DataSet_Spectral_System.midi_noteRow
            Return _DSSPECTRALSYSTEM.midi_note.FindBymidi_note_id(midi_note_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.midi_noteRow() = _DSSPECTRALSYSTEM.midi_note.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.midi_note_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.midi_noteRow
            Dim RowSet As DataSet_Spectral_System.midi_noteRow() = _DSSPECTRALSYSTEM.midi_note.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("midi_note", _CurrentRow.midi_note_id)
        End Function

        Public Sub DeleteRow(midi_note_id As Integer)
            Dim R As DataSet_Spectral_System.midi_noteRow = GetRow(midi_note_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.midi_noteRow = GetRow(CurrentRow.midi_note_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.midi_noteRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.midi_noteRow In RowsToDelete
                DeleteRow(R.midi_note_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .midi_note_id = DGV.CurrentRow.Cells("midi_note_id").Value
                    .midi_note_name = DGV.CurrentRow.Cells("midi_note_name").Value.ToString
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.midi_noteRow() = _DSSPECTRALSYSTEM.midi_note.Select("midi_note_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .midi_note_id = RowSet.First.midi_note_id
                    .midi_note_name = RowSet.First.midi_note_name
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.midi_note_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewmidi_noteID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.midi_note.Compute("MAX(midi_note_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_note_sector ------------------------------"
    Public Class TableClass_note_sector
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.note_sectorDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim note_sector_id As System.Int32
            Dim note_sector_name As System.String
            Dim sort_order As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public note_sector_name As System.String = ""
            Public sort_order As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const note_sector_id = "note_sector_id"
            Const note_sector_name = "note_sector_name"
            Const sort_order = "sort_order"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "note_sector"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.note_sectorDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.note_sector
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.note_sector.DefaultView
            DefaultView.Sort = "sort_order ASC"
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenSortableTable.AddRow
            Dim R As DataSet_Spectral_System.note_sectorRow = _DSSPECTRALSYSTEM.note_sector.Newnote_sectorRow
            With R
                .note_sector_id = GetNewnote_sectorID()
                If _DefaultRowValues.note_sector_name IsNot Nothing Then .note_sector_name = _DefaultRowValues.note_sector_name
                .sort_order = _DefaultRowValues.sort_order
                .sort_order = 10000
            End With
            _DSSPECTRALSYSTEM.note_sector.Addnote_sectorRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.note_sector_id
        End Function

        Public Function AddRow2(note_sector_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.note_sectorRow = _DSSPECTRALSYSTEM.note_sector.Newnote_sectorRow
            With R
                .note_sector_id = GetNewnote_sectorID()
                .note_sector_name = note_sector_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.note_sector.Addnote_sectorRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.note_sector_id
        End Function

        Public Function AddRow3(note_sector_id As System.Int32, note_sector_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.note_sectorRow = _DSSPECTRALSYSTEM.note_sector.Newnote_sectorRow
            With R
                .note_sector_id = note_sector_id
                .note_sector_name = note_sector_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.note_sector.Addnote_sectorRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.note_sector_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.note_sectorRow() = _DSSPECTRALSYSTEM.note_sector.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.note_sectorRow() = _DSSPECTRALSYSTEM.note_sector.Select("note_sector_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(note_sector_name As String) As DataSet_Spectral_System.note_sectorRow
            For Each r As DataSet_Spectral_System.note_sectorRow In DT.Rows
                If r.note_sector_name = note_sector_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(note_sector_id As Integer) As DataSet_Spectral_System.note_sectorRow
            Return _DSSPECTRALSYSTEM.note_sector.FindBynote_sector_id(note_sector_id)
        End Function

        Public Function GetRowsSortedBySortOrder(Filter As String) As DataRow() Implements I_GenericCodeGenSortableTable.GetRowsSortedBySortOrder
            Return _DSSPECTRALSYSTEM.note_sector.Select(Filter, "sort_order ASC", DataViewRowState.CurrentRows)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.note_sectorRow() = _DSSPECTRALSYSTEM.note_sector.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.note_sector_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.note_sectorRow
            Dim RowSet As DataSet_Spectral_System.note_sectorRow() = _DSSPECTRALSYSTEM.note_sector.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("note_sector", _CurrentRow.note_sector_id)
        End Function

        Public Sub DeleteRow(note_sector_id As Integer)
            Dim R As DataSet_Spectral_System.note_sectorRow = GetRow(note_sector_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.note_sectorRow = GetRow(CurrentRow.note_sector_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.note_sectorRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.note_sectorRow In RowsToDelete
                DeleteRow(R.note_sector_id)
            Next
        End Sub

        Public Sub MoveCurrentRow(MoveUp As Boolean) Implements I_GenericCodeGenSortableTable.MoveCurrentRow
            Dim R As DataSet_Spectral_System.note_sectorRow = GetRow(CurrentRow.note_sector_id)
            If MoveUp = True Then
                R.sort_order = R.sort_order - 15
            Else
                R.sort_order = R.sort_order + 15
            End If
            R.EndEdit() 'Seems to be ESSENTIAL, otherwise the next SELECT doesn't order properly. Strange !! 

            ReSortRows()
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .note_sector_id = DGV.CurrentRow.Cells("note_sector_id").Value
                    .note_sector_name = DGV.CurrentRow.Cells("note_sector_name").Value.ToString
                    .sort_order = DGV.CurrentRow.Cells("sort_order").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.note_sectorRow() = _DSSPECTRALSYSTEM.note_sector.Select("note_sector_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .note_sector_id = RowSet.First.note_sector_id
                    .note_sector_name = RowSet.First.note_sector_name
                    .sort_order = RowSet.First.sort_order
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.note_sector_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewnote_sectorID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.note_sector.Compute("MAX(note_sector_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

        Public Sub ReSortRows()
            Dim FilterString As String = _DSSPECTRALSYSTEM.note_sector.DefaultView.RowFilter
            Dim RowSet As DataSet_Spectral_System.note_sectorRow() = _DSSPECTRALSYSTEM.note_sector.Select(FilterString, "sort_order ASC", DataViewRowState.CurrentRows)
            For i = 0 To RowSet.Count - 1
                RowSet(i).sort_order = i * 10
            Next
        End Sub

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_patch_category ------------------------------"
    Public Class TableClass_patch_category
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.patch_categoryDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim patch_category_id As System.Int32
            Dim patch_category_name As System.String
            Dim sort_order As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public patch_category_name As System.String = ""
            Public sort_order As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const patch_category_id = "patch_category_id"
            Const patch_category_name = "patch_category_name"
            Const sort_order = "sort_order"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "patch_category"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.patch_categoryDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.patch_category
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.patch_category.DefaultView
            DefaultView.Sort = "sort_order ASC"
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenSortableTable.AddRow
            Dim R As DataSet_Spectral_System.patch_categoryRow = _DSSPECTRALSYSTEM.patch_category.Newpatch_categoryRow
            With R
                .patch_category_id = GetNewpatch_categoryID()
                If _DefaultRowValues.patch_category_name IsNot Nothing Then .patch_category_name = _DefaultRowValues.patch_category_name
                .sort_order = _DefaultRowValues.sort_order
                .sort_order = 10000
            End With
            _DSSPECTRALSYSTEM.patch_category.Addpatch_categoryRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.patch_category_id
        End Function

        Public Function AddRow2(patch_category_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.patch_categoryRow = _DSSPECTRALSYSTEM.patch_category.Newpatch_categoryRow
            With R
                .patch_category_id = GetNewpatch_categoryID()
                .patch_category_name = patch_category_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.patch_category.Addpatch_categoryRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.patch_category_id
        End Function

        Public Function AddRow3(patch_category_id As System.Int32, patch_category_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.patch_categoryRow = _DSSPECTRALSYSTEM.patch_category.Newpatch_categoryRow
            With R
                .patch_category_id = patch_category_id
                .patch_category_name = patch_category_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.patch_category.Addpatch_categoryRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.patch_category_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.patch_categoryRow() = _DSSPECTRALSYSTEM.patch_category.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.patch_categoryRow() = _DSSPECTRALSYSTEM.patch_category.Select("patch_category_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(patch_category_name As String) As DataSet_Spectral_System.patch_categoryRow
            For Each r As DataSet_Spectral_System.patch_categoryRow In DT.Rows
                If r.patch_category_name = patch_category_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(patch_category_id As Integer) As DataSet_Spectral_System.patch_categoryRow
            Return _DSSPECTRALSYSTEM.patch_category.FindBypatch_category_id(patch_category_id)
        End Function

        Public Function GetRowsSortedBySortOrder(Filter As String) As DataRow() Implements I_GenericCodeGenSortableTable.GetRowsSortedBySortOrder
            Return _DSSPECTRALSYSTEM.patch_category.Select(Filter, "sort_order ASC", DataViewRowState.CurrentRows)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.patch_categoryRow() = _DSSPECTRALSYSTEM.patch_category.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.patch_category_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.patch_categoryRow
            Dim RowSet As DataSet_Spectral_System.patch_categoryRow() = _DSSPECTRALSYSTEM.patch_category.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("patch_category", _CurrentRow.patch_category_id)
        End Function

        Public Sub DeleteRow(patch_category_id As Integer)
            Dim R As DataSet_Spectral_System.patch_categoryRow = GetRow(patch_category_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.patch_categoryRow = GetRow(CurrentRow.patch_category_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.patch_categoryRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.patch_categoryRow In RowsToDelete
                DeleteRow(R.patch_category_id)
            Next
        End Sub

        Public Sub MoveCurrentRow(MoveUp As Boolean) Implements I_GenericCodeGenSortableTable.MoveCurrentRow
            Dim R As DataSet_Spectral_System.patch_categoryRow = GetRow(CurrentRow.patch_category_id)
            If MoveUp = True Then
                R.sort_order = R.sort_order - 15
            Else
                R.sort_order = R.sort_order + 15
            End If
            R.EndEdit() 'Seems to be ESSENTIAL, otherwise the next SELECT doesn't order properly. Strange !! 

            ReSortRows()
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .patch_category_id = DGV.CurrentRow.Cells("patch_category_id").Value
                    .patch_category_name = DGV.CurrentRow.Cells("patch_category_name").Value.ToString
                    .sort_order = DGV.CurrentRow.Cells("sort_order").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.patch_categoryRow() = _DSSPECTRALSYSTEM.patch_category.Select("patch_category_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .patch_category_id = RowSet.First.patch_category_id
                    .patch_category_name = RowSet.First.patch_category_name
                    .sort_order = RowSet.First.sort_order
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.patch_category_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewpatch_categoryID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.patch_category.Compute("MAX(patch_category_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

        Public Sub ReSortRows()
            Dim FilterString As String = _DSSPECTRALSYSTEM.patch_category.DefaultView.RowFilter
            Dim RowSet As DataSet_Spectral_System.patch_categoryRow() = _DSSPECTRALSYSTEM.patch_category.Select(FilterString, "sort_order ASC", DataViewRowState.CurrentRows)
            For i = 0 To RowSet.Count - 1
                RowSet(i).sort_order = i * 10
            Next
        End Sub

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_patch_type ------------------------------"
    Public Class TableClass_patch_type
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.patch_typeDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim patch_type_id As System.Int32
            Dim patch_type_name As System.String
            Dim sort_order As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public patch_type_name As System.String = ""
            Public sort_order As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const patch_type_id = "patch_type_id"
            Const patch_type_name = "patch_type_name"
            Const sort_order = "sort_order"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "patch_type"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.patch_typeDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.patch_type
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.patch_type.DefaultView
            DefaultView.Sort = "sort_order ASC"
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenSortableTable.AddRow
            Dim R As DataSet_Spectral_System.patch_typeRow = _DSSPECTRALSYSTEM.patch_type.Newpatch_typeRow
            With R
                .patch_type_id = GetNewpatch_typeID()
                If _DefaultRowValues.patch_type_name IsNot Nothing Then .patch_type_name = _DefaultRowValues.patch_type_name
                .sort_order = _DefaultRowValues.sort_order
                .sort_order = 10000
            End With
            _DSSPECTRALSYSTEM.patch_type.Addpatch_typeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.patch_type_id
        End Function

        Public Function AddRow2(patch_type_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.patch_typeRow = _DSSPECTRALSYSTEM.patch_type.Newpatch_typeRow
            With R
                .patch_type_id = GetNewpatch_typeID()
                .patch_type_name = patch_type_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.patch_type.Addpatch_typeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.patch_type_id
        End Function

        Public Function AddRow3(patch_type_id As System.Int32, patch_type_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.patch_typeRow = _DSSPECTRALSYSTEM.patch_type.Newpatch_typeRow
            With R
                .patch_type_id = patch_type_id
                .patch_type_name = patch_type_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.patch_type.Addpatch_typeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.patch_type_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.patch_typeRow() = _DSSPECTRALSYSTEM.patch_type.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.patch_typeRow() = _DSSPECTRALSYSTEM.patch_type.Select("patch_type_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(patch_type_name As String) As DataSet_Spectral_System.patch_typeRow
            For Each r As DataSet_Spectral_System.patch_typeRow In DT.Rows
                If r.patch_type_name = patch_type_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(patch_type_id As Integer) As DataSet_Spectral_System.patch_typeRow
            Return _DSSPECTRALSYSTEM.patch_type.FindBypatch_type_id(patch_type_id)
        End Function

        Public Function GetRowsSortedBySortOrder(Filter As String) As DataRow() Implements I_GenericCodeGenSortableTable.GetRowsSortedBySortOrder
            Return _DSSPECTRALSYSTEM.patch_type.Select(Filter, "sort_order ASC", DataViewRowState.CurrentRows)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.patch_typeRow() = _DSSPECTRALSYSTEM.patch_type.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.patch_type_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.patch_typeRow
            Dim RowSet As DataSet_Spectral_System.patch_typeRow() = _DSSPECTRALSYSTEM.patch_type.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("patch_type", _CurrentRow.patch_type_id)
        End Function

        Public Sub DeleteRow(patch_type_id As Integer)
            Dim R As DataSet_Spectral_System.patch_typeRow = GetRow(patch_type_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.patch_typeRow = GetRow(CurrentRow.patch_type_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.patch_typeRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.patch_typeRow In RowsToDelete
                DeleteRow(R.patch_type_id)
            Next
        End Sub

        Public Sub MoveCurrentRow(MoveUp As Boolean) Implements I_GenericCodeGenSortableTable.MoveCurrentRow
            Dim R As DataSet_Spectral_System.patch_typeRow = GetRow(CurrentRow.patch_type_id)
            If MoveUp = True Then
                R.sort_order = R.sort_order - 15
            Else
                R.sort_order = R.sort_order + 15
            End If
            R.EndEdit() 'Seems to be ESSENTIAL, otherwise the next SELECT doesn't order properly. Strange !! 

            ReSortRows()
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .patch_type_id = DGV.CurrentRow.Cells("patch_type_id").Value
                    .patch_type_name = DGV.CurrentRow.Cells("patch_type_name").Value.ToString
                    .sort_order = DGV.CurrentRow.Cells("sort_order").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.patch_typeRow() = _DSSPECTRALSYSTEM.patch_type.Select("patch_type_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .patch_type_id = RowSet.First.patch_type_id
                    .patch_type_name = RowSet.First.patch_type_name
                    .sort_order = RowSet.First.sort_order
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.patch_type_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewpatch_typeID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.patch_type.Compute("MAX(patch_type_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

        Public Sub ReSortRows()
            Dim FilterString As String = _DSSPECTRALSYSTEM.patch_type.DefaultView.RowFilter
            Dim RowSet As DataSet_Spectral_System.patch_typeRow() = _DSSPECTRALSYSTEM.patch_type.Select(FilterString, "sort_order ASC", DataViewRowState.CurrentRows)
            For i = 0 To RowSet.Count - 1
                RowSet(i).sort_order = i * 10
            Next
        End Sub

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_phase_setting ------------------------------"
    Public Class TableClass_phase_setting
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.phase_settingDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim phase_setting_id As System.Int32
            Dim phase_setting_name As System.String
        End Structure

        Public Class Default_Row_Values
            Public phase_setting_name As System.String = ""
        End Class

        Public Structure ColNames
            Const phase_setting_id = "phase_setting_id"
            Const phase_setting_name = "phase_setting_name"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "phase_setting"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.phase_settingDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.phase_setting
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.phase_setting.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral_System.phase_settingRow = _DSSPECTRALSYSTEM.phase_setting.Newphase_settingRow
            With R
                .phase_setting_id = GetNewphase_settingID()
                If _DefaultRowValues.phase_setting_name IsNot Nothing Then .phase_setting_name = _DefaultRowValues.phase_setting_name
            End With
            _DSSPECTRALSYSTEM.phase_setting.Addphase_settingRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.phase_setting_id
        End Function

        Public Function AddRow2(phase_setting_name As System.String) As Integer
            Dim R As DataSet_Spectral_System.phase_settingRow = _DSSPECTRALSYSTEM.phase_setting.Newphase_settingRow
            With R
                .phase_setting_id = GetNewphase_settingID()
                .phase_setting_name = phase_setting_name
            End With
            _DSSPECTRALSYSTEM.phase_setting.Addphase_settingRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.phase_setting_id
        End Function

        Public Function AddRow3(phase_setting_id As System.Int32, phase_setting_name As System.String) As Integer
            Dim R As DataSet_Spectral_System.phase_settingRow = _DSSPECTRALSYSTEM.phase_setting.Newphase_settingRow
            With R
                .phase_setting_id = phase_setting_id
                .phase_setting_name = phase_setting_name
            End With
            _DSSPECTRALSYSTEM.phase_setting.Addphase_settingRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.phase_setting_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.phase_settingRow() = _DSSPECTRALSYSTEM.phase_setting.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.phase_settingRow() = _DSSPECTRALSYSTEM.phase_setting.Select("phase_setting_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(phase_setting_name As String) As DataSet_Spectral_System.phase_settingRow
            For Each r As DataSet_Spectral_System.phase_settingRow In DT.Rows
                If r.phase_setting_name = phase_setting_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(phase_setting_id As Integer) As DataSet_Spectral_System.phase_settingRow
            Return _DSSPECTRALSYSTEM.phase_setting.FindByphase_setting_id(phase_setting_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.phase_settingRow() = _DSSPECTRALSYSTEM.phase_setting.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.phase_setting_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.phase_settingRow
            Dim RowSet As DataSet_Spectral_System.phase_settingRow() = _DSSPECTRALSYSTEM.phase_setting.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("phase_setting", _CurrentRow.phase_setting_id)
        End Function

        Public Sub DeleteRow(phase_setting_id As Integer)
            Dim R As DataSet_Spectral_System.phase_settingRow = GetRow(phase_setting_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.phase_settingRow = GetRow(CurrentRow.phase_setting_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.phase_settingRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.phase_settingRow In RowsToDelete
                DeleteRow(R.phase_setting_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .phase_setting_id = DGV.CurrentRow.Cells("phase_setting_id").Value
                    .phase_setting_name = DGV.CurrentRow.Cells("phase_setting_name").Value.ToString
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.phase_settingRow() = _DSSPECTRALSYSTEM.phase_setting.Select("phase_setting_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .phase_setting_id = RowSet.First.phase_setting_id
                    .phase_setting_name = RowSet.First.phase_setting_name
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.phase_setting_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewphase_settingID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.phase_setting.Compute("MAX(phase_setting_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_sample ------------------------------"
    Public Class TableClass_sample
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.sampleDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim sample_id As System.Int32
            Dim sample_name As System.String
            Dim sort_order As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public sample_name As System.String = ""
            Public sort_order As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const sample_id = "sample_id"
            Const sample_name = "sample_name"
            Const sort_order = "sort_order"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "sample"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.sampleDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.sample
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.sample.DefaultView
            DefaultView.Sort = "sort_order ASC"
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenSortableTable.AddRow
            Dim R As DataSet_Spectral_System.sampleRow = _DSSPECTRALSYSTEM.sample.NewsampleRow
            With R
                .sample_id = GetNewsampleID()
                If _DefaultRowValues.sample_name IsNot Nothing Then .sample_name = _DefaultRowValues.sample_name
                .sort_order = _DefaultRowValues.sort_order
                .sort_order = 10000
            End With
            _DSSPECTRALSYSTEM.sample.AddsampleRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.sample_id
        End Function

        Public Function AddRow2(sample_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.sampleRow = _DSSPECTRALSYSTEM.sample.NewsampleRow
            With R
                .sample_id = GetNewsampleID()
                .sample_name = sample_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.sample.AddsampleRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.sample_id
        End Function

        Public Function AddRow3(sample_id As System.Int32, sample_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.sampleRow = _DSSPECTRALSYSTEM.sample.NewsampleRow
            With R
                .sample_id = sample_id
                .sample_name = sample_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.sample.AddsampleRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.sample_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.sampleRow() = _DSSPECTRALSYSTEM.sample.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.sampleRow() = _DSSPECTRALSYSTEM.sample.Select("sample_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(sample_name As String) As DataSet_Spectral_System.sampleRow
            For Each r As DataSet_Spectral_System.sampleRow In DT.Rows
                If r.sample_name = sample_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(sample_id As Integer) As DataSet_Spectral_System.sampleRow
            Return _DSSPECTRALSYSTEM.sample.FindBysample_id(sample_id)
        End Function

        Public Function GetRowsSortedBySortOrder(Filter As String) As DataRow() Implements I_GenericCodeGenSortableTable.GetRowsSortedBySortOrder
            Return _DSSPECTRALSYSTEM.sample.Select(Filter, "sort_order ASC", DataViewRowState.CurrentRows)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.sampleRow() = _DSSPECTRALSYSTEM.sample.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.sample_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.sampleRow
            Dim RowSet As DataSet_Spectral_System.sampleRow() = _DSSPECTRALSYSTEM.sample.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("sample", _CurrentRow.sample_id)
        End Function

        Public Sub DeleteRow(sample_id As Integer)
            Dim R As DataSet_Spectral_System.sampleRow = GetRow(sample_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.sampleRow = GetRow(CurrentRow.sample_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.sampleRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.sampleRow In RowsToDelete
                DeleteRow(R.sample_id)
            Next
        End Sub

        Public Sub MoveCurrentRow(MoveUp As Boolean) Implements I_GenericCodeGenSortableTable.MoveCurrentRow
            Dim R As DataSet_Spectral_System.sampleRow = GetRow(CurrentRow.sample_id)
            If MoveUp = True Then
                R.sort_order = R.sort_order - 15
            Else
                R.sort_order = R.sort_order + 15
            End If
            R.EndEdit() 'Seems to be ESSENTIAL, otherwise the next SELECT doesn't order properly. Strange !! 

            ReSortRows()
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .sample_id = DGV.CurrentRow.Cells("sample_id").Value
                    .sample_name = DGV.CurrentRow.Cells("sample_name").Value.ToString
                    .sort_order = DGV.CurrentRow.Cells("sort_order").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.sampleRow() = _DSSPECTRALSYSTEM.sample.Select("sample_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .sample_id = RowSet.First.sample_id
                    .sample_name = RowSet.First.sample_name
                    .sort_order = RowSet.First.sort_order
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.sample_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewsampleID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.sample.Compute("MAX(sample_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

        Public Sub ReSortRows()
            Dim FilterString As String = _DSSPECTRALSYSTEM.sample.DefaultView.RowFilter
            Dim RowSet As DataSet_Spectral_System.sampleRow() = _DSSPECTRALSYSTEM.sample.Select(FilterString, "sort_order ASC", DataViewRowState.CurrentRows)
            For i = 0 To RowSet.Count - 1
                RowSet(i).sort_order = i * 10
            Next
        End Sub

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_sample_playback_mode ------------------------------"
    Public Class TableClass_sample_playback_mode
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.sample_playback_modeDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim sample_playback_mode_id As System.Int32
            Dim sample_playback_mode_name As System.String
            Dim sort_order As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public sample_playback_mode_name As System.String = ""
            Public sort_order As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const sample_playback_mode_id = "sample_playback_mode_id"
            Const sample_playback_mode_name = "sample_playback_mode_name"
            Const sort_order = "sort_order"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "sample_playback_mode"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.sample_playback_modeDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.sample_playback_mode
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.sample_playback_mode.DefaultView
            DefaultView.Sort = "sort_order ASC"
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenSortableTable.AddRow
            Dim R As DataSet_Spectral_System.sample_playback_modeRow = _DSSPECTRALSYSTEM.sample_playback_mode.Newsample_playback_modeRow
            With R
                .sample_playback_mode_id = GetNewsample_playback_modeID()
                If _DefaultRowValues.sample_playback_mode_name IsNot Nothing Then .sample_playback_mode_name = _DefaultRowValues.sample_playback_mode_name
                .sort_order = _DefaultRowValues.sort_order
                .sort_order = 10000
            End With
            _DSSPECTRALSYSTEM.sample_playback_mode.Addsample_playback_modeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.sample_playback_mode_id
        End Function

        Public Function AddRow2(sample_playback_mode_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.sample_playback_modeRow = _DSSPECTRALSYSTEM.sample_playback_mode.Newsample_playback_modeRow
            With R
                .sample_playback_mode_id = GetNewsample_playback_modeID()
                .sample_playback_mode_name = sample_playback_mode_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.sample_playback_mode.Addsample_playback_modeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.sample_playback_mode_id
        End Function

        Public Function AddRow3(sample_playback_mode_id As System.Int32, sample_playback_mode_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.sample_playback_modeRow = _DSSPECTRALSYSTEM.sample_playback_mode.Newsample_playback_modeRow
            With R
                .sample_playback_mode_id = sample_playback_mode_id
                .sample_playback_mode_name = sample_playback_mode_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.sample_playback_mode.Addsample_playback_modeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.sample_playback_mode_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.sample_playback_modeRow() = _DSSPECTRALSYSTEM.sample_playback_mode.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.sample_playback_modeRow() = _DSSPECTRALSYSTEM.sample_playback_mode.Select("sample_playback_mode_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(sample_playback_mode_name As String) As DataSet_Spectral_System.sample_playback_modeRow
            For Each r As DataSet_Spectral_System.sample_playback_modeRow In DT.Rows
                If r.sample_playback_mode_name = sample_playback_mode_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(sample_playback_mode_id As Integer) As DataSet_Spectral_System.sample_playback_modeRow
            Return _DSSPECTRALSYSTEM.sample_playback_mode.FindBysample_playback_mode_id(sample_playback_mode_id)
        End Function

        Public Function GetRowsSortedBySortOrder(Filter As String) As DataRow() Implements I_GenericCodeGenSortableTable.GetRowsSortedBySortOrder
            Return _DSSPECTRALSYSTEM.sample_playback_mode.Select(Filter, "sort_order ASC", DataViewRowState.CurrentRows)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.sample_playback_modeRow() = _DSSPECTRALSYSTEM.sample_playback_mode.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.sample_playback_mode_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.sample_playback_modeRow
            Dim RowSet As DataSet_Spectral_System.sample_playback_modeRow() = _DSSPECTRALSYSTEM.sample_playback_mode.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("sample_playback_mode", _CurrentRow.sample_playback_mode_id)
        End Function

        Public Sub DeleteRow(sample_playback_mode_id As Integer)
            Dim R As DataSet_Spectral_System.sample_playback_modeRow = GetRow(sample_playback_mode_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.sample_playback_modeRow = GetRow(CurrentRow.sample_playback_mode_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.sample_playback_modeRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.sample_playback_modeRow In RowsToDelete
                DeleteRow(R.sample_playback_mode_id)
            Next
        End Sub

        Public Sub MoveCurrentRow(MoveUp As Boolean) Implements I_GenericCodeGenSortableTable.MoveCurrentRow
            Dim R As DataSet_Spectral_System.sample_playback_modeRow = GetRow(CurrentRow.sample_playback_mode_id)
            If MoveUp = True Then
                R.sort_order = R.sort_order - 15
            Else
                R.sort_order = R.sort_order + 15
            End If
            R.EndEdit() 'Seems to be ESSENTIAL, otherwise the next SELECT doesn't order properly. Strange !! 

            ReSortRows()
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .sample_playback_mode_id = DGV.CurrentRow.Cells("sample_playback_mode_id").Value
                    .sample_playback_mode_name = DGV.CurrentRow.Cells("sample_playback_mode_name").Value.ToString
                    .sort_order = DGV.CurrentRow.Cells("sort_order").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.sample_playback_modeRow() = _DSSPECTRALSYSTEM.sample_playback_mode.Select("sample_playback_mode_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .sample_playback_mode_id = RowSet.First.sample_playback_mode_id
                    .sample_playback_mode_name = RowSet.First.sample_playback_mode_name
                    .sort_order = RowSet.First.sort_order
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.sample_playback_mode_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewsample_playback_modeID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.sample_playback_mode.Compute("MAX(sample_playback_mode_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

        Public Sub ReSortRows()
            Dim FilterString As String = _DSSPECTRALSYSTEM.sample_playback_mode.DefaultView.RowFilter
            Dim RowSet As DataSet_Spectral_System.sample_playback_modeRow() = _DSSPECTRALSYSTEM.sample_playback_mode.Select(FilterString, "sort_order ASC", DataViewRowState.CurrentRows)
            For i = 0 To RowSet.Count - 1
                RowSet(i).sort_order = i * 10
            Next
        End Sub

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_timbre_mode ------------------------------"
    Public Class TableClass_timbre_mode
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.timbre_modeDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim timbre_mode_id As System.Int32
            Dim timbre_mode_name As System.String
            Dim sort_order As System.Int32
        End Structure

        Public Class Default_Row_Values
            Public timbre_mode_name As System.String = ""
            Public sort_order As System.Int32 = 0
        End Class

        Public Structure ColNames
            Const timbre_mode_id = "timbre_mode_id"
            Const timbre_mode_name = "timbre_mode_name"
            Const sort_order = "sort_order"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "timbre_mode"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.timbre_modeDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.timbre_mode
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.timbre_mode.DefaultView
            DefaultView.Sort = "sort_order ASC"
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenSortableTable.AddRow
            Dim R As DataSet_Spectral_System.timbre_modeRow = _DSSPECTRALSYSTEM.timbre_mode.Newtimbre_modeRow
            With R
                .timbre_mode_id = GetNewtimbre_modeID()
                If _DefaultRowValues.timbre_mode_name IsNot Nothing Then .timbre_mode_name = _DefaultRowValues.timbre_mode_name
                .sort_order = _DefaultRowValues.sort_order
                .sort_order = 10000
            End With
            _DSSPECTRALSYSTEM.timbre_mode.Addtimbre_modeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.timbre_mode_id
        End Function

        Public Function AddRow2(timbre_mode_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.timbre_modeRow = _DSSPECTRALSYSTEM.timbre_mode.Newtimbre_modeRow
            With R
                .timbre_mode_id = GetNewtimbre_modeID()
                .timbre_mode_name = timbre_mode_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.timbre_mode.Addtimbre_modeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.timbre_mode_id
        End Function

        Public Function AddRow3(timbre_mode_id As System.Int32, timbre_mode_name As System.String, sort_order As System.Int32) As Integer
            Dim R As DataSet_Spectral_System.timbre_modeRow = _DSSPECTRALSYSTEM.timbre_mode.Newtimbre_modeRow
            With R
                .timbre_mode_id = timbre_mode_id
                .timbre_mode_name = timbre_mode_name
                .sort_order = sort_order
                .sort_order = 20000
            End With
            _DSSPECTRALSYSTEM.timbre_mode.Addtimbre_modeRow(R)
            ReSortRows()
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.timbre_mode_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.timbre_modeRow() = _DSSPECTRALSYSTEM.timbre_mode.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.timbre_modeRow() = _DSSPECTRALSYSTEM.timbre_mode.Select("timbre_mode_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(timbre_mode_name As String) As DataSet_Spectral_System.timbre_modeRow
            For Each r As DataSet_Spectral_System.timbre_modeRow In DT.Rows
                If r.timbre_mode_name = timbre_mode_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(timbre_mode_id As Integer) As DataSet_Spectral_System.timbre_modeRow
            Return _DSSPECTRALSYSTEM.timbre_mode.FindBytimbre_mode_id(timbre_mode_id)
        End Function

        Public Function GetRowsSortedBySortOrder(Filter As String) As DataRow() Implements I_GenericCodeGenSortableTable.GetRowsSortedBySortOrder
            Return _DSSPECTRALSYSTEM.timbre_mode.Select(Filter, "sort_order ASC", DataViewRowState.CurrentRows)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.timbre_modeRow() = _DSSPECTRALSYSTEM.timbre_mode.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.timbre_mode_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.timbre_modeRow
            Dim RowSet As DataSet_Spectral_System.timbre_modeRow() = _DSSPECTRALSYSTEM.timbre_mode.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("timbre_mode", _CurrentRow.timbre_mode_id)
        End Function

        Public Sub DeleteRow(timbre_mode_id As Integer)
            Dim R As DataSet_Spectral_System.timbre_modeRow = GetRow(timbre_mode_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.timbre_modeRow = GetRow(CurrentRow.timbre_mode_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.timbre_modeRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.timbre_modeRow In RowsToDelete
                DeleteRow(R.timbre_mode_id)
            Next
        End Sub

        Public Sub MoveCurrentRow(MoveUp As Boolean) Implements I_GenericCodeGenSortableTable.MoveCurrentRow
            Dim R As DataSet_Spectral_System.timbre_modeRow = GetRow(CurrentRow.timbre_mode_id)
            If MoveUp = True Then
                R.sort_order = R.sort_order - 15
            Else
                R.sort_order = R.sort_order + 15
            End If
            R.EndEdit() 'Seems to be ESSENTIAL, otherwise the next SELECT doesn't order properly. Strange !! 

            ReSortRows()
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .timbre_mode_id = DGV.CurrentRow.Cells("timbre_mode_id").Value
                    .timbre_mode_name = DGV.CurrentRow.Cells("timbre_mode_name").Value.ToString
                    .sort_order = DGV.CurrentRow.Cells("sort_order").Value
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.timbre_modeRow() = _DSSPECTRALSYSTEM.timbre_mode.Select("timbre_mode_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .timbre_mode_id = RowSet.First.timbre_mode_id
                    .timbre_mode_name = RowSet.First.timbre_mode_name
                    .sort_order = RowSet.First.sort_order
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.timbre_mode_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewtimbre_modeID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.timbre_mode.Compute("MAX(timbre_mode_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

        Public Sub ReSortRows()
            Dim FilterString As String = _DSSPECTRALSYSTEM.timbre_mode.DefaultView.RowFilter
            Dim RowSet As DataSet_Spectral_System.timbre_modeRow() = _DSSPECTRALSYSTEM.timbre_mode.Select(FilterString, "sort_order ASC", DataViewRowState.CurrentRows)
            For i = 0 To RowSet.Count - 1
                RowSet(i).sort_order = i * 10
            Next
        End Sub

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_wave_editing_action ------------------------------"
    Public Class TableClass_wave_editing_action
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.wave_editing_actionDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim wave_editing_action_id As System.Int32
            Dim wave_editing_action_name As System.String
        End Structure

        Public Class Default_Row_Values
            Public wave_editing_action_name As System.String = ""
        End Class

        Public Structure ColNames
            Const wave_editing_action_id = "wave_editing_action_id"
            Const wave_editing_action_name = "wave_editing_action_name"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "wave_editing_action"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.wave_editing_actionDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.wave_editing_action
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.wave_editing_action.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral_System.wave_editing_actionRow = _DSSPECTRALSYSTEM.wave_editing_action.Newwave_editing_actionRow
            With R
                .wave_editing_action_id = GetNewwave_editing_actionID()
                If _DefaultRowValues.wave_editing_action_name IsNot Nothing Then .wave_editing_action_name = _DefaultRowValues.wave_editing_action_name
            End With
            _DSSPECTRALSYSTEM.wave_editing_action.Addwave_editing_actionRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.wave_editing_action_id
        End Function

        Public Function AddRow2(wave_editing_action_name As System.String) As Integer
            Dim R As DataSet_Spectral_System.wave_editing_actionRow = _DSSPECTRALSYSTEM.wave_editing_action.Newwave_editing_actionRow
            With R
                .wave_editing_action_id = GetNewwave_editing_actionID()
                .wave_editing_action_name = wave_editing_action_name
            End With
            _DSSPECTRALSYSTEM.wave_editing_action.Addwave_editing_actionRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.wave_editing_action_id
        End Function

        Public Function AddRow3(wave_editing_action_id As System.Int32, wave_editing_action_name As System.String) As Integer
            Dim R As DataSet_Spectral_System.wave_editing_actionRow = _DSSPECTRALSYSTEM.wave_editing_action.Newwave_editing_actionRow
            With R
                .wave_editing_action_id = wave_editing_action_id
                .wave_editing_action_name = wave_editing_action_name
            End With
            _DSSPECTRALSYSTEM.wave_editing_action.Addwave_editing_actionRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.wave_editing_action_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.wave_editing_actionRow() = _DSSPECTRALSYSTEM.wave_editing_action.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.wave_editing_actionRow() = _DSSPECTRALSYSTEM.wave_editing_action.Select("wave_editing_action_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(wave_editing_action_name As String) As DataSet_Spectral_System.wave_editing_actionRow
            For Each r As DataSet_Spectral_System.wave_editing_actionRow In DT.Rows
                If r.wave_editing_action_name = wave_editing_action_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(wave_editing_action_id As Integer) As DataSet_Spectral_System.wave_editing_actionRow
            Return _DSSPECTRALSYSTEM.wave_editing_action.FindBywave_editing_action_id(wave_editing_action_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.wave_editing_actionRow() = _DSSPECTRALSYSTEM.wave_editing_action.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.wave_editing_action_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.wave_editing_actionRow
            Dim RowSet As DataSet_Spectral_System.wave_editing_actionRow() = _DSSPECTRALSYSTEM.wave_editing_action.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("wave_editing_action", _CurrentRow.wave_editing_action_id)
        End Function

        Public Sub DeleteRow(wave_editing_action_id As Integer)
            Dim R As DataSet_Spectral_System.wave_editing_actionRow = GetRow(wave_editing_action_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.wave_editing_actionRow = GetRow(CurrentRow.wave_editing_action_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.wave_editing_actionRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.wave_editing_actionRow In RowsToDelete
                DeleteRow(R.wave_editing_action_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .wave_editing_action_id = DGV.CurrentRow.Cells("wave_editing_action_id").Value
                    .wave_editing_action_name = DGV.CurrentRow.Cells("wave_editing_action_name").Value.ToString
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.wave_editing_actionRow() = _DSSPECTRALSYSTEM.wave_editing_action.Select("wave_editing_action_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .wave_editing_action_id = RowSet.First.wave_editing_action_id
                    .wave_editing_action_name = RowSet.First.wave_editing_action_name
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.wave_editing_action_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewwave_editing_actionID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.wave_editing_action.Compute("MAX(wave_editing_action_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_wave_shape ------------------------------"
    Public Class TableClass_wave_shape
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.wave_shapeDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim wave_shape_id As System.Int32
            Dim wave_shape_name As System.String
        End Structure

        Public Class Default_Row_Values
            Public wave_shape_name As System.String = ""
        End Class

        Public Structure ColNames
            Const wave_shape_id = "wave_shape_id"
            Const wave_shape_name = "wave_shape_name"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "wave_shape"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.wave_shapeDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.wave_shape
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.wave_shape.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral_System.wave_shapeRow = _DSSPECTRALSYSTEM.wave_shape.Newwave_shapeRow
            With R
                .wave_shape_id = GetNewwave_shapeID()
                If _DefaultRowValues.wave_shape_name IsNot Nothing Then .wave_shape_name = _DefaultRowValues.wave_shape_name
            End With
            _DSSPECTRALSYSTEM.wave_shape.Addwave_shapeRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.wave_shape_id
        End Function

        Public Function AddRow2(wave_shape_name As System.String) As Integer
            Dim R As DataSet_Spectral_System.wave_shapeRow = _DSSPECTRALSYSTEM.wave_shape.Newwave_shapeRow
            With R
                .wave_shape_id = GetNewwave_shapeID()
                .wave_shape_name = wave_shape_name
            End With
            _DSSPECTRALSYSTEM.wave_shape.Addwave_shapeRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.wave_shape_id
        End Function

        Public Function AddRow3(wave_shape_id As System.Int32, wave_shape_name As System.String) As Integer
            Dim R As DataSet_Spectral_System.wave_shapeRow = _DSSPECTRALSYSTEM.wave_shape.Newwave_shapeRow
            With R
                .wave_shape_id = wave_shape_id
                .wave_shape_name = wave_shape_name
            End With
            _DSSPECTRALSYSTEM.wave_shape.Addwave_shapeRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.wave_shape_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.wave_shapeRow() = _DSSPECTRALSYSTEM.wave_shape.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.wave_shapeRow() = _DSSPECTRALSYSTEM.wave_shape.Select("wave_shape_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(wave_shape_name As String) As DataSet_Spectral_System.wave_shapeRow
            For Each r As DataSet_Spectral_System.wave_shapeRow In DT.Rows
                If r.wave_shape_name = wave_shape_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(wave_shape_id As Integer) As DataSet_Spectral_System.wave_shapeRow
            Return _DSSPECTRALSYSTEM.wave_shape.FindBywave_shape_id(wave_shape_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.wave_shapeRow() = _DSSPECTRALSYSTEM.wave_shape.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.wave_shape_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.wave_shapeRow
            Dim RowSet As DataSet_Spectral_System.wave_shapeRow() = _DSSPECTRALSYSTEM.wave_shape.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("wave_shape", _CurrentRow.wave_shape_id)
        End Function

        Public Sub DeleteRow(wave_shape_id As Integer)
            Dim R As DataSet_Spectral_System.wave_shapeRow = GetRow(wave_shape_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.wave_shapeRow = GetRow(CurrentRow.wave_shape_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.wave_shapeRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.wave_shapeRow In RowsToDelete
                DeleteRow(R.wave_shape_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .wave_shape_id = DGV.CurrentRow.Cells("wave_shape_id").Value
                    .wave_shape_name = DGV.CurrentRow.Cells("wave_shape_name").Value.ToString
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.wave_shapeRow() = _DSSPECTRALSYSTEM.wave_shape.Select("wave_shape_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .wave_shape_id = RowSet.First.wave_shape_id
                    .wave_shape_name = RowSet.First.wave_shape_name
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.wave_shape_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewwave_shapeID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.wave_shape.Compute("MAX(wave_shape_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#Region "----------Class : TableClass_waveform ------------------------------"
    Public Class TableClass_waveform
        Implements WarmBreeze_DataLibrary.I_GenericCodeGenNonSortableTable, WarmBreeze_DataLibrary.I_GenericCodeGenTable
#Region "Declarations"
        Private _DSSPECTRALSYSTEM As DataSet_Spectral_System
        Private _ParentClass As CodeGen_DS_Spectral_System
        Private _Table_BindingSource As New BindingSource
        Private _DT As DataSet_Spectral_System.waveformDataTable
        Private _AlternativeView As New DataView
        Private _CurrentRow As New RowValues
        Private _DefaultRowValues As New Default_Row_Values
        Private _ChildCodeGenTableList As New List(Of I_GenericCodeGenTable)
        Public Structure RowValues
            Dim RowIndex As Integer
            Dim RowIsEmpty As Boolean
            Dim waveform_id As System.Int32
            Dim waveform_name As System.String
        End Structure

        Public Class Default_Row_Values
            Public waveform_name As System.String = ""
        End Class

        Public Structure ColNames
            Const waveform_id = "waveform_id"
            Const waveform_name = "waveform_name"
        End Structure

        Public Event Event_NewRowAdded(ByVal sender As Object, ByVal e As System.EventArgs)
        Public Event Event_BeforeRowDeleted(ByVal sender As Object, ByVal e As EventArgs_BeforeRowDelete)
#End Region

#Region "Properties"
        Public ReadOnly Property TableName() As String Implements I_GenericCodeGenNonSortableTable.TableName, I_GenericCodeGenTable.TableName
            Get
                Return "waveform"
            End Get
        End Property

        Public ReadOnly Property Table_BindingSource() As BindingSource Implements I_GenericCodeGenNonSortableTable.TableBindingSource
            Get
                Return _Table_BindingSource
            End Get
        End Property

        Public ReadOnly Property DefaultView() As DataView Implements I_GenericCodeGenNonSortableTable.DefaultView
            Get
                Return _DT.DefaultView
            End Get
        End Property

        Public ReadOnly Property AlternativeView() As DataView Implements I_GenericCodeGenNonSortableTable.AlternativeView
            Get
                Return _AlternativeView
            End Get
        End Property

        Public ReadOnly Property DT() As DataSet_Spectral_System.waveformDataTable
            Get
                Return _DT
            End Get
        End Property

        Public ReadOnly Property CurrentRow() As RowValues
            Get
                Return _CurrentRow
            End Get
        End Property

        Public Property DefaultRowValues() As Default_Row_Values
            Get
                Return _DefaultRowValues
            End Get
            Set(value As Default_Row_Values)
                _DefaultRowValues = value
            End Set
        End Property

        Public Property ChildCodeGenTableList() As List(Of I_GenericCodeGenTable) Implements I_GenericCodeGenTable.ChildCodeGenTableList
            Get
                Return _ChildCodeGenTableList
            End Get
            Set(value As List(Of I_GenericCodeGenTable))
                _ChildCodeGenTableList = value
            End Set
        End Property

        Public ReadOnly Property HasForeignKeys() As Boolean Implements I_GenericCodeGenTable.HasForeignKeys
            Get
                Return False
            End Get
        End Property

#End Region

#Region "Methods"
        Public Sub New(ByRef DSSPECTRALSYSTEM As DataSet_Spectral_System, ByRef ParentClass As CodeGen_DS_Spectral_System)
            _DSSPECTRALSYSTEM = DSSPECTRALSYSTEM
            _DT = _DSSPECTRALSYSTEM.waveform
            _AlternativeView.Table = _DT
            _ParentClass = ParentClass
            Table_BindingSource.DataSource = DSSPECTRALSYSTEM.waveform.DefaultView
        End Sub

        Public Function AddRow() As Integer Implements I_GenericCodeGenNonSortableTable.AddRow
            Dim R As DataSet_Spectral_System.waveformRow = _DSSPECTRALSYSTEM.waveform.NewwaveformRow
            With R
                .waveform_id = GetNewwaveformID()
                If _DefaultRowValues.waveform_name IsNot Nothing Then .waveform_name = _DefaultRowValues.waveform_name
            End With
            _DSSPECTRALSYSTEM.waveform.AddwaveformRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.waveform_id
        End Function

        Public Function AddRow2(waveform_name As System.String) As Integer
            Dim R As DataSet_Spectral_System.waveformRow = _DSSPECTRALSYSTEM.waveform.NewwaveformRow
            With R
                .waveform_id = GetNewwaveformID()
                .waveform_name = waveform_name
            End With
            _DSSPECTRALSYSTEM.waveform.AddwaveformRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.waveform_id
        End Function

        Public Function AddRow3(waveform_id As System.Int32, waveform_name As System.String) As Integer
            Dim R As DataSet_Spectral_System.waveformRow = _DSSPECTRALSYSTEM.waveform.NewwaveformRow
            With R
                .waveform_id = waveform_id
                .waveform_name = waveform_name
            End With
            _DSSPECTRALSYSTEM.waveform.AddwaveformRow(R)
            RaiseEvent Event_NewRowAdded(R, Nothing)
            Return R.waveform_id
        End Function

        Public Function RowCount() As Integer Implements I_GenericCodeGenNonSortableTable.RowCount
            Dim RowSet As DataSet_Spectral_System.waveformRow() = _DSSPECTRALSYSTEM.waveform.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return 0
            Else
                Return RowSet.Count
            End If
        End Function

        Public Function GetFirstRowForPrimePK(PK_ID As Integer) As DataRow Implements I_GenericCodeGenNonSortableTable.GetFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.waveformRow() = _DSSPECTRALSYSTEM.waveform.Select("waveform_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function FindFirstByName(waveform_name As String) As DataSet_Spectral_System.waveformRow
            For Each r As DataSet_Spectral_System.waveformRow In DT.Rows
                If r.waveform_name = waveform_name Then Return r
            Next
            Return Nothing
        End Function

        Public Function GetRow(waveform_id As Integer) As DataSet_Spectral_System.waveformRow
            Return _DSSPECTRALSYSTEM.waveform.FindBywaveform_id(waveform_id)
        End Function

        Public Function GetFirst_id() As Integer
            Dim RowSet As DataSet_Spectral_System.waveformRow() = _DSSPECTRALSYSTEM.waveform.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return -1
            Else
                Return RowSet.First.waveform_id
            End If
        End Function

        Public Function GetFirstRow() As DataSet_Spectral_System.waveformRow
            Dim RowSet As DataSet_Spectral_System.waveformRow() = _DSSPECTRALSYSTEM.waveform.Select(Nothing, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Return Nothing
            Else
                Return RowSet.First
            End If
        End Function

        Public Function CurrentRowHasDataDependencies() As Boolean Implements I_GenericCodeGenNonSortableTable.CurrentRowHasDataDependencies
            Return _ParentClass.HasChildTableDataDependency("waveform", _CurrentRow.waveform_id)
        End Function

        Public Sub DeleteRow(waveform_id As Integer)
            Dim R As DataSet_Spectral_System.waveformRow = GetRow(waveform_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Public Sub DeleteCurrentRow() Implements I_GenericCodeGenNonSortableTable.DeleteCurrentRow
            Dim R As DataSet_Spectral_System.waveformRow = GetRow(CurrentRow.waveform_id)
            Dim e As New EventArgs_BeforeRowDelete
            RaiseEvent Event_BeforeRowDeleted(R, e)
            If R Is Nothing Or e.OkToDelete = False Then Exit Sub

            R.Delete()
        End Sub

        Friend Sub DeleteRows(FilterString As String)
            Dim RowsToDelete As DataSet_Spectral_System.waveformRow() = _DT.Select(FilterString, Nothing, DataViewRowState.CurrentRows)
            For Each R As DataSet_Spectral_System.waveformRow In RowsToDelete
                DeleteRow(R.waveform_id)
            Next
        End Sub

        Public Sub RefreshCurrentRowValuesFromDGV(ByRef DGV As DataGridView) Implements I_GenericCodeGenNonSortableTable.RefreshCurrentRowValues
            With _CurrentRow
                If DGV.CurrentRow Is Nothing Then
                    .RowIsEmpty = True
                Else
                    .RowIsEmpty = False
                    .RowIndex = DGV.CurrentRow.Index
                    .waveform_id = DGV.CurrentRow.Cells("waveform_id").Value
                    .waveform_name = DGV.CurrentRow.Cells("waveform_name").Value.ToString
                End If
            End With
        End Sub

        Public Sub SetCurrentRowToFirstRowForPrimePK(PK_ID As Integer) Implements I_GenericCodeGenNonSortableTable.SetCurrentRowToFirstRowForPrimePK
            Dim RowSet As DataSet_Spectral_System.waveformRow() = _DSSPECTRALSYSTEM.waveform.Select("waveform_id = " & PK_ID, Nothing, DataViewRowState.CurrentRows)
            If RowSet.Count = 0 Then
                Exit Sub
            Else
                With _CurrentRow
                    .RowIsEmpty = False
                    .RowIndex = 0
                    .waveform_id = RowSet.First.waveform_id
                    .waveform_name = RowSet.First.waveform_name
                End With
            End If
        End Sub

        Public Sub SetDefaultForeignKeyValue(KeyName As String, KeyValue As Integer) Implements I_GenericCodeGenTable.SetDefaultForeignKeyValue
            Select Case KeyName
            End Select
        End Sub

        Public Sub SetDefaultViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetDefaultViewFilter
            _DT.DefaultView.RowFilter = FilterString
        End Sub

        Public Sub SetAlternativeViewFilter(FilterString As String) Implements I_GenericCodeGenTable.SetAlternativeViewFilter
            _AlternativeView.RowFilter = FilterString
        End Sub

        Public Function GetTablePKCurrentValue() As Integer Implements I_GenericCodeGenTable.GetTablePKCurrentValue
            If _CurrentRow.RowIsEmpty = True Then
                Return -1
            Else
                Return _CurrentRow.waveform_id
            End If
        End Function

        Public Sub DecoupleTableBindings() Implements I_GenericCodeGenTable.DecoupleTableBindings
            Table_BindingSource.DataSource = Nothing
        End Sub

        Public Sub RecoupleTableBindings() Implements I_GenericCodeGenTable.RecoupleTableBindings
            Table_BindingSource.DataSource = DefaultView
        End Sub

#End Region

#Region "Private subs"
        Public Function GetNewwaveformID() As Integer
            Dim MaxID As Object = _DSSPECTRALSYSTEM.waveform.Compute("MAX(waveform_id)", Nothing)
            If IsDBNull(MaxID) = True Then
                Return 0
            Else
                Return CInt(MaxID) + 1
            End If
        End Function

#End Region

    End Class

#End Region

#End Region

End Class

#End Region



























































