﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Spectral1.PRESENTATION
{
    public partial class UC_Waveform : UserControl
    {
        Int32[] _waveform;
        float[] dashValues = { 2, 5, 2, 5 };
        Pen white_pen = new Pen(Color.White);
        Pen green_pen = new Pen(Color.LightGreen, 2);
        const float border = 5;
        PL_Main _plm;

        public UC_Waveform()
        {
            InitializeComponent();
        }

        public void Initialise(Int32[] waveform, PL_Main plm)
        {
            _plm = plm;
            _waveform = waveform;
            white_pen.DashPattern = dashValues;
            this.Refresh();
        }

        private void panel1_Paint(object sender, PaintEventArgs e)
        {
            //if (flag_wave_has_changed == false) { return; }
            if (_plm == null) { return; }
            if ((_plm.BL.DA.DASystem.flag_cloning_waveset == true) || (_plm.BL.DA.DASystem.flag_disable_waveform_update == true)) return;
            if ((_plm.BL.DA.DASystem.flag_initialising_system == true) || (_plm.BL.DA.DASystem.flag_suppress_patch_events == true) || (_waveform == null)) { return; }
            float graph_height = panel1.Height - border;
            float graph_width = panel1.Width - border;
            float x_step = ((graph_width - border - border) / 628);

            e.Graphics.DrawLine(white_pen, border, graph_height / 2, graph_width - border, graph_height / 2);
            e.Graphics.DrawLine(white_pen, border, border, border, graph_height);
            e.Graphics.DrawLine(white_pen, graph_width - border, border, graph_width - border, graph_height);
            e.Graphics.DrawLine(white_pen, graph_width / 2, border, graph_width / 2, graph_height);

            float x1;
            float y1;
            float x2;
            float y2;
            float max_amplitude = 0;
            for (int a_index = 0; a_index < 628; a_index++)
            {
                if ((float)(_waveform[a_index]) > max_amplitude) { max_amplitude = (float)(_waveform[a_index]); };
            }

            float scaling;
            if (max_amplitude == 0)
            {
                scaling = 1;
            }
            else
            {
                scaling = ((graph_height - border - border) / 2) / max_amplitude;
            }

            for (int a_index = 1; a_index < 628; a_index++)
            {
                x1 = border + (x_step * (a_index - 1));
                x2 = x1 + x_step;
                y1 = border + (graph_height / 2) - ((float)(_waveform[a_index - 1]) * scaling);
                y2 = border + (graph_height / 2) - ((float)(_waveform[a_index]) * scaling);
                e.Graphics.DrawLine(green_pen, x1, y1, x2, y2);
            }
        }
    }
}
