﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using static Spectral1_VBClassLibrary.DataSet_Spectral;
using Spectral1_VBClassLibrary;
using static Spectral1_VBClassLibrary.CodeGen_DS_Spectral;
using static Spectral1.PL_Main;
using static Spectral1.DATA_ACCESS.DA_Spectral;
using static Spectral1.BUSINESS_LOGIC.BL_KeyScaling;

namespace Spectral1.PRESENTATION
{
    public partial class UC_Envelope : UserControl
    {
        CodeGen_DS_Spectral _CGS;
        float[] dashValues = { 2, 5, 2, 5 };
        float[] dashValues2 = { 10, 5, 10, 5 };
        Pen white_pen = new Pen(Color.White);
        Pen dashed_white_pen = new Pen(Color.White);
        Pen double_dashed_yellow_pen = new Pen(Color.White,2);
        Pen amplitude_pen = new Pen(Color.LightGreen, 2);
        Pen tremolo_pen = new Pen(Color.Blue, 2);
        Pen vibrato_pen = new Pen(Color.Red, 2);
        Pen cutoff_level_pen = new Pen(Color.Yellow, 2);
        Pen noise_cutoff_level_pen = new Pen(Color.Gray, 2);
        Pen cutoff_lfo_pen = new Pen(Color.Orange, 2);
        Pen noise_pen = new Pen(Color.BlanchedAlmond, 2);
        Pen timbre_pen = new Pen(Color.Violet, 2);
        Pen sample_pen = new Pen(Color.Purple, 2);
        Pen pitch_pen = new Pen(Color.Brown, 2);
        SolidBrush white_brush = new SolidBrush(Color.White);
        SolidBrush black_brush = new SolidBrush(Color.Black);
        const Int32 left_border = 145;
        const Int32 right_border = 40;
        const Int32 bottom_border = 30;
        const Int32 top_border = 40;
        const Int32 legend_left = 10;

        float pixels_per_ms_X = 5;
        float graph_pixels_per_ms_X = 5;
        float graph_pixels_per_ms_Y = 5;
        bool _enabled = false;
        PL_Main _plm;

        public UC_Envelope()
        {
            InitializeComponent();
        }

        public void Initialise(PL_Main plm)
        {
            _plm = plm;
            _CGS = plm.BL.DA.CGS;
            dashed_white_pen.DashPattern = dashValues;
            double_dashed_yellow_pen.DashPattern = dashValues2;
            panel_graph.Width = 5000;
        }

        public void DisplayEnabled(bool isEnabled,bool DoARefresh)
        {
            _enabled = isEnabled;
            if (DoARefresh == true) { this.Refresh(); }
        }

        private string GetADSRSectionName(Int32 adsr_section_id)
        {
            string section_name = "";

            switch ((adsr_sections)adsr_section_id)
            {
                case adsr_sections.adsr_section_attack:
                    return "A";
                case adsr_sections.adsr_section_decay:
                    return "D";
                case adsr_sections.adsr_section_sustain:
                    return "S";
                case adsr_sections.adsr_section_release:
                    return "R";
            }

            return section_name;
        }

        private string GetEnvelopeName(Int32 envelope_id)
        {
            string envelope_name = "";

            switch ((envelope)envelope_id)
            {
                case envelope.env_amplitude:
                    return "Amplitude";
                case envelope.env_timbre_lfo:
                    return "Timbre lfo depth";
                case envelope.env_noise:
                    return "Noise gain";
                case envelope.env_tremolo:
                    return "Tremolo depth";
                case envelope.env_vibrato:
                    return "Vibrato depth";
                case envelope.env_timbre:
                    return "Timbre morph";
                case envelope.env_noise_cutoff_level:
                    return "Noise cut-off freq";
                case envelope.env_sample:
                    return "Sample gain";
                case envelope.env_pitch:
                    return "Pitch shift";
            }

            return envelope_name;
        }

        private bool EnvActive(Int32 patch_id,Int32 envelope_id)
        {
            for (Int32 a = 0; a < max_adsr_sections; a++)
            {
                if ((env_types)_CGS.Table_adsr_section_envelope_config.GetRow(patch_id, a, envelope_id).depth_env_type_id != env_types.env_type_none)
                { return true; }
            }
            return false;
        }

        private int log_of_65535_value(int input)
        {
            int result_value;
            result_value = (int)(Math.Log10(input + 1) * 13606.41);
            return result_value;
        }

        private void panel_graph_Paint(object sender, PaintEventArgs e)
        {
            if (_plm == null)
            {
                e.Graphics.Clear(Color.Black);
                return;
            }

            if (_CGS.Table_patch.CurrentRow.RowIsEmpty == true)
            {
                e.Graphics.Clear(Color.Black);
                return;
            }

            if ((_plm.BL.DA.DASystem.flag_initialising_system == true) || (_plm.BL.DA.DASystem.flag_suppress_patch_events == true) ||(_plm.BL.DA.DASystem.flag_executing_sdl_code == true) || (_enabled == false)|| (_CGS == null) )
            {
                e.Graphics.Clear(Color.Black);
                return;
            }


            const Int32 truncation_threshold_ms = 1000;
            bool[] adsr_section_truncation = new bool[max_adsr_sections];
            Int32[] truncated_end_time = new Int32[max_adsr_sections];
            Int32 total_end_time_ms = 0;
            Int32 end_time_ms;
            float temp_X = 0;
            Int32 patch_id = _plm.BL.BLPatch.current_patch.patch_id;
            Int32 adsr_section_id = _plm.BL.BLPatch.current_patch.current_adsr_section_id;
            Int32 adsr_section_envelope_config_id = _plm.BL.BLPatch.current_patch.current_adsr_section_envelope_config_id;
            float graph_height;
            float graph_width;
            Int32 legend_Y;
            Int32 for_note_id = _plm.envelope_note_for();
            String for_note_id_text = _plm.BL.DA.CGSS.Table_midi_note.DT.FindBymidi_note_id(for_note_id).midi_note_name;
            Int32 key_scale_split_note_id = _plm.BL.BLPatch.current_patch.key_scale_split_note_id;

            //Draw the midi note 
            e.Graphics.DrawString("Note: " + for_note_id_text, new Font("Arial",15, FontStyle.Bold), white_brush,new Point(5,5));

            //Draw horizontals
            for (Int32 a = 0; a < max_adsr_sections; a++)
            {
                if (_CGS.Table_adsr_section.GetRow(patch_id, a).flag_active == 1)
                {
                    adsr_sectionRow r = _CGS.Table_adsr_section.GetRow(patch_id, a);
                    Int32 et = key_scaled_end_time(key_scale_split_note_id,(ushort)r.end_time_ms,(short)r.end_time_ms_keyscale_upper, (short)r.end_time_ms_keyscale_lower,for_note_id);
                    if (et < 0) { et = 0; }
                    if ((et > truncation_threshold_ms)&&(a == Convert.ToInt32(adsr_sections.adsr_section_sustain)))
                    {
                        adsr_section_truncation[a] = true;
                        truncated_end_time[a] = truncation_threshold_ms;
                        end_time_ms = truncation_threshold_ms;
                    }
                    else
                    {
                        adsr_section_truncation[a] = false;
                        truncated_end_time[a] = et;
                        end_time_ms = et;
                    }
                    
                    total_end_time_ms += end_time_ms;
                }
            }
            pixels_per_ms_X = (float)(1.0 * (panel_graph.ClientRectangle.Width - left_border - right_border) / total_end_time_ms);

            graph_height = panel_graph.ClientRectangle.Height - (top_border + bottom_border);
            graph_width = (pixels_per_ms_X * total_end_time_ms);

            e.Graphics.DrawLine(dashed_white_pen, left_border, graph_height + top_border, left_border + graph_width, graph_height + top_border);
            e.Graphics.DrawLine(dashed_white_pen, left_border, top_border, left_border + graph_width, top_border);

            //Draw ADSR section verticals
            temp_X = 0;
            total_end_time_ms = 0;
            for (Int32 a = 0; a < max_adsr_sections; a++)
            {
                if (_CGS.Table_adsr_section.GetRow(patch_id, a).flag_active == 1)
                {
                    e.Graphics.DrawString(GetADSRSectionName(a), new Font("Segoe UI", 8, FontStyle.Bold | FontStyle.Italic), white_brush, left_border + temp_X + 3, top_border - 20);
                    e.Graphics.DrawString(total_end_time_ms.ToString() + "ms", new Font("Segoe UI", 8), white_brush, left_border + temp_X - 15, top_border + graph_height);
                    e.Graphics.DrawLine(dashed_white_pen, left_border + temp_X, top_border - 20, left_border + temp_X, graph_height + top_border);
                    temp_X += truncated_end_time[a] * pixels_per_ms_X;
                    total_end_time_ms += truncated_end_time[a];
                }
            }
            e.Graphics.DrawLine(dashed_white_pen, left_border + temp_X, top_border - 20, left_border + temp_X, graph_height + top_border);
            e.Graphics.DrawString(total_end_time_ms.ToString() + "ms", new Font("Segoe UI", 8), white_brush, left_border + temp_X - 15, top_border + graph_height);

            graph_pixels_per_ms_X = (float)(1.0 * graph_width / total_end_time_ms);
            graph_pixels_per_ms_Y = (float)(1.0 * graph_height / 65535);

            //Draw the envelopes
            Int32 total_elapsed_ms;
            Int32 section_elapsed_samples;
            Int32 env_value_usw = 0;
            Int32 env_target_level_usw;
            Int32 env_delta_sw;
            legend_Y = top_border;

            for (Int32 envelope_id = 0; envelope_id < max_envelopes; envelope_id++)
            {
                Point[] P = new Point[total_end_time_ms];
                total_elapsed_ms = 0;

                env_value_usw = Convert.ToInt32(_CGS.Table_envelope_control.GetRow(patch_id, envelope_id).depth_initial_level * 655.34);

                if (EnvActive(patch_id, envelope_id) == true)
                {
                    int event_32Sample_trigger_count = 0;
                    int event_1ms_trigger_count = 0;
                    int event_10ms_trigger_count = 0;
                    bool recalc_env_value;

                    for (Int32 a = 0; a < max_adsr_sections; a++)
                    {
                        adsr_sectionRow r = _CGS.Table_adsr_section.GetRow(patch_id, a);
                        if (r.flag_active == 1)
                        {
                            adsr_section_envelope_configRow cr = _CGS.Table_adsr_section_envelope_config.GetRow(patch_id, a, envelope_id);

                            env_target_level_usw = Convert.ToInt32(key_scaled_depth_env_target_usp0to100(key_scale_split_note_id,cr.depth_env_target,cr.depth_env_target_keyscale_upper,cr.depth_env_target_keyscale_lower,for_note_id) * 655.35);

                            for (section_elapsed_samples = 0; section_elapsed_samples < truncated_end_time[a] * samples_per_ms; section_elapsed_samples++)
                            {
                                if (event_32Sample_trigger_count == 32) { event_32Sample_trigger_count = 0; }
                                if (event_1ms_trigger_count == samples_per_ms) { event_1ms_trigger_count = 0; total_elapsed_ms++; }
                                if (event_10ms_trigger_count == samples_per_ms * 10) { event_10ms_trigger_count = 0; }

                                recalc_env_value = false;
                                if ((event_32Sample_trigger_count == 0) && (envelope_id == Convert.ToInt32(envelope.env_amplitude))) { recalc_env_value = true; }
                                if ((event_1ms_trigger_count == 0) && ((envelope_id == Convert.ToInt32(envelope.env_noise_cutoff_level)) || (envelope_id == Convert.ToInt32(envelope.env_noise)) || (envelope_id == Convert.ToInt32(envelope.env_sample)) || (envelope_id == Convert.ToInt32(envelope.env_pitch)))) { recalc_env_value = true; }
                                if ((event_10ms_trigger_count == 0) && ((envelope_id == Convert.ToInt32(envelope.env_tremolo)) || (envelope_id == Convert.ToInt32(envelope.env_timbre_lfo)) || (envelope_id == Convert.ToInt32(envelope.env_vibrato)) || (envelope_id == Convert.ToInt32(envelope.env_timbre)) )) { recalc_env_value = true; }

                                if (recalc_env_value == true)
                                {
                                    //=======THIS LOGIC MIRRORS DSP Chip (Tone Processor) ========================

                                    if (env_value_usw < env_target_level_usw)
                                    {
                                        switch ((env_types)cr.depth_env_type_id)
                                        {
                                            case env_types.env_type_linear:
                                                env_delta_sw = key_scaled_depth_env_lin_delta_usw(key_scale_split_note_id,cr.depth_env_lin_delta,cr.depth_env_lin_delta_keyscale_upper,cr.depth_env_lin_delta_keyscale_lower,for_note_id);
                                                break;
                                            case env_types.env_type_exponential:
                                                env_delta_sw = (Int32)(((env_target_level_usw - env_value_usw) * key_scaled_depth_env_exp_multiplier_usp0to100(key_scale_split_note_id,cr.depth_env_exp_multiplier,cr.depth_env_exp_multiplier_keyscale_upper,cr.depth_env_exp_multiplier_keyscale_lower,for_note_id)* 655.35/65535));
                                                break;
                                            default:
                                                env_delta_sw = 0;
                                                break;
                                        }
                                        if (env_value_usw > (env_target_level_usw - env_delta_sw))
                                        { env_value_usw = env_target_level_usw; }
                                        else
                                        { env_value_usw += env_delta_sw; }
                                    }
                                    else if (env_value_usw > env_target_level_usw)
                                    {
                                        switch ((env_types)cr.depth_env_type_id)
                                        {
                                            case env_types.env_type_linear:
                                                env_delta_sw =key_scaled_depth_env_lin_delta_usw(key_scale_split_note_id, cr.depth_env_lin_delta, cr.depth_env_lin_delta_keyscale_upper, cr.depth_env_lin_delta_keyscale_lower, for_note_id);
                                                break;
                                            case env_types.env_type_exponential:
                                                env_delta_sw = (Int32)(((env_value_usw - env_target_level_usw) * key_scaled_depth_env_exp_multiplier_usp0to100(key_scale_split_note_id, cr.depth_env_exp_multiplier, cr.depth_env_exp_multiplier_keyscale_upper, cr.depth_env_exp_multiplier_keyscale_lower, for_note_id) *655.35/ 65535));
                                                break;
                                            default:
                                                env_delta_sw = 0;
                                                break;
                                        }
                                        if (env_value_usw < env_delta_sw)
                                        { env_value_usw = 0; }
                                        else
                                        { env_value_usw -= env_delta_sw; }
                                    }
                                }

                                //============================================================================

                                P[total_elapsed_ms].X = left_border + Convert.ToInt32(1.0 * graph_pixels_per_ms_X * total_elapsed_ms);

                                if ( (envelope_id == Convert.ToInt32(envelope.env_vibrato)))
                                {
                                    P[total_elapsed_ms].Y = top_border + Convert.ToInt32(graph_pixels_per_ms_Y * (65535 - log_of_65535_value(env_value_usw)));
                                }
                                else
                                {
                                    P[total_elapsed_ms].Y = top_border + Convert.ToInt32(graph_pixels_per_ms_Y * (65535 - env_value_usw));
                                };
        
                                event_32Sample_trigger_count++;
                                event_1ms_trigger_count++;
                                event_10ms_trigger_count++;
                            }
                        }
                    }


                    if (P.GetLength(0) >1)
                    {
                        //Draw lines
                        switch ((envelope)envelope_id)
                        {
                            case envelope.env_amplitude:
                                e.Graphics.DrawLines(amplitude_pen, P);
                                e.Graphics.DrawLine(amplitude_pen, legend_left, legend_Y + 5, legend_left + 20, legend_Y + 5);
                                break;
                            case envelope.env_tremolo:
                                e.Graphics.DrawLines(tremolo_pen, P);
                                e.Graphics.DrawLine(tremolo_pen, legend_left, legend_Y + 5, legend_left + 20, legend_Y + 5);
                                break;
                            case envelope.env_vibrato:
                                e.Graphics.DrawLines(vibrato_pen, P);
                                e.Graphics.DrawLine(vibrato_pen, legend_left, legend_Y + 5, legend_left + 20, legend_Y + 5);
                                break;
                            case envelope.env_timbre_lfo:
                                e.Graphics.DrawLines(cutoff_lfo_pen, P);
                                e.Graphics.DrawLine(cutoff_lfo_pen, legend_left, legend_Y + 5, legend_left + 20, legend_Y + 5);
                                break;
                            case envelope.env_noise_cutoff_level:
                                e.Graphics.DrawLines(noise_cutoff_level_pen, P);
                                e.Graphics.DrawLine(noise_cutoff_level_pen, legend_left, legend_Y + 5, legend_left + 20, legend_Y + 5);
                                break;
                            case envelope.env_noise:
                                e.Graphics.DrawLines(noise_pen, P);
                                e.Graphics.DrawLine(noise_pen, legend_left, legend_Y + 5, legend_left + 20, legend_Y + 5);
                                break;
                            case envelope.env_timbre:
                                e.Graphics.DrawLines(timbre_pen, P);
                                e.Graphics.DrawLine(timbre_pen, legend_left, legend_Y + 5, legend_left + 20, legend_Y + 5);
                                break;
                            case envelope.env_sample:
                                e.Graphics.DrawLines(sample_pen, P);
                                e.Graphics.DrawLine(sample_pen, legend_left, legend_Y + 5, legend_left + 20, legend_Y + 5);
                                break;
                            case envelope.env_pitch:
                                e.Graphics.DrawLines(pitch_pen, P);
                                e.Graphics.DrawLine(pitch_pen, legend_left, legend_Y + 5, legend_left + 20, legend_Y + 5);
                                break;
                        }

                    }

                    //Draw symbol to mark any truncation
                    temp_X = 0;
                    for (Int32 a = 0; a < max_adsr_sections; a++)
                    {
                        if (_CGS.Table_adsr_section.GetRow(patch_id, a).flag_active == 1)
                        {  
                            if (adsr_section_truncation[a] == true)
                            {
                                float x = left_border + temp_X + (truncated_end_time[a] * pixels_per_ms_X) - 50;
                                float y = top_border - 20;
                                float width = 20;
                                float height = graph_height + bottom_border;
                                e.Graphics.FillRectangle(black_brush, x, y, width, height);
                                e.Graphics.DrawLine(double_dashed_yellow_pen, x + 10, y, x + 10, y + height);
                            }
                            temp_X += truncated_end_time[a] * pixels_per_ms_X;
                        }
                    }

                    //Draw legend entry
                    e.Graphics.DrawString(GetEnvelopeName(envelope_id), new Font("Segoe UI", 8), white_brush, legend_left + 25, legend_Y);

                    legend_Y += 20;

                }
            }
        }
    }
}
