﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using WarmBreeze_DataLibrary;
using static Spectral1_VBClassLibrary.DataSet_Spectral_System;
using static Spectral1_VBClassLibrary.DataSet_Spectral;
using static Spectral1.DATA_ACCESS.DA_Spectral;
using Spectral1.BUSINESS_LOGIC;

namespace Spectral1.PRESENTATION
{
    public partial class PL_UC_PatchSet : UserControl
    {
        #region "========================== DECLARATIONS ========================================"
        private PL_Main _plm;
        #endregion

        #region "========================== EVENTS ========================================"

        private bool patch_in_module_patches(Int32 patch_set_id, Int32 patch_id)
        {
            for (Int32 p = 0; p < patches_per_patchset; p++)
            {
                patch_set_patchesRow pspr = _plm.BL.DA.CGS.Table_patch_set_patches.GetRow(patch_set_id, p);
                if (pspr.patch_id == patch_id) { return true; }
            }

            return false;
        }

        private void button_SavePatchSet_Click(object sender, EventArgs e)
        {
            Int32 patch_set_id = _plm.BL.DA.CGS.Table_patch_set.CurrentRow.patch_set_id;


            //Check for patches that aren't to be loaded
            string error_text = "";
            for (Int32 performance_id = 0; performance_id < performances_per_patchset; performance_id++)
            {
                for (Int32 pcr_id = 0; pcr_id < max_midi_channels; pcr_id++)
                {
                    performance_channelRow pcr = _plm.BL.DA.CGS.Table_performance_channel.GetRow(patch_set_id, performance_id, pcr_id);
                    if (patch_in_module_patches(patch_set_id, pcr.patch_id) == false)
                    {
                        error_text +="PerformanceID" + performance_id.ToString() + " : Patch '" + _plm.BL.DA.CGS.Table_patch.GetRow(pcr.patch_id).patch_name + "' does not exist in the PatchSet patches" + "\r\n";
                    }
                }
            }
            if (error_text != "")
            {
                _plm.PLInfo.DisplayMinorError(error_text);
                return;
            }

            if (_plm.PLInfo.DisplayConfirm("Replace all current Patches in the module's memory with the Patches (and performances) defined in the selected PatchSet?") == false) { return; }

            _plm.Cursor = Cursors.WaitCursor;
            _plm.BL.DA.DASystem.flag_suppress_patch_events = true;

            if (_plm.BL.DA.CGS.Table_patch_set.CurrentRow.RowIsEmpty == true)
            {
                _plm.PLInfo.DisplayExclamation("You must define a PatchSet before you can save the Patches to the Module");
                if (_plm.BL.DA.DASystem.flag_saving_or_loading == false) { _plm.ClearStatus(); }
                return;
            }

            try
            {
                Int32 last_saved_patch_id = -1;

                _plm.BL.DA.DAUSBComms.send_to_module_stop_play_mode(); //new
                _plm.BL.DA.DAUSBComms.send_to_module_msg_default_banks();

                for (Int32 patch_set_patches_id = 0; patch_set_patches_id < patches_per_patchset; patch_set_patches_id++)
                {
                    Int32 patch_id = _plm.BL.DA.CGS.Table_patch_set_patches.GetRow(patch_set_id, patch_set_patches_id).patch_id;
                    _plm.SetStatus("Saving patch " + (patch_set_patches_id + 1).ToString() + " of " + patches_per_patchset.ToString() + " to Module");
                    if (patch_id != last_saved_patch_id)
                    {

                        double level_scaling = _plm.BL.BLWaveSet.current_waveform_set.current_block.current_waveform.CalcLevelScaling();
                        double filter_scaling_factor = _plm.BL.BLFilter.current_body_resonance_filter.GetFilterScalingFactor();
                        _plm.BL.DA.DAUSBComms.send_to_module_total_patch_config(patch_id,level_scaling,filter_scaling_factor);
                    }
                    last_saved_patch_id = patch_id;

                    _plm.BL.DA.DAUSBComms.send_to_module_save_patch_to_module(patch_set_patches_id);
                }

                for (Int32 performance_id = 0; performance_id < performances_per_patchset; performance_id++)
                {
                    _plm.BL.DA.DAUSBComms.send_to_module_performance(patch_set_id,performance_id);
                }
                _plm.BL.DA.DAUSBComms.send_to_module_relay_performances_to_mixer();

                _plm.PLInfo.DisplayInfo("PatchSet has been saved to module successfully");
            }
            catch (Exception ex)
            {
                _plm.PLInfo.DisplayMinorError("Error saving PatchSet : " + ex.Message);
            }
            finally
            {
                _plm.BL.DA.DAUSBComms.send_to_module_start_play_mode();
                _plm.BL.DA.DASystem.flag_suppress_patch_events = false;
                _plm.Cursor = Cursors.Default;
                _plm.ClearStatus();
            }

        }

        private void Table_patch_set_row_changed(object sender, EventArgs e)
        {

        }

        private void Table_patch_set_patches_row_changed(object sender, EventArgs e)
        {

        }


        private void Table_patch_set_row_added(object sender, EventArgs e)
        {
            Cursor entry_cursor = _plm.Cursor; _plm.Cursor = Cursors.WaitCursor; _plm.Refresh();
            _plm.BL.DA.DASystem.flag_suppress_patch_events = true;

            patch_setRow R = (patch_setRow)(sender);
            Int32 p = R.patch_set_id;
            for (Int32 psp = 0; psp < patches_per_patchset; psp++)
            {
                _plm.BL.DA.CGS.Table_patch_set_patches.DeleteRow(p, psp);//Ensure any existing row is deleted
                _plm.BL.DA.CGS.Table_patch_set_patches.AddRow3(p, psp, 0);
            }

            for (Int32 psp = 0; psp < performances_per_patchset; psp++)
            {
                _plm.BL.DA.CGS.Table_performance.DeleteRow(p, psp);//Ensure any existing row is deleted
                _plm.BL.DA.CGS.Table_performance.AddRow3(p, psp, BL_DGV.default_text, max_haas_delay);
            }

            _plm.BL.DA.DASystem.flag_suppress_patch_events = false;
            _plm.RefreshUI();
            _plm.Cursor = entry_cursor;

            InitForPatchSet();
            RefreshUI();
        }

        private void pL_UC_AddDeleteDGV_PatchSet_EVENT_RowDeleted(object sender, EventArgs e)
        {
            if (_plm.BL.DA.DASystem.flag_importing_exporting == true) { return; }
            _plm.BL.DA.CGS.Table_performance_processor.DT.Clear(); //***
            _plm.BL.DA.CGS.Table_performance_processor.DT.AcceptChanges();

            InitForPatchSet();
            RefreshUI();
        }

        private void pL_UC_AddDeleteDGV_PatchSet_EVENT_BeforeRowDeleted(object sender, EventArgs e)
        {
            Int32 p = _plm.BL.DA.CGS.Table_patch_set.CurrentRow.patch_set_id;
            for (Int32 psp = 0; psp < patches_per_patchset; psp++)
            {
                _plm.BL.DA.CGS.Table_patch_set_patches.GetRow(p, psp).Delete();
            }

            for (Int32 psp = 0; psp < performances_per_patchset; psp++)
            {
                _plm.BL.DA.CGS.Table_performance.GetRow(p, psp).Delete();
            }

            RefreshUI();
        }

        private void pL_UC_AddDeleteDGV_PatchSet_EVENT_DGVSelectionChanged(object sender, EventArgs e)
        {
            InitForPatchSet();
            RefreshUI();
        }

        //private void pL_UC_AddDeleteOrderDGV_PAtchSetPatches_EVENT_DGVSelectionChanged(object sender, EventArgs e)
        //{
        //    if ((_plm.flag_suppress_patch_events == true) || (_plm.BL.DA.CGS.Table_patch_set_patches.CurrentRow.RowIsEmpty == true)) { return; }

        //    _plm.Cursor = Cursors.WaitCursor;
        //    _plm.SetStatus("Loading Patch on Module");
        //    Int32 module_patch_id = _plm.BL.DA.CGS.Table_patch_set_patches.CurrentRow.patch_set_patches_id;
        //    _plm.BL.DAC.load_patch(module_patch_id);
        //    if (_plm.flag_saving_or_loading == false) { _plm.ClearStatus(); }
        //    _plm.Cursor = Cursors.Default;
        //}

        #endregion

        #region "========================== METHODS ========================================"
        private void InitForPatchSet()
        {
            _plm.BL.DA.CGS.Table_patch_set_patches.SetDefaultViewFilter("patch_set_id = " + _plm.BL.DA.CGS.Table_patch_set.CurrentRow.patch_set_id);
            _plm.BL.DA.CGS.Table_performance.SetDefaultViewFilter("patch_set_id = " + _plm.BL.DA.CGS.Table_patch_set.CurrentRow.patch_set_id);
        }
        #endregion

        public PL_UC_PatchSet()
        {
            InitializeComponent();
        }

        public void Initialise(PL_Main plm)
        {
            _plm = plm;

            //Patch Set
            _plm.BL.BLDGV.InitialisePatchSetDGV(ref pL_UC_AddDeleteDGV_PatchSet);
            _plm.BL.DA.CGS.Table_patch_set.DT.RowChanged += Table_patch_set_row_changed;
            _plm.BL.DA.CGS.Table_patch_set.Event_NewRowAdded += Table_patch_set_row_added;

            //PatchSet patches
            _plm.BL.BLDGV.InitialisePatchSetPatchesDGV(ref pL_UC_AddDeleteOrderDGV_PAtchSetPatches);
            _plm.BL.DA.CGS.Table_patch_set_patches.DT.RowChanged += Table_patch_set_patches_row_changed;

            //Performance
            pL_UC_Performance1.Initialise(_plm);

            //MIDI Settings
            _plm.BL.BLDGV.InitialiseSystemSettingsDGV(ref pL_UC_AddDeleteDGV_MIDI_Settings);

            RefreshUI();
        }

        public void SetIsConnectedInAnotherThread(bool IsConnected)
        {
            if (this.InvokeRequired)
            {
                this.Invoke((Action)(() => { 
                    button_SavePatchSet.Enabled = IsConnected;
                }));
            }
        }

        public void RefreshUI()
        {
            this.Visible = (_plm.BL.DA.CGS.Table_patch.CurrentRow.RowIsEmpty == false);

            if (_plm.BL.DA.CGS.Table_patch_set.RowCount() > 0)
            {
                tabControl1.Visible = true;
                label_ps.Visible = true;
                pL_UC_AddDeleteOrderDGV_PAtchSetPatches.Visible = true;
                button_SavePatchSet.Visible = true;
            }
            else
            {
                tabControl1.Visible = false;
                label_ps.Visible = false;
                pL_UC_AddDeleteOrderDGV_PAtchSetPatches.Visible = false;
                button_SavePatchSet.Visible = false;
            }

            pL_UC_Performance1.RefreshUI();

            button_SavePatchSet.Enabled = _plm.BL.DA.DAUSBComms.IsConnected();

            //PatchSetPatches
            pL_UC_AddDeleteOrderDGV_PAtchSetPatches.Enabled = (_plm.BL.DA.CGS.Table_patch.RowCount() > 0 && (_plm.BL.DA.CGS.Table_patch_set.RowCount() > 0));

        }


    }
}
