﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Spectral1.PRESENTATION
{
    public partial class PL_AppSettings : Form
    {
        public PL_AppSettings()
        {
            InitializeComponent();
            numericUpDown_default_patch_bank.Value = Properties.Settings.Default.default_patch_bank;
            numericUpDown_default_performance_bank.Value = Properties.Settings.Default.default_performance_bank;
            textBox_presets_path.Text = Properties.Settings.Default.presets_path;
        }

        private void button_close_Click(object sender, EventArgs e)
        {
            Properties.Settings.Default.default_patch_bank = Convert.ToInt16(numericUpDown_default_patch_bank.Value);
            Properties.Settings.Default.default_performance_bank = Convert.ToInt16(numericUpDown_default_performance_bank.Value);
            Properties.Settings.Default.Save();
            this.Close();
        }

        private void button_set_presets_path_Click(object sender, EventArgs e)
        {
            using (var fbd = new FolderBrowserDialog())
            {
                fbd.Description = "Set the folder where you store the preset SDL text files";
                //fbd.RootFolder = Environment.SpecialFolder.MyDocuments;
                fbd.ShowNewFolderButton = true;
                //fbd.
                DialogResult result = fbd.ShowDialog();

                if (result == DialogResult.OK && !string.IsNullOrWhiteSpace(fbd.SelectedPath))
                {
                    Properties.Settings.Default.presets_path = fbd.SelectedPath;
                    textBox_presets_path.Text = Properties.Settings.Default.presets_path;
                }
            }
        }
    }
}
