﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static Spectral1.PARSER.c_dsl_functions;
using static Spectral1.PARSER.c_lexer;

namespace Spectral1.PARSER
{
    public partial class c_parser
    {
        #region "==================== METHODS - PRIVATE =========================="
      
        private void WaveSetFunction()
        {
            //WaveSetFunction -> waveset Dot MorphAcrossNoteSectors|MorphAcrossIntensityLayers|SetCurrentIntensityLayer|SetCurrentNoteSector
            DiscardToken(TokenType.WaveSet);
            DiscardToken(TokenType.Dot);
            if (is_waveset_function_token(_lookaheadFirst))
            {
                switch (_lookaheadFirst.TokenType)
                {
                    case TokenType.MorphAcrossNoteSectors:
                        wsd_wsf_MorphAcrossNoteSectors(); break;
                    case TokenType.MorphAcrossIntensityLayers:
                        wsd_wsf_MorphAcrossIntensityLayers(); break;
                    case TokenType.SetCurrentIntensityLayer:
                        wsd_wsf_SetCurrentIntensityLayer(); break;
                    case TokenType.SetCurrentNoteSector:
                        wsd_wsf_SetCurrentNoteSector(); break;
                }
            }
            else
            {
                throw new c_dsl_exception(ExpectedWaveSetDefinitionObjectErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private void wsd_wsf_MorphAcrossNoteSectors()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.MorphAcrossNoteSectors);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.NoteSectorFrom);
            DiscardToken(TokenType.Colon);
            p.Add(GetNoteSectorIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.NoteSectorTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetNoteSectorIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.WaveSet, functions.W_WS_MorphAcrossNoteSectors, p, _lookaheadFirst.start_position);
        }

        private void wsd_wsf_MorphAcrossIntensityLayers()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.MorphAcrossIntensityLayers);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.IntensityLayerFrom);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntensityLayerIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.IntensityLayerTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntensityLayerIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.WaveSet, functions.W_WS_MorphAcrossIntensityLayers, p, _lookaheadFirst.start_position);
        }

        private void wsd_wsf_SetCurrentIntensityLayer()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetCurrentIntensityLayer);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.IntensityLayer);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntensityLayerIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.WaveSet, functions.W_WS_SetCurrentIntensityLayer, p, _lookaheadFirst.start_position);
        }

        private void wsd_wsf_SetCurrentNoteSector()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetCurrentNoteSector);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.NoteSector);
            DiscardToken(TokenType.Colon);
            p.Add(GetNoteSectorIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.WaveSet, functions.W_WS_SetCurrentNoteSector, p, _lookaheadFirst.start_position);
        }

        #endregion

    }
}
