﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static Spectral1.PARSER.c_dsl_functions;
using static Spectral1.PARSER.c_lexer;

namespace Spectral1.PARSER
{
    public partial class c_parser
    {
        #region "==================== METHODS - PRIVATE =========================="
        private void NoteSectorFunction()
        {
            DiscardToken(TokenType.CurrentNoteSector);
            DiscardToken(TokenType.Dot);
            if (is_note_sector_function_token(_lookaheadFirst))
            {
                switch (_lookaheadFirst.TokenType)
                {
                    case TokenType.CopyTo:
                        wsd_nsf_CopyTo(); break;
                    case TokenType.CopyToRange:
                        wsd_nsf_CopyToRange(); break;
                    case TokenType.MorphWaveformBlocks:
                        wsd_nsf_MorphWaveformBlocks(); break;
                    case TokenType.MorphWaveforms:
                        wsd_nsf_MorphWaveforms(); break;
                }
            }
            else
            {
                throw new c_dsl_exception(ExpectedNoteSectorFunctionErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private void wsd_nsf_CopyTo()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.CopyTo);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.NoteSectorTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetNoteSectorIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentNoteSector, functions.W_NS_CopyTo, p, _lookaheadFirst.start_position);
        }

        private void wsd_nsf_CopyToRange()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.CopyToRange);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.NoteSectorFrom);
            DiscardToken(TokenType.Colon);
            p.Add(GetNoteSectorIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.NoteSectorTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetNoteSectorIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentNoteSector, functions.W_NS_CopyToRange, p, _lookaheadFirst.start_position);
        }

        private void wsd_nsf_MorphWaveformBlocks()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.MorphWaveformBlocks);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.IntensityLayerFrom);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntensityLayerIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.IntensityLayerTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntensityLayerIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentNoteSector, functions.W_NS_MorphWaveformBlocks, p, _lookaheadFirst.start_position);
        }

        private void wsd_nsf_MorphWaveforms()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.MorphWaveforms);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.IntensityLayerFrom);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntensityLayerIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.IntensityLayerTo);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntensityLayerIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.Waveform);
            DiscardToken(TokenType.Colon);
            p.Add(GetWaveFormIDValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.WaveSet, target_objects.CurrentNoteSector, functions.W_NS_MorphWaveforms, p, _lookaheadFirst.start_position);
        }
        #endregion



    }
}
