﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static Spectral1.PARSER.c_dsl_functions;
using static Spectral1.PARSER.c_lexer;

namespace Spectral1.PARSER
{
    public partial class c_parser
    {
        #region "==================== METHODS - PRIVATE =========================="

        private void PatchGeneralFunction()
        {
            DiscardToken(TokenType.General);
            DiscardToken(TokenType.Dot);
            if (is_patch_general_function_token(_lookaheadFirst))
            {
                switch (_lookaheadFirst.TokenType)
                {
                    case TokenType.SetPortamento:
                        pd_general_SetPortamento(); break;
                    case TokenType.SetScalingSplit:
                        pd_general_SetScalingSplit(); break;
                    case TokenType.SetPatchGain:
                        pd_general_SetPatchGain(); break;
                    case TokenType.SetDetuning:
                        pd_general_SetDetuning(); break;
                    case TokenType.SetActiveOscillators:
                        pd_general_SetActiveOscillators(); break;
                    case TokenType.SetDetuningMode:
                        pd_general_SetDetuningMode(); break;
                    case TokenType.SetOscillatorDetuning:
                        pd_general_SetOscillatorDetuning(); break;
                    case TokenType.SetLFO:
                        pd_general_SetLFO(); break;
                    case TokenType.SetEnvelopeGainController:
                        pd_general_SetEnvelopeGainController(); break;
                }
            }
            else
            {
                throw new c_dsl_exception(ExpectedPatchGeneralFunctionErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private void pd_general_SetPortamento()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetPortamento);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.Enabled);
            DiscardToken(TokenType.Colon);
            p.Add(GetEnabledValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.PortamentoAmount);
            DiscardToken(TokenType.Colon);
            p.Add(GetPercentValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.Patch, target_objects.General, functions.P_GEN_SetPortamento, p, _lookaheadFirst.start_position);
        }

        private void pd_general_SetScalingSplit()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetScalingSplit);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.Note);
            DiscardToken(TokenType.Colon);
            p.Add(GetNoteName(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.Patch, target_objects.General, functions.P_GEN_SetScalingSplit, p, _lookaheadFirst.start_position);
        }

        private void pd_general_SetPatchGain()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetPatchGain);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.Gain);
            DiscardToken(TokenType.Colon);
            p.Add(GetPercentValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.Patch, target_objects.General, functions.P_GEN_SetPatchGain, p, _lookaheadFirst.start_position);
        }

        private void pd_general_SetDetuning()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetDetuning);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.DetuningType);
            DiscardToken(TokenType.Colon);
            p.Add(GetPatchDetuningType(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.Detuning);
            DiscardToken(TokenType.Colon);
            p.Add(GetPercentValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.Patch, target_objects.General, functions.P_GEN_SetDetuning, p, _lookaheadFirst.start_position);
        }

        private void pd_general_SetActiveOscillators()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetActiveOscillators);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.OscillatorCount);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntegerValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.Patch, target_objects.General, functions.P_GEN_SetActiveOscillators, p, _lookaheadFirst.start_position);
        }

        private void pd_general_SetDetuningMode()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetDetuningMode);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.DetuningMode);
            DiscardToken(TokenType.Colon);
            p.Add(GetPatchDetuningMode(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.Patch, target_objects.General, functions.P_GEN_SetDetuningMode, p, _lookaheadFirst.start_position);
        }

        private void pd_general_SetOscillatorDetuning()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetOscillatorDetuning);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.Oscillator);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntegerValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);
            DiscardToken(TokenType.Detuning);
            DiscardToken(TokenType.Colon);
            p.Add(GetDecimalValue(_lookaheadFirst));
            DiscardToken();

            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.Patch, target_objects.General, functions.P_GEN_SetOscillatorDetuning, p, _lookaheadFirst.start_position);
        }

        private void pd_general_SetLFO()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetLFO);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.LFOType);
            DiscardToken(TokenType.Colon);
            p.Add(GetPatchLFOType(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.Enabled);
            DiscardToken(TokenType.Colon);
            p.Add(GetEnabledValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.WaveType);
            DiscardToken(TokenType.Colon);
            p.Add(GetWaveFormShapeTypeValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.Frequency);
            DiscardToken(TokenType.Colon);
            p.Add(GetDecimalValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.FrequencyCC);
            DiscardToken(TokenType.Colon);
            p.Add(GetPatchCCName(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.DepthCC);
            DiscardToken(TokenType.Colon);
            p.Add(GetPatchCCName(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.CloseParenthesis);


            list_of_functions.add(definition_objects.Patch, target_objects.General, functions.P_GEN_SetLFO, p, _lookaheadFirst.start_position);
        }

        private void pd_general_SetEnvelopeGainController()
        {
            List<String> p = new List<String>();

            DiscardToken(TokenType.SetEnvelopeGainController);
            DiscardToken(TokenType.OpenParenthesis);
            DiscardToken(TokenType.Envelope);
            DiscardToken(TokenType.Colon);
            p.Add(GetPatchEnvelopeName(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.InitialLevel);
            DiscardToken(TokenType.Colon);
            p.Add(GetIntegerValue(_lookaheadFirst));
            DiscardToken();
            DiscardToken(TokenType.Comma);

            DiscardToken(TokenType.GainCC);
            DiscardToken(TokenType.Colon);
            p.Add(GetPatchCCName(_lookaheadFirst));
            DiscardToken();

            DiscardToken(TokenType.CloseParenthesis);

            list_of_functions.add(definition_objects.Patch, target_objects.General, functions.P_GEN_SetEnvelopeGainControllero, p, _lookaheadFirst.start_position);
        }

        #endregion

    }
}
