﻿using Spectral1.DATA_ACCESS;
using System;
using static Spectral1.PARSER.c_lexer;

namespace Spectral1.PARSER
{
    public partial class c_parser
    {
        #region "========================= DECLARATIONS ======================================"
        public string ExpectedPatchDefinitionObjectErrorText = "Expecting a Patch definition object but found ";
        public string ExpectedPatchFunctionErrorText = "Expecting a Patch function name but found ";
        public string ExpectedPatchGeneralFunctionErrorText = "Expecting a general function name but found ";
        public string ExpectedPatchADSRFunctionErrorText = "Expecting an ADSR function name but found ";

        public string InvalidNoteErrorText = "Invalid Note value  ";
        public string InvalidDetuningTypeErrorText = "Invalid Detuning Type value  ";
        public string InvalidDetuningModeErrorText = "Invalid Detuning Mode value  ";
        public string InvalidLFOTypeErrorText = "Invalid LFO Type value  ";
        public string InvalidCCNameErrorText = "Invalid Continuous Controller Name value  ";
        public string InvalidADSRSectionNameErrorText = "Invalid ADSR Section Name value  ";
        public string InvalidADSRPresetNameErrorText = "Invalid ADSR Preset Name value  ";
        public string InvalidSampleNameErrorText = "Invalid Sample Name value  ";
        public string InvalidSampleModeErrorText = "Invalid Sample Mode value  ";
        public string InvalidEnvelopeNameErrorText = "Invalid Envelope Name value  ";
        public string InvalidEnvelopeTypeErrorText = "Invalid Envelope Type value  ";

        #endregion

        #region "==================== METHODS - PATCH GET TOKEN =============================="

        private string GetNoteName(c_lexer_token token)
        {
            if (is_note_name_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidNoteErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetPatchDetuningType(c_lexer_token token)
        {
            if (is_detuning_type_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidDetuningTypeErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetPatchDetuningMode(c_lexer_token token)
        {
            if (is_detuning_mode_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidDetuningModeErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetPatchLFOType(c_lexer_token token)
        {
            if (is_lfo_type_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidLFOTypeErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetPatchCCName(c_lexer_token token)
        {
            if (is_CC_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidCCNameErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetPatchADSRSectionName(c_lexer_token token)
        {
            if (is_adsr_section_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidADSRSectionNameErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetPatchADSRPresetName(c_lexer_token token)
        {
            if (is_adsr_preset_name_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidADSRPresetNameErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetPatchSampleName(c_lexer_token token)
        {
            if (is_sample_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidSampleNameErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetPatchSampleMode(c_lexer_token token)
        {
            if (is_sample_mode_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidSampleModeErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetPatchEnvelopeName(c_lexer_token token)
        {
            if (is_envelope_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidEnvelopeNameErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }

        private string GetPatchEnvelopeType(c_lexer_token token)
        {
            if (is_envelope_type_token(token))
            { return token.Value; }
            else
            {
                throw new c_dsl_exception(InvalidEnvelopeTypeErrorText + "'" + _lookaheadFirst.Value + "'");
            }
        }
        #endregion

        #region "=============================== METHODS - AUTO-GENERATE ========================="
        public string generate_code_for_current_patch(ref PL_Main plm,PL_UC_SpectralParser patch_parser)
        {
            string error_text = "";

            try
            {
                int patch_id = plm.BL.BLPatch.current_patch.patch_id;

                patch_parser.add_code_comment("===== GENERAL : Misc ==========");
                string OscillatorCount = plm.BL.BLPatch.current_patch.get_string_patch_active_layers();
                patch_parser.add_code_p_g_SetActiveOscillators(OscillatorCount);

                string Detuning = plm.BL.BLPatch.current_patch.get_string_patch_random_detuning();
                patch_parser.add_code_p_g_SetDetuning("Random", Detuning);
                Detuning = plm.BL.BLPatch.current_patch.get_string_patch_regular_detuning();
                patch_parser.add_code_p_g_SetDetuning("Regular", Detuning);

                string DetuningModeName = plm.BL.BLPatch.current_patch.get_string_patch_detuning_mode();
                patch_parser.add_code_p_g_SetDetuningMode(DetuningModeName);

                string Enabled = plm.BL.BLPatch.current_patch.get_string_patch_portamento_enabled();
                string Percent = plm.BL.BLPatch.current_patch.get_string_patch_portamento_rate();
                patch_parser.add_code_p_g_SetPortamento(Enabled, Percent);

                string NoteName = plm.BL.BLPatch.current_patch.get_string_patch_keyscale_split_note_name();
                patch_parser.add_code_p_g_SetScalingSplit(NoteName);

                patch_parser.add_blank_line();
                patch_parser.add_code_comment("===== GENERAL : Detuning ==========");
                for (int i = 0; i < DA_Spectral.max_oscillators; i++)
                {
                    switch (i)
                    {
                        case 0:
                            Detuning = plm.BL.BLPatch.current_patch.get_string_patch_layer0_detune();
                            break;
                        case 1:
                            Detuning = plm.BL.BLPatch.current_patch.get_string_patch_layer1_detune();
                            break;
                        case 2:
                            Detuning = plm.BL.BLPatch.current_patch.get_string_patch_layer2_detune();
                            break;
                    }

                    patch_parser.add_code_p_g_SetOscillatorDetuning(i.ToString(), Detuning);
                }

                patch_parser.add_blank_line();
                patch_parser.add_code_comment("===== GENERAL : Envelope control ==========");
                for (int e = 0; e < DA_Spectral.max_envelopes; e++)
                {
                    if (e != Convert.ToInt32(DA_Spectral.envelope.env_portamento))
                    {
                        string EnvType = plm.BL.BLPatch.current_patch.get_string_envelope_control_envelope_type(patch_id, e);
                        string InitialLevel = plm.BL.BLPatch.current_patch.get_string_envelope_control_initial_level(patch_id, e);
                        string GainCC = plm.BL.BLPatch.current_patch.get_string_envelope_control_gain_cc_source(patch_id, e);
                        patch_parser.add_code_p_g_SetEnvelopeGainControllero(EnvType, InitialLevel, GainCC);
                    }
                }

                patch_parser.add_blank_line();
                patch_parser.add_code_comment("===== GENERAL : LFOs ==========");
                for (int i = 0; i < DA_Spectral.max_lfos; i++)
                {
                    string LFOType = plm.BL.BLPatch.current_patch.get_string_lfo_type(patch_id, i);
                    string LFOEnabled = plm.BL.BLPatch.current_patch.get_string_lfo_enabled(patch_id, i);
                    string WaveType = plm.BL.BLPatch.current_patch.get_string_lfo_wave_type(patch_id, i);
                    string Frequency = plm.BL.BLPatch.current_patch.get_string_lfo_frequency(patch_id, i);
                    string FrequencyCC = plm.BL.BLPatch.current_patch.get_string_lfo_freq_cc_source(patch_id, i);
                    string DepthCC = plm.BL.BLPatch.current_patch.get_string_lfo_depth_cc_source(patch_id, i);
                    patch_parser.add_code_p_g_SetLFO(LFOType, LFOEnabled, WaveType, Frequency, FrequencyCC, DepthCC);
                }

                patch_parser.add_blank_line();
                patch_parser.add_code_comment("===== ADSR SECTIONS ==========");
                for (int i = 0; i < DA_Spectral.max_adsr_sections; i++)
                {
                    string Section = plm.BL.BLPatch.current_patch.get_string_adsr_section_name(patch_id,i);
                    string SectionEnabled = plm.BL.BLPatch.current_patch.get_string_adsr_section_active(patch_id, i);
                    string Duration = plm.BL.BLPatch.current_patch.get_string_adsr_section_end_time_ms(patch_id, i);
                    string EndKSU = plm.BL.BLPatch.current_patch.get_string_adsr_section_end_KSU(patch_id, i);
                    string EndKSL = plm.BL.BLPatch.current_patch.get_string_adsr_section_end_KSL(patch_id, i);
                    string Sample = plm.BL.BLPatch.current_patch.get_string_adsr_section_sample_name(patch_id, i);
                    string SampleMode = plm.BL.BLPatch.current_patch.get_string_adsr_section_sample_mode(patch_id, i);
                    patch_parser.add_code_p_a_ConfigureSection(Section, Enabled, Duration, EndKSU, EndKSL, Sample, SampleMode);
                }

                for (int adsr_section_id = 0; adsr_section_id < DA_Spectral.max_adsr_sections; adsr_section_id++)
                {
                    string Section = plm.BL.BLPatch.current_patch.get_string_adsr_section_name(patch_id, adsr_section_id);
                    patch_parser.add_blank_line();
                    patch_parser.add_code_comment("----- ENVELOPES : for ADSR section '"+ Section + "' ----------");
                    for (int adsr_section_envelope_config_id = 0; adsr_section_envelope_config_id < DA_Spectral.max_envelopes; adsr_section_envelope_config_id++)
                    {
                        if (adsr_section_envelope_config_id != Convert.ToInt32(DA_Spectral.envelope.env_portamento))
                        {
                            patch_parser.add_code_p_a_ConfigureEnvelope_DERIVED(patch_id, adsr_section_id, adsr_section_envelope_config_id);

                        }
                    }
                }

            }
            catch (Exception ex)
            {
                error_text = "Error generating code :" + ex.Message;
            }

            return error_text;
        }
        
        #endregion

        #region "==================== METHODS - OTHER =========================="
        private void PatchDefinition()
        {
            DiscardToken(TokenType.Patch);
            DiscardToken(TokenType.OpenCurlyParenthesis);
            while (_lookaheadFirst.TokenType != TokenType.CloseCurlyParenthesis)
            {
                PatchDefinitionItem();
            }
            DiscardToken(TokenType.CloseCurlyParenthesis);
        }

        private void PatchDefinitionItem()
        {
            if (is_patch_definition_object_token(_lookaheadFirst))
            {
                switch (_lookaheadFirst.TokenType)
                {
                    case TokenType.General:
                        PatchGeneralFunction(); break;
                    case TokenType.ADSR:
                        PatchADSRFunction(); 
                        break;
                }
            }
            else
            {
                throw new c_dsl_exception(ExpectedPatchFunctionErrorText + "'" + _lookaheadFirst.Value + "'");
            }
            DiscardToken(TokenType.SemiColon);
        }
        #endregion

    }
}
