﻿using Spectral1.DATA_ACCESS;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Spectral1.PARSER
{
    public partial class c_lexer
    {
        #region "====================== METHODS - WAVESET TOKEN LOGIC ============================"

        public static bool is_waveset_definition_object_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.WaveSet
                   || token.TokenType == TokenType.CurrentIntensityLayer
                   || token.TokenType == TokenType.CurrentNoteSector
                   || token.TokenType == TokenType.CurrentWaveformBlock
                   || token.TokenType == TokenType.CurrentWaveform;
        }


        public static bool is_waveset_function_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.MorphAcrossNoteSectors
                   || token.TokenType == TokenType.MorphAcrossIntensityLayers
                   || token.TokenType == TokenType.SetCurrentIntensityLayer
                   || token.TokenType == TokenType.SetCurrentNoteSector;
        }

        public static bool is_intensity_layer_function_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.CopyTo
                   || token.TokenType == TokenType.CopyToRange
                   || token.TokenType == TokenType.ShapeTheHarmonics
                   || token.TokenType == TokenType.MorphWaveformBlocks
                   || token.TokenType == TokenType.MorphWaveforms;
        }

        public static bool is_note_sector_function_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.CopyTo
                   || token.TokenType == TokenType.CopyToRange
                   || token.TokenType == TokenType.MorphWaveformBlocks
                   || token.TokenType == TokenType.MorphWaveforms;
        }

        public static bool is_waveform_block_function_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.SetCurrentWaveform
                   || token.TokenType == TokenType.MorphWaveforms
                   || token.TokenType == TokenType.CopyTo
                   || token.TokenType == TokenType.CopyAcrossNoteSectors
                   || token.TokenType == TokenType.CopyAcrossIntensityLayers
                   || token.TokenType == TokenType.CopyAcrossAllDimensions;
        }

        public static bool is_waveform_function_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.CopyTo
                    || token.TokenType == TokenType.CopyToRange
                    || token.TokenType == TokenType.CopyAcrossNoteSectors
                    || token.TokenType == TokenType.CopyAcrossIntensityLayers
                    || token.TokenType == TokenType.CopyAcrossAllDimensions
                    || token.TokenType == TokenType.SetName

                    || token.TokenType == TokenType.SetHarmonicLevels
                    || token.TokenType == TokenType.SetHarmonicLevelsFromCSV
                    || token.TokenType == TokenType.SetHarmonicLevelsFromLevelShapeType
                    || token.TokenType == TokenType.SetHarmonicLevelsFromInstrumentType
                    || token.TokenType == TokenType.SetHarmonicLevelsFromWaveFormShape
                    || token.TokenType == TokenType.SetHarmonicLevel
                    || token.TokenType == TokenType.MorphHarmonicLevels
                    || token.TokenType == TokenType.SetHarmonicPhases
                    || token.TokenType == TokenType.SetHarmonicPhasesFromCSV
                    || token.TokenType == TokenType.SetHarmonicPhasesFromPhaseShapeType
                    || token.TokenType == TokenType.SetHarmonicPhasesFromInstrumentType
                    || token.TokenType == TokenType.SetHarmonicPhasesFromWaveFormShape
                    || token.TokenType == TokenType.SetHarmonicPhase;
        }

        public static bool is_intensity_layer_range_token(c_lexer_token token)
        {
            bool result = token.TokenType == TokenType.All || token.TokenType == TokenType.Integer;
            if (result)
            {
                return ((Convert.ToInt32(token.Value) >= 0) && (Convert.ToInt32(token.Value) <= DA_Spectral.max_intensity_layers));
            }
            else
            { return false; }
        }

        public static bool is_intensity_layer_id_token(c_lexer_token token)
        {
            if (token.TokenType == TokenType.Integer)
            {
                return ((Convert.ToInt32(token.Value) >= 0) && (Convert.ToInt32(token.Value) <= DA_Spectral.max_intensity_layers));
            }
            else
            { return false; }
        }

        public static bool is_direction_value_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.Up || token.TokenType == TokenType.Down;
        }

        public static bool is_note_sector_range_token(c_lexer_token token)
        {
            bool result = token.TokenType == TokenType.All || token.TokenType == TokenType.Integer;
            if (result)
            {
                return ((Convert.ToInt32(token.Value) >= 0) && (Convert.ToInt32(token.Value) <= DA_Spectral.max_note_sectors));
            }
            else
            { return false; }
        }

        public static bool is_note_sector_id_token(c_lexer_token token)
        {
            if (token.TokenType == TokenType.Integer)
            {
                return ((Convert.ToInt32(token.Value) >= 0) && (Convert.ToInt32(token.Value) <= DA_Spectral.max_note_sectors));
            }
            else
            { return false; }

        }

        public static bool is_db_slope_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.dbminus12 ||
                            token.TokenType == TokenType.dbminus24 ||
                            token.TokenType == TokenType.dbminus3 ||
                            token.TokenType == TokenType.dbminus6 ||
                            token.TokenType == TokenType.dbplus12 ||
                            token.TokenType == TokenType.dbplus24 ||
                            token.TokenType == TokenType.dbplus3 ||
                            token.TokenType == TokenType.dbplus6
                ;
        }

        public static bool is_harmonic_range_token(c_lexer_token token)
        {
            if (token.TokenType == TokenType.Integer)
            {
                return ((Convert.ToInt32(token.Value) >= 0) && (Convert.ToInt32(token.Value) <= DA_Spectral.max_harmonics));
            }
            else
            { return token.TokenType == TokenType.All; }
        }

        public static bool is_harmonic_id_token(c_lexer_token token)
        {
            if (token.TokenType == TokenType.Integer)
            {
                return ((Convert.ToInt32(token.Value) >= 0) && (Convert.ToInt32(token.Value) <= DA_Spectral.max_harmonics));
            }
            else
            { return false; }
        }

        public static bool is_harmonic_level_token(c_lexer_token token)
        {
            if (token.TokenType == TokenType.Integer)
            {
                return ((Convert.ToInt32(token.Value) >= 0) && (Convert.ToInt32(token.Value) <= DA_Spectral.max_hamonic_level_value));
            }
            else
            { return false; }
        }

        public static bool is_harmonic_phase_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.Inverted || token.TokenType == TokenType.AllInPhase;
        }

        public static bool is_harmonic_level_shape_type_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.LinearDecreasing ||
                            token.TokenType == TokenType.ExponentialAll ||
                            token.TokenType == TokenType.ExponentialOdd ||
                            token.TokenType == TokenType.AllZero ||
                             token.TokenType == TokenType.AllMax
                            ;
        }

        public static bool is_harmonic_phase_shape_type_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.InvertedEven ||
                            token.TokenType == TokenType.InvertedOdd ||
                            token.TokenType == TokenType.Inverted3711 ||
                            token.TokenType == TokenType.AllInPhase;
        }

        public static bool is_instrument_type_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.Guitar ||
                            token.TokenType == TokenType.MutedGuitar ||
                            token.TokenType == TokenType.Violin ||
                            token.TokenType == TokenType.Cello ||
                            token.TokenType == TokenType.Trumpet ||
                            token.TokenType == TokenType.Flute ||
                            token.TokenType == TokenType.Clarinet
                            ;
        }

        public static bool is_waveform_range_token(c_lexer_token token)
        {
            bool result = token.TokenType == TokenType.Integer;
            if (result)
            {
                return ((Convert.ToInt32(token.Value) >= 0) && (Convert.ToInt32(token.Value) <= DA_Spectral.max_waveforms));
            }
            else
            { return false; }
        }

        public static bool is_waveform_id_token(c_lexer_token token)
        {
            if (token.TokenType == TokenType.Integer)
            {
                return ((Convert.ToInt32(token.Value) >= 0) && (Convert.ToInt32(token.Value) <= DA_Spectral.max_waveforms));
            }
            else
            { return false; }
        }

        public static bool is_waveform_name_token(c_lexer_token token)
        {
            return token.TokenType == TokenType.Sine ||
                token.TokenType == TokenType.Saw ||
                token.TokenType == TokenType.Triangle ||
                token.TokenType == TokenType.Square;
        }

        #endregion

    }
}
