﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static Spectral1.PARSER.c_dsl_functions;

namespace Spectral1.PARSER
{
    public class c_dsl_functions
    {

        #region "============================= DECLARATIONS ========================"
        public List<c_parser_dsl_function> list_of_functions;
        #endregion

        #region "============================= ENUMS ========================"
        public enum definition_objects
        {
            WaveSet,
            Patch,
            Filter
        }

        public enum target_objects
        {
            WaveSet,
            CurrentIntensityLayer,
            CurrentNoteSector,
            CurrentWaveform,
            CurrentWaveformBlock,
            General,
            ADSR
        }

        public enum functions
        {
            W_WS_MorphAcrossIntensityLayers,
            W_WS_SetCurrentIntensityLayer,
            W_WS_SetCurrentNoteSector,
            W_NS_CopyTo,
            W_NS_CopyToRange,
            W_NS_MorphWaveformBlocks,
            W_NS_MorphWaveforms,
            W_IL_CopyTo,
            W_IL_CopyToRange,
            W_IL_ShapeTheHarmonics,
            W_IL_MorphWaveformBlocks,
            W_IL_MorphWaveforms,
            W_WB_CopyTo,
            W_WB_MorphWaveforms,
            W_WB_SetCurrentWaveform,
            W_WB_CopyAcrossNoteSectors,
            W_WB_CopyAcrossIntensityLayers,
            W_WB_CopyAcrossAllDimensions,
            W_WF_CopyTo,
            W_WF_CopyToRange,
            W_WF_SetWaveformName,
            W_WF_CopyAcrossNoteSectors,
            W_WF_CopyAcrossIntensityLayers,
            W_WF_CopyAcrossAllDimensions,
            W_WF_SetHarmonicLevelsFromCSV,
            W_WF_SetHarmonicLevelsFromHarmonicLevelShapeType,
            W_WF_SetHarmonicLevelsFromInstrumentType,
            W_WF_SetHarmonicLevelsFromWaveShape,
            W_WF_SetHarmonicLevel,
            W_WF_MorphHarmonicLevels,
            W_WF_SetHarmonicPhases,
            W_WF_SetHarmonicPhasesFromCSV,
            W_WF_SetHarmonicPhasesFromInstrumentType,
            W_WF_SetHarmonicPhasesFromHarmonicPhaseShapeType,
            W_WF_SetHarmonicPhasesFromWaveShape,
            W_WS_MorphAcrossNoteSectors,
            W_WF_SetHarmonicPhase,
            P_GEN_SetPortamento,
            P_GEN_SetScalingSplit,
            P_GEN_SetPatchGain,
            P_GEN_SetDetuning,
            P_GEN_SetActiveOscillators,
            P_GEN_SetDetuningMode,
            P_GEN_SetOscillatorDetuning,
            P_GEN_SetLFO,
            P_GEN_SetEnvelopeGainControllero,
            P_ADSR_ConfigureSection,
            P_ADSR_ConfigureEnvelope,
            P_ADSR_LoadPreset
        }
        #endregion


        #region "============================= METHODS ============================"
        public c_dsl_functions()
        {
            list_of_functions = new List<c_parser_dsl_function>();
        }

        public void add(definition_objects definition_object, target_objects target_object, functions function, List<String> parameter_values,int start_position)
        {
            c_parser_dsl_function f = new c_parser_dsl_function();
            f.definition_object = definition_object;
            f.target_object = target_object;
            f.function = function;
            f.start_position = start_position;
            f.parameter_values = parameter_values;
            list_of_functions.Add(f);
        }

        public static Int32 bool_string_to_int(string bool_string)
        {
            if (bool_string.ToUpper() == "TRUE")
            { return 1; }
            else
            { return 0; }
        }

        public static float convert_friendly_percent_to_real1(string friendly_percent)
        {
            return (float)((Convert.ToDouble(friendly_percent)) / 100);
        }

        public static float convert_friendly_percent_to_real100(string friendly_percent)
        {
            return (float)((Convert.ToDouble(friendly_percent)));
        }

        public static int check_integer(string check_value_as_string, int range_low, int range_high, string error_text)
        {
            int check_value = Convert.ToInt32(check_value_as_string);
            if ((check_value < range_low) || (check_value > range_high))
            {
                throw new InvalidOperationException(error_text + "\r\nValid range : " + range_low.ToString() + " to " + range_high.ToString());
            }
            else
            { return check_value; }
        }

        public static float check_unsigned_percentage(string check_value_as_string)
        {
            return check_float(check_value_as_string, 0, 100, "Invalid percentage !");
        }

        public static float check_signed_percentage(string check_value_as_string)
        {
            return check_float(check_value_as_string, -100, 100, "Invalid percentage !");
        }

        public static float check_float(string check_value_as_string, int range_low, int range_high, string error_text)
        {
            double check_value = Convert.ToDouble(check_value_as_string);
            if ((check_value < range_low) || (check_value > range_high))
            {
                throw new InvalidOperationException(error_text + "\r\nValid range : " + range_low.ToString() + " to " + range_high.ToString());
            }
            else
            { return (float)check_value; }
        }
        #endregion


        #region "============================ SUB CLASSES =================================="
        public class c_parser_dsl_function
        {
            public definition_objects definition_object;
            public target_objects target_object;
            public functions function;
            public int start_position;
            public List<String> parameter_values = new List<String>();
        }
        #endregion
    }
}









