'ver 2 27/05/22 
'RF Peak Hold Pwr Meter with Servo indicator
'Ver 2 - Added Fvrsetup before each ADC read command because Fvrsetup resets after each ADC read.
'use 08M or 08M2
'C.0 (pin 7) reserved from prog
'C.1 (pin 6) NU
'C.2 (pin 5) ADC I/P for Power Sensor AD8318, 0.5v to 2.0v
'C.3 (pin 4) Mode Selection, Peak Hold = Lo, Normal = Hi, pulled high
'C.4 (pin 3) servo o/p
'C.5 reserved for prog
'
'
'
'

'W0 
'W1 used for ADC10
'W2 (b4 & b5) used for servo
'W3 Peak Hold loop counter
'W4 used for math
'#######################################################################################
symbol servmin = 70     	'define servo minimum. Set this for each servo model!

'Initialize
fvrsetup FVR2048        	'set internal ADC Ref as 2.048V
adcconfig %011          	'set FVR as ADC Vref+, 0V Vref-

init:
servo 4,servmin		   'initialize servo
pause 500  			 'delay to let pointer move to max
servopos 4,100   		 'set pointer to show life
pause 500
servopos 4,servmin		'set pointer to min

ReadSens:    		     'read sensor routine
	w4=1000     		'initialize to about min pwr (max V)
					'the peak will be neg going and will drag this down to whatever it finds
	if pinC.3=1  then goto samp2 'if mode is sample, then by pass peak hold
	for w3=1 to 400   	'search for neg going peak. This value may be adj for signals with long inter-burst periods.
        fvrsetup FVR2048        	'set internal ADC Ref as 2.048V
        adcconfig %011          	'set FVR as ADC Vref+, 0V Vref-
		readadc10 C.2,w1
		if w1 >= w4 then goto bypass   'ignore this read if new reading is higher
		w4=w1 		'update peak storage only if current read is lower v (=higher pwr) than stored
		bypass:
	next w3

calclev:				'enter here from samp2 if in sample mode
	'display w4, ie peak neg going or normal value
	'2.048v max (Reference)with 10 bit adc is 2048mv/1024 steps = 2.0mv per adc step
	'For AD8318 at 2.5GHz 24.5mV per 1dB from ~500mv to 2000mv, ie about 1500mv dynamic range
	'Servo has a range from 70 to 250, ie about 180 steps.
	'Therefore 1500mv/180 steps = ~8mv per servo step.
	'This give 8mv per servo step / 2mv per ADC step = 4 ADC steps per servo step.
	'With the AD8318 giving 25mv per 1dB, we have a resolution of 25/8 = ~3 servo steps per 1dB.
	'Allow for 500mv (500mv/2mv=250 ADC steps) initial offset to optimize dynamic range.
	'500mv sensor output is 0 servo steps thence 1 servo step for each 4 ADC step increase.

	if W4 >250 then goto cont     'check for too low error in sensor, ie < 500mv
	W4=250			'set a value due to error in reading range.
cont:
	W4=W4-250     	    'subtract 500mv offset at 2mv per ADC step
	W4=W4/4     		'get servo steps per ADC step
	W4=W4 + servmin  	 'add servo minimum
	if W4 <251 then goto cont2    'check for out of range value following calc.
		W4=250		'if out of range set a default
	if W4 > servmin then goto cont2    'check for out of range
	W4=servmin  		'if out of range set a default
cont2:
	servopos 4,W4           'set servo pointer to calculated value
	pause 100   		'let servo settle
	goto ReadSens     	'loop for another measurement

'#######################################################################################
'sub routines

samp2:	'perform adc read without peak hold    
	readadc10 C.2,w4  	'read ADC directly into W4 rather than W1
	goto calclev 
end
