
#include "esp_camera.h"
#include "FS.h"
#include "SPI.h"
#include "SD_MMC.h"
#include "EEPROM.h"
#include "driver/rtc_io.h"
#define CAMERA_MODEL_AI_THINKER
#include "camera_pins.h"
#define ID_ADDRESS            0x00
#define COUNT_ADDRESS         0x01
#define ID_BYTE               0xAA
#define EEPROM_SIZE           0x0F


#include <Time.h>
#include <Wire.h>
#include <RtcDS3231.h>
RtcDS3231<TwoWire> Rtc(Wire);

String dow[7]  = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};  // Sunday is dayOfWeek 0
String moy[12] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"}; // January is month 0
uint16_t nextImageNumber = 0;

#define I2C_SDA 3  //14
#define I2C_SCL 1  //15

#include <SSD1306.h> 
SSD1306 display(0x3c, I2C_SDA, I2C_SCL); 

void setup() {
Wire.begin(I2C_SDA, I2C_SCL);  

  Serial.begin(115200);
  Serial.println();
  Serial.println("Booting...");

  pinMode(4, INPUT);              //GPIO for LED flash
  digitalWrite(4, LOW);
  rtc_gpio_hold_dis(GPIO_NUM_4);  //diable pin hold if it was enabled before sleeping
  
  camera_config_t config;
  config.ledc_channel = LEDC_CHANNEL_0;
  config.ledc_timer = LEDC_TIMER_0;
  config.pin_d0 = Y2_GPIO_NUM;
  config.pin_d1 = Y3_GPIO_NUM;
  config.pin_d2 = Y4_GPIO_NUM;
  config.pin_d3 = Y5_GPIO_NUM;
  config.pin_d4 = Y6_GPIO_NUM;
  config.pin_d5 = Y7_GPIO_NUM;
  config.pin_d6 = Y8_GPIO_NUM;
  config.pin_d7 = Y9_GPIO_NUM;
  config.pin_xclk = XCLK_GPIO_NUM;
  config.pin_pclk = PCLK_GPIO_NUM;
  config.pin_vsync = VSYNC_GPIO_NUM;
  config.pin_href = HREF_GPIO_NUM;
  config.pin_sscb_sda = SIOD_GPIO_NUM;
  config.pin_sscb_scl = SIOC_GPIO_NUM;
  config.pin_pwdn = PWDN_GPIO_NUM;
  config.pin_reset = RESET_GPIO_NUM;
  config.xclk_freq_hz = 20000000;
  config.pixel_format = PIXFORMAT_JPEG;
  
  //init with high specs to pre-allocate larger buffers
  if(psramFound())  {
    config.frame_size = FRAMESIZE_UXGA;
    config.jpeg_quality = 10;
    config.fb_count = 2;
  } else 
  {
    config.frame_size = FRAMESIZE_SVGA;
    config.jpeg_quality = 12;
    config.fb_count = 1;
  }


  //initialize camera
  esp_err_t err = esp_camera_init(&config);
  if (err != ESP_OK)   {
    Serial.printf("Camera init failed with error 0x%x", err);
    return;
  }
  
  //set the camera parameters
  sensor_t * s = esp_camera_sensor_get();
  s->set_contrast(s, 2);    //min=-2, max=2
  s->set_brightness(s, 2);  //min=-2, max=2
  s->set_saturation(s, 2);  //min=-2, max=2
  delay(100);               //wait a little for settings to take effect
  
  //initialize & mount SD card
  if(!SD_MMC.begin()) {
    Serial.println("Card Mount Failed");
    return;
  }
  
  uint8_t cardType = SD_MMC.cardType();

  if(cardType == CARD_NONE) {
    Serial.println("No SD card attached");
    return;
  }

  //initialize EEPROM & get file number
  if (!EEPROM.begin(EEPROM_SIZE))  {
    Serial.println("Failed to initialise EEPROM"); 
    Serial.println("Exiting now"); 
    while(1);   //wait here as something is not right
  }

/*
  EEPROM.get(COUNT_ADDRESS, nextImageNumber);
  Serial.println(nextImageNumber);
  nextImageNumber += 1;
  EEPROM.put(COUNT_ADDRESS, nextImageNumber);
  EEPROM.commit();
  while(1);
  */
  
  /*ERASE EEPROM BYTES START*/
  /*
  Serial.println("Erasing EEPROM...");
  for(int i = 0; i < EEPROM_SIZE; i++)
  {
    EEPROM.write(i, 0xFF);
    EEPROM.commit();
    delay(20);
  }
  Serial.println("Erased");
  while(1);
  */
  /*ERASE EEPROM BYTES END*/  

  if(EEPROM.read(ID_ADDRESS) != ID_BYTE) {   //there will not be a valid picture number
    Serial.println("Initializing ID byte & restarting picture count");
    nextImageNumber = 0;
    EEPROM.write(ID_ADDRESS, ID_BYTE);  
    EEPROM.commit(); 
  }
  else                                      //obtain next picture number
  {
    EEPROM.get(COUNT_ADDRESS, nextImageNumber);
    nextImageNumber +=  1;    
    Serial.print("Next image number:");
    Serial.println(nextImageNumber);
  }

  //take new image
  camera_fb_t * fb = NULL;
  //obtain camera frame buffer
  fb = esp_camera_fb_get();
  if (!fb) 
  {
    Serial.println("Camera capture failed");
    Serial.println("Exiting now"); 
    while(1);   //wait here as something is not right
  }

  display.init();
  display.flipScreenVertically();  
  display.setFont(ArialMT_Plain_10);
 
  display.drawString(0, 0, "ESP32 - Camera success!");
  display.drawString(0, 14, "Wait for trigger...");
  display.display();
  delay(1000);

  Rtc.Begin();
  RtcDateTime compiled = RtcDateTime(__DATE__, __TIME__);
//    printDateTime(compiled);
    Serial.println();
    if (!Rtc.IsDateTimeValid())    {
        // Common Cuases:
        //    1) first time you ran and the device wasn't running yet
        //    2) the battery on the device is low or even missing

        Serial.println("RTC lost confidence in the DateTime!");

        // following line sets the RTC to the date & time this sketch was compiled
        // it will also reset the valid flag internally unless the Rtc device is
        // having an issue

        Rtc.SetDateTime(compiled);
    }

    if (!Rtc.GetIsRunning())    {
        Serial.println("RTC was not actively running, starting now");
        Rtc.SetIsRunning(true);
    }

    RtcDateTime now = Rtc.GetDateTime();
    if (now < compiled)     {
        Serial.println("RTC is older than compile time!  (Updating DateTime)");
        Rtc.SetDateTime(compiled);
    }
    else if (now > compiled)     {
        Serial.println("RTC is newer than compile time. (this is expected)");
    }
    else if (now == compiled)     {
        Serial.println("RTC is the same as compile time! (not expected but all is fine)");
    }

    // never assume the Rtc was last configured by you, so
    // just clear them to your needed state
    Rtc.Enable32kHzPin(false);
    Rtc.SetSquareWavePin(DS3231SquareWavePin_ModeNone); 
RtcDateTime t = Rtc.GetDateTime();  
RtcTemperature temp = Rtc.GetTemperature();
uint8_t data1[30];
String s1=" ";  
sprintf((char*)data1, "-%02d%02d-%02d%02d%02d",t.Day(),t.Month(),t.Hour(),t.Minute(),t.Second() );
Serial.println((char*)data1);
//sprintf((char*)data1, "%02d%02d",t.Hour(),t.Minute() );

  //save to SD card
  //generate file path
  String path = "/IMG" + String(nextImageNumber)+(char*)data1 + ".jpg";
    
  fs::FS &fs = SD_MMC;

  //create new file
  File file = fs.open(path.c_str(), FILE_WRITE);
  if(!file)
  {
    Serial.println("Failed to create file");
    Serial.println("Exiting now"); 
    while(1);   //wait here as something is not right    
  } 
  else 
  {
    file.write(fb->buf, fb->len); 
    EEPROM.put(COUNT_ADDRESS, nextImageNumber);
    EEPROM.commit();
  }
  file.close();
display.clear();
sprintf((char*)data1, "%s %02d/%02d/%02d %02d:%02d:%02d",dow[t.DayOfWeek()],t.Day(),t.Month(), t.Year()-2000,t.Hour(),t.Minute(),t.Second() );
display.drawString(0, 0, (char*)data1 );
display.drawString(0, 14, path );
display.drawString(0, 24, "Image saved" );
display.display();
delay(1500);
display.clear();
display.display();  
  //return camera frame buffer
  esp_camera_fb_return(fb);
  Serial.printf("Image saved: %s\n", path.c_str());

  pinMode(4, OUTPUT);              //GPIO for LED flash
  digitalWrite(4, LOW);            //turn OFF flash LED
  rtc_gpio_hold_en(GPIO_NUM_4);    //make sure flash is held LOW in sleep
 
  Serial.println("Entering deep sleep mode");
  Serial.flush(); 
  esp_sleep_enable_ext0_wakeup(GPIO_NUM_13, 0);   //wake up when pin 13 goes LOW
  delay(2000);                                    //wait for 3 seconds to let PIR sensor settle
  esp_deep_sleep_start();
}

void loop() {
}
