#include "esp_camera.h"
#include <WiFi.h>

#define CAMERA_MODEL_AI_THINKER // Has PSRAM

#include "camera_pins.h"
#define RED 2
#define GREEN 14
#define LOCK 12

// DEFINE HERE THE KNOWN NETWORKS
const char* KNOWN_SSID[] = {"bera1", "bera.", ".bera"};
const char* KNOWN_PASSWORD[] = {"99690343141", "9969034314", "9969034314"};
const int   KNOWN_SSID_COUNT = sizeof(KNOWN_SSID) / sizeof(KNOWN_SSID[0]); // number of known networks

int status = WL_IDLE_STATUS;
IPAddress ip;
String x;
  
void startCameraServer();

#define I2C_SDA 15  //14
#define I2C_SCL 13  //15
#include <SSD1306.h> 
SSD1306 display(0x3c, I2C_SDA, I2C_SCL); 

boolean matchFace = false;
boolean openLock = false;
long prevMillis=0;
int interval = 6000;  //DELAY


void setup() {
  Wire.begin(I2C_SDA, I2C_SCL);  
  pinMode(LOCK,OUTPUT);
  pinMode(RED,OUTPUT);
  pinMode(GREEN,OUTPUT);
  digitalWrite(LOCK,LOW);
  digitalWrite(RED,HIGH);
  digitalWrite(GREEN,LOW);
    
  Serial.begin(115200);
  Serial.setDebugOutput(true);
  Serial.println();
  
  display.init();
  display.flipScreenVertically();  
  display.setFont(ArialMT_Plain_10);
  display.drawString(0, 0, "ESP32 - Camera server!");
  display.drawString(0, 14, "Camera connecting...");
 
  camera_config_t config;
  config.ledc_channel = LEDC_CHANNEL_0;
  config.ledc_timer = LEDC_TIMER_0;
  config.pin_d0 = Y2_GPIO_NUM;
  config.pin_d1 = Y3_GPIO_NUM;
  config.pin_d2 = Y4_GPIO_NUM;
  config.pin_d3 = Y5_GPIO_NUM;
  config.pin_d4 = Y6_GPIO_NUM;
  config.pin_d5 = Y7_GPIO_NUM;
  config.pin_d6 = Y8_GPIO_NUM;
  config.pin_d7 = Y9_GPIO_NUM;
  config.pin_xclk = XCLK_GPIO_NUM;
  config.pin_pclk = PCLK_GPIO_NUM;
  config.pin_vsync = VSYNC_GPIO_NUM;
  config.pin_href = HREF_GPIO_NUM;
  config.pin_sscb_sda = SIOD_GPIO_NUM;
  config.pin_sscb_scl = SIOC_GPIO_NUM;
  config.pin_pwdn = PWDN_GPIO_NUM;
  config.pin_reset = RESET_GPIO_NUM;
  config.xclk_freq_hz = 20000000;
  config.pixel_format = PIXFORMAT_JPEG;
  
  // if PSRAM IC present, init with UXGA resolution and higher JPEG quality
  //                      for larger pre-allocated frame buffer.
  if(psramFound()){
    config.frame_size = FRAMESIZE_UXGA;
    config.jpeg_quality = 10;
    config.fb_count = 2;
  } else {
    config.frame_size = FRAMESIZE_SVGA;
    config.jpeg_quality = 12;
    config.fb_count = 1;
  }
  // camera init
  esp_err_t err = esp_camera_init(&config);
  if (err != ESP_OK) {
    Serial.printf("Camera init failed with error 0x%x", err);
    return;
  }
  sensor_t * s = esp_camera_sensor_get();
  // initial sensors are flipped vertically and colors are a bit saturated
  if (s->id.PID == OV3660_PID) {
    s->set_vflip(s, 1); // flip it back
    s->set_brightness(s, 1); // up the brightness just a bit
    s->set_saturation(s, -2); // lower the saturation
  }
  // drop down frame size for higher initial frame rate
  s->set_framesize(s, FRAMESIZE_QVGA);


display.clear();
display.drawString(0, 0, "ESP32 - Camera server!");
display.drawString(0, 14, "Camera connected");
  display.display();
  delay(1000);

  boolean wifiFound = false;
  int i, n;
  WiFi.mode(WIFI_STA);
  WiFi.disconnect();
  delay(100);
  Serial.println("Setup done");
 // ----------------------------------------------------------------
  // WiFi.scanNetworks will return the number of networks found
  // ----------------------------------------------------------------
  Serial.println(F("scan start"));
  int nbVisibleNetworks = WiFi.scanNetworks();
  Serial.println(F("scan done"));
  if (nbVisibleNetworks == 0) {
    Serial.println(F("no networks found. Reset to try again"));
    display.drawString(0, 34, "No network. Restarting");
    display.display();
    delay(3000);
     esp_restart();  
 //   while (true); // no need to go further, hang in there, will auto launch the Soft WDT reset
  }

  // ----------------------------------------------------------------
  // if you arrive here at least some networks are visible
  // ----------------------------------------------------------------
  Serial.print(nbVisibleNetworks);
  Serial.println(" network(s) found");

  // ----------------------------------------------------------------
  // check if we recognize one by comparing the visible networks
  // one by one with our list of known networks
  // ----------------------------------------------------------------
  for (i = 0; i < nbVisibleNetworks; ++i) {
    Serial.println(WiFi.SSID(i)); // Print current SSID
    for (n = 0; n < KNOWN_SSID_COUNT; n++) { // walk through the list of known SSID and check for a match
      if (strcmp(KNOWN_SSID[n], WiFi.SSID(i).c_str())) {
        Serial.print(F("\tNot matching "));
        Serial.println(KNOWN_SSID[n]);
      } else { // we got a match
        wifiFound = true;
        break; // n is the network index we found
      }
    } // end for each known wifi SSID
    if (wifiFound) break; // break from the "for each visible network" loop
  } // end for each visible network

  if (!wifiFound) {
    Serial.println(F("no Known network identified. Restarting again"));
    display.drawString(0, 44, "No known network...");
    display.display();
    delay(3000);
    esp_restart();  
    //while (true); // no need to go further, hang in there, will auto launch the Soft WDT reset
  }

  // ----------------------------------------------------------------
  // if you arrive here you found 1 known SSID
  // ----------------------------------------------------------------
  Serial.print(F("\nConnecting to "));
  Serial.println(KNOWN_SSID[n]);

  // ----------------------------------------------------------------
  // We try to connect to the WiFi network we found
  // ----------------------------------------------------------------
  WiFi.begin(KNOWN_SSID[n], KNOWN_PASSWORD[n]);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    int f=f+1;
    Serial.print ( "." );
    if(f>60){    
          Serial.print("Restarting...");
esp_restart();    
    }
    Serial.print(".");
  }
  Serial.println("");

  // ----------------------------------------------------------------
  // SUCCESS, you are connected to the known WiFi network
  // ----------------------------------------------------------------
  Serial.println(F("WiFi connected, your IP address is "));
  Serial.println(WiFi.localIP());


  startCameraServer();

  Serial.print("Camera Ready! Use 'http://");
  Serial.print(WiFi.localIP());
  Serial.println("' to connect");
  x = "connected to "+String(KNOWN_SSID[n]);
  display.drawString(0, 24, x );

//uint8_t data1[20];
//sprintf((char*)data1,%s,(char*)WiFi.localIP() );
//Serial.println((char*)data1);



  ip = WiFi.localIP();
  String y = "http://"+String(ip[0])+"."+String(ip[1])+","+String(ip[2])+"."+String(ip[3]);
  display.drawString(0, 34,y );
  display.display();
  delay(1000);

  
}

void loop() {
  ip = WiFi.localIP();
//  Serial.print(ip[0]);
//  Serial.println(x);
  // put your main code here, to run repeatedly:
//  delay(10000);
  if(ip[0]<=0)   esp_restart();    
//  Serial.print(ip[0]);
//  Serial.println(x);
 if(matchFace==true && openLock==false)  {
    openLock=true;
    digitalWrite(LOCK,HIGH);
    digitalWrite(GREEN,HIGH);
    digitalWrite(RED,LOW);
    prevMillis=millis();
    Serial.print("UNLOCK DOOR");    
   }
   if (openLock == true && millis()-prevMillis > interval)   {
    openLock=false;
    matchFace=false;
    digitalWrite(LOCK,LOW);
    digitalWrite(GREEN,LOW);
    digitalWrite(RED,HIGH);
    Serial.print("LOCK DOOR");
    }

}
