//SSD1306/SH1106 OLED implementation for 16F1455

#ifndef OLED_H
#define OLED_H
#include <xc.h>
#include "softi2c.h"
#include "font.h"

#define OLED_ADDRESS 0x78   //8bit write address, read address is +1
//#define OLED_ADDRESS 0x7A   //8bit write address, read address is +1

#define OLED_X_OFFSET (32)
#define OLED_BIG_PIXEL_WIDTH 7

//for flippable text display
//TEXT_RH is same as original
#define TEXT_RH 1
#define TEXT_LH 2

//for startup delay
#define _XTAL_FREQ 4000000

extern char col,page; //column variable

char textFlip;

void OLEDsendCommand(unsigned char c);
void OLEDsendData(unsigned char c);
void OLEDclear(void);
void OLEDinit(void);
void OLEDsetpage(unsigned char p);
void OLEDsetcolumn(unsigned char c);
void OLEDchars(char c,char xs, char ys, char p);    //generic scaled, x,y and padding
unsigned char getbits(unsigned char j, char y, char s); //get byte from j at pos y, scale s
void OLEDflip(char c);      //to suit flip orientation according to textFlip
unsigned char revBits(unsigned char b); //reverse bit order
//some template sizes
void OLEDchar4(unsigned char x);
void OLEDchar2(unsigned char x);
void OLEDchar1(unsigned char x);
//reused delays
void delay2000(void);                   //reused
void delay200(void);                   //reused

#endif  //OLED_H

