//misc utilities

#ifndef UTIL_H
#define	UTIL_H
#include <xc.h>
#include "oled.h"
#include "io.h"

//tolerance for ADC convergence
#define R_TOLERANCE (200)
//series test resistor
#define R_TEST (10000)
//open circuit threshold, also helps us dodge /0
#define R_HIGH_ADC (1020)
//lead resistance
#define R_LEAD (63)
//nominal supply for voltage calculations, in mV, not used
//#define V_SUPPLY (5000)
//open circuit threshold, different for diodes due to leakage
#define D_HIGH_ADC (990)
//fudge factor for caps
#define C_FACTOR (2560)
//used for cal values
#define R_TEST_LOWER (9000)
#define R_TEST_UPPER (11000)
#define R_LEAD_LOWER (0)
#define R_LEAD_UPPER (1000)
#define R_LEAD_OS (23)

//initial counter for cap ramp counting
#define C_COUNT (16384)

//values for shared capacitance testing

//nominal value in pF of ADC sample cap
#define SCAP_SAMPLEC (14)
//upper and low ADC limits for valid result
#define SCAP_ADCHI (1015)
#define SCAP_ADCLO (700)
//nominal stray lead capacitance
#define SCAP_STRAY (30)

long vf,vr; //forward and reverse ADC, used as globals
extern unsigned long bvolt; //battery voltage, set by main()
extern long t;              //needed for showD()
unsigned int rtest=R_TEST;  //powerup defaults
unsigned int rlead=R_LEAD;  


char getDigit(signed char p);  //get digit of t at pth decimal place (0 = ones)
void getV(void);                         //common ADC sample code
long getR(void);                         //get resistance, negative => invalid
long getDF(void);                        //get diode FV, result in mV
long getDR(void);                        //get diode RV, result in mV
int getCLO(void);                       //use shared capacitance method to get lo-range capacitance
long getC(void);                         //get cap in pF?
void getFVR(void);   //switch to FVR and read (and switch back)
void showD(void);                        //common code for DF/DR
void showC(void);
void showCLO(void);                      //use this to differentiate (pF only)
void showR(void);
char lzFix(char c); //suppress leading zero suppression for display reasons
unsigned long places(signed char n);    //this is smaller than a const array
void doCalibration(void);               //wrap up all the calibration features
void sleepDelay(void);                  //nominally 200ms for legible display updates
void loadCalFromFlash(void);            //custom wrapper for this program
void SaveCalToFlash(void);              //custom wrapper for this program

//little helpers for small amount of duplicated code
void showCount(char j);                 //helper to catch duplicated code
void showOhms(void);                    //to help with repeated code, uses global t
void showHold(void);
void showRelease(void);
void showLoad(void);

void setHand(void);                     //check and set handedness
void setTestR(void);                    //set and save series test resistance value
void setContR(void);                    //set and save contact/lead resistance
char saveQuery(void);                   //prompt for save and return result
char promptCal(void);                   //prompt to check if calibration wanted

#endif

