#include "config.h"
#include <xc.h>
#include "io.h"
#include "softi2c.h"
#include "oled.h"
#include "font.h"
#include "util.h"

char i,j;
long t;
unsigned long bvolt;
char col,page; //column variable
extern char textFlip;

#define SCREEN_TIMEOUT (10)

void main(void) {
    WDTCON=0;       //off under software control
    textFlip=TEXT_RH;
    //textFlip=TEXT_LH;    
    OSCFRQ=2;           //4MHz
    ioinit();
    I2Cstop();          //this sets up I2C to idle state
    OLEDinit();         //does clear too
    col=0;
    page=0;
    loadCalFromFlash();
    doCalibration();
    j=SCREEN_TIMEOUT;
    while(1){
        getFVR();         //this is battery voltage and ADC reference, put in bvolt
        page=0;
        col=0;        
        t=getC();        
        if(t>0){
            showC();
            j=SCREEN_TIMEOUT;
        }else{
            t=getCLO();
            if(t>0){
                showCLO();
                j=SCREEN_TIMEOUT;
            }else{        
                getV();
                t=getR();
                if(t>=0){
                    j=SCREEN_TIMEOUT;
                    showR();
                }else{
                    t=getDF();
                    if(t>=0){
                        j=SCREEN_TIMEOUT;
                        showD();
                        OLEDchar4(F_DF); 
                    }else{
                        t=getDR();
                        if(t>=0){
                            j=SCREEN_TIMEOUT;
                            showD();
                            OLEDchar4(F_DR);
                        }else{      //if not valid show battery
                            t=bvolt;
                            OLEDchar4(F_BAT);
                            OLEDchar4(getDigit(3));
                            OLEDchar4(F_POINT);                                
                            OLEDchar4(getDigit(2));
                            OLEDchar4(getDigit(1));
                            OLEDchar4(F_VOLT);                
                        }
                    }      
                }
            }
        }
        sleepDelay();
        if(j){
            j--;
        }else{
            //go to sleep until triggered
            j=SCREEN_TIMEOUT;           //reset counter
            OLEDsendCommand(0xAE);      //display off
            ADCON0bits.ADON=0;          //turn off
            ANSELA=0;                   //digital for INT
            
            //default INT pin is RA2, as per 12F1572
            INTCONbits.PEIE=1;          //enable peripheral interrupts
            INTCONbits.INTEDG=0;        //falling edge
            PIR0bits.INTF=0;            //clear
            PIE0bits.INTE=1;            //enable
            
            //OPTION_REGbits.INTEDG=0;    //falling edge
            //INTCONbits.INTF=0;          //clear
            //INTCONbits.INTE=1;          //enable
            
            SLEEP();                    //sleep
            NOP();                      //ensure next instruction is executed
            PIE0bits.INTE=0;            //disable
            //INTCONbits.INTE=0;          //disable
            ANSELA=1<<2;                //AN2 on RA2 only            
            ADCON0bits.ADON=1;          //turn on
            OLEDsendCommand(0xAF);      //display on
        }
    }
    return;
}
