//SSD1306/SH1106 OLED implementation for 16F1455

#include "oled.h"
#include "softi2c.h"

void OLEDsendCommand(unsigned char c){
    I2Cstart();
    I2Cbyte(OLED_ADDRESS); //write
    I2Cbyte(0x80); //write
    I2Cbyte(c); //write
    I2Cstop();
}

void OLEDsendData(unsigned char c){     //not used only does a single byte
    I2Cstart();
    I2Cbyte(OLED_ADDRESS); //write
    I2Cbyte(0x40); //write
    I2Cbyte(c); //write
    I2Cstop();
}

void OLEDinit(void){
    delay200();             //startup delay for display
    OLEDsendCommand(0x20);  //set addressing mode
    OLEDsendCommand(0x02);  //set page addressing mode (SH1106 only supports page mode)
    OLEDsendCommand(0x8D);  //Charge pump setting
    OLEDsendCommand(0x14);  //Enable Charge pump
    OLEDsendCommand(0xA1);  //column reverse
    //OLEDsendCommand(0xA0);  //column normal
    OLEDsendCommand(0xC8);  //row reverse
    //OLEDsendCommand(0xC0);  //row normal
    OLEDsendCommand(0xAF);  //display on
    OLEDsendCommand(0x81);  //set contrast
    OLEDsendCommand(0xFF);  //to max
    OLEDclear();
}

void OLEDclear(void){
    unsigned char i,j;
    for(i=0;i<8;i++){
        OLEDsetpage(i);
        OLEDsendCommand(0xB0+i); //cycle through pages
        //OLEDsendCommand(0x00);   //column=0 (lower nybble)     
        OLEDsendCommand(0x10);   //column=0 (upper nybble)
        I2Cstart();
        I2Cbyte(OLED_ADDRESS); //write
        I2Cbyte(0x40); //write data
        for(j=0;j<128;j++){
            I2Cbyte(0x00);
        }
        I2Cstop();
    }
}

void OLEDsetpage(unsigned char p){
    //p=7-p;      //flipped
    OLEDsendCommand(0xB0 + (p&7));      //set page address    
}

void OLEDsetcolumn(unsigned char c){
    //c=127-c;     //flipped
    c=c+OLED_X_OFFSET;
    OLEDsendCommand(0x00 + (c & 0x0F));  //set column lower address
    OLEDsendCommand(0x10 + ((c>>4)&0x0F));   //set column higher address    
}

void OLEDchars(char c,char xs, char ys, char p){    //generic scaled, x,y and padding
    unsigned char j,k,r;
    unsigned int i;
    char t;
    if(c>F_LAST){return;}
    i=c*8;
    for(k=0;k<ys;k++){  //rows
        if(textFlip==TEXT_RH){        
            OLEDsetcolumn(col);
            OLEDsetpage(4+k+page);
        }else{
            OLEDsetcolumn(col+4);
            OLEDsetpage(k+page);            
        }
        I2Cstart();
        I2Cbyte(OLED_ADDRESS);  //write
        I2Cbyte(0x40);          //write data
        for(j=0;j<8;j++){       //8 font columns
            t=getbits(font8[j+i],k,ys);
            for(r=0;r<xs;r++){I2Cbyte(t);}
        }
        for(r=0;r<p;r++){I2Cbyte(0);}
        I2Cstop();
    }    
    col=col+(8*xs)+p;    
}

unsigned char getbits(unsigned char j, char y, char s){ //get byte from j at pos y, scale s
    unsigned long d=0;    //32 bits to hold our intermediate
    unsigned long m,b;    //multiplier and output bitmask    
    unsigned char bits;
    char i;
    if(s<2){return j;}  //quick and easy
    switch(s){case 3:m=8;break;case 4:m=16;break;default:m=4;break;}
    b=m-1;
    bits=128;
    for(i=0;i<8;i++){
        d=d<<s;
        if(j&bits){d=d+b;}
        bits=bits>>1;
    }
    switch(y){
        case 0:return (d>> 0)&0xFF;break;
        case 1:return (d>> 8)&0xFF;break;
        case 2:return (d>>16)&0xFF;break;
    }
    return (d>>24)&0xFF;
}

void OLEDflip(char c){      //to suit flip orientation according to textFlip
    if(c==TEXT_RH){
        OLEDsendCommand(0xA1);  //column reverse
        OLEDsendCommand(0xC8);  //row reverse
    }else{
        OLEDsendCommand(0xA0);  //column normal
        OLEDsendCommand(0xC0);  //row normal
    }          
}

unsigned char revBits(unsigned char b){ //reverse bit order
    unsigned char n=0;
    if(b&128){n=n+1;}
    if(b&64){n=n+2;}
    if(b&32){n=n+4;}
    if(b&16){n=n+8;}
    if(b&8){n=n+16;}
    if(b&4){n=n+32;}
    if(b&2){n=n+64;}
    if(b&1){n=n+128;}
    return n;
}
//some template sizes
void OLEDchar4(unsigned char x){OLEDchars(x,1,4,3);}
void OLEDchar2(unsigned char x){OLEDchars(x,1,2,1);}
void OLEDchar1(unsigned char x){OLEDchars(x,1,1,1);}

void delay2000(void){                   //reused
    __delay_ms(2000); 
}

void delay200(void){                   //reused
    __delay_ms(200); 
}