/*  SC_PMsensor_demo.ino
 *  A simple Arduino program to interact with Particulate Matter
 *  or smoke sensors based on the Sharp GP2Y1010AU.
 *  
 *  Adapted from a sketch written by JongHyun Woo, the author
 *  of the Arduino library PMsensor-master, and provided with his
 *  library as an example: PMsensorDefault.ino.
 *  
 *  Note that the sensor's LED pin should be connected to the
 *  digital IO pin 3 of the Arduino, while the Vout pin should
 *  be connected to the A0 pin of the Arduino.
 *  
 *  Also the data rate for the link to the Arduino Serial Monitor
 *  should be set to 9600 baud.
 */
#include <PMsensor.h>

PMsensor PM;

void setup() {
  Serial.begin(9600);

  /////(infrared LED pin, sensor pin)  /////
  PM.init(3, A0);
}

void loop() {
  Serial.println("=================================");
  Serial.println("Read PM2.5");

  float filter_Data = PM.read(0.1);
  //float noFilter_Data = PM.read();

  Serial.print("Filter : ");
  Serial.println(filter_Data);
  //Serial.print("noFilter : ");
  //Serial.println(noFilter_Data);

  
  delay(1000);
}
