                                          
 
;IR to UHF Converter

	ERRORLEVEL -302
	ERRORLEVEL -306
; PIC10LF322

	list P=PIC10F322
	#include P10F322.inc

;Program Configuration Register 
		__CONFIG    _CP_OFF & _MCLRE_ON & _PWRTE_ON & _WDTE_OFF & _FOSC_INTOSC & _LVP_ON & _BOREN_OFF	

; RAM 

STORE1			equ	H'40'	; Delay loop counter
STORE2			equ	H'41'	; delay loop counter
DATA_COUNT		equ	H'42'	; data output counter
POWER_COUNT		equ	H'43'	; power counter 
DLY_LOOP		equ	H'44'	; delay loop 


; ******************************************************************

; start at memory 0

	org		0			; reset vector
	goto	MAIN
	    			 
	org		4			; interrupt vector not used

; ***********************************************************
		
MAIN

; set inputs/outputs
	movlw	H'00'
	movwf	PORTA		; outputs low
	clrf	ANSELA		; digital I/O
	bcf		OPTION_REG,7	; weak pullups enabled
	movlw	B'00000001'	; pullups off/on
	movwf	WPUA	
	movlw	B'00000001'	; outputs/inputs set 
	movwf	TRISA		; port data direction register
	bsf		INTCON,IOCIE; interrupt on change enabled  
	bsf		INTCON,PEIE	; peripheral interrupt enable
	movlw	B'01010000'	;
	movwf	OSCCON		; set at 4MHz
	bsf		IOCAP,0		; RA0 positive edge
	bsf		IOCAN,0		; RA0 negative edge		
	clrf	FVRCON

; initial conditions

	movlw	H'00'
	movwf	LATA		; outputs low 

; test for infra red LED drive, either high or low driving
; pullup is on so if reads high at RA0, leave with pullup
; if RA0 reads low then switch off pullup
; start with delay

	movlw	D'5'
	movwf	DLY_LOOP	; delay extension for 1s total

MORE_DLY
	movlw	D'255'
	movwf	STORE1
	movwf	STORE2
LOOP1
	movf	STORE2,w
	btfsc	STATUS,Z	; when zero end of delay
	goto	END_DELY
	decf	STORE2,f
LOOP2
	decfsz	STORE1,f
	goto	LOOP2
	movlw	D'255'
	movwf	STORE1
	goto	LOOP1

END_DELY
	decfsz	DLY_LOOP,f
	goto	MORE_DLY

; if RA0 reads low switch off pullup
	btfsc	PORTA,0	
	goto	KEEP_PULLUP

	bcf		WPUA,0	; RA0 weak pullup off
	
KEEP_PULLUP
; set power timer to max
	movlw	D'100'		; power up counter for UHF transmitter
	movwf	POWER_COUNT
	movlw	D'250'
	movwf	STORE1		; power up extension period
; set Data timer to max
	movlw	D'3'
	movwf	DATA_COUNT

DECODE
; if PORTA,0 went high, as seen by interrupt on change flag, set VCC and data high
	btfss	IOCAF,0 ;
	goto	IN_LOW
	
	clrf	IOCAF	; clear when set

; check PORTA,2 for a high. If high bypass
	btfsc	LATA,2	; Data
	goto	RST_PWR
; high so power up the UHF transmitter 
	bsf		LATA,1
; add delay to compensate for off delay
	movlw	D'12'
	movwf	DLY_LOOP

START_DELAY
	decfsz	DLY_LOOP,f
	goto	START_DELAY
	bsf		LATA,2		; data high to UHF
; reset power timer to max
RST_PWR
	movlw	D'100'		; power up counter
	movwf	POWER_COUNT
	movlw	D'250'
	movwf	STORE1		; power up extension period
; reset Data timer to max
	movlw	D'3'
	movwf	DATA_COUNT

	goto	DECODE
	
IN_LOW
; if low,

; count down power timer. When ended clear power and data & sleep
	decfsz	STORE1,f
	goto	DATA_TIMER
	movlw	D'250'
	movwf	STORE1
	decfsz	POWER_COUNT,f
	goto	DATA_TIMER
	movlw	D'100'		; power up counter
	movwf	POWER_COUNT
; clear outputs
	clrf	LATA
	goto	STOP

DATA_TIMER
; count down data level timer. When ended clear data	
	decfsz	DATA_COUNT,f
	goto	DECODE
	movlw	D'3'		; data counter
	movwf	DATA_COUNT
; clear data output
	bcf		LATA,2
	goto	DECODE

STOP ; power down till signal reoccurs

; clear flag wait for new signal

	bcf		INTCON,IOCIF		; clear flag
	clrf	IOCAF				; interrupt flags
	sleep
	nop
	goto	DECODE
       

	end
