
 
; UHF receiver to IR LED Converter (receiver)

	ERRORLEVEL -302
	ERRORLEVEL -306


	    list      p=12F617           ; list directive to define processor
     #include <p12F617.inc>        ; processor specific variable definitions


     __CONFIG   _CP_OFF & _BOR_OFF & _MCLRE_ON & _WDT_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _IOSCFS_4MHZ & _WRT_OFF

; ******************************************************************

; bank 0 RAM 


STORE1			equ	H'22'	; delay counter	
STORE2			equ	H'23'	; delay counter
PORT			equ	H'24'	; port store
TIMEOUT			equ	H'25'	; indicates timer1 status; timing or timeout
INSET			equ	H'26'	; input GPIO5
RUN				equ	H'27'	; counter
OSC_TUNE		equ	H'28'	; frequency value setting via A/D 
TEMPS			equ	H'29'	; convert temporary working value
 
; ******************************************************************

; start at memory 0

	org		0			; reset vector
	goto	MAIN		; 
;	org     4			; interrupt vector not used


MAIN

; set oscillator calibration
	bsf		STATUS,RP0	; bank 1
    movlw   0x00      	; set oscillator to factory calibrated frequency 
    movwf   OSCTUNE
	
	bcf		STATUS,RP0	; select memory bank 0
	call	DELAYms		; add small delay

; set inputs/outputs
	clrf	GPIO		; outputs low
	movlw	B'00000111'	; comparators off
	movwf	CMCON0
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000000'	; pullups off
	movwf	WPU
	movlw	B'00111000'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'00000100'	; settings (pullups enabled) timer0/32 (8ms)
	movwf	OPTION_REG

; analog inputs, A/D
	movlw	B'01011000'	; AN3 analog input 
	movwf	ANSEL
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'00001100'	; channel 3 
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on

; initial conditions
	movlw	B'00000000'	; port low
	movwf	GPIO	
	call	DELAYms		; add small delay

	clrf	TMR1H
	clrf	TMR1L
	bcf		T1CON,5		; /1 prescaler
	bcf		T1CON,4
	bsf		T1CON,0		; timer 1 on	

	call	DELAYms		; add small delay

; allow interrupts
ALL_INTERRUPTS
	bsf		STATUS,RP0	; select memory bank 1		
	bsf		PIE1,TMR1IE	; timer 1 overflow interrupt
	bcf		STATUS,RP0	; select memory bank 0
	bsf		INTCON,T0IE	; timer 0 enable
	bcf		INTCON,T0IF	; timer 0 interrupt flag
	bcf		PIR1,TMR1IF	; timer 1 interrupt flag

INPUT_SIGX

; if timer1 timeout flag set, clear timeout

	btfss	PIR1,TMR1IF	
	goto	BY_TIMEOUT
	clrf	TIMEOUT		; timeout flag cleared
	bcf		GPIO,0		; clear ACK.
BY_TIMEOUT
; locate 3ms gaps (GP5 continuously low). Then start (set timeout,0) the timeout flag to run the output

; check for 3ms periods of no signal. A gap indicates an incoming signal (not noise)
; If these do not occur, then allow timeout with timer1. Reset timer1 and timer1 flag for each gap detected

; check GP5. If low, check if low for 3ms. If so reset countdown period
	call	PORT_RUN
	btfss	INSET,5
	goto	LOWIN
; GP5 whenever high reset timer0 
	clrf	TMR0		; reset timer 0 

;  for 3ms timeout 
	bsf		TMR0,7		; set 3ms timeout period
	bsf		TMR0,5
	bcf		INTCON,T0IF	; 
	goto	START

LOWIN
	btfss	INTCON,T0IF	; 3ms period flag, if set then input low for 3ms
	goto	INPUT_SIGX
; input low for 3ms
	bsf		TIMEOUT,0	; allow signal output with flag set
; clear timer1
	clrf	TMR1H
	clrf	TMR1L
	bcf		PIR1,TMR1IF	; timer 1 interrupt flag

; check frequency setting
	call	ACQUIRE_AD
	comf 	ADRESH,w	; get ms bits but complement due to reverse connection on trim pot
	movwf	OSC_TUNE
	call	CONVERT		; convert to OSCTUNE 2's complement 5 bit value

; start output with timeout flag set
START
  	btfss	TIMEOUT,0	; only run when flag is set 	
	goto	INPUT_SIGX	

	call	PORT_RUN	; check input GPIO5 (INSET,5)

	bcf		GPIO,0		; clear ACK.


	btfsc	INSET,5		; set ACK LED when input is high
	bsf		GPIO,0		; acknowledge

INPUT_SIG
	btfss	GPIO,5		; when high begin to read data
	goto	LOW2

; generate carrier at 33.3% duty
	btfss	PORT,1
	goto	LOW1

	movlw	B'00000001'	; PORT GP0 and GP1 low and GP3 (acknowledge) high
	movwf	GPIO
	bcf		PORT,1
	nop
	nop
	nop
	nop
	nop	
	nop
	nop	
	nop
	goto	INPUT_SIG
LOW1
	movlw	B'00000111'	; PORT GP0 and GP1 and GP3 (acknowledge) high
	movwf	GPIO
	bsf		PORT,1
	goto	INPUT_SIG

LOW2
	movlw	B'00000000'	; PORT GP0 and GP1 low and GP3 (acknowledge) high
	movwf	GPIO
	bcf		PORT,1
	
	goto	INPUT_SIGX	


; ***************************************************************************	

; Subroutines

; delay loop 

DELAYms
	movlw	D'23'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	H'B0'
DELDSP
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,1	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,1	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return

; check for high at GP5
PORT_RUN
	btfss	GPIO,5
	goto	LOW_RUN
; check if remains high for 15us
	movlw	D'3'
	movwf	RUN
RUN_HI	
	decfsz	RUN,f
	goto	CK_HI
; yes high for 100us
	bsf		INSET,5
	return
CK_HI
	btfsc	GPIO,5		; check high
	goto	RUN_HI		; still high
LOW_RUN
	bcf		INSET,5		; low so set inset,5 low
	return


; convert OSC_TUNE (00-FF) to OSCTUNE 5-bit 2's complement. Overall 12.5% adjustment
CONVERT
	movf	OSC_TUNE,w
	movwf	TEMPS
; shift for 5-bit value

	rrf		TEMPS,f
	rrf		TEMPS,f
	rrf		TEMPS,f
	btfss	TEMPS,4
	goto	REVx
	bcf		TEMPS,4
	goto	STRAIGHTx
REVx
	bsf		TEMPS,4
STRAIGHTx
	movf	TEMPS,w
	bsf		STATUS,RP0	; bank 1
	movwf	OSCTUNE
	bcf		STATUS,RP0	; bank 0	
	return

	end
