'
' Written by K F Horton January 2019

' Background information credits:
' https://en.wikipedia.org/wiki/Conway%27s_Game_of_Life
' https://en.wikipedia.org/wiki/Oscillator_(cellular_automaton)
' http://wwwhomes.uni-bielefeld.de/achim/freq_top_life.html
' http://conwaylife.com/wiki/Queen_bee_shuttle

Option Autorun On
Option default integer  
Option explicit  
Option baudrate 19200
cpu 48

Const maximum_pointer = 19

Const brightness = 70

Const back_colour = rgb(black)
Const cell_colour = rgb(white)
Const cell_dark_colour = rgb(blue)
Const text_colour = rgb(white)
Const button_colour = rgb(white)

' Arrays used to keep track of touch sensitive buttons
Dim Integer key_coord(2, 5)
Dim String key_caption(2) length 20
Dim tx1(5),tx2(5),ty1(5),ty2(5)

' Arrays to hold screen matrices. 
' The screen is 32 (x) by 24(y) cells and is surrounded by a border of empty (0) cells
' Thus the four corners of the screen are:
' element(01) = &H100000000;	element(01) = &H000000002
' element(24) = &H100000000;	element(24) = &H000000002

' Similarly the four corners of the border are:
' element(00) = &H200000000;	element(00) = &H000000001
' element(25) = &H200000000;	element(25) = &H000000001
Dim screen1(25), screen2(25), user(24)

Dim title as string  length 40
Dim subtitle as string length 40
Dim wrap_round, wrap_flag, tu
Dim pointer = 0

' Turn on backlight
PWM 2, 250, brightness

start:

' Draw the selection screen
cls back_colour
text  20,160,str$(3),,7,1, rgb(red), back_colour
drawbutton 1,0,110,165,100,40,button_colour,"Select"
text 250,160,str$(2),,7,1, rgb(blue), back_colour
text 160,226,"Credits: Wikipedia-Conway's Game of Life",c,1,1,text_colour,back_colour
tx1(1) = 020:ty1(1) = 160:tx2(1) = 070:ty2(1) = 210
tx1(2) = 120:ty1(2) = 165:tx2(2) = 210:ty2(2) = 205
tx1(3) = 250:ty1(3) = 160:tx2(3) = 300:ty2(3) = 210
tx1(4) = 000:ty1(4) = 000:tx2(4) = 000:ty2(4) = 000
get_matrix pointer

wait_if_touch

' Process touch screen
do
	tu = CheckTouch(1,4)
	if tu = 1 then
		' Down button
		pointer = pointer - 1
		if pointer < 0 then pointer = maximum_pointer
		get_matrix pointer
		wait_if_touch

	else if tu = 2 then
		' Select button
		drawbutton 1,2
		wait_if_touch
		drawbutton 1,1
		if pointer = 0 then user_create ' Special case for user created display
		game_of_life
		goto start

	else if tu = 3 then
		'Up button
		pointer = pointer + 1
		if pointer > maximum_pointer then pointer = 0
		get_matrix pointer
		wait_if_touch

	else if (tu = 4) and (wrap_flag <> 0) then
		'Wrap around button
		if wrap_round <> 0 then
			drawbutton 2,1
			wrap_round = 0
		else
			drawbutton 2,2
			wrap_round = 1
		end if
		wait_if_touch
	end if
loop

sub get_matrix(no)
	Local y,a
	select case no ' Select the matrix
		case 0
			restore layout00
		case 1
			restore layout01
		case 2
			restore layout02
		case 3
			restore layout03
		case 4
			restore layout04
		case 5
			restore layout05
		case 6
			restore layout06
		case 7
			restore layout07
		case 8
			restore layout08
		case 9
			restore layout09
		case 10
			restore layout10
		case 11
			restore layout11
		case 12
			restore layout12
		case 13
			restore layout13
		case 14
			restore layout14
		case 15
			restore layout15
		case 16
			restore layout16
		case 17
			restore layout17
		case 18
			restore layout18
		case 19
			restore layout19
		case else
			restore layout01
	end select

	' Read the data
	read title
	read subtitle
	read wrap_round
	text  160,20,"                    ",c,1,2, back_colour, back_colour
	text  160,50,"                    ",c,1,2, back_colour, back_colour
	text  160,20,title,c,1,2, text_colour, back_colour
	text  160,50,subtitle,c,1,2, text_colour, back_colour

	for y = 1 to 24
		read a
		screen1(y) = a << 1
	next y

	wrap_flag = wrap_round
	if wrap_flag = 2 then
		drawbutton 2,0,55,100,190,30,button_colour,"Wrap around"
		tx1(4) = 70:ty1(4) = 100:tx2(4) = 230:ty2(4) = 130
		drawbutton 2,2
	else
		drawbutton 2,0,55,90,190,50,back_colour,"           "
		tx1(4) = 000:ty1(4) = 000:tx2(4) = 000:ty2(4) = 000
	end if
end sub

Sub wait_if_touch
	' Wait if the screen is being touched
	do
	loop until Touch(x) = -1
	pause 100
End sub


sub game_of_life
	Local x, y, y1, y2, m1, m2, m3, m4, c, c1, c2, c3, c4

	' This subroutine is written for speed not compactness!

	' Any live cell with fewer than two live neighbours dies, as if by underpopulation.
	' Any live cell with two or three live neighbours lives on to the next generation.
	' Any live cell with more than three live neighbours dies, as if by overpopulation.
	' Any dead cell with exactly three live neighbours becomes a live cell, as if by reproduction

	' display initial screen
	cls back_colour
	for y = 1 to 24
		m1 = &H100000000
		for x = 1 to 32
			if screen1(y)and m1 then
				box (x-1) * 10,(y-1) * 10,10,10,1,back_colour,cell_colour
			end if
			m1 = m1 >> 1
		next x
	next y

	do
		' Determine whether screen wraps around or not
		y2 = 2
		if wrap_round then 
			y1 = 24
			m4 = &H000000002
		else
			y1 = 0
			m4 = &H200000000
		end if

		' Apply the rules to create screen2 from screen1
		for y = 1 to 24
			m1 = m4
			m2 = &H100000000
			m3 = &H080000000
			for x = 1 to 32
				if x = 1 then
					c1 = 0
					if screen1(y1) and m1 then c1 = c1 + 1
					if screen1(y) and m1 then c1 = c1 + 1
					if screen1(y2) and m1 then c1 = c1 + 1
				else
					c1 = c2
					if screen1(y) and m1 then c1 = c1 + 1
				end if

				if x < 3 then
					c2 = 0
					if screen1(y1) and m2 then c2 = c2 + 1
					if screen1(y2) and m2 then c2 = c2 + 1
				else
					c2 = c3
				end if

				c3 = 0
				if screen1(y1) and m3 then c3 = c3 + 1
				if screen1(y2) and m3 then c3 = c3 + 1

				c = c1 + c2 + c3 + c4

				if screen1(y)and m3 then c = c + 1

				if screen1(y)and m2 then
					if (c < 2) or (c > 3) then
						screen2(y) = screen2(y) and (m2 xor -1)
					else
						screen2(y) = screen2(y) or m2
					end if
				else
					if (c = 3) then
						screen2(y) = screen2(y) or m2
					else
						screen2(y) = screen2(y) and (m2 xor -1)
					end if
				end if

				m1 = m1 >> 1
				m2 = m2 >> 1
				m3 = m3 >> 1
				if wrap_round then
					if m1 = 1 then m1 = &H100000000
					if m3 = 1 then m3 = &H100000000
				end if
			next x
			y1 = y1 + 1
			y2 = y2 + 1
			if wrap_round then
				if y1 > 24 then y1 = 1
				if y2 > 24 then y2 = 1
			end if
		next y

		'Update the display from screen2
		for y = 1 to 24
			if screen1(y) <> screen2(y) then
				m1 = &H100000000
				for x = 1 to 32
					if ((screen1(y) xor screen2(y)) and m1) then 
						if screen2(y)and m1 then
							box (x-1) * 10,(y-1) * 10,10,10,1,back_colour,cell_colour
						else
							box (x-1) * 10,(y-1) * 10,10,10,1,back_colour,back_colour
						end if
					end if
					m1 = m1 >> 1
				next x
			end if
		next y

		if Touch(x) <> -1 then exit do ' Terminate if screen touched

		' Determine whether screen wraps around or not
		y2 = 2
		if wrap_round then 
			y1 = 24
			m4 = &H000000002
		else
			y1 = 0
			m4 = &H200000000
		end if

		'Apply the rules to create screen1 from screen2
		for y = 1 to 24
			m1 = m4
			m2 = &H100000000
			m3 = &H080000000
			for x = 1 to 32
				if x = 1 then
					c1 = 0
					if screen2(y1) and m1 then c1 = c1 + 1
					if screen2(y) and m1 then c1 = c1 + 1
					if screen2(y2) and m1 then c1 = c1 + 1
				else
					c1 = c2
					if screen2(y) and m1 then c1 = c1 + 1
				end if

				if x < 3 then
					c2 = 0
					if screen2(y1) and m2 then c2 = c2 + 1
					if screen2(y2) and m2 then c2 = c2 + 1
				else
					c2 = c3
				end if

				c3 = 0
				if screen2(y1) and m3 then c3 = c3 + 1
				if screen2(y2) and m3 then c3 = c3 + 1

				c = c1 + c2 + c3 + c4

				if screen2(y)and m3 then c = c + 1

				if screen2(y)and m2 then
					if (c < 2) or (c > 3) then
						screen1(y) = screen1(y) and (m2 xor -1)
					else
						screen1(y) = screen1(y) or m2
					end if
				else
					if (c = 3) then
						screen1(y) = screen1(y) or m2
					else
						screen1(y) = screen1(y) and (m2 xor -1)
					end if
				end if
				m1 = m1 >> 1
				m2 = m2 >> 1
				m3 = m3 >> 1
				if wrap_round then
					if m1 = 1 then m1 = &H100000000
					if m3 = 1 then m3 = &H100000000
				end if
			next x
			y1 = y1 + 1
			y2 = y2 + 1
			if wrap_round then
				if y1 > 24 then y1 = 1
				if y2 > 24 then y2 = 1
			end if
		next y

		'Update the display from screen1
		for y = 1 to 24
			if screen1(y) <> screen2(y) then
				m1 = &H100000000
				for x = 1 to 32
					if ((screen1(y) xor screen2(y)) and m1) then 
						if screen1(y)and m1 then
							box (x-1) * 10,(y-1) * 10,10,10,1,back_colour,cell_colour
						else
							box (x-1) * 10,(y-1) * 10,10,10,1,back_colour,back_colour
						end if
					end if
					m1 = m1 >> 1
				next x
			end if
		next y

	loop until Touch(x) <> -1 ' Terminate if screen touched
end sub

Sub user_create
	Local x,y,m1,tx,ty
	cls back_colour
	' Set up initial screen
	for y = 1 to 24
		m1 = &H100000000
		for x = 1 to 32
			if (y < 22) or (x < 30) then
				if (user(y) and (&H100000000 >> x-1)) = 0 then
					box (x-1) * 10,(y-1) * 10,10,10,1,back_colour,cell_dark_colour
				else
					box (x-1) * 10,(y-1) * 10,10,10,1,back_colour,cell_colour
				end if
			end if
		next x
	next y
	box 310,230,10,10,1,back_colour,rgb(red)

	' Allow user to set / clear cells
	do
		tx = Touch(x)
		ty = Touch(y)
		if (tx <> -1) and (ty <> -1) then 
			tx = tx \ 10
			ty = ty \ 10
			if tx > 31 then tx = 31
			if ty > 23 then ty = 23
			if (tx < 29) or (ty < 21) then
				if (user(ty+1) and (&H100000000 >> tx)) = 0 then
					box tx * 10,ty * 10,10,10,1,back_colour,cell_colour
				else
					box tx * 10,ty * 10,10,10,1,back_colour,cell_dark_colour
				end if
				user(ty+1) = user(ty+1) xor (&H100000000 >> tx)
			end if
			if (tx > 29) and (ty > 21) then exit do
			wait_if_touch
		end if
	loop

	'Update screen1 with the user's choice
	for y = 1 to 24
		screen1(y) = user(y)
	next y
end sub


Function CheckTouch(StartI, EndI)
	Local i, j, tx, ty
	'Check if a touch sensitive area of the screen has been touched
	tx = Touch(x)
	If tx = -1 Then CheckTouch = -1 : Exit Function
	ty = Touch(y)
	For j = StartI To EndI
		If tx >= tx1(j) And tx < tx2(j) And ty >= ty1(j) And ty < ty2(j) Then
			CheckTouch = j
			Exit For
		EndIf
	Next j
End Function
    
Sub DrawButton n As Integer, mode As Integer, bx As integer, by As integer, w As integer, h As integer, bc As integer, s As string
	Local integer bcol, fcol
	' Draw a button
 	If mode = 0 Then
		key_coord(n,0) = bx : key_coord(n,1) = by : key_coord(n,2) = w : key_coord(n,3) = h
		key_coord(n,4) = bc : key_caption(n) = s
	EndIf
  
	If mode > 1 Then
		bcol = key_coord(n,4) : fcol = 0    ' draw in reverse video if it is being touched
	Else
		bcol = back_colour : fcol = key_coord(n,4)    ' a normal (untouched) button
	EndIf
  
	RBox key_coord(n,0), key_coord(n,1), key_coord(n,2), key_coord(n,3), , key_coord(n,4), bcol)
	Text key_coord(n,0) + key_coord(n,2)/2, key_coord(n,1) + key_coord(n,3)/2, key_caption(n), CM, 1, 2, fcol, bcol
End Sub

' Pointers as a font
 ' Font type    : Triangles (4 characters)
 ' Font size    : 52x50 pixels
 ' Memory usage : 1304 bytes
DefineFont #7
  04303234 70000000 00000000 00000700 00000000 000000D8 800D0000 00000000
  00008C01 18000000 000000C0 00060300 00000000 00006030 03060000 00000000
  00306000 0C000000 00008001 18C00000 00000000 00C00018 80010000 0000000C
  60003000 03000000 00000600 00600000 00000030 00030006 C0000000 00001800
  01000C00 01000080 000C0080 00180000 0000C000 06000003 30000000 00600000
  00000600 00000003 30000060 000C0000 00800100 0000C000 18000018 C0000000
  00800100 00000C00 00000030 00030060 00060000 00006000 06003000 03000000
  00C00000 00180000 0000000C 80018001 0C000000 00001800 03C00000 00000000
  00300006 60000000 00000006 60000300 00000000 00000C30 80010000 000000C0
  00181800 00000000 000080C1 300C0000 00000000 00006300 06000000 FFFFFF7F
  FFF7FFFF FFFFFFFF FFFF7FFF F7FFFFFF FFFFFFFF 0030FFFF 00000000 00000063
  18060000 00000000 0080C100 0C000000 0000000C C0800100 00000000 00000618
  00030000 00000060 00033000 06000000 00003000 01600000 00000080 0018000C
  C0000000 0000C000 0C001800 01000000 00600080 00300000 00000006 30000003
  60000000 00000300 00000600 00000018 800100C0 000C0000 00000C00 00008001
  180000C0 00060000 00000300 00006000 03000030 00060000 00300000 00006000
  0C008001 18000000 00C00000 00C00000 00000018 8001000C 60000000 00003000
  03000600 00000000 00600030 00030000 00000006 C0001800 01000000 00000C80
  010C0000 00000080 0018C000 06000000 00000003 30600000 00000000 00000603
  30000000 00000060 008C0100 00000000 0000C018 D8000000 00000000 00800D00
  00000000 00000070 00070000 00000000 00007000 07000000 00000000 00F80000
  00000000 0000800F FC010000 00000000 00C01F00 03000000 000000FE E03F0000
  00000000 0000FF07 7F000000 000000F0 80FF0F00 00000000 0000F8FF FF1F0000
  000000C0 00FCFF01 3F000000 0000E0FF FEFF0300 00000000 00F0FF7F FF070000
  000000FF F8FFFF00 0F000000 0080FFFF FFFF0100 000000FC C0FFFF1F FF030000
  0000FEFF FFFF3F00 070000E0 00FFFFFF FF7F0000 0000F0FF FFFFFF0F FF000080
  00F8FFFF FFFF1F00 0100C0FF FCFFFFFF FF3F0000 00E0FFFF FFFFFF03 7F0000FE
  F0FFFFFF FFFF0700 0000FFFF FFFFFFFF FF0F00F8 80FFFFFF FFFFFF01 1F00FCFF
  FFFFFFFF FFFF03C0 00FEFFFF FFFFFF3F FF07E0FF FFFFFFFF FFFF7F00 0FF0FFFF
  FFFFFFFF FFFF80FF F8FFFFFF FFFFFF1F FFC1FFFF FFFFFFFF FFFF3FFC E3FFFFFF
  FFFFFFFF FF7FFEFF FFFFFFFF FFFFFFF7 7FFFFFFF FFFFFFFF FFFFF7FF FFFFFFFF
  FFFFFF3F FFE3FFFF FFFFFFFF FFFF1FFE C1FFFFFF FFFFFFFF FF0FFCFF FFFFFFFF
  FFFFFF80 07F8FFFF FFFFFFFF FF7F00FF F0FFFFFF FFFFFF03 3F00FEFF FFFFFFFF
  FFFF01E0 00FCFFFF FFFFFF1F FF00C0FF F8FFFFFF FFFF0F00 0080FFFF FFFFFF7F
  FF0700F0 00FFFFFF FFFF3F00 0300E0FF FEFFFFFF FF1F0000 00C0FFFF FFFFFF01
  0F0000FC 80FFFFFF FFFF0000 0000F8FF FFFFFF07 7F000000 00F0FFFF FFFF0300
  000000FE E0FFFF3F FF010000 0000FCFF FFFF1F00 000000C0 00F8FFFF FF0F0000
  000080FF F0FF7F00 07000000 0000FFFF FF3F0000 000000E0 00FEFF03 1F000000
  0000C0FF FCFF0100 00000000 0080FF0F FF000000 000000F8 00FF0700 00000000
  0000F07F FE030000 00000000 00E03F00 01000000 000000FC C01F0000 00000000
  0000F800 0F000000 00000080 00700000 00000000 00000007
End DefineFont

layout00:
data "Design your own"
data ""
data 2 ' 0 - No wrap around; 1 - Wrap around: 2 - Ask user
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout01:
data "Still lives and"
data "Binary oscillators"
data 0 ' 0 - No wrap around; 1 - Wrap around: 2 - Ask user
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00110000110000110000110000010000
data &B00110001001001001000101000101000
data &B00000000110000101000010000010000
data &B00000000000000010000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00001110000001110000000110000000
data &B00000000000011100000000110000000
data &B00000000000000000000000001100000
data &B00000000000000000000000001100000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout02:
data "Pulsar (3) and"
data "Pentadecathlon (15)"
data 0
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00001110001110000000000000000000
data &B00000000000000000000000000000000
data &B00100001010000100000000000000000
data &B00100001010000100000000000000000
data &B00100001010000100000000000000000
data &B00001110001110000000000000000000
data &B00000000000000000000000000000000
data &B00001110001110000000000000000000
data &B00100001010000100000000000100000
data &B00100001010000100000000001010000
data &B00100001010000100000000000100000
data &B00000000000000000000000000100000
data &B00001110001110000000000000100000
data &B00000000000000000000000000100000
data &B00000000000000000000000000100000
data &B00000000000000000000000001010000
data &B00000000000000000000000000100000
data &B00000000000000000000000000100000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout03:
data "Star (3) and"
data "cross (3)"
data 0
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000001110000000000000011000000
data &B00000000000000000000000111100000
data &B00000101010100000000000000000000
data &B00000000000000000000010100101000
data &B00010100000101000000110000001100
data &B00010000000001000000110000001100
data &B00010100000101000000010100101000
data &B00000000000000000000000000000000
data &B00000101010100000000000111100000
data &B00000000000000000000000011000000
data &B00000001110000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout04:
data "French kiss (3)"
data "and Octagon (5)"
data 0
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000110000000000000000000
data &B00000000000100000000000000000000
data &B00000000110100000000000100100000
data &B00000001001000000000001011010000
data &B00000001000000000000000100100000
data &B00000000010000000000000100100000
data &B00000010010000000000001011010000
data &B00000101100000000000000100100000
data &B00000100000000000000000000000000
data &B00001100000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout05:
data "Clock (4) and"
data "Pinwheel (4)"
data 0
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000110000000000000011000000
data &B00000000110000000000000011000000
data &B00000000000000000000000000000000
data &B00000011110000000000001111000000
data &B00110100001000000011010000100000
data &B00110101101000000011010010100000
data &B00000100011011000000010001101100
data &B00000100001011000000010100101100
data &B00000011110000000000001111000000
data &B00000000000000000000000000000000
data &B00000011000000000000001100000000
data &B00000011000000000000001100000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout06:
data "Pentoad (5) and"
data "Fumarole (5)"
data 0
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000110000000000000000
data &B00000000000000100000000000000000
data &B00000000000010100000000100100000
data &B00000000000011000000011100111000
data &B00000000110000000000001100110000
data &B00000000011000000000000100100000
data &B00000000110000000000010100101000
data &B00000000011000000000011000011000
data &B00000110000000000000000000000000
data &B00001010000000000000000000000000
data &B00001000000000000000000000000000
data &B00011000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout07:
data "Kok's galaxy (8)"
data ""
data 0
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000001010010000000000000
data &B00000000000001110101100000000000
data &B00000000000010000001000000000000
data &B00000000000001000001100000000000
data &B00000000000000000000000000000000
data &B00000000000011000001000000000000
data &B00000000000001000000100000000000
data &B00000000000011010111000000000000
data &B00000000000000100101000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout08:
data "Cloverleaf (4) and"
data "Figure 8 (8)"
data 0
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000101000000000000000000000
data &B00000011101110000000000000000000
data &B00000100010001000000000000000000
data &B00000101000101000000000000000000
data &B00000011010110000000000000000000
data &B00000000000000000000000000000000
data &B00000011010110000000000000000000
data &B00000101000101000000000000000000
data &B00000100010001000000000000000000
data &B00000011101110000000000000000000
data &B00000000101000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000001110000000000
data &B00000000000000000001110000000000
data &B00000000000000000001110000000000
data &B00000000000000000000001110000000
data &B00000000000000000000001110000000
data &B00000000000000000000001110000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout09:
data "Unix (6) and"
data "Tumbler (14)"
data 0
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000001000000000000000000000000
data &B00000010111100000000000000000000
data &B00000101011100000000000000000000
data &B00001010000000000000000000000000
data &B00000100000000000000000000000000
data &B00000110000000000000000000000000
data &B00000110000000000000000000000000
data &B00000110000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000100000100000000
data &B00000000000000001010001010000000
data &B00000000000000000011011000000000
data &B00000000000000000110001100000000
data &B00000000000000000011011000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout10:
data "Mazing (4) Mold (4)"
data "and Blocker (8)"
data 0
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000011100000000000000000000000
data &B00000011100000000000000000000000
data &B00001100111000000000000000000000
data &B00001100000000000000000000000000
data &B00001110000000000000000000000000
data &B00000010000000000000000000000000
data &B00000010000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000011000000000
data &B00000000000000000000100100000000
data &B00000000000000000000101010000000
data &B00000000000000000000010111000000
data &B00000000000000000000000111000000
data &B00000000110000000000000000000000
data &B00001100001111000000000000000000
data &B00001100110111000000000000000000
data &B00000000100000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout11:
data "Queen bee"
data "shuttle (30)"
data 0
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000100000000000000
data &B00000000000000001100000000000000
data &B00000000000000011000011000000000
data &B00000110000000111000011001100000
data &B00000110000000011000011001100000
data &B00000000000000001100000000000000
data &B00000000000000000100000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout12:
data "Gliders"
data ""
data 1
data &B00100000001000000010000000100000
data &B00010000000100000001000000010000
data &B01110000011100000111000001110000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout13:
data "Spaceships"
data ""
data 1
data &B00000000000000000000000000010000
data &B00000000000000000000000001000100
data &B00000000000000000000000010000000
data &B00000000000000000000000010000100
data &B00000000000000000000000011111000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00111100000000000000000000000000
data &B01000100000000000000000000000000
data &B00000100000000000000000000000000
data &B01001000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000110000
data &B00000000000000000000000010000100
data &B00000000000000000000000100000000
data &B00000000000000000000000100000100
data &B00000000000000000000000111111000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout14:
data "Diehard"
data ""
data 0
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000100000000000
data &B00000000000000110000000000000000
data &B00000000000000010001110000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout15:
data "R-pentomino"
data ""
data 2
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000110000000
data &B00000000000000000000001100000000
data &B00000000000000000000000100000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout16:
data "Acorn"
data ""
data 2
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000001000000000000000
data &B00000000000000000010000000000000
data &B00000000000000011001110000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout17:
data "Complex 1"
data ""
data 2
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000010000000000000
data &B00000000000000001011000000000000
data &B00000000000000001010000000000000
data &B00000000000000001000000000000000
data &B00000000000000100000000000000000
data &B00000000000010100000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout18:
data "Complex 2"
data ""
data 2
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000001110100000000000000
data &B00000000000001000000000000000000
data &B00000000000000001100000000000000
data &B00000000000000110100000000000000
data &B00000000000001010100000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout19:
data "Complex 3"
data ""
data 2 ' 0 - No wrap around; 1 - Wrap around: 2 - Ask user
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000001111111101111100011100
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000


data "Empty"
data ""
data 0 ' 0 - No wrap around; 1 - Wrap around: 2 - Ask user
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000






