'
' Written by K F Horton October 2019

' Background information credits:
' https://en.wikipedia.org/wiki/Conway%27s_Game_of_Life
' https://en.wikipedia.org/wiki/Oscillator_(cellular_automaton)
' http://wwwhomes.uni-bielefeld.de/achim/freq_top_life.html
' http://conwaylife.com/wiki/Queen_bee_shuttle
' SSD1306 display drivers Peter Mather (edited by Peter Carnegie) 

Option Autorun On
Option default integer  
Option explicit  
cpu 48

Const maximum_pointer = 19
Const previous_switch = 10
Const next_switch = 9
Const debounce = 50
Const menu_delay = 1500
Const initial_screen = 4000
const IR_device_const = 510
const IR_next_const = 216
const IR_previous_const = 176
Const back_colour = rgb(black)
Const cell_colour = rgb(cyan)
Const text_colour = rgb(white)
Const text_colour1 = rgb(green)
Const BLK = 26


' Arrays to hold screen matrices. 
' The screen is 32 (x) by 20(y) cells and is surrounded by a border of empty (0) cells
' Thus the four corners of the screen are:
' element(01) = &H100000000;	element(01) = &H000000002
' element(20) = &H100000000;	element(20) = &H000000002

' Similarly the four corners of the border are:
' element(00) = &H200000000;	element(00) = &H000000001
' element(21) = &H200000000;	element(21) = &H000000001
Dim screen1(21), screen2(21)

Dim title as string  length 25
Dim subtitle as string length 25
Dim wrap_round, iterations
Dim pointer = 1
Dim automatic = 0
Dim IR_device, IR_next, IR_previous
Dim Device_Code, Key_Code
Dim IR_Code = 0
Dim temp
Dim get_ir_codes

setpin next_switch, DIN, PULLUP
setpin previous_switch, DIN, PULLUP
setpin BLK, DOUT
Pin(BLK) = 1

splash_screen

if (pin(next_switch) = 0) or (pin(previous_switch) = 0) then automatic = 1
 
IR Device_Code, Key_Code, IR_Int

var restore					' Retrieve stored IR codes

if (IR_next = 0) and (IR_previous = 0) then	' Set IR codes to default if not already set up
	IR_device = IR_device_const		' Default values
	IR_next = IR_next_const
	IR_previous = IR_previous_const
end if

get_ir_codes = timer				' Timer for initial splash screen
do while timer < get_ir_codes + initial_screen
	if key_Code then
		cls back_colour			' Interrupted by IR device so do IR setup
		key_code = 0
		text 80,0,"Set up IR remote","CT",1,1,text_colour,back_colour
		text 80,40,"Press next","CT",1,1,text_colour,back_colour
		do while key_code = 0
			IR_device = Device_Code
			IR_next = Key_Code
		loop
		key_code = 0
		text 80,40,"Press previous","CT",1,1,text_colour,back_colour
		do while key_code = 0
			IR_previous = Key_Code
		loop
		key_code = 0
		IR_code = 0
		var save IR_device, IR_next, IR_previous
		splash_screen
		get_ir_codes = timer		' Reset timer
	end if
loop

get_ir_codes = 0	' Only respond to correct device code

cls back_colour 

if automatic <> 0 then
	do
		temp = 0
		get_matrix pointer
		pause menu_delay * 2
		game_of_life
		pause menu_delay
		pointer = pointer + 1
		if pointer > maximum_pointer then pointer = 1
	loop
end if

do
	get_matrix pointer
	do while switch() = 0
	loop

	do while Switch() <> 0
		timer = 0
		do while timer < menu_delay
			if switch() = 0  then exit do
		loop 
		if switch() = 1 then ' Next
			pointer = pointer + 1
			if pointer > maximum_pointer then pointer = 1
			get_matrix pointer
		end if

		if switch() = 2 then
			pointer = pointer - 1 ' Previous
			if pointer < 1 then pointer = maximum_pointer 
			get_matrix pointer
		end if
	loop

	game_of_life
loop

sub splash_screen
	cls back_colour 
	text 80,0,"Conway's","CT",1,1,text_colour,back_colour
	text 80,20,"Game of life","CT",1,1,text_colour,back_colour
	text 0,40," Credits: Wikipedia","LT",1,1,text_colour1,back_colour
	text 0,60,"Conway's Game o Life","LT",1,1,text_colour1,back_colour
end sub

sub IR_Int
	print Device_code,Key_code
	if Device_Code = IR_device then
		select case Key_Code
			case IR_next
				IR_Code = 1
			case IR_previous
				IR_Code = 2
			case else
				IR_Code = 0
		end select
	end if
end sub

function switch()
	switch = 0
	if IR_Code <> 0 then
		switch = IR_Code
		exit function
	end if

	if (pin(next_switch) <> 0) and (pin(previous_switch) <> 0) then exit function
	pause debounce
	if pin(next_switch) = 0 then switch = 1
	if pin(previous_switch) = 0 then switch = 2
end function

sub get_matrix(no)
	Local y,a
	select case no ' Select the matrix
		case 1
			restore layout01
		case 2
			restore layout02
		case 3
			restore layout03
		case 4
			restore layout04
		case 5
			restore layout05
		case 6
			restore layout06
		case 7
			restore layout07
		case 8
			restore layout08
		case 9
			restore layout09
		case 10
			restore layout10
		case 11
			restore layout11
		case 12
			restore layout12
		case 13
			restore layout13
		case 14
			restore layout14
		case 15
			restore layout15
		case 16
			restore layout16
		case 17
			restore layout17
		case 18
			restore layout18
		case 19
			restore layout19
		case else
			restore layout01
	end select

	' Read the data
	read title
	read subtitle
	read wrap_round
	read iterations
	CLS
	text 80,20,title,"CT",1,1,text_colour,back_colour
	text 80,40,subtitle,"CT",1,1,text_colour,back_colour
	for y = 1 to 20
		read a
		screen1(y) = a << 1
	next y
end sub

sub game_of_life
	Local x, y, y1, y2, m1, m2, m3, m4, c, c1, c2, c3, c4

	' This subroutine is written for speed not compactness!

	' Any live cell with fewer than two live neighbours dies, as if by underpopulation.
	' Any live cell with two or three live neighbours lives on to the next generation.
	' Any live cell with more than three live neighbours dies, as if by overpopulation.
	' Any dead cell with exactly three live neighbours becomes a live cell, as if by reproduction

	' display initial screen
	cls
	for y = 1 to 20
		m1 = &H100000000
		for x = 1 to 32
			if screen1(y)and m1 then
'				box(x-1) * 4,(y-1) * 3,3,2,1,back_colour,cell_colour 
				box(x-1) * 5,(y-1) * 4,4,3,1,back_colour,cell_colour 
			end if
			m1 = m1 >> 1
		next x
	next y

	do
		' Determine whether screen wraps around or not
		y2 = 2
		if wrap_round then 
			y1 = 20
			m4 = &H000000002
		else
			y1 = 0
			m4 = &H200000000
		end if

		' Apply the rules to create screen2 from screen1
		for y = 1 to 20
			m1 = m4
			m2 = &H100000000
			m3 = &H080000000
			for x = 1 to 32
				if x = 1 then
					c1 = 0
					if screen1(y1) and m1 then c1 = c1 + 1
					if screen1(y) and m1 then c1 = c1 + 1
					if screen1(y2) and m1 then c1 = c1 + 1
				else
					c1 = c2
					if screen1(y) and m1 then c1 = c1 + 1
				end if

				if x < 3 then
					c2 = 0
					if screen1(y1) and m2 then c2 = c2 + 1
					if screen1(y2) and m2 then c2 = c2 + 1
				else
					c2 = c3
				end if

				c3 = 0
				if screen1(y1) and m3 then c3 = c3 + 1
				if screen1(y2) and m3 then c3 = c3 + 1

				c = c1 + c2 + c3 + c4

				if screen1(y)and m3 then c = c + 1

				if screen1(y)and m2 then
					if (c < 2) or (c > 3) then
						screen2(y) = screen2(y) and (m2 xor -1)
					else
						screen2(y) = screen2(y) or m2
					end if
				else
					if (c = 3) then
						screen2(y) = screen2(y) or m2
					else
						screen2(y) = screen2(y) and (m2 xor -1)
					end if
				end if

				m1 = m1 >> 1
				m2 = m2 >> 1
				m3 = m3 >> 1
				if wrap_round then
					if m1 = 1 then m1 = &H100000000
					if m3 = 1 then m3 = &H100000000
				end if
			next x
			y1 = y1 + 1
			y2 = y2 + 1
			if wrap_round then
				if y1 > 20 then y1 = 1
				if y2 > 20 then y2 = 1
			end if
		next y

		'Update the display from screen2
		for y = 1 to 20
			if screen1(y) <> screen2(y) then
				m1 = &H100000000
				for x = 1 to 32
					if ((screen1(y) xor screen2(y)) and m1) then 
						if screen2(y)and m1 then
							'box(x-1) * 4,(y-1) * 3,3,2,1,back_colour,cell_colour
							box(x-1) * 5,(y-1) * 4,4,3,1,back_colour,cell_colour
						else
							'box(x-1) * 4,(y-1) * 3,3,2,1,back_colour,back_colour
							box(x-1) * 5,(y-1) * 4,4,3,1,back_colour,back_colour
						end if
					end if
					m1 = m1 >> 1
				next x
			end if
		next y

		if (automatic = 0) and (switch() <> 0) then
			do
			IR_Code = 0
			loop until switch() = 0
			exit do ' Terminate if switch pushed
		end if

		' Determine whether screen wraps around or not
		y2 = 2
		if wrap_round then 
			y1 = 20
			m4 = &H000000002
		else
			y1 = 0
			m4 = &H200000000
		end if

		'Apply the rules to create screen1 from screen2
		for y = 1 to 20
			m1 = m4
			m2 = &H100000000
			m3 = &H080000000
			for x = 1 to 32
				if x = 1 then
					c1 = 0
					if screen2(y1) and m1 then c1 = c1 + 1
					if screen2(y) and m1 then c1 = c1 + 1
					if screen2(y2) and m1 then c1 = c1 + 1
				else
					c1 = c2
					if screen2(y) and m1 then c1 = c1 + 1
				end if

				if x < 3 then
					c2 = 0
					if screen2(y1) and m2 then c2 = c2 + 1
					if screen2(y2) and m2 then c2 = c2 + 1
				else
					c2 = c3
				end if

				c3 = 0
				if screen2(y1) and m3 then c3 = c3 + 1
				if screen2(y2) and m3 then c3 = c3 + 1

				c = c1 + c2 + c3 + c4

				if screen2(y)and m3 then c = c + 1

				if screen2(y)and m2 then
					if (c < 2) or (c > 3) then
						screen1(y) = screen1(y) and (m2 xor -1)
					else
						screen1(y) = screen1(y) or m2
					end if
				else
					if (c = 3) then
						screen1(y) = screen1(y) or m2
					else
						screen1(y) = screen1(y) and (m2 xor -1)
					end if
				end if
				m1 = m1 >> 1
				m2 = m2 >> 1
				m3 = m3 >> 1
				if wrap_round then
					if m1 = 1 then m1 = &H100000000
					if m3 = 1 then m3 = &H100000000
				end if
			next x
			y1 = y1 + 1
			y2 = y2 + 1
			if wrap_round then
				if y1 > 20 then y1 = 1
				if y2 > 20 then y2 = 1
			end if
		next y

		'Update the display from screen1
		for y = 1 to 20
			if screen1(y) <> screen2(y) then
				m1 = &H100000000
				for x = 1 to 32
					if ((screen1(y) xor screen2(y)) and m1) then 
						if screen1(y)and m1 then
							box(x-1) * 5,(y-1) * 4,4,3,1,back_colour,cell_colour
							' box(x-1) * 4,(y-1) * 3,3,2,1,back_colour,cell_colour
						else
							' box(x-1) * 4,(y-1) * 3,3,2,1,back_colour,back_colour
							box(x-1) * 5,(y-1) * 4,4,3,1,back_colour,back_colour
						end if
					end if
					m1 = m1 >> 1
				next x
			end if
		next y

	if automatic <> 0 then
		iterations = iterations - 2
		if iterations <=0 then exit do
	else if switch() <> 0 then ' Terminate if switch pressed
		IR_Code = 0
		do
		loop until switch() = 0
		exit do
	end if
	loop
end sub

layout01:
data "Still lives and"
data "Binary oscillators"
data 0 ' 0 - No wrap around; 1 - Wrap around
data 10 ' Number of iterations when automatic
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00110000110000110000110000010000
data &B00110001001001001000101000101000
data &B00000000110000101000010000010000
data &B00000000000000010000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00001110000001110000000110000000
data &B00000000000011100000000110000000
data &B00000000000000000000000001100000
data &B00000000000000000000000001100000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000


layout02:
data "Pulsar (3) and"
data "Pentadecathlon (15)"
data 0
data 45
data &B00000000000000000000000000000000
data &B00001110001110000000000000000000
data &B00000000000000000000000000000000
data &B00100001010000100000000000000000
data &B00100001010000100000000000000000
data &B00100001010000100000000000000000
data &B00001110001110000000000000000000
data &B00000000000000000000000000100000
data &B00001110001110000000000001010000
data &B00100001010000100000000000100000
data &B00100001010000100000000000100000
data &B00100001010000100000000000100000
data &B00000000000000000000000000100000
data &B00001110001110000000000000100000
data &B00000000000000000000000001010000
data &B00000000000000000000000000100000
data &B00000000000000000000000000100000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout03:
data "Star (3) and"
data "cross (3)"
data 0
data 15
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000001110000000000000011000000
data &B00000000000000000000000111100000
data &B00000101010100000000000000000000
data &B00000000000000000000010100101000
data &B00010100000101000000110000001100
data &B00010000000001000000110000001100
data &B00010100000101000000010100101000
data &B00000000000000000000000000000000
data &B00000101010100000000000111100000
data &B00000000000000000000000011000000
data &B00000001110000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout04:
data "French kiss (3)"
data "and Octagon (5)"
data 0
data 25
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000110000000000000000000
data &B00000000000100000000000000000000
data &B00000000110100000000000100100000
data &B00000001001000000000001011010000
data &B00000001000000000000000100100000
data &B00000000010000000000000100100000
data &B00000010010000000000001011010000
data &B00000101100000000000000100100000
data &B00000100000000000000000000000000
data &B00001100000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout05:
data "Clock (4) and"
data "Pinwheel (4)"
data 0
data 20
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000110000000000000011000000
data &B00000000110000000000000011000000
data &B00000000000000000000000000000000
data &B00000011110000000000001111000000
data &B00110100001000000011010000100000
data &B00110101101000000011010010100000
data &B00000100011011000000010001101100
data &B00000100001011000000010100101100
data &B00000011110000000000001111000000
data &B00000000000000000000000000000000
data &B00000011000000000000001100000000
data &B00000011000000000000001100000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout06:
data "Pentoad (5) and"
data "Fumarole (5)"
data 0
data 25
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000110000000000000000
data &B00000000000000100000000000000000
data &B00000000000010100000000100100000
data &B00000000000011000000011100111000
data &B00000000110000000000001100110000
data &B00000000011000000000000100100000
data &B00000000110000000000010100101000
data &B00000000011000000000011000011000
data &B00000110000000000000000000000000
data &B00001010000000000000000000000000
data &B00001000000000000000000000000000
data &B00011000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout07:
data "Kok's galaxy (8)"
data ""
data 0
data 40
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000001010010000000000000
data &B00000000000001110101100000000000
data &B00000000000010000001000000000000
data &B00000000000001000001100000000000
data &B00000000000000000000000000000000
data &B00000000000011000001000000000000
data &B00000000000001000000100000000000
data &B00000000000011010111000000000000
data &B00000000000000100101000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout08:
data "Cloverleaf (4) and"
data "Figure 8 (8)"
data 0
data 40
data &B00000000000000000000000000000000
data &B00000000101000000000000000000000
data &B00000011101110000000000000000000
data &B00000100010001000000000000000000
data &B00000101000101000000000000000000
data &B00000011010110000000000000000000
data &B00000000000000000000000000000000
data &B00000011010110000000000000000000
data &B00000101000101000000000000000000
data &B00000100010001000000000000000000
data &B00000011101110000000000000000000
data &B00000000101000000000000000000000
data &B00000000000000000001110000000000
data &B00000000000000000001110000000000
data &B00000000000000000001110000000000
data &B00000000000000000000001110000000
data &B00000000000000000000001110000000
data &B00000000000000000000001110000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout09:
data "Unix (6) and"
data "Tumbler (14)"
data 0
data 56
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000001000000000000000000000000
data &B00000010111100000000000000000000
data &B00000101011100000000000000000000
data &B00001010000000000000000000000000
data &B00000100000000000000000000000000
data &B00000110000000000000000000000000
data &B00000110000000000000000000000000
data &B00000110000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000100000100000000
data &B00000000000000001010001010000000
data &B00000000000000000011011000000000
data &B00000000000000000110001100000000
data &B00000000000000000011011000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout10:
data "Mazing (4) Mold (4)"
data "and Blocker (8)"
data 0
data 40
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000011100000000000000000000000
data &B00000011100000000000000000000000
data &B00001100111000000000000000000000
data &B00001100000000000000000000000000
data &B00001110000000000000000000000000
data &B00000010000000000000000000000000
data &B00000010000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000011000000000
data &B00000000000000000000100100000000
data &B00000000000000000000101010000000
data &B00000000000000000000010111000000
data &B00000000110000000000000111000000
data &B00001100001111000000000000000000
data &B00001100110111000000000000000000
data &B00000000100000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout11:
data "Queen bee"
data "shuttle (30)"
data 0
data 120
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000100000000000000
data &B00000000000000001100000000000000
data &B00000000000000011000011000000000
data &B00000110000000111000011001100000
data &B00000110000000011000011001100000
data &B00000000000000001100000000000000
data &B00000000000000000100000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout12:
data "Gliders"
data ""
data 1
data 168
data &B00100000001000000010000000100000
data &B00010000000100000001000000010000
data &B01110000011100000111000001110000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout13:
data "Spaceships"
data ""
data 1
data 128
data &B00000000100000000000000000000000
data &B00000010001000000000000000000000
data &B00000100000000000000000000000000
data &B00000100001000000000000000000000
data &B00000111110000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000011110000000000000
data &B00000000000000010001000000000000
data &B00000000000000010000000000000000
data &B00000000000000001001000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000110000
data &B00000000000000000000000010000100
data &B00000000000000000000000100000000
data &B00000000000000000000000100000100
data &B00000000000000000000000111111000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout14:
data "Diehard"
data ""
data 0
data 190
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000100000000000
data &B00000000000000110000000000000000
data &B00000000000000010001110000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout15:
data "R-pentomino"
data ""
data 1
data 234
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000110000000
data &B00000000000000000000001100000000
data &B00000000000000000000000100000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout16:
data "Acorn"
data ""
data 1
data 80
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000001000000000000000
data &B00000000000000000010000000000000
data &B00000000000000011001110000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout17:
data "Complex 1"
data ""
data 1
data 392
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000010000000000000
data &B00000000000000001011000000000000
data &B00000000000000001010000000000000
data &B00000000000000001000000000000000
data &B00000000000000100000000000000000
data &B00000000000010100000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout18:
data "Complex 2"
data ""
data 1
data 348
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000001110100000000000000
data &B00000000000001000000000000000000
data &B00000000000000001100000000000000
data &B00000000000000110100000000000000
data &B00000000000001010100000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

layout19:
data "Complex 3"
data ""
data 1 ' 0 - No wrap around; 1 - Wrap around
data 126
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000001111111101111100011100
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000


data "Empty"
data ""
data 0 ' 0 - No wrap around; 1 - Wrap around
data 200000 ' Number of iterations when automatic
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000
data &B00000000000000000000000000000000

  
' IPS DRIVER                                   ' WARNING: DO NOT CHANGE ANY VALUES or CODE below!!!!

' ==========

'

CSub ST7735S

   00000232

    'spi_write_data

    27BDFFE0 AFBF001C AFB10018 AFB00014 309100FF 3C109D00 8E030090 8E02001C

    8064002C 0040F809 24050006 8E030090 8E02001C 8064002D 0040F809 24050005

    3C02BF80 AC515820 3C03BF80 8C625810 30420080 1040FFFD 3C02BF80 8C425820

    3C029D00 8C430090 8C42001C 8064002D 0040F809 24050006 8FBF001C 8FB10018

    8FB00014 03E00008 27BD0020

    'spi_write_command

    27BDFFE0 AFBF001C AFB10018 AFB00014 309100FF 3C109D00 8E030090 8E02001C

    8064002C 0040F809 24050005 8E030090 8E02001C 8064002D 0040F809 24050005

    3C02BF80 AC515820 3C03BF80 8C625810 30420080 1040FFFD 3C02BF80 8C425820

    3C029D00 8C430090 8C42001C 8064002D 0040F809 24050006 8FBF001C 8FB10018

    8FB00014 03E00008 27BD0020

    'spi_write_cd

    27BDFFD8 AFBF0024 AFB10020 AFB0001C AFA60030 AFA70034 00A08821 27A20030

    AFA20010 308400FF 0411FFD2 00000000 1A20000A 00008021 8FA20010 24430004

    AFA30010 90440000 0411FFA7 00000000 26100001 1611FFF9 8FA20010 8FBF0024

    8FB10020 8FB0001C 03E00008 27BD0028

    'DefineRegion

    27BDFFD8 AFBF0024 AFB10020 AFB0001C 3C039D00 8C630090 90630015 30630001

    1060000A 00E01021 3C039D00 8C63008C 8C710000 00B18021 00F18821 8C620004

    00443821 10000009 00C23021 3C039D00 8C63008C 8C680004 01043821 01063021

    8C710000 00B18021 00518821 00061203 AFA20010 AFA60014 2404002A 24050004

    00073203 0411FFC2 00000000 00111203 AFA20010 AFB10014 2404002B 24050004

    00103203 02003821 0411FFB9 00000000 2404002C 0411FF93 00000000 8FBF0024

    8FB10020 8FB0001C 03E00008 27BD0028

    'DrawBitmapSPI

    27BDFFB8 AFBF0044 AFBE0040 AFB7003C AFB60038 AFB50034 AFB40030 AFB3002C

    AFB20028 AFB10024 AFB00020 0080B021 00A0F021 00C0A021 AFA70054 8FA4005C

    8FA30060 3C029D00 8C420094 8C420000 02C2102B 104000C3 8FB50064 3C029D00

    8C420098 8C420000 00A2102B 104000BD 8FA20058 70462802 00B63021 04C000B9

    70471002 005E2821 04A000B6 00003821 2BC50000 03C5380A 00E02821 3C07BF80

    8CE85830 AFA80010 8CE85800 AFA80014 8CE85840 AFA80018 ACE05800 3C080001

    35088260 ACE85800 ACE05830 24080C00 ACE85840 7C901340 00043C03 2408FFF8

    00E83824 02078025 321000FF 7C9120C0 00042143 2407FFE0 00872024 02248825

    323100FF 7C721340 00032403 00884024 02489025 325200FF 7C7320C0 00031943

    00673824 02679825 327300FF 24A7FFFF 02C02021 24C6FFFF 00E23821 0411FF7C

    00000000 3C179D00 8EE30090 8EE2001C 8064002C 0040F809 24050006 8EE30090

    8EE2001C 8064002D 0040F809 24050005 0014C823 8FA20054 70547802 25EFFFFF

    0280B821 00005821 0000C021 8FAD0058 3C069D00 240C0001 1000004D 3C02BF80

    27DE0001 27C3FFFF 04600044 00000000 8CC30098 8C630000 007E182B 1460006A

    8FBF0044 1E80002D 01E04821 1000003B 00000000 24630001 2464FFFF 04800020

    00000000 8CC40094 8C840000 0083202B 1480001B 00000000 91040000 00872024

    1080000D 00000000 8C445810 30840002 1480FFFD 00000000 AC505820 8C445810

    30840002 1480FFFD 00000000 AC515820 1000000B 00000000 8C445810 30840002

    1480FFFD 00000000 AC525820 8C445810 30840002 1480FFFD 00000000 AC535820

    5465FFDD 24630001 254A0001 15540005 2529FFFF 10000011 00000000 02C01821

    00005021 014B2021 24850007 28880000 00A8200B 000440C3 02A84021 000927C3

    00042742 01243821 30E70007 00E43823 00EC3804 1000FFC7 006D2821 57CEFFB9

    27DE0001 27180001 01F97821 01775821 8FA40054 0304182A 10600005 8FA50058

    1CA0FFAF 03C57021 1000FFF7 27180001 3C02BF80 8C435810 30630080 1060FFFD

    00000000 10000002 3C02BF80 8C435820 8C435810 30630020 1060FFFC 00000000

    3C02BF80 AC405800 24040040 3C03BF80 AC645814 8FA70010 AC475830 8FA80014

    AC485800 8FA30018 AC435840 3C029D00 8C430090 8C42001C 8064002D 0040F809

    24050006 8FBF0044 8FBE0040 8FB7003C 8FB60038 8FB50034 8FB40030 8FB3002C

    8FB20028 8FB10024 8FB00020 03E00008 27BD0048

    'DrawRectangleSPI

    27BDFFC0 AFBF003C AFBE0038 AFB70034 AFB60030 AFB5002C AFB40028 AFB30024

    AFB20020 AFB1001C AFB00018 8FA30050 3C02BF80 8C575830 8C5E5800 8C485840

    AFA80010 AC405800 3C080001 35088260 AC485800 AC405830 24080C00 AC485840

    0086102A 14400005 00A7102A 00801021 00C02021 00403021 00A7102A 14400004

    28930000 00A01021 00E02821 00403821 0013200B 00809821 3C029D00 8C420094

    8C420000 0082402B 2444FFFF 0088980A 28D40000 0014300B 00C0A021 00C2202B

    2442FFFF 0044A00A 28B50000 0015280B 00A0A821 3C029D00 8C420098 8C420000

    00A2282B 2444FFFF 0085A80A 28F60000 0016380B 00E0B021 00E2202B 2442FFFF

    0044B00A 7C711340 00032403 2402FFF8 00821024 02228825 323100FF 7C7020C0

    00031943 2402FFE0 00621824 02038025 321000FF 02602021 02A02821 02803021

    02C03821 0411FE95 00000000 3C129D00 8E430090 8E42001C 8064002C 0040F809

    24050006 8E430090 8E42001C 8064002D 0040F809 24050005 24020001 00539823

    0274A021 00552023 00962021 70942002 1080000E 2484FFFF 3C02BF80 8C435810

    30630002 1460FFFD 00000000 AC515820 8C435810 30630002 1460FFFD 00000000

    AC505820 1480FFF5 2484FFFF 3C03BF80 8C625810 30420080 1040FFFD 3C02BF80

    8C425810 30420020 14400006 3C02BF80 8C435820 8C435810 30630020 1060FFFC

    00000000 3C02BF80 AC405800 24040040 3C03BF80 AC645814 AC575830 AC5E5800

    8FA30010 AC435840 3C029D00 8C430090 8C42001C 8064002D 0040F809 24050006

    8FBF003C 8FBE0038 8FB70034 8FB60030 8FB5002C 8FB40028 8FB30024 8FB20020

    8FB1001C 8FB00018 03E00008 27BD0040

    'getFPC

    27BDFFF8 AFBF0004 00852023 03E42021 ACC40000 8FBF0004 03E00008 27BD0008

    'pstring

    27BDFFE0 AFBF001C AFB00018 00808021 00002021 3C059D00 24A508A4 27A60010

    0411FFEF 00000000 8FA40010 3C029D00 8C42002C 0040F809 02042021 8FBF001C

    8FB00018 03E00008 27BD0020

    'main

    27BDFF88 AFBF0074 AFBE0070 AFB7006C AFB60068 AFB50064 AFB40060 AFB3005C

    AFB20058 AFB10054 AFB00050 00809021 00A08821 00C09821 00E08021 8FB40088

    8FB6008C 8FB50090 00002021 3C059D00 24A50928 27A60048 0411FFCE 00000000

    3C029D00 8C430090 8E240000 A064002E 8C430090 8E440000 A064002C 8C430090

    8E640000 A064002D 8C430090 8E040000 A0640015 8C430090 92040000 24840002

    A0640015 8C420090 80430015 28640005 5480000A 24030014 3C059D00 2463FFFC

    A0430015 8CA20090 80430015 28640005 1080FFFB 2463FFFC 24030014 A0430014

    3C029D00 8C42008C 2403001A 12A00007 AC430000 3C029D00 8C42008C 8C440000

    8EA30000 00831821 AC430000 3C029D00 8C42008C 24030001 12C00008 AC430004

    3C029D00 8C42008C 8C440004 8EC30000 00831821 10000005 AC430004 3C029D00

    8C42008C 2403001A AC430000 3C109D00 8E030090 8E020010 8064002E 24050008

    0040F809 00003021 8E030090 8E020010 8064002E 24050065 0040F809 00003021

    8E030090 8E02001C 8064002E 0040F809 24050006 8E030090 8E020010 8064002C

    24050008 0040F809 00003021 8E030090 8E020010 8064002C 24050065 0040F809

    00003021 8E030090 8E02001C 8064002C 0040F809 24050006 8E030090 8E020010

    8064002D 24050008 0040F809 00003021 8E030090 8E020010 8064002D 24050065

    0040F809 00003021 8E030090 8E02001C 8064002D 0040F809 24050006 3C02BF81

    8C44F220 7C84D800 3C020661 3442A053 1082000B 24030050 3C02BF81 8C43F220

    7C63D800 3C020660 3442A053 00621826 24020050 2404000C 0083100B 00401821

    3C029D00 8C420088 00621821 8C640000 24030064 54830007 00008821 3C03BF80

    8C715830 8C775800 8C7E5840 10000003 3C03BF81 0000B821 3C03BF81 8C65F220

    7CA5D800 3C040661 3484A053 10A4000B 24030050 3C03BF81 8C64F220 7C84D800

    3C030660 3463A053 00831826 24040050 2405000C 00A3200B 00801821 00621021

    8C430000 24020065 1062008E 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800

    3C030661 3463A053 10A3000B 24040014 3C03BF81 8C64F220 7C84D800 3C030660

    3463A053 00832026 24030014 24050003 00A4180B 00602021 24050008 0040F809

    00003021 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800 3C030661 3463A053

    10A3000B 24040014 3C03BF81 8C64F220 7C84D800 3C030660 3463A053 00832026

    24030014 24050003 00A4180B 00602021 24050065 0040F809 00003021 3C029D00

    8C420010 3C03BF81 8C65F220 7CA5D800 3C030661 3463A053 10A3000B 24040029

    3C03BF81 8C64F220 7C84D800 3C030660 3463A053 00832026 24030029 2405000E

    00A4180B 00602021 24050002 0040F809 00003021 3C029D00 8C420010 3C03BF81

    8C65F220 7CA5D800 3C030661 3463A053 10A3000B 24040029 3C03BF81 8C64F220

    7C84D800 3C030660 3463A053 00832026 24030029 2405000E 00A4180B 00602021

    24050065 0040F809 00003021 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800

    3C030661 3463A053 10A3000B 2404000E 3C03BF81 8C64F220 7C84D800 3C030660

    3463A053 00832026 2403000E 24050019 00A4180B 00602021 24050008 0040F809

    00003021 3C029D00 8C420010 3C03BF81 8C65F220 7CA5D800 3C030661 3463A053

    10A3000B 2404000E 3C03BF81 8C64F220 7C84D800 3C030660 3463A053 00832026

    2403000E 24050019 00A4180B 00602021 24050065 0040F809 00003021 3C02BF81

    8C43FA84 24040001 7C831804 AC43FA84 3C02BF81 8C43FB04 24040003 7C831804

    AC43FB04 3C02BF81 8C43FA84 24040001 7C831804 AC43FA84 3C02BF81 8C44FB04

    24030003 7C641804 AC44FB04 3C02BF80 34048060 AC445800 AC435830 24030C00

    AC435840 16200005 3C109D00 8C515830 8C575800 8C5E5840 3C109D00 8E030090

    8E02001C 8064002E 0040F809 24050006 8E020004 0040F809 24042710 8E030090

    8E02001C 8064002E 0040F809 24050005 8E020004 0040F809 24042710 8E030090

    8E02001C 8064002E 0040F809 24050006 8E020004 0040F809 24042710 24040011

    0411FC78 00000000 8E020004 3C040007 0040F809 3484A120 2410002D AFB00010

    240400B1 24050003 24060001 2407002C 0411FC8F 00000000 AFB00010 240400B2

    24050003 24060001 2407002C 0411FC88 00000000 AFB00010 24020001 AFA20014

    2402002C AFA20018 AFB0001C 240400B3 24050006 24060001 2407002C 0411FC7C

    00000000 240400B4 24050001 24060007 0411FC77 00000000 24020084 AFA20010

    240400C0 24050003 240600A2 24070002 0411FC6F 00000000 240400C1 24050001

    240600C5 0411FC6A 00000000 240400C2 24050002 2406000A 00003821 0411FC64

    00000000 240400C3 24050002 2406008A 2407002A 0411FC5E 00000000 240400C4

    24050002 2406008A 240700EE 0411FC58 00000000 240400C5 24050001 2406000E

    0411FC53 00000000 1280000A 24040021 8E820000 8E830004 00431025 24030020

    0062200B 0411FC27 00000000 10000004 2404003A 0411FC23 00000000 2404003A

    24050001 24060005 0411FC41 00000000 AFA00010 2402007F AFA20014 2404002A

    24050004 00003021 00003821 0411FC38 00000000 AFA00010 2402009F AFA20014

    2404002B 24050004 00003021 00003821 0411FC2F 00000000 24120007 AFB20010

    24020012 AFA20014 24140037 AFB40018 24020032 AFA2001C 24100029 AFB00020

    2413002D AFB30024 24020025 AFA20028 AFB0002C 2402002B AFA20030 24020039

    AFA20034 AFA00038 24160001 AFB6003C 24020003 AFA20040 24150010 AFB50044

    240400E0 24050010 24060002 2407001C 0411FC0F 00000000 AFB20010 24020006

    AFA20014 2402002E AFA20018 2403002C AFA3001C AFB00020 AFB30024 AFA20028

    AFA2002C AFB40030 2402003F AFA20034 AFA00038 AFA0003C 24020002 AFA20040

    AFB50044 240400E1 24050010 24060003 2407001D 0411FBF6 00000000 24040013

    0411FBD0 00000000 3C109D00 8E020004 0040F809 24042710 24040029 0411FBC9

    00000000 8E020090 80420015 14560007 3C029D00 24040036 24050001 240600A8

    0411FBE3 00000000 3C029D00 8C420090 80430015 24020002 14620007 3C029D00

    24040036 24050001 240600C8 0411FBD8 00000000 3C029D00 8C420090 80430015

    24020003 14620007 3C029D00 24040036 24050001 24060068 0411FBCD 00000000

    3C029D00 8C420090 80430015 24020004 14620007 3C029D00 24040036 24050001

    24060008 0411FBC2 00000000 3C029D00 8C420090 90420015 30420001 10400008

    3C029D00 8C430098 24040050 AC640000 8C420094 240300A0 10000007 AC430000

    8C430094 24040050 AC640000 8C420098 240300A0 AC430000 8FA50048 3C029D00

    8C430048 3C049D00 248405EC 00852021 AC640000 8FA50048 8C43004C 3C049D00

    24840258 00852021 AC640000 8C430048 8C440094 8C860000 8C420098 8C470000

    AFA00010 8C620000 00002021 00002821 24C6FFFF 0040F809 24E7FFFF 3C02BF80

    AC515830 AC575800 AC5E5840 3C049D00 24841314 0411FD67 00000000 8FBF0074

    8FBE0070 8FB7006C 8FB60068 8FB50064 8FB40060 8FB3005C 8FB20058 8FB10054

    8FB00050 03E00008 27BD0078

    '.rodata

    'startup

    37375453 20533533 76697264 6C207265 6564616F 000A0D64

End CSub



Sub mm.startup                        ' system SUB to ensure IPS driver loaded at Power-Up

	ST7735S 22,23,21, 1,0,0,0         ' DCpin, RESETpin, CSpin, orientation (1-4)[, invertdisplay(0,1)], xshift, yshift


End Sub

