//basic IO setup and defines

#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  

//local         mains detect on RC4
//              status LED (active high) on RA4
//upstream      incoming data on RC5
//downstream    chain sense on RC3 (AN7)
//              latch on RA2
//              data on RC0
//              clock on RC1
//              clear on RC2

#define AC_IN RC4
#define STATUS_LED LATA4
#define DMX_IN RC5
#define CHAIN_SENSE (7)
#define SR_CLR LATC2
#define SR_LAT LATA2
#define SR_DAT LATC0
#define SR_CLK LATC1

void ioInit(void);
void SPItx(char c);
void sendBuffer(unsigned char* p); //send contents of p[0] to p[3]
int getADC(char chan);

#endif	/* IO_H */

