#include "io.h"

void ioInit(void) {
    //mostly no analog functions
    ANSELA=0;
    ANSELC=0;       
    ANSELCbits.ANSC3=1; //chain sense
    
    //disable individual pullups
    WPUA=0;
    WPUC=0;

    //set tris bits on output drivers
    TRISA4=0;   //LED
    STATUS_LED=0;
    TRISC2=0;   //CLR
    SR_CLR=0;   
    TRISA2=0;   //LATCH
    SR_LAT=0;   
    
    //IOC setting for AC IN (RC4)
    //INLVLC4=0;          //TTL level input instead of ST
    //IOCCP4=1;           //both positive
    //IOCCN4=1;           //and negative changes
    //IOCCF4=0;           //clear flags
    //IOCIE=1;            //enable interrupt (needs GIE)

    //ADC
    ADCON0=0;            //reset
    ADCON1= 0b10100000;  //1=right align, 010=1/32 FOSC, 00=NA, 00=V+REF=VDD
    ADCON2=0;            //no autoconvert
    ADCON0bits.ADON=1;   //turn on

    //PPS
    PPSLOCK=0x55;
    PPSLOCK=0xAA;
    PPSLOCKED=0;
    RC1PPS=0b10000; //C1 is SCK
    RC0PPS=0b10010; //C0 iS SDO
    PPSLOCKED=1;

    //MSSP for data out
    TRISC1=0;       //output for SCK
    TRISC0=0;       //output for SDO
    SSP1CON1=0;     //reset MSSP
    //SSP1CON1bits.SSPM=2;    //SPI master, FOSC/64
    SSP1CON1bits.SSPM=10;   //SPI master, derived from SSP1ADD
    SSP1CON1bits.CKP=0;     //
    SSP1STATbits.CKE=1;     //
    //SSP1ADD=127;            //CLK=((ADD<7:0> + 1) *4)/FOSC
    SSP1ADD=7;              //CLK=((ADD<7:0> + 1) *4)/FOSC
    SSPEN=1;        //MSSP on
}

void SPItx(char c){ //single byte
    PIR1bits.SSP1IF=0;
    SSPBUF=c;
    while(PIR1bits.SSP1IF==0){}
    SR_LAT=1;
    SR_LAT=0;
    SR_CLR=1;
}

void sendBuffer(unsigned char* p){ //send contents of p[0] to p[3]
    PIR1bits.SSP1IF=0;
    SSPBUF=p[3];    //work backwards
    while(PIR1bits.SSP1IF==0){}
    PIR1bits.SSP1IF=0;
    SSPBUF=p[2];
    while(PIR1bits.SSP1IF==0){}
    PIR1bits.SSP1IF=0;
    SSPBUF=p[1];
    while(PIR1bits.SSP1IF==0){}
    PIR1bits.SSP1IF=0;
    SSPBUF=p[0];
    while(PIR1bits.SSP1IF==0){}
    SR_LAT=1;
    SR_LAT=0;
    SR_CLR=1;
}

int getADC(char chan){   //get result from selected channel
    int j;
    ADCON0bits.CHS=chan;
    ADCON0bits.ADGO=1;          //start
    while(ADCON0bits.ADGO){}    //wait till done
    j=ADRES;        
    return j;    
}


