// remap_mlx90614.ino

/*
 >>> [format(x, '#04x') for x in range(1,128)]
[
    '0x00', '0x01', '0x02', '0x03', '0x04', '0x05', '0x06', '0x07',
    '0x08', '0x09', '0x0a', '0x0b', '0x0c', '0x0d', '0x0e', '0x0f',
    '0x10', '0x11', '0x12', '0x13', '0x14', '0x15', '0x16', '0x17',
    '0x18', '0x19', '0x1a', '0x1b', '0x1c', '0x1d', '0x1e', '0x1f',
    '0x20', '0x21', '0x22', '0x23', '0x24', '0x25', '0x26', '0x27',
    '0x28', '0x29', '0x2a', '0x2b', '0x2c', '0x2d', '0x2e', '0x2f',
    '0x30', '0x31', '0x32', '0x33', '0x34', '0x35', '0x36', '0x37',
    '0x38', '0x39', '0x3a', '0x3b', '0x3c', '0x3d', '0x3e', '0x3f',
    '0x40', '0x41', '0x42', '0x43', '0x44', '0x45', '0x46', '0x47',
    '0x48', '0x49', '0x4a', '0x4b', '0x4c', '0x4d', '0x4e', '0x4f',
    '0x50', '0x51', '0x52', '0x53', '0x54', '0x55', '0x56', '0x57',
    '0x58', '0x59', '0x5a', '0x5b', '0x5c', '0x5d', '0x5e', '0x5f',
    '0x60', '0x61', '0x62', '0x63', '0x64', '0x65', '0x66', '0x67',
    '0x68', '0x69', '0x6a', '0x6b', '0x6c', '0x6d', '0x6e', '0x6f',
    '0x70', '0x71', '0x72', '0x73', '0x74', '0x75', '0x76', '0x77',
    '0x78', '0x79', '0x7a', '0x7b', '0x7c', '0x7d', '0x7e', '0x7f'
]
 */


 #include "i2cmaster.h"

 // New slave address (default is 0x5A)
 byte NewMLXAddr = 0x2B;

 void setup(){
   Serial.begin(9600);
   Serial.println("Setup...");
   // Initialise some stuff
   i2c_init();
   PORTC = (1 << PORTC4) | (1 << PORTC5);
   delay(5000);
   // Read on universal address (0)
   ReadAddr(0);
   // Change to new address NewMLXAddr
   ChangeAddr(NewMLXAddr, 0x00);
   // Read on universal address (0)
   ReadAddr(0);
   Serial.println("**---READY---**");
   // Signal user to cycle power
   Serial.println("> [setup] Cycle power NOW to store new address - you have 10 seconds");
   delay(10000);
   // Read on universal address (0)
   ReadAddr(0);
   Serial.println("  Warning, next ReadTemp() may fail if address has not been set.");
   ReadTemp(NewMLXAddr);
   Serial.println("**---DONE---**");
 }

 /**
 * Read temperature from MLX at new address once setup() is done.
 *
 */
 void loop(){
     delay(5000);
     ReadTemp(NewMLXAddr);
 }

 /**
 * Changes the address of the MLX to NewAddr1.
 *
 */
 word ChangeAddr(byte NewAddr1, byte NewAddr2) {
   Serial.print("> [ChangeAddr] Will change address to: ");
   Serial.println(NewAddr1, HEX);
   i2c_start_wait(0 + I2C_WRITE);
   i2c_write(0x2E);
   i2c_write(0x00);
   i2c_write(0x00);

   if (i2c_write(0x6F) == 0) {
     i2c_stop();
     Serial.println("> [ChangeAddr] Data erased.");
   }
   else {
     i2c_stop();
     Serial.println("> [ChangeAddr] Failed to erase data");
     return -1;
   }

   Serial.print("> [ChangeAddr] Writing data: ");
   Serial.print(NewAddr1, HEX);
   Serial.print(", ");
   Serial.println(NewAddr2, HEX);

   for (int a = 0; a != 256; a++) {
     i2c_start_wait(0 + I2C_WRITE);
     i2c_write(0x2E);
     i2c_write(NewAddr1);
     i2c_write(NewAddr2);

     if (i2c_write(a) == 0) {
       i2c_stop();
       delay(100);
       Serial.print("> [ChangeAddr] Found correct CRC: 0x");
       Serial.println(a, HEX);
       return a;
     }
   }
   i2c_stop();
   Serial.println("> [ChangeAddr] Correct CRC not found");
   return -1;
 }

 /**
 * Reads the MLX address.
 *
 */
 byte ReadAddr(byte MLXAddress) {
   byte NewMLXAddress;
   Serial.println("> [ReadAddr] Reading address");
   if (MLXAddress == 0) {
     Serial.print("  Using MLX univeral address");
   } else {
     Serial.print("  Using MLX address: ");
     Serial.print(MLXAddress, HEX);
   }
   Serial.print(", Data: ");
   i2c_start_wait(MLXAddress + I2C_WRITE);
   i2c_write(0x2E);
   i2c_rep_start(MLXAddress + I2C_READ);

   NewMLXAddress = i2c_readAck();
   Serial.print(NewMLXAddress, HEX);
   Serial.print(", ");
   Serial.print(i2c_readAck(), HEX);
   Serial.print(", ");
   Serial.println(i2c_readNak(), HEX);
   i2c_stop();
   return NewMLXAddress;
 }
