//##############################################################################
//    filename:        MCP4822.h
//##############################################################################
//    header file LCD library for mcp4822 spi dac ...
//##############################################################################
//      Author:            P.Prosser
//      Company:           
//      Adapted:            
//      Revision:           0.0 (for XC32)
//      Date:         	    Aug 2024
//     	Compiler            
//      MPLAB X             
//      MCC                 
//##############################################################################
//
//==============================================================================
//      LCD library FUNCTIONS:
//

#ifndef MCP4822_H
#define MCP4822_H

#include <stdint.h>

#define NumBits 12  // for MCP4822
#define REF_VOLTAGE 2.048
#define Max_Voltage  (REF_VOLTAGE * 2)
#define MCP4822_Gain_1 0
#define MCP4822_Active 1
#define MCP4822_InActive 0
#define MCP4822_Channel_A 0
#define MCP4822_Channel_B 1
#define DAC_Full_Scale ((2<<12)-1)
#define MCP4822_Ref_V_Nom 2.048
#define MCP4822_Settle_Us 5
#define MCP4822_Settle_Time CORETIMER_DelayMs(MCP4822_Settle_Us * 4);     /* Delay after current set */

typedef void (*MCP4822_regWrite) (const uint8_t* data,const uint8_t len);
typedef void (*MCP4822_CSenable) (const uint32_t* GPIO_port,const uint8_t GPIO_pin);
typedef void (*MCP4822_CSdisable) (const uint32_t* GPIO_port,const uint8_t GPIO_pin);

//typedef struct {
//    const uint8_t           SS_pin;
//    const uint32_t*         SS_Port;
//    const MCP4822_regWrite  writeFunction;
//    const MCP4822_CSenable  CSenableFunction;
//    const MCP4822_CSenable  CSdisableFunction;
//} MCP4822_device;


#define DAC_Time_us 1

#define MCP4822_CS_Assert SPI_SS1_Clear() 
#define MCP4822_CS_Clear SPI_SS1_Set() 
#define MCP4822_LDAC_Assert LDAC_L_Clear() 
#define MCP4822_LDAC_Clear LDAC_L_Set() 

void MCP4822_setValue(int Output_Sel, int Gain_L, int Shut_Down_L, int Value_To_Write);

void MCP4822_setVoltage(int Channel, float Voltage);

void MCP4822_set_DAC_VAL(int Channel, int Value);
void MCP4822_Init();

void MCP4822_Shut_Down();

#endif