#include "nvm.h"

unsigned char EEPROMread(unsigned int add){
    //FSR techniques should work, but appear to be affected by silicon errata
    //unsigned char* d;
    //d=(unsigned char*)(EEPROM_START_FSR+add);
    //return *d;
    //return *((unsigned char*)(EEPROM_START_FSR+add));    
    NVMCON1bits.NVMREGS=1;      //EEPROM, UID, CONFIG
    add=add+EEPROM_START;
    NVMADRH=add>>8;
    NVMADRL=add;
    NVMCON1bits.RD=1;
    return NVMDATL;        
}

void EEPROMwrite(unsigned int add, unsigned char d){
    unsigned char iflag;
    NVMCON1bits.NVMREGS=1;      //EEPROM, UID, CONFIG
    NVMCON1bits.WREN=1;    
    add=add+EEPROM_START;
    NVMADRH=add>>8;
    NVMADRL=add;
    NVMDATL=d;
    iflag=INTCON;               //save interrupt flags
    INTCONbits.GIE=0;           //disable interrupts globally
    NVMCON2=0x55;
    NVMCON2=0xAA;
    NVMCON1bits.WR=1;
    NOP();
    NOP();
    while(NVMCON1bits.WR){}     //wait for completion
    NVMCON1bits.WREN=0;         //disable writes    
    INTCON=iflag;               //restore interrupts        
}
