#include "menu.h"

//state machine based menu system
char menuService(void){         //service
    char i,d,keyok,r;
    r=0;
    if(menuWaiting==0){
        if(menuState==0){
            showMainMenu();
        }else if(menuState==MENU_CONFIRM){
            showConfirm(menuState-1);
        }else{
            showOption(menuState-1);
        }
        menuWaiting=1;
    }
    d=getInput();
    while(d){
        keyok=0;    //flag set if valid key pressed
        if(d==ESC_KEY){  //ESC, redo main menu
            menuState=0;
            menuWaiting=0;
            menuEntry=0;
            menuSelection=0;    //reset        
        }else if(d==CANCEL_KEY){
            return MENU_CANCEL;
        }else{
            if(menuState==0){
                for(i=0;i<MENU_COUNT;i++){
                    if(d==(i+menuFirst)){
                        menuState=i+1;
                        menuWaiting=0;
                        menuEntry=0;
                    }
                }
            }else if(menuState==MENU_CONFIRM){          //expect Y/N
                if((d=='Y')||(d=='y')){
                    menuState=0;        //back to main
                    menuWaiting=0;                    
                    menuResult=menuEntry;
                    menuEntry=0;                    
                    LCD_data('Y');
                    return menuSelection;   //result
                }
                if((d=='N')||(d=='n')){
                    menuState=0;        //back to main
                    menuWaiting=0;                    
                    menuEntry=0;                    
                    LCD_data('N');
                    //as per above, but no return
                }
            }else{          //expect numeric entry
                if((d>='0')&&(d<='9')){ //number
                    menuEntry=menuEntry*10+d-'0';
                    showNumber();
                }
                 if((d==8)||(d==127)){   //backspace/delete
                    menuEntry=menuEntry/10;
                    showNumber();
                }
                if(d==13){          //enter
                    menuSelection=menuState;
                    menuState=MENU_CONFIRM;       //wait for confirm
                    menuWaiting=0;
                }
            }
        }
        d=getInput();
    }
    return 0;
}


char getInput(void){            //IO interface, assumes character device eg, UART
    if(uartAvailable()){
        return uartReceive();        
    }else{
        return 0;
    }    
}

void showMainMenu(void){
    LCD_clr();
    LCD_print("Calibration:");
    LCD_cmd(LCD_SETPOS+LCD_LINE1);
    LCD_print("1:");
    LCD_print(menuItems[0]);
    LCD_ulong(calValues[0],5);     //int is 5 chars
    LCD_cmd(LCD_SETPOS+LCD_LINE2);
    LCD_print("2:");
    LCD_print(menuItems[1]);
    LCD_ulong(calValues[1],5);     //int is 5 chars
    LCD_cmd(LCD_SETPOS+LCD_LINE3);
    LCD_print("3:");
    LCD_print(menuItems[2]);
    LCD_ulong(calValues[2],5);     //int is 5 chars
}

void showOption(char m){
    LCD_clr();
    LCD_print("Enter value:");
    LCD_cmd(LCD_SETPOS+LCD_LINE1);
    LCD_print(menuItems[m]);
    showNumber();   //shows blank entry
}

void showNumber(void){      //needs menuEntry
    LCD_cmd(LCD_SETPOS+LCD_LINE2);
    LCD_ulong(menuEntry,6);     //int is 5 chars
    LCD_print("_      ");    
}

void showConfirm(char m){   //needs menuEntry
    showNumber();                   //ensure up to date
    LCD_cmd(LCD_SETPOS+LCD_LINE3);    
    LCD_print("Confirm (Y/N)?");        
}