//IO setup and interfaces

#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "portpins.h"

#define _XTAL_FREQ 32000000

#define RLY_CTL LATAbits.LATA4

#define PIN_COUNT (12)
#define MISC_PIN_COUNT (2)
#define DFP_PIN_COUNT (13)
#define UFP_PIN_COUNT (14)
#define ADC_OSAMPLE (16)

extern unsigned char matrix[PIN_COUNT][PIN_COUNT];
extern unsigned char dfpcheck[DFP_PIN_COUNT];
extern unsigned char ufpcheck[UFP_PIN_COUNT];
extern long powerV[4];       //for ADC values from power check

//#define PCB_REVC
#define PCB_REVD

#ifdef PCB_REVC
const char dfpins[DFP_PIN_COUNT]={
    D4,D5,A1,B6,    //GND,VBUS,DP,DM
    B7,A0,A2,A3,    //TXP1,TXM1,RXP1,RXM1
    E1,E2,E0,A5,    //TXP2,TXM2,RXP2,RXM2
    A7              //SHD   //note that this is shared with UFP
};

const char ufpins[UFP_PIN_COUNT]={
    C0,C7,C2,C5,    //GND,VBUS,DP,DM
    C6,C1,C4,C3,    //TXP1,TXM1,RXP1,RXM1
    D1,D2,D3,D0,    //TXP2,TXM2,RXP2,RXM2
    A7,A6           //SHD, ID            
};
#endif

#ifdef PCB_REVD
const char dfpins[DFP_PIN_COUNT]={
    C6,C5,A1,B6,    //GND,VBUS,DP,DM
    B7,A0,A2,A3,    //TXP1,TXM1,RXP1,RXM1
    A6,C0,A7,A5,    //TXP2,TXM2,RXP2,RXM2
    E1              //SHD   //note that this is shared with UFP
};

const char ufpins[UFP_PIN_COUNT]={
    E2,C7,C2,D5,    //GND,VBUS,DP,DM
    D4,C1,C4,C3,    //TXP1,TXM1,RXP1,RXM1
    D1,D2,D3,D0,    //TXP2,TXM2,RXP2,RXM2
    E1,E0           //SHD, ID            
};
#endif

const char npins[UFP_PIN_COUNT][5]={
    "GND ","VBUS","DP  ","DM  ",
    "TXP1","TXM1","RXP1","RXM1",
    "TXP2","TXM2","RXP2","RXM2",
    "SHLD","ID  "
};

void ioinit(void);
void ioDeinit(void);    //for idle mode
int getADC(char channel);
unsigned char usbScan(void);
unsigned char doUFP(void);
unsigned char doDFP(void);
int getBatt(void);
void powerScan(unsigned char d);       //check current handling of cable
void setPWM(unsigned char d);   //set duty cycle
void setIO(void);       //set pins to suit IO scanning
void setPWR(void);      //set pins to suit POWER checking
void setSleep(void);    //set pins to suit IO sleep (and wakeup via pin change)
int getDrop(int c);     //check voltage drop at current corresponding to c
int getmV(int c);        //checks and calcs from above

#endif	/* IO_H */

