//helpers in main

#ifndef USBTEST_H
#define	USBTEST_H
#include <xc.h>
#include <string.h> //for strlen
#include "io.h"
#include "hd44780.h"
#include "util.h"
#include "graphics.h"
#include "uart.h"
#include "menu.h"
#include "nvm.h"
#include "tmr0.h"

#define SIG_SIZE (18)
#define SIG_COUNT (15)
#define MSG_SIZE (200)

//all in main:
extern unsigned char sig_match;
extern const unsigned char sigs[SIG_COUNT][SIG_SIZE];
extern unsigned char sigDelta[SIG_SIZE];
extern unsigned char sig[SIG_SIZE];
extern volatile unsigned char t0cnt;
extern unsigned char t0last;
extern unsigned int idleTime;
const unsigned char ufpOTG[UFP_PIN_COUNT]={   //signature for OTG cable
    1,0,0,0,
    0,0,0,0,
    0,0,0,0,
    0,1
};

//helpers to streamline main
void reportUFP(void);
void reportDFP(void);
void LCD_sig(const unsigned char* s); //print to LCD
unsigned char match_sig(const unsigned char* s1,const unsigned char* s2);    //count mismatches
unsigned char closest_match(const unsigned char* s);          //return delta of best match
void setSigDelta(const unsigned char* s);       //set sigDelta based on sig vs s
void setSigPlus(const unsigned char* s);        //set sigDelta for bits sig has and s doesn't
void setSigMinus(const unsigned char* s);       //set sigDelta for bits s has and sig doesn't
void getSig(unsigned char* m,unsigned char* s); //get signature s from matrix m
void doCalibration(void);
void loadCal(void);
void setTimeout(void);
void doSleep(void);
char sigBit(unsigned char* s, char x, char y);           //return bit from sig s
char checkAdd(unsigned char* s, char n); //check for presence of item n in sig s
char isOTG(void);   //check if ufpcheck ~ OTG cable
int FVRadj(int n);      //adjust n for current value of VREF

#endif //USBTEST_H

