//Port and Pin defs to allow parameterised access/control

#ifndef PORTPIN_H
#define	PORTPIN_H
#include <xc.h>

char getPort(char type, char n);
void setPort(char type, char n, char v);

//ADC channels are: mapped RA0-RE2 = 0-34, so let's use this as our reference
//PORT,TRIS,LAT,ANSEL,WPU,ODCON

volatile unsigned char* const ports[6][5]={
    {&PORTA,  &PORTB,  &PORTC,  &PORTD,  &PORTE},
    {&TRISA,  &TRISB,  &TRISC,  &TRISD,  &TRISE},
    {&LATA,  &LATB,  &LATC,  &LATD,  &LATE},
    {&ANSELA,  &ANSELB,  &ANSELC,  &ANSELD,  &ANSELE},
    {&WPUA,  &WPUB,  &WPUC,  &WPUD,  &WPUE},
    {&ODCONA,  &ODCONB,  &ODCONC,  &ODCOND,  &ODCONE}    
};

//mnemonics
#define PORT (0)
#define TRIS (1)
#define LAT (2)
#define ANSEL (3)
#define WPU (4)
#define ODCON (5)
//bitfields
const unsigned char bt[]={1,2,4,8,16,32,64,128};

//quick refs, can also be used for ADC channels or PPS Input selections
//eg ADPCH=A0; or INTPPS=B5;

#define A0 (0)
#define A1 (1)
#define A2 (2)
#define A3 (3)
#define A4 (4)
#define A5 (5)
#define A6 (6)
#define A7 (7)

#define B0 (8)
#define B1 (9)
#define B2 (10)
#define B3 (11)
#define B4 (12)
#define B5 (13)
#define B6 (14)
#define B7 (15)

#define C0 (16)
#define C1 (17)
#define C2 (18)
#define C3 (19)
#define C4 (20)
#define C5 (21)
#define C6 (22)
#define C7 (23)

#define D0 (24)
#define D1 (25)
#define D2 (26)
#define D3 (27)
#define D4 (28)
#define D5 (29)
#define D6 (30)
#define D7 (31)

#define E0 (32)
#define E1 (33)
#define E2 (34)
#define E3 (35)

#define NOPIN (255)

#endif //PORTPIN_H

