#include "io.h"
//for FVRadj
#include "usbtest.h"

void ioinit(void){
    //Peripheral Module Enable
    //PMD0=0x00;    //SYSCLK/IOC etc, don't change
    //PMD1=0xFE;      //TMR0 on, TMR2-TMR6, NCO off
    //PMD2=0xDF;      //ADC on, DAC, CMP, ZCD off
    //PMD3=0xFE;      //CCP1 on, CCP2-PWM7 off
    //PMD4=0xBF;      //UART on, MSSP, CWG off
    //PMD5=0xFF;      //SMT, CLC, DSM always off

    //GPIO: no analog
    ANSELA=0;
    ANSELB=0;
    ANSELC=0;
    ANSELD=0;
    ANSELE=0;
    
    //Relay
    RLY_CTL=0;
    TRISAbits.TRISA4=0;
    
    //ADC
    ADCON0=0;   //reset ADC
    ADFRM0=1;   //right-justify
    //ADCLK=63; //FOSC/128 (2n+2)
    ADCLK=15; //FOSC/32 (2n+2)
    ADREF=3;    //FVR ADC reference
    ADCON0bits.ADON=1;  //turn on ADC
    
    //FVR for battery check reference and higher precision measurements
    FVRCON=0b10000001;  //on, ADCx1=1.024V

    //RB5 is PWM output, CCP1 (0x9) - CCP4 (0xC) can use PORTB
    TRISB5=1;   //set as input while setting up
    //PPS sequence
    unsigned char iflag;
    iflag=INTCON;               //save interrupt flags
    INTCONbits.GIE=0;           //disable interrupts globally
    PPSLOCK=0x55;
    PPSLOCK=0xAA;
    PPSLOCKED=0;
    RB5PPS=0x9; //CCP1 on RB5
    PPSLOCKED=1;
    INTCON=iflag;               //restore interrupts    
    //TIMER selection
    CCPTMRS0bits.C1TSEL=1;      //TMR2
    //CCP1 setup
    CCP1CON=0;      //reset
    CCP1FMT=1;      //left aligned duty cycle
    CCP1CONbits.CCP1MODE=0xF;   //PWM mode
    CCP1CONbits.EN=1;//on
    setPWM(0);      //8-bit duty cycle
    //TMR2 needed for CCP1-CCP5
    T2CON=0;        //reset
    PIR4bits.TMR2IF=0;  //clear interrupt
    T2PR=0xFF;      //period
    T2CLKCON=1;     //FOSC/4    (doesn't seem to work with FOSC)
    T2CONbits.CKPS=0;   //1:1 (0 - 7 = 1:1 - 1:128)    
    T2CONbits.OUTPS=0;  //1:1
    T2HLT=0;        //software control free running mode, no sync
    T2CONbits.ON=1; //run
    //and enable output
    TRISB5=0;       //enable output

}

void ioDeinit(void){    //for idle mode
    //ADC
    ADCON0=0;   //reset ADC
    //FVR for battery check reference
    FVRCON=0;  //off
    //TMR2
    T2CON=0;        //reset
    //PWM6
    //PWM6CON=0;      //reset
    //CCP1
    CCP1CON=0;      //reset
    TRISB5=1;       //PWM pin
    
    //Peripheral Module Disable
    //PMD0=0xFF;    //SYSCLK/IOC etc, don't disable
    //PMD1=0xFF;
    //PMD2=0xFF;
    //PMD3=0xFF;
    //PMD4=0xFF;
    //PMD5=0xFF;
}

int getADC(char channel){           //get ADC result from channel
    ADPCH=channel;
    ADGO=1;         //go
    while(ADGO){};  //wait for conversion
    return ADRES;
}

unsigned char usbScan(void){
    char i,j;
    int r=0;
    for(i=0;i<PIN_COUNT;i++){
        setPort(LAT,dfpins[i],0);   //low
        __delay_ms(1);
        for(j=0;j<PIN_COUNT;j++){
            matrix[i][j]=0;
            if((getPort(PORT,ufpins[j])==0)&&(ufpins[j]!=NOPIN)){
                r++;
                matrix[i][j]=1;
            }
        }
        setPort(LAT,dfpins[i],1);   //back high
    }
    return r;
}

unsigned char doUFP(void){
    char i,j;
    int r=0;
    for(i=0;i<UFP_PIN_COUNT;i++){ufpcheck[i]=0;}    //clear
    for(i=0;i<UFP_PIN_COUNT;i++){
        setPort(LAT,ufpins[i],0);   //low
        __delay_ms(1);
        for(j=0;j<UFP_PIN_COUNT;j++){
            if((getPort(PORT,ufpins[j])==0)&&(ufpins[j]!=NOPIN)){
                if(i!=j){ufpcheck[i]=1;ufpcheck[j]=1;}
            }
        }
        setPort(LAT,ufpins[i],1);   //back high
    }    
    for(i=0;i<UFP_PIN_COUNT;i++){if(ufpcheck[i]){r++;}}    //check involved pins
    return r;
}

unsigned char doDFP(void){
    char i,j;
    int r=0;
    for(i=0;i<DFP_PIN_COUNT;i++){dfpcheck[i]=0;}    //clear
    for(i=0;i<DFP_PIN_COUNT;i++){
        setPort(LAT,dfpins[i],0);   //low
        __delay_ms(1);
        for(j=0;j<DFP_PIN_COUNT;j++){
            if((getPort(PORT,dfpins[j])==0)&&(dfpins[j]!=NOPIN)){
                if(i!=j){dfpcheck[i]=1;dfpcheck[j]=1;}
            }
        }
        setPort(LAT,dfpins[i],1);   //back high
    }
    for(i=0;i<DFP_PIN_COUNT;i++){if(dfpcheck[i]){r++;}}    //check involved pins
    return r;
}

int getBatt(void){  //result in mV
    int v;
    long t;
    char i;
    ADREF=0;    //VDD/VSS ADC reference
    getADC(0x3F);   //FVR dummy read
    __delay_ms(1);  //allow to settle
    v=0;
    for(i=0;i<ADC_OSAMPLE;i++){
        v=v+getADC(0x3F); //FVR
    }
    v=FVRadj(v);
    if(v<(110*ADC_OSAMPLE)){
        t=9999;     //overflow four digits
    }else{
        t=((1L<<20)*ADC_OSAMPLE)/v;   //result in mV
    }
    ADREF=3;    //FVR ADC reference
    return t;    
}

void powerScan(unsigned char d){       //check current handling of cable
    char i;
    ADREF=3;    //FVR ADC reference
    setPWM(d);   //    
    __delay_ms(1); //allow to charge
    for(i=0;i<4;i++){powerV[i]=0;}
    for(i=0;i<ADC_OSAMPLE;i++){
#ifdef PCB_REVC
        powerV[0]+=getADC(dfpins[1]);   //notionally in order of current flow 5V DFP
        powerV[1]+=getADC(ufpins[1]);   //5VUFP
        powerV[2]+=getADC(dfpins[0]);   //GND DFP Order of these two fixed in RevD
        powerV[3]+=getADC(ufpins[0]);   //GND UFP
#endif
#ifdef PCB_REVD
        powerV[0]+=getADC(dfpins[1]);   //notionally in order of current flow 5V DFP
        powerV[1]+=getADC(ufpins[1]);   //5VUFP
        powerV[2]+=getADC(ufpins[0]);   //GND UFP
        powerV[3]+=getADC(dfpins[0]);   //GND DFP
#endif
    }
    //setPWM(0);         //shut off is done in caller
    for(i=0;i<4;i++){
        powerV[i]=FVRadj(powerV[i])/ADC_OSAMPLE;
    }
}

void setPWM(unsigned char d){   //set duty cycle
    CCPR1H = 0xFF - d;
}

void setIO(void){       //set pins to suit IO scanning
    char i;
    //return to normal pin modes
    for(i=0;i<PIN_COUNT;i++){
        setPort(ODCON,dfpins[i],1); //open drain only
        setPort(LAT,dfpins[i],1);   //high
        setPort(WPU,dfpins[i],1);   //pull-up on
        setPort(TRIS,dfpins[i],0);  //output
        setPort(ANSEL,dfpins[i],0); //analog disable
    }
    for(i=0;i<UFP_PIN_COUNT;i++){
        setPort(ODCON,ufpins[i],1); //open drain only
        setPort(LAT,ufpins[i],1);   //high
        setPort(WPU,ufpins[i],1);   //pull-up on
        setPort(TRIS,ufpins[i],0);  //output
        setPort(ANSEL,ufpins[i],0); //analog disable
    }        
}

void setPWR(void){      //set pins to suit POWER checking
    char i;
    //set modes for power checking
    for(i=0;i<PIN_COUNT;i++){
        setPort(ODCON,dfpins[i],1); //open drain only
        setPort(LAT,dfpins[i],1);   //high
        setPort(WPU,dfpins[i],0);   //pull-up off
        setPort(TRIS,dfpins[i],1);  //input
        setPort(ANSEL,dfpins[i],1); //analog enable
    }
    for(i=0;i<UFP_PIN_COUNT;i++){
        setPort(ODCON,ufpins[i],1); //open drain only
        setPort(LAT,ufpins[i],1);   //high
        setPort(WPU,ufpins[i],0);   //pull-up off
        setPort(TRIS,ufpins[i],1);  //input
        setPort(ANSEL,ufpins[i],1); //analog enable
    }
}

void setSleep(void){       //set pins to suit IO sleep (and wakeup via pin change)
    char i;
    //DFP float high, UFP are low to pull down
    for(i=0;i<PIN_COUNT;i++){
        setPort(ODCON,dfpins[i],1); //open drain only
        setPort(LAT,dfpins[i],1);   //high
        setPort(WPU,dfpins[i],1);   //pull-up on
        setPort(TRIS,dfpins[i],0);  //output
        setPort(ANSEL,dfpins[i],0); //analog disable
    }
    for(i=0;i<UFP_PIN_COUNT;i++){
        setPort(ODCON,ufpins[i],0); //push pull
        setPort(LAT,ufpins[i],0);   //low
        setPort(WPU,ufpins[i],0);   //pull-up off
        setPort(TRIS,ufpins[i],0);  //output
        setPort(ANSEL,ufpins[i],0); //analog disable
    }        
}

int getDrop(int c){     //check voltage drop at current corresponding to c
    int d=1;
    //assumes that IO/RLY are set
    powerScan(d);       //ensure we have valid values to start
    while((powerV[0]<1000)&&
          (powerV[1]<1000)&& 
          (powerV[2]<1000)&&
          (powerV[3]<1000)&&
          (powerV[3]<(c/2))){
        d=d*2;
        powerScan(d);
    }
    while((powerV[0]<1000)&&
          (powerV[1]<1000)&& 
          (powerV[2]<1000)&&
          (powerV[3]<1000)&&
          (powerV[3]<c)){
        d=d+1;
        powerScan(d);
    }
    setPWM(0);         //shut off
    return d;   //we can inspect powerV for actual result
}

int getmV(int c){        //run and validate getDrop()
    int d;
    d=getDrop(c);
    if(powerV[0]>1000){return -1;}
    if(powerV[1]>1000){return -1;}
    if(powerV[2]>1000){return -1;}
    if(powerV[3]>1000){return -1;}
    if((powerV[0]<=powerV[1])){return -1;}
    if((powerV[2]<=powerV[3])){return -1;}
    if(d<=1){return -1;}
    return powerV[0]+powerV[2]-powerV[1]-powerV[3];     //cable drop
}
