//interface for HD44780 LCD using 4 bit mode

#ifndef HD44780_H
#define	HD44780_H

//pin defs: not using RW pin
#define LCD_PWR LATDbits.LATD6
#define LCD_D7 LATDbits.LATD7
#define LCD_D6 LATBbits.LATB0
#define LCD_D5 LATBbits.LATB1
#define LCD_D4 LATBbits.LATB2
#define LCD_EN LATBbits.LATB3
#define LCD_RS LATBbits.LATB4

#include <xc.h> // include processor files - each processor file is guarded.  
#include "io.h"

const char hex[]="0123456789ABCDEF";

#define LCD_SETPOS (0x80)
#define LCD_LINE0 (0)
#define LCD_LINE1 (64)
#define LCD_LINE2 (20)
#define LCD_LINE3 (84)
#define F_SPACE (' ')
#define LCD_CLR (1)

void LCD_init(void);
void LCD_deinit(void);      //for low power mode
void LCD_data(unsigned char d);
void LCD_cmd(unsigned char c);
void LCD_print(const char *c);
void LCD_setpos(unsigned char x);
void LCD_cgram(const unsigned char* p);   //load CGRAM with 64bytes from p
char getDigit(unsigned long n, signed char p);  //get digit of t at pth decimal place (0 = ones)
char lzFix(char c); //suppress leading zero suppression for display reasons
unsigned long places(signed char n);    //this is smaller than a const array
void LCD_ulong(unsigned long n, char p);    //output unsigned long to p places using getDigit
void LCD_clr(void);                 //separate function to include necessary delay

#endif	/* HD44780_H */

