#include "usbtest.h"

void doSleep(void){
    char i;
    char f=0;
    GIE=0;  //turn off interrupts
    T0CON0=0;       //reset
    LCD_deinit();
    ioDeinit();     //PWM etc
    setSleep();     //IO pins for sensing wakeup, DFP pulled high, UFP low
    __delay_ms(20); //let pins settle
    CPUDOZE=0;      //DOZE off (SLEEP=SLEEP)
    VREGPM=1;       //use low power sleep
    //VREGPM=0;       //use normal sleep (default)
    WDTCON0=0;      //reset WDT
    //WDTCON0bits.WDTPS=9;    //512ms
    //WDTCON0bits.SEN=1;      //WDT on
    
    //clear all IOC flags
    IOCAF=0x00;
    IOCBF=0x00;
    IOCCF=0x00;
    IOCEF=0x00;    
    // all IOCs set
    IOCAP=0xFF;
    IOCAN=0xFF;
    IOCBP=0xFF;
    IOCBN=0xFF;
    IOCCP=0xFF;
    IOCCN=0xFF;
    IOCEP=0xFF;
    IOCEN=0xFF;
    PIE0bits.IOCIE=1;    
    for(i=0;i<PIN_COUNT;i++){   //check if any pins low before sleeping
        if((getPort(PORT,dfpins[i])==0)){f=1;}
    }
    //sleep until IOC unless something's already changed    
    if(f==0){
        NOP();
        SLEEP();
        NOP();
    }
    //all IOCs clear
    PIE0bits.IOCIE=0;
    IOCAP=0x00;
    IOCAN=0x00;
    IOCBP=0x00;
    IOCBN=0x00;
    IOCCP=0x00;
    IOCCN=0x00;
    IOCEP=0x00;
    IOCEN=0x00;
    
    WDTCON0=0;      //reset WDT, not needed for normal operation
    //restart mostly the same as init (except UART)
    ioinit();
    LCD_init();
    tmr0init();
    LCD_cgram(graphics);
    setIO();
    setPWM(0);         //shut off
    loadCal();         //load cal values from EEPROM
    GIE=1;
    LCD_clr();    
}


void doCalibration(void){
    char r=0;
    unsigned int v;
    while(1){
        r=menuService();        
        if((r>0) && (r<(MENU_COUNT+1))){
            if((menuResult<1)&&(r!=3)){     //disallow 0 except for contact resistance
                LCD_clr();
                LCD_print("Cannot set to 0.");                            
            }else{
                LCD_clr();
                LCD_print("Saving");            
                LCD_cmd(LCD_SETPOS+LCD_LINE1);
                LCD_print(menuItems[r-1]);
                LCD_cmd(LCD_SETPOS+LCD_LINE2);
                LCD_ulong(menuResult,5);     //int is 5 chars            
                EEPROMwrite(r*2-2,(menuResult>>0)&0xFF);    //LSB
                EEPROMwrite(r*2-1,(menuResult>>8)&0xFF);    //MSB
                loadCal();          //confirm writeback has completed by reloading
            }
            __delay_ms(2000);                   
        }
        if(r==MENU_CANCEL){return;}  //cancel key pressed
        if(t0last!=t0cnt){
            t0last=t0cnt;
            v=getBatt();
            LCD_cmd(LCD_SETPOS+LCD_LINE0+15);
            LCD_data(getDigit(v,3));
            LCD_data('.');
            LCD_data(getDigit(v,2));
            LCD_data(getDigit(v,1));
            LCD_data('V');
        }
    }    
}

void reportDFP(void){
    unsigned char i,j;
    i=0;
    j=0;    
    LCD_cmd(LCD_SETPOS+LCD_LINE1);
    LCD_print("DFP: ");
    while(i<11){        //11 display slots 3/4/4
        if(j<DFP_PIN_COUNT){
            if(dfpcheck[j]){
                if(i==3){LCD_cmd(LCD_SETPOS+LCD_LINE2);}
                if(i==7){LCD_cmd(LCD_SETPOS+LCD_LINE3);}
                LCD_print(npins[j]);
                LCD_data(',');
                i++;                
            }
            j++;
        }else{
            if(i==3){LCD_cmd(LCD_SETPOS+LCD_LINE2);}
            if(i==7){LCD_cmd(LCD_SETPOS+LCD_LINE3);}
            LCD_print("     "); //erase any previous display
            i++;
        }
    }
}

void reportUFP(void){
    unsigned char i,j;
    i=0;
    j=0;    
    LCD_cmd(LCD_SETPOS+LCD_LINE1);
    LCD_print("UFP: ");
    while(i<11){        //11 display slots 3/4/4
        if(j<UFP_PIN_COUNT){
            if(ufpcheck[j]){
                if(i==3){LCD_cmd(LCD_SETPOS+LCD_LINE2);}
                if(i==7){LCD_cmd(LCD_SETPOS+LCD_LINE3);}
                LCD_print(npins[j]);
                LCD_data(',');
                i++;                
            }
            j++;
        }else{
            if(i==3){LCD_cmd(LCD_SETPOS+LCD_LINE2);}
            if(i==7){
                LCD_cmd(LCD_SETPOS+LCD_LINE3);
                if(isOTG()){
                    LCD_print("UFP cable is OTG");
                    i=i+3;      //jump out of loop
                }                
            }
            LCD_print("     ");
            i++;
        }
    }
}

void LCD_sig(const unsigned char* s){ //print to LCD
    unsigned char i;
    LCD_cmd(LCD_SETPOS+LCD_LINE2);
    for(i=0;i<(SIG_SIZE/2);i++){
        LCD_data(hex[(s[i]>>4)&0xF]);
        LCD_data(hex[(s[i]>>0)&0xF]);        
    }
    LCD_cmd(LCD_SETPOS+LCD_LINE3);
    for(i=(SIG_SIZE/2);i<SIG_SIZE;i++){
        LCD_data(hex[(s[i]>>4)&0xF]);
        LCD_data(hex[(s[i]>>0)&0xF]);        
    }
}

unsigned char match_sig(const unsigned char* s1,const unsigned char* s2){    //count mismatches
    unsigned char i,r;
    r=0;
    for(i=0;i<SIG_SIZE;i++){
        r=r+countSetBits(s1[i]^s2[i]);
    }
    return r;
}

unsigned char closest_match(const unsigned char* s){          //return delta of best match
    unsigned char i,r,d;
    r=144;      //highest possible result
    sig_match=0xFF;   //invalidate
    for(i=0;i<SIG_COUNT;i++){
        d=match_sig(s,sigs[i]);
        if(r>d){
            r=d;
            sig_match=i;
        }
    }
    return r;    
}

void setSigDelta(const unsigned char* s){       //set sigDelta based on differences sig vs s
    char i;
    for(i=0;i<SIG_SIZE;i++){
        sigDelta[i]=sig[i]^s[i];
    }    
}

void setSigPlus(const unsigned char* s){       //set sigDelta for bits sig has and s doesn't
    char i;
    for(i=0;i<SIG_SIZE;i++){
        sigDelta[i]=sig[i] & (~s[i]);
    }    
}

void setSigMinus(const unsigned char* s){       //set sigDelta for bits s has and sig doesn't
    char i;
    for(i=0;i<SIG_SIZE;i++){
        sigDelta[i]=s[i] & (~sig[i]);
    }        
}

void getSig(unsigned char* m,unsigned char* s){ //get signature s from matrix m
    unsigned char i,j,k;
    i=0;
    j=0;
    k=0;
    for(j=0;j<SIG_SIZE;j++){
        s[j]=0;
        for(k=0;k<8;k++){
            if(m[i]){
                s[j]=s[j]|bt[7-k];
            }
            i++;
        }
    }
}

void loadCal(void){
    char i;
    for(i=0;i<MENU_COUNT;i++){
        calValues[i]=EEPROMread(i*2)+EEPROMread(i*2+1)*256;
    }
    if(calValues[0]<1){calValues[0]=1024;}    //avoid /0 error
    if(calValues[1]<1){calValues[1]=220;}    //avoid /0 error
    //0 is acceptable for calValues[2], contact resistance
    if(calValues[3]<1){calValues[1]=2;}    //avoid /0 error
}

void setTimeout(void){
    idleTime=40;        //load values in 1/4s, ie 10s <=> 40
}

char sigBit(unsigned char* s, char x, char y){    //return bit from sig s
    unsigned char d=y*12+x;     //bit index
    if(s[d>>3]&bt[7-(d&7)]){
        return 1;        
    }else{
        return 0;
    }    
}

char checkAdd(unsigned char* s, char n){ //check for presence of item n in sig s
    char i;
    for(i=0;i<12;i++){
        if(sigBit(s,i,n)){return 1;}
        if(sigBit(s,n,i)){return 1;}
    }
    return 0;
}

char isOTG(void){   //check if ufpcheck ~ OTG cable
    char i;
    for(i=0;i<UFP_PIN_COUNT;i++){
        if(ufpOTG[i]!=ufpcheck[i]){return 0;}
    }
    return 1;
}

int FVRadj(int n){      //adjust n for current value of VREF
    long m;
    m = ((long)n * (long)calValues[0])/1024;
    return m;
}