#include "uart.h"

void uartDeinit(void){
    //interrupts
    RCIE=0;
    RCIF=0;
    //peripheral
    SPEN=0;         //disable SP
    TXEN=0;         //disable TX
    CREN=0;         //disable receive
    //PINS
    //TRISB6=1;       //OUTPUT            
    WPUB7=1;        //pullup on RX
    //PPS
    unsigned char iflag;
    iflag=INTCON;               //save interrupt flags
    INTCONbits.GIE=0;           //disable interrupts globally
    PPSLOCK=0x55;
    PPSLOCK=0xAA;
    PPSLOCKED=0;
    RB6PPS=0;                  //RB6=LAT
    PPSLOCKED=1;
    INTCON=iflag;               //restore interrupts    
}

void uartInit(void){
    rx_head=0;
    rx_tail=0;
    rx_head=0;
    rx_tail=0;         
    //PPS
    unsigned char iflag;
    iflag=INTCON;               //save interrupt flags
    INTCONbits.GIE=0;           //disable interrupts globally
    PPSLOCK=0x55;
    PPSLOCK=0xAA;
    PPSLOCKED=0;
    RXPPS=0x0F;     //RX=RB7
    //RB6PPS=0x10;    //RB6=TX
    PPSLOCKED=1;
    INTCON=iflag;               //restore interrupts    
    //PINS
    //TRISB6=0;       //OUTPUT            
    WPUB7=1;        //pullup on RX
    /*
    //TX
    TX1STA=0;   //reset
    SPEN=1;
    TX1STAbits.SYNC=0;
    TXEN=1;
    */
    
    //BAUD/COMMON
    //BAUD1CON=0;  //8bit BRG, low speed
    BAUD1CON=8;  //16bit BRG, low speed
    TX1STAbits.BRGH=1;  //high speed
    SP1BRG=833;         //8e6/9600 =833 =>9604
    //SP1BRG=69;          //8e6/115200 =69 => 115942
    //SP1BRG=208;         //8e6/38400 = 208 => 38461

    //RX
    RC1STA=0;       //reset
    TX1STAbits.SYNC=0;
    CREN=1;         //enable receive
    SPEN=1;         //enable serial port
    
    //INTERRUPTS
    RCIE=1;
    PEIE=1;         //allow interrupts, GIE set in main
    //TXIE is set when there is data in buffer
}
/*
void uartSend(char c){      //add to txbuf
    //implementation could possibly write directly to output, but not tested working
    while(((tx_head+1)%BUFSIZE)==tx_tail){} //blocking till buffer free
    TXIE=0;                                 //disable while we add to avoid buffer corruption
    txbuf[tx_head]=c;                       //add to queue
    tx_head=(tx_head+1)%BUFSIZE;            //increment pointer
    TXIE=1;                                 //enable interrupts again (or any time there is data)
}


void uartSends(char* c){    //char array
    while(*c){
        uartSend(*c);
        c++;
    }
}

*/
char uartAvailable(void){   //bytes to receive in rxbuf
    return (rx_head+BUFSIZE-rx_tail)%BUFSIZE;    
}

char uartReceive(void){     //take from rxbuf
  char c;
  if(rx_head==rx_tail){
      return 0xFF;    //empty
  }
  c=rxbuf[rx_tail];
  rx_tail=(rx_tail+1)%BUFSIZE;
  return c;    
}
